/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "aswvdial.h"

int ReadProc(void)
{
    FILE *fp = NULL;
    char line[256];
    int temp = 0;

    fp = fopen( "/proc/net/route","r");
    if (fp)
    {
        while (fgets( line, 256, fp))
        {
            if (strstr( line, "ppp0"))
		temp = 1;
        }
	(void) fclose( fp);
    }
    else
    {
    	printf( "\nError: cannot open /proc/net/route\n");
    }

    return temp;
}

int ReadConfig(int *maxentries)
{
    FILE *wvdial_config = NULL;
    char line[256], *token;
    const char cut[] = " =[]";

    wvdial_config = fopen( "/etc/wvdial.conf", "r");
    if (wvdial_config != NULL)
    {
        while (fgets( line, 30, wvdial_config) != NULL)
        {
	    if ((strstr( line, "[") != NULL) && (*maxentries <= 15))
	    {
	        token = strtok( line, cut);
	        token = strtok( NULL, cut);
		if (NULL != token)
		    (void) strlcpy( wvdial_opt[*maxentries], token, 17);

		*maxentries = *maxentries + 1;
	    }
	}

	if (*maxentries != 0)
	    *maxentries = *maxentries - 1;

	(void) fclose( wvdial_config);
    }
    else
    {
    	printf( "\nError: cannot open /etc/wvdial.conf\n");
	return 0;
    }
    return 1;
}
