/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef ASWVDIAL_H
#define ASWVDIAL_H

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "../wmgeneral/wmgeneral.h"
#include "../wmgeneral/misc.h"

#define VERSION "1.7"

struct Twvdial
{
    char provider[17];
    time_t start;
    time_t end;
    double elapsed;
} wvdial;

char wvdial_opt[15][17];

/*prototypes*/
void AswvdialUsage( void);
void PressEvent( XButtonEvent *xbe, int *connection, int *event, int *maxentries);
int ReadProc( void);
int ReadConfig( int *maxentries);
void Timing( int cmd, int *entry);
void DrawChar( char what[]);
void DrawNumber( int x, int y, double what);
void SaveConnection(void);
size_t strlcpy( char *dst, const char* src, size_t siz);

#endif /*ASWVDIAL_H*/

