.\" t
.\" @(#)ascompose.3		08/01/2007
.TH ascompose 1 "AfterStep v.2.2.6" "Aug  1 2007" "AfterStep X11 window manager"
.UC
.SH NAME
\fBascompose\fP\ - provides access to libAfterImage functionality, using scripts written in custom XML dialect
libAfterImage/ascompose
.SH NAMEascompose
is a tool to compose image(s) and display/save it based on supplied XML input file.

.SH SYNOPSIS
.nf
ascompose -f file|-s string [-o file] [-t type] [-V]
ascompose -i include_file [-i more_include_file ... ]
             -f file|-s string [-o file] [-t type] [-V]
ascompose -f file|-s string [-o file] [-t type] [-V] [-n]
ascompose -f file|-s string [-o file] [-t type [-c compression_level]] 
             [-V] [-r]
ascompose [-h]
ascompose [-v]
.fi 
.SH DESCRIPTION
.nf
ascompose reads supplied XML data, and manipulates image accordingly.
It could transform images from files of any supported file format,
draw gradients, render antialiased texturized text, perform
superimposition of arbitrary number of images, and save images into
files of any of supported output file formats.

At any point, the result of any operation could be assigned a name,
and later on referenced under this name.

At any point during the script processing, result of any operation
could be saved into a file of any supported file types.

Internal image format is 32bit ARGB with 8bit per channel.

Last image referenced, will be displayed in X window, unless -n option
is specified. If -r option is specified, then this image will be
displayed in root window of X display, effectively setting a background
for a desktop. If -o option is specified, this image will also be
saved into the file or requested type.

ascompose can be compiled to not reference X Window System, thus
allowing it to be used on web servers and any other place. It does not
even require X libraries in that case.

Supported file types for input are :
XPM   - via internal code, or libXpm library.
JPEG  - via libJpeg library.
PNG   - via libPNG library.
XCF   - via internal code. For now XCF support is not complete as it
        does not merge layers.
PPM/PNM - via internal code.
BMP, ICO, CUR - via internal code.
GIF   - via libungif library.
TIFF  - via libtiff library (including alpha channel support).
see libAfterImage/ASImageFileTypes for more.

Supported file types for output :
XPM   - via internal code, or libXpm library.
JPEG  - via libJpeg library.
PNG   - via libPNG library.
GIF   - via libungif library.
TIFF  - via libtiff library (including alpha channel support).
.fi 
.SH OPTIONS
.nf
   -h --help          display help and exit.
   -f --file file     an XML file to use as input.
   -s --string string an XML string to use as input.
   -n --no-display    don't display the last referenced image.
   -r --root-window   draw last referenced image image on root window.
   -o --output file   output last referenced image in to a file.
                      You should use -t to specify what file type to
                      use. Filenames are meaningless when it comes to
                      determining what file type to use.
   -t --type type     type of file to output to.
   -c --compress level compression level.
   -v --version       display version and exit.
   -V --verbose       increase verbosity. To increase verbosity level
                      use several of these, like: ascompose -V -V -V.
   -D --debug         maximum verbosity - show everything and
                      debug messages.
   -i --include file  include file as input prior to processing main 
                         file.
.fi 
.SH PORTABILITY
.nf
ascompose could be used both with and without X window system. It has
been tested on most UNIX flavors on both 32 and 64 bit architecture.
It has also been tested under CYGWIN environment on Windows 95/NT/2000
.fi 
.SH USES
.nf
libAfterImage         all the image manipulation routines.
libAfterBase          Optionally. Misc data handling such as hash
                      tables and console io. Must be used when compiled
                      without X Window support.
libJPEG               JPEG image format support.
libPNG                PNG image format support.
libungif              GIF image format support.
libTIFF               TIFF image format support.
.fi 
.SH AUTHOR
.nf
Ethan Fisher          <allanon at crystaltokyo dot com>
Sasha Vasko           <sasha at aftercode dot net>
Eric Kowalski         <eric at beancrock dot net>
.fi libAfterImage/ascompose/sample
.SH EXAMPLE
.nf
Here is the default script that gets executed by ascompose, if no
parameters are given :
.fi 
.SH SOURCE
Source : 
.nf
#if 1
static char* default_doc_str = "\
<composite op=hue>\
  <composite op=add>\
    <scale width=512 height=proportional>\
        <img id=rose src=rose512.jpg/></scale>\
    <tile width=512 height=384><img src=back.xpm/></tile>\
  </composite>\
  <tile width=512 height=384><img src=fore.xpm/></tile>\
</composite>\
<printf format=\"original image width=%d\n\" var=\"rose.width\"/>\
<printf format=\"original image height=%d\n\" var=\"rose.height\"/>\
<printf format=\
\"original image size in pixels=%d\n\" val=$rose.width*$rose.height/>";
#else   
static char* default_doc_str = "\
  <composite op=add>\
    <scale width=512 height=proportional>\
        <img id=rose src=rose512.jpg/></scale>\
    <tile width=512 height=384><img src=back.xpm/></tile>\
  </composite>";
#endif
.fi 
