.\" t
.\" @(#)transform.3		08/01/2007
.TH transform 1 "AfterStep v.2.2.6" "Aug  1 2007" "AfterStep X11 window manager"
.UC
.SH NAME
\fBtransform\fP\ - transformations available for ASImages
libAfterImage/transform.h
.SH NAMEtransform


.SH SYNOPSIS
.nf
Defines transformations that could be performed on ASImage.
.fi 
.SH DESCRIPTION
.nf
Transformations can be performed with different degree of quality.
Internal engine uses 24.8 bits per channel per pixel. As the result
there are no precision loss, while performing complex calculations.
Error diffusion algorithms could be used to transform it back into 8
bit without quality loss.

Any Transformation could be performed with the result written directly
into XImage, so that it could be displayed faster.

Complex interpolation algorithms are used to perform scaling
operations, thus yielding very good quality. All the transformations
are performed in integer math, with the result of greater speeds.
Optional MMX inline assembly has been incorporated into some
procedures, and allows to achieve considerably better performance on
compatible CPUs.
.fi 
.SH SEE ALSO
.nf
 Transformations :
         scale_asimage(), tile_asimage(), merge_layers(), 
            make_gradient(), flip_asimage(), mirror_asimage(), 
            pad_asimage(), blur_asimage_gauss(), fill_asimage(), 
            adjust_asimage_hsv()

 Other libAfterImage modules :
         ascmap.h asfont.h asimage.h asvisual.h blender.h export.h
         import.h transform.h ximage.h
.fi 
.SH AUTHOR
.nf
Sasha Vasko <sasha at aftercode dot net>
.fi libAfterImage/transform/scale_asimage()
.SH NAMEscale_asimage()
- scales source ASImage into new image of requested dimensions.

.SH SYNOPSIS
.nf
ASImage *scale_asimage( struct ASVisual *asv,
                        ASImage *src,
                        unsigned int to_width,
                        unsigned int to_height,
                        ASAltImFormats out_format,
                        unsigned int compression_out, int quality );
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "src"
- source ASImage
.IP "to_width"
- desired width of the resulting image
.IP "to_height"
- desired height of the resulting image
.IP "out_format"
- optionally describes alternative ASImage format that should be produced as the result - XImage, ARGB32, etc.
.IP "compression_out-"
compression level of resulting image in range 0-100.
.IP "quality"
- output quality

.SH RETURN VALUE
.nf
returns newly created and encoded ASImage on success, NULL of failure.
.fi 
.SH DESCRIPTION
.nf
If size has to be reduced - then several neighboring pixels will be 
averaged into single pixel. If size has to be increased then new 
pixels will be interpolated based on values of four neighboring pixels.
.fi 
.SH EXAMPLE
.nf
ASScale
.fi libAfterImage/transform/tile_asimage()
.SH NAMEtile_asimage()
- tiles/crops ASImage to desired size, while optionaly tinting it at the same time.

.SH SYNOPSIS
.nf
ASImage *tile_asimage ( struct ASVisual *asv,
                        ASImage *src,
                        int offset_x,
                        int offset_y,
                        unsigned int to_width,
                        unsigned int to_height,
                        ARGB32 tint,
                        ASAltImFormats out_format,
                        unsigned int compression_out, int quality );
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "src"
- source ASImage
.IP "offset_x"
- left clip margin
.IP "offset_y"
- right clip margin
.IP "to_width"
- desired width of the resulting image
.IP "to_height"
- desired height of the resulting image
.IP "tint"
- ARGB32 value describing tinting color.
.IP "out_format"
- optionally describes alternative ASImage format that should be produced as the result - XImage, ARGB32, etc.
.IP "compression_out-"
compression level of resulting image in range 0-100.
.IP "quality"
- output quality

.SH RETURN VALUE
.nf
returns newly created and encoded ASImage on success, NULL of failure.
.fi 
.SH DESCRIPTION
.nf
Offset_x and offset_y define origin on source image from which
tiling will start. If offset_x or offset_y is outside of the image
boundaries, then it will be reduced by whole number of image sizes to
fit inside the image. At the time of tiling image will be tinted
unless tint == 0.
.fi 
.SH EXAMPLE
.nf
ASTile
.fi libAfterImage/transform/merge_layers()
.SH NAMEmerge_layers()


.SH SYNOPSIS
.nf
ASImage *merge_layers  ( struct ASVisual *asv,
                         ASImageLayer *layers, int count,
                         unsigned int dst_width,
                         unsigned int dst_height,
                         ASAltImFormats out_format,
                         unsigned int compression_out, int quality);
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "layers"
- array of ASImageLayer structures that will be rendered one on top of another. First element corresponds to the bottommost layer.
.IP "dst_width"
- desired width of the resulting image
.IP "dst_height"
- desired height of the resulting image
.IP "out_format"
- optionally describes alternative ASImage format that should be produced as the result - XImage, ARGB32, etc.
.IP "compression_out"
- compression level of resulting image in range 0-100.
.IP "quality"
- output quality

.SH RETURN VALUE
.nf
returns newly created and encoded ASImage on success, NULL of failure.
.fi 
.SH DESCRIPTION
.nf
merge_layers() will create new ASImage of requested size. It will then
go through all the layers, and fill image with composition.
Bottommost layer will be used unchanged and above layers will be
superimposed on it, using algorithm specified in ASImageLayer
structure of the overlaying layer. Layers may have smaller size
then destination image, and maybe placed in arbitrary locations. Each
layer will be padded to fit width of the destination image with all 0
effectively making it transparent.
.fi libAfterImage/transform/make_gradient()
.SH NAMEmake_gradient()
- renders linear gradient into new ASImage

.SH SYNOPSIS
.nf
ASImage *make_gradient ( struct ASVisual *asv,
                         struct ASGradient *grad,
                         unsigned int width,
                         unsigned int height,
                         ASFlagType filter,
                         ASAltImFormats out_format,
                         unsigned int compression_out, int quality);
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "grad"
- ASGradient structure defining how gradient should be drawn
.IP "width"
- desired width of the resulting image
.IP "height"
- desired height of the resulting image
.IP "filter"
- only channels corresponding to set bits will be rendered.
.IP "out_format"
- optionally describes alternative ASImage format that should be produced as the result - XImage, ARGB32, etc.
.IP "compression_out-"
compression level of resulting image in range 0-100.
.IP "quality"
- output quality

.SH RETURN VALUE
.nf
returns newly created and encoded ASImage on success, NULL of failure.
.fi 
.SH DESCRIPTION
.nf
make_gradient() will create new image of requested size and it will
fill it with gradient, described in structure pointed to by grad.
Different dithering techniques will be applied to produce nicer
looking gradients.
.fi libAfterImage/transform/flip_asimage()
.SH NAMEflip_asimage()
- rotates ASImage in 90 degree increments

.SH SYNOPSIS
.nf
ASImage *flip_asimage ( struct ASVisual *asv,
                        ASImage *src,
                        int offset_x, int offset_y,
                        unsigned int to_width,
                        unsigned int to_height,
                        int flip, ASAltImFormats out_format,
                        unsigned int compression_out, int quality );
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "src"
- source ASImage
.IP "offset_x"
- left clip margin
.IP "offset_y"
- right clip margin
.IP "to_width"
- desired width of the resulting image
.IP "to_height"
- desired height of the resulting image
.IP "flip"
- flip flags determining degree of rotation.
.IP "out_format"
- optionally describes alternative ASImage format that should be produced as the result - XImage, ARGB32, etc.
.IP "compression_out"
- compression level of resulting image in range 0-100.
.IP "quality"
- output quality

.SH RETURN VALUE
.nf
returns newly created and encoded ASImage on success, NULL of failure.
.fi 
.SH DESCRIPTION
.nf
flip_asimage() will create new image of requested size, it will then
tile source image based on offset_x, offset_y, and destination size,
and it will rotate it then based on flip value. Three rotation angles
supported 90, 180 and 270 degrees.
.fi libAfterImage/transform/mirror_asimage()
.SH NAMEmirror_asimage()


.SH SYNOPSIS
.nf
ASImage *mirror_asimage ( struct ASVisual *asv,
                          ASImage *src,
                          int offset_x, int offset_y,
                          unsigned int to_width,
                          unsigned int to_height,
                          Bool vertical, ASAltImFormats out_format,
                          unsigned int compression_out, int quality );
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "src"
- source ASImage
.IP "offset_x"
- left clip margin
.IP "offset_y"
- right clip margin
.IP "to_width"
- desired width of the resulting image
.IP "to_height"
- desired height of the resulting image
.IP "vertical"
- mirror in vertical direction.
.IP "out_format"
- optionally describes alternative ASImage format that should be produced as the result - XImage, ARGB32, etc.
.IP "compression_out"
- compression level of resulting image in range 0-100.
.IP "quality"
- output quality

.SH RETURN VALUE
.nf
returns newly created and encoded ASImage on success, NULL of failure.
.fi 
.SH DESCRIPTION
.nf
mirror_asimage() will create new image of requested size, it will then
tile source image based on offset_x, offset_y, and destination size,
and it will mirror it in vertical or horizontal direction.
.fi libAfterImage/transform/pad_asimage()
.SH NAMEpad_asimage()
enlarges ASImage, padding it with specified color on each side in accordance with requested geometry.

.SH SYNOPSIS
.nf
ASImage *pad_asimage( ASVisual *asv, ASImage *src,
                     int dst_x, int dst_y,
                     unsigned int to_width,
                     unsigned int to_height,
                     ARGB32 color,
                     ASAltImFormats out_format,
                     unsigned int compression_out, int quality );
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "src"
- source ASImage
.IP "dst_x,"
dst_y - placement of the source image relative to the origin of destination image
.IP "to_width"
- width of the destination image
.IP "to_height"
- height of the destination image
.IP "color"
- ARGB32 color value to pad with.
.IP "out_format"
- optionally describes alternative ASImage format that should be produced as the result - XImage, ARGB32, etc.
.IP "compression_out"
- compression level of resulting image in range 0-100.
.IP "quality"
- output quality

.SH RETURN VALUE
.nf
returns newly created and encoded ASImage on success, NULL of failure.
.fi libAfterImage/transform/blur_asimage_gauss()
.SH NAMEblur_asimage_gauss()
Performs Gaussian blurr of the image ( usefull for drop shadows and the likes ).

.SH SYNOPSIS
.nf
ASImage* blur_asimage_gauss( ASVisual* asv, ASImage* src,
                             double horz, double vert,
                             ASAltImFormats out_format,
                             unsigned int compression_out, 
                                int quality );
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "src"
- source ASImage
.IP "horz"
- horizontal radius of the blurr
.IP "vert"
- vertical radius of the blurr
.IP "out_format"
- optionally describes alternative ASImage format that should be produced as the result - XImage, ARGB32, etc.
.IP "compression_out"
- compression level of resulting image in range 0-100.
.IP "quality"
- output quality

.SH RETURN VALUE
.nf
returns newly created and encoded ASImage on success, NULL of failure.
.fi libAfterImage/transform/fill_asimage()
.SH NAMEfill_asimage()
- Fills rectangle within the existing ASImage with specified color.

.SH SYNOPSIS
.nf
Bool fill_asimage( ASVisual *asv, ASImage *im,
                   int x, int y, int width, int height,
                   ARGB32 color );
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "im"
- ASImage to fill with the color
.IP "x,"
y - left-top corner of the rectangle to fill.
.IP "width,"
height - size of the rectangle to fill.
.IP "color"
- ARGB32 color value to fill rectangle with.

.SH RETURN VALUE
.nf
True on success, False on failure.
.fi libAfterImage/transform/adjust_asimage_hsv()
.SH NAMEadjust_asimage_hsv()
- adjusts image color properties in HSV colorspace

.SH SYNOPSIS
.nf
ASImage *adjust_asimage_hsv( ASVisual *asv, ASImage *src,
                             int offset_x, int offset_y,
                             unsigned int to_width,
                             unsigned int to_height,
                             unsigned int affected_hue,
                             unsigned int affected_radius,
                             int hue_offset, int saturation_offset,
                             int value_offset,
                             ASAltImFormats out_format,
                             unsigned int compression_out, int quality);
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "src"
- ASImage to adjust colors of.
.IP "offset_x,"

.IP "offset_y"
- position on infinite surface tiled with original image, of the left-top corner of the area to be used for new image.
.IP "to_width,"

.IP "to_height"
- size of the area of the original image to be used for new image.
.IP "affected_hue"
- hue in degrees in range 0-360. This allows to limit impact of color adjustment to affect only limited range of hues.
.IP "affected_radius"
Sets the diapason of the range of affected hues.
.IP "hue_offset"
- value by which to change hues in affected range.
.IP "saturation_offset"
- value by which to change saturation of the pixels in affected hue range.
.IP "value_offset"
- value by which to change Value(brightness) of pixels in affected hue range.
.IP "out_format"
- optionally describes alternative ASImage format that should be produced as the result - XImage, ARGB32, etc.
.IP "compression_out-"
compression level of resulting image in range 0-100.
.IP "quality"
- output quality

.SH RETURN VALUE
.nf
returns newly created and encoded ASImage on success, NULL of failure.
.fi 
.SH DESCRIPTION
.nf
This function will tile original image to specified size with offsets
requested, and then it will go though it and adjust hue, saturation and
value of those pixels that have specific hue, set by affected_hue/
affected_radius parameters. When affected_radius is greater then 180
entire image will be adjusted. Note that since grayscale colors have
no hue - the will not get adjusted. Only saturation and value will be
adjusted in gray pixels.
Hue is measured as an angle on a 360 degree circle, The following is
relationship of hue values to regular color names :
red      - 0
yellow   - 60
green    - 120
cyan     - 180
blue     - 240
magenta  - 300
red      - 360

All the hue values in parameters will be adjusted to fall withing
0-360 range.
.fi libAfterImage/transform/colorize_asimage_vector()
.SH NAMEcolorize_asimage_vector()
creates ASImage from double precision indexed image data - usefull for scientific visualisation.

.SH SYNOPSIS
.nf
Bool colorize_asimage_vector( ASVisual *asv, ASImage *im,
                                 ASVectorPalette *palette,
                              ASAltImFormats out_format,
                              int quality );
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "im"
- ASImage to update.
.IP "palette"
- palette to be used in conversion of double precision values into colors.
.IP "out_format"
- optionally describes alternative ASImage format that should be produced as the result - XImage, ARGB32, etc.
.IP "quality"
- output quality

.SH RETURN VALUE
.nf
True on success, False on failure.
.fi 
.SH DESCRIPTION
.nf
This function will try to convert double precision indexed image data
into actuall color image using palette. Original data should be 
attached to ASImage using vector member. Operation is relatively fast 
and allows representation of scientific data as color image with 
dynamically changing palette.
.fi libAfterImage/transform/create_asimage_from_vector()
.SH NAMEcreate_asimage_from_vector()
- convinience function allowing to create new ASImage, set its vector data and colorize it using palette - all in one step.

.SH SYNOPSIS
.nf
ASImage *create_asimage_from_vector( ASVisual *asv, double *vector,
                                     unsigned int width,
                                     unsigned int height,
                                     ASVectorPalette *palette,
                                     ASAltImFormats out_format,
                                     unsigned int compression,
                                     int quality );
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "vector"
- data to be attached to new ASImage and used to generate RGB image
.IP "width,"
height - size of the new image.
.IP "palette"
- palette to be used in conversion of double precision values into colors.
.IP "out_format"
- optionally describes alternative ASImage format that should be produced as the result - XImage, ARGB32, etc.
.IP "compression_out-"
compression level of resulting image in range 0-100.
.IP "quality"
- output quality

.SH RETURN VALUE
.nf
New ASImage  on success, NULL on failure.
.fi 
.SH SEE ALSO
.nf
colorize_asimage_vector(), create_asimage(), set_asimage_vector()
.fi libAfterImage/transform/slice_asimage2()
.SH NAMEslice_asimage2()
- slice ASImage leaving its corners intact, and scaling the middle part.

.SH SYNOPSIS
.nf
ASImage*
slice_asimage2( ASVisual *asv, ASImage *src,
            int slice_x_start, int slice_x_end,
            int slice_y_start, int slice_y_end,
            int to_width,
            int to_height,
            Bool scaled,
            ASAltImFormats out_format,
            unsigned int compression_out, int quality );
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure
.IP "src"
- source ASImage.
.IP "slice_x_start"
- ending of the left corners
.IP "slice_x_end"
- begining of the right corners
.IP "slice_y_start"
- ending of the top corners
.IP "slice_y_end"
- begining of the bottom corners
.IP "to_width"
- width of the generated image;
.IP "to_height"
- height of the generated image;
.IP "scaled"
- if True - middle part of the image will be scaled, otherwise - tiled;
.IP "out_format"
- optionally describes alternative ASImage format that should be produced as the result - XImage, ARGB32, etc.;
.IP "compression_out-"
compression level of resulting image in range 0-100;
.IP "quality"
- output quality.

.SH RETURN VALUE
.nf
New ASImage  on success, NULL on failure.
.fi 
.SH SEE ALSO
.nf
scale_asimage(), tile_asimage()
.fi 
