.\" t
.\" @(#)import.3		08/01/2007
.TH import 1 "AfterStep v.2.2.6" "Aug  1 2007" "AfterStep X11 window manager"
.UC
.SH NAME
\fBimport\fP\ - functionality for reading images from files
libAfterImage/import.h
.SH NAMEimport
- Image file format autodetection, reading and decoding routines.

.SH SEE ALSO
.nf
Functions :
        file2ASImage(), get_asimage(), file2pixmap()

Other libAfterImage modules :
         ascmap.h asfont.h asimage.h asvisual.h blender.h export.h
         import.h transform.h ximage.h
.fi 
.SH AUTHOR
.nf
Sasha Vasko <sasha at aftercode dot net>
.fi libAfterImage/gamma
.SH NAMESCREEN_GAMMA
- Defines default value for screen gamma correction.

.SH SOURCE
Source : 
.nf
#define SCREEN_GAMMA 2.2
#define DEFAULT_PNG_IMAGE_GAMMA     0.45455
.fi libAfterImage/ASImageFileTypes
.SH NAMEASImageFileTypes
- List of known image file formats.

.SH SOURCE
Source : 
.nf
typedef enum
{
    ASIT_Xpm = 0,
    ASIT_ZCompressedXpm,
    ASIT_GZCompressedXpm,
    ASIT_Png,
    ASIT_Jpeg,
    ASIT_Xcf,
    ASIT_Ppm,
    ASIT_Pnm,
    ASIT_Bmp,
    ASIT_Ico,
    ASIT_Cur,
    ASIT_Gif,
    ASIT_Tiff,
    ASIT_XMLScript,
    ASIT_SVG,
    /* reserved for future implementation : */
    ASIT_Xbm,
    ASIT_Targa,
    ASIT_Supported = ASIT_Targa,
    ASIT_Pcx,
    ASIT_HTML,
    ASIT_XML,
    ASIT_Unknown
}ASImageFileTypes;
.fi libAfterImage/ASImageListEntry
.SH NAMEASImageListEntry
- entry in linked list of images loaded from single directory.

.SH SOURCE
Source : 
.nf
typedef struct ASImageListEntryBuffer
{
#define ASILEB_Dirty        (0x01<<0)          
#define ASILEB_Binary       (0x01<<1)          

    ASFlagType flags ; 

    size_t size ; 
    char  *data ; 
    
}ASImageListEntryBuffer;

typedef struct ASImageListEntry
{
#define MAGIC_ASIMAGE_LIST_ENTRY            0xA3A311E4
#define IS_ASIMAGE_LIST_ENTRY(e)  (((e)!=NULL)&&((e)->magic==MAGIC_ASIMAGE_LIST_ENTRY)&&((e)->ref_count>0)) 

    unsigned long magic ; 
    struct ASImageListEntry *prev, *next ;
    char   *name ;
    char   *fullfilename ;

    ASImageFileTypes    type;
    ASImage            *preview;
    
    mode_t d_mode;
    time_t d_mtime;
    off_t  d_size;      /* total size, in bytes */

    ASImageListEntryBuffer *buffer ; 

    int ref_count;
}ASImageListEntry;
.fi libAfterImage/import/file2ASImage()
.SH NAMEfile2ASImage()
- load ASImage from file.

.SH SYNOPSIS
.nf
ASImage *file2ASImage( const char *file, ASFlagType what,
                       double gamma,
                       unsigned int compression, ... );
.fi 
.SH INPUTS
.IP "file"
- file name with or without directory name
.IP "what"
- reserved for future use
.IP "gamma"
- gamma value to be used to correct image
.IP "compression"
- compression level of the resulting ASImage
.IP "..."
- NULL terminated list of strings, representing arbitrary number of directories to be searched each.

.SH RETURN VALUE
.nf
Pointer to ASImage structure holding image data on success.
NULL on failure
.fi 
.SH DESCRIPTION
.nf
file2ASImage will attempt to interpret filename in the following way:
1)It will try to find file using unmodified filename in all the
provided search paths.
2)It will attempt to append .gz and then .Z to the filename and
find such file in all the provided search paths.
3)If filename ends with extension consisting of digits only - it will
attempt to find file with this extension stripped off. On success
this extension will be used to load subimage from the file with that
number. Subimages are supported only for XCF, GIF, BMP, ICO and CUR
files.
After the file is found file2ASImage() attempts to detect file format,
and if it is known it will load it into new ASImage structure.
.fi 
.SH EXAMPLE
.nf
asview.c: ASView.2
.fi libAfterImage/import/get_asimage()
.SH NAMEget_asimage()
- increment reference counter if file is already loaded, or load image from file.

.SH SYNOPSIS
.nf
ASImage *get_asimage( ASImageManager* imageman, const char *file,
                      ASFlagType what, unsigned int compression );
.fi 
.SH INPUTS
.IP "imageman"
- pointer to valid ASVisual structure.
.IP "file"
- root window ID for the destination screen.
.IP "what"
- full image file's name with path.
.IP "compression"
-

.SH RETURN VALUE
.nf
Pointer to ASImage structure holding image data on success.
NULL on failure
.fi 
.SH DESCRIPTION
.nf
get_asimage will attempt check with the ASImageManager's list of load
images, and if image with requested filename already exists - it will
increment its reference count and return its pointer.
Otherwise it will call file2ASImage() to load image from file. It will
use PATH and gamma values from the ASImageManager to pass to
file2ASImage(). If image is successfully loaded - it will be added to
the ASImageManager's list and its pointer will be returned.
.fi 
.SH SEE ALSO
.nf
file2ASImage()
.fi libAfterImage/import/file2pixmap()
.SH NAMEfile2pixmap()
- convinience function to load file into X Pixmap.

.SH SYNOPSIS
.nf
Pixmap file2pixmap( struct ASVisual *asv, Window root,
                    const char *realfilename,
                    Pixmap *mask_out);
.fi 
.SH INPUTS
.IP "asv"
- pointer to valid ASVisual structure.
.IP "root"
- root window ID for the destination screen.
.IP "realfilename"
- full image file's name with path.

.SH RETURN VALUE
.nf
Pixmap ID of the X Pixmap filled with loaded image. If mask_out is
not NULL it will point to image mask Pixmap ID if there is an alpha
channel in image, None otherwise.
On failure None will be returned.
.fi 
.SH DESCRIPTION
.nf
file2pixmap() will attempt to open specified file and autodetect its
format. If format is known it will load it into ASImage first, and
then convert it into X Pixmap. In case image has alpha channel -
mask Pixmap will be produced if mask_out is not NULL.
.fi 
