.if !\n(.g .ab GNU tbl requires GNU troff.
.if !dTS .ds TS
.if !dTE .ds TE
.lf 1 xiterm.man
.TH "1" "XITERM" "JULY, 15 1998" "X Version 11" "X Tools" 
.SH "NAME" 
xiterm (X international terminal) \- a VT102 emulator for the X window system
.PP 
.SH "SYNOPSIS" 
.PP 
\fBxiterm\fP [options] [-e command [ args ]]
.PP 
.SH "DESCRIPTION" 
.PP 
\fBxiterm\fP, version \fB2\&.0\fP, is a colour vt102 terminal emulator
intended as an \fIxterm\fP(1) replacement for users who do not require
features such as Tektronix 4014 emulation and toolkit-style configurability\&.
As a result, \fBxiterm\fP uses much less swap space -- a significant
advantage on a machine serving many X sessions\&.
.PP 
.PP 
.SH "OPTIONS" 
.PP 
The \fBxiterm\fP options (mostly a subset of \fIxterm\fP\'s) are listed below\&.
In keeping with the smaller-is-better philosophy, options may be eliminated
or default values chosen at compile-time, so options and defaults listed
may not accurately reflect the version installed on your system\&.
.PP 
Note that \fBxiterm\fP permits the resource name to be used as a long-option
(--/++ option) so the potential command-line options are far greater than
those listed\&.
For example: `xiterm --loginShell --color1 Orange\'\&.
.PP 
.IP "\fB-help\fP, \fB--help\fP" 
Print out a message describing available options\&.
.IP "\fB-display\fP \fIdisplayname\fP" 
Attempt to open a window on the named X display (\fB-d\fP still
respected)\&.  In the absence of this option, the display specified
by the \fBDISPLAY\fP environment variable is used\&.
.IP "\fB-geometry\fP \fIgeom\fP" 
Window geometry (-g still respected);
resource \fBgeometry\fP\&.
.IP "\fB-rv\fP|\fB+rv\fP" 
Turn on/off simulated reverse video;
resource \fBreverseVideo\fP\&.
.IP "\fB-bg\fP \fIcolour\fP" 
Window background colour;
resource \fBbackground\fP\&.
.IP "\fB-fg\fP \fIcolour\fP" 
Window foreground colour;
resource \fBforeground\fP\&.
.IP "\fB-pixmap:\fP \fIfile[;geom]\fP" 
Specify XPM file for the background and also optionally specify its
scaling with a geometry string\&.  Note you may need to add quotes to
avoid special shell interpretation of the `;\' in the command-line;
resource \fBbackgroundPixmap\fP\&.
.IP "\fB-cr\fP \fIcolour\fP" 
The cursor colour;
resource \fBcursorColor\fP\&.
.IP "\fB-pr\fP \fIcolour\fP" 
The mouse pointer colour;
resource \fBpointerColor\fP\&.
.IP "\fB-bd\fP \fIcolour\fP" 
The colour of the border between the xterm scrollbar and the text;
resource \fBborderColor\fP\&.
.IP "\fB-fn\fP \fIfontname\fP" 
Main normal text font;
resource \fBfont\fP\&.
.IP "\fB-fb\fP \fIfontname\fP" 
Main bold text font;
resource \fBboldFont\fP\&.
.IP "\fB-fm\fP \fIfontname\fP" 
Main multicharacter font;
resource \fBmfont\fP\&.
.IP "\fB-km\fP \fImode\fP" 
Multiple-character font-set encoding mode;
\fBeucj\fP: EUC Japanese encoding\&.
\fBsjis\fP: Shift JIS encoding;
resource \fBmultichar_encoding\fP\&.
.IP "\fB-grk\fP \fImode\fP" 
Greek keyboard translation;
\fBiso\fP: ISO-8859 mapping\&.
\fBibm\fP: IBM-437 mapping;
resource \fBgreek_keyboard\fP\&.
.IP "\fB-name\fP \fIname\fP" 
Specify the application name under which resources
are to be obtained, rather than the default executable file name\&.
Name should not contain `\&.\' or `*\' characters\&.
Also sets the icon and title name\&.
.IP "\fB-ls\fP|\fB+ls\fP" 
Start as a login-shell/sub-shell;
resource \fBloginShell\fP\&.
.IP "\fB-ut\fP|\fB+ut\fP" 
Inhibit/enable writing a utmp entry;
resource \fButmpInhibit\fP\&.
.IP "\fB-vb\fP|\fB+vb\fP" 
Turn on/off visual bell on receipt of a bell character;
resource \fBvisualBell\fP\&.
.IP "\fB-sb\fP|\fB+sb\fP" 
Turn on/off scrollbar;
resource \fBscrollBar\fP\&.
.IP "\fB-si\fP|\fB+si\fP" 
Turn on/off scroll-to-bottom on TTY output inhibit;
resource \fBscrollTtyOutput\fP\&.
.IP "\fB-sk\fP|\fB+sk\fP" 
Turn on/off scroll-to-bottom on keypress;
resource \fBscrollKeypress\fP\&.
.IP "\fB-sr\fP|\fB+sr\fP" 
Put scrollbar on right/left;
resource \fBscrollBar_right\fP\&.
.IP "\fB-st\fP|\fB+st\fP" 
Display scrollbar without/with a trough;
resource \fBscrollBar_floating\fP\&.
.IP "\fB-iconic\fP" 
Start iconified, if the window manager supports that option\&.
.IP "\fB-sl\fP \fInumber\fP" 
Save \fInumber\fP lines in the scrollback buffer;
resource \fBsaveLines\fP\&.
.IP "\fB-tn\fP \fItermname\fP" 
This option specifies the name of the terminal type to be set in the
\fBTERM\fP environment variable\&. This terminal type must exist in the
\fItermcap(5)\fP database and should have \fIli#\fP and \fIco#\fP entries;
resource \fBtermName\fP\&.
.IP "\fB-e\fP \fIcommand [arguments]\fP" 
Run the command with its command-line arguments in the \fBxiterm\fP
window; also sets the window title and icon name to be the basename
of the program being executed if neither \fI-title\fP (\fI-T\fP) nor
\fI-n\fP are given on the command line\&.  If this option is used, it
must be the last on the command-line\&.  If there is no \fB-e\fP option
then the default is to run the program specified by the \fBSHELL\fP
environment variable or, failing that, \fIsh(1)\fP\&.
.IP "\fB-title\fP \fItext\fP" 
Window title \fB-T\fP still respected); the default title is the
basename of the program specified after the \ef3\e-e\efP option, if
any, otherwise the application name;
resource \fBtitle\fP\&.
.IP "\fB-n\fP \fItext\fP" 
Icon name; the default name is the basename of the program specified
after the \ef3\e-e\efP option, if any, otherwise the application name;
resource \fBiconName\fP\&.
.IP "\fB-C\fP" 
Capture system console messages\&.
.SH "RESOURCES (available also as long-options)" 
.PP 
\fBxiterm\fP accepts application defaults set in XAPPLOADDIR/xiterm (compile-time
defined: usually \fB/usr/lib/X11/app-defaults/xiterm\fP) and resources set in
\fB~/\&.Xdefaults\fP or \fB~/\&.Xresources\fP\&.  Note that when reading X resources,
\fBxiterm\fP recognizes two class names: \fBXTerm\fP and \fBxiterm\fP\&.  The class name
\fBXTerm\fP allows resources common to both \fBxiterm\fP and \fIxterm\fP to be easily
configured, while the class name \fBxiterm\fP allows resources unique to \fBxiterm\fP,
notably colours and key-handling, to be shared between different \fBxiterm\fP
configurations\&.  If no resources are specified, suitable defaults will be
used\&.  Command-line arguments can be used to override resource settings\&.  The
following resources are allowed:
.PP 
.IP "\fBgeometry:\fP \fIgeom\fP" 
Create the window with the specified X window geometry [default
80x24];
option \fB-geometry\fP\&.
.IP "\fBbackground:\fP \fIcolour\fP" 
Use the specified colour as the window\'s background colour [default
White];
option \fB-bg\fP\&.
.IP "\fBforeground:\fP \fIcolour\fP" 
Use the specified colour as the window\'s foreground colour [default
Black];
option \fB-fg\fP\&.
.IP "\fBcolor\fP\fIn\fP\fB:\fP \fIcolour\fP" 
Use the specified colour for the colour value \fIn\fP, where 0-7
corresponds to low-intensity (normal) colours and 8-15 corresponds to
high-intensity (bold = bright foreground, blink = bright
background) colours\&.  The canonical names are as follows:
0=black, 1=red, 2=green, 3=yellow, 4=blue, 5=magenta, 6=cyan, 7=white,
but the actual colour names used are listed in the
\fBCOLORS AND GRAPHICS\fP section\&.
.IP "\fBcolorBD:\fP \fIcolour\fP" 
Use the specified colour to display bold characters when the
foreground colour is the default\&.
.IP "\fBcolorUL:\fP \fIcolour\fP" 
Use the specified colour to display underlined characters when the
foreground colour is the default\&.
.IP "\fBcursorColor:\fP \fIcolour\fP" 
Use the specified colour for the cursor\&.  The default is to use the
foreground colour;
option \fB-cr\fP\&.
.IP "\fBcursorColor2:\fP \fIcolour\fP" 
Use the specified colour for the colour of the cursor text\&.  For this
to take effect, \fBcursorColor\fP must also be specified\&.  The default
is to use the background colour\&.
.IP "\fBreverseVideo:\fP \fIboolean\fP" 
\fBTrue\fP: simulate reverse video by foreground and background colours;
option \fB-rv\fP,
\fBFalse\fP: regular screen colours [default];
option \fB+rv\fP\&.
See note in \fBCOLORS AND GRAPHICS\fP section\&.
.IP "\fBscrollColor:\fP \fIcolour\fP" 
Use the specified colour for the scrollbar [default #B2B2B2]\&.
.IP "\fBthroughColor:\fP \fIcolour\fP" 
Use the specified colour of the scrollbar\'s through area [default
#A2A2A2]\&.
.IP "\fBbackgroundPixmap:\fP \fIfile[;geom]\fP" 
Use the specified XPM file (note the `\&.xpm\' extension is optional)
for the background and also optionally specify its scaling with a
geometry string \fBWxH+X+Y\fP, in which \fB"W" / "H"\fP specify the
horizontal/vertical scale (percent) and \fB"X" / "Y"\fP locate the
image centre (percent)\&.  A scale of 0 displays the image with tiling\&.
A scale of 1 displays the image without any scaling\&.  A scale of 2 to
9 specifies an integer number of images in that direction\&.  No image
will be magnified beyond 10 times its original size\&.  The maximum
permitted scale is 1000\&.  [default 0x0+50+50]
.IP "\fBmenu:\fP \fIfile[;tag]\fP" 
Read in the specified menu file (note the `\&.menu\' extension is
optional) and also optionally specify a starting tag to find\&.  See
the reference documentation for details on the syntax for the menuBar\&.
.IP "\fBpath:\fP \fIpath\fP" 
Specify the colon-delimited search path for finding files (XPM and
menus), in addition to the paths specified by the \fBXITERMPATH\fP and
\fBPATH\fP environment variables\&.
.IP "\fBfont:\fP \fIfontname\fP" 
Select the main text font used [default 7x14];
option \fB-fn\fP\&.
.IP "\fBfont\fP\fIn\fP\fB:\fP \fIfontname\fP" 
Specify the alternative font \fIn\fP\&.  The default font values: 
.br 
.RS 
.IP 
.TS 
.nr 3c \n(.C
.cp 0
.nr 3lps \n[.s]
.nr 3cent \n[.ce]
.de 3init
.ft \n[.f]
.ps \n[.s]
.vs \n[.v]u
.in \n[.i]u
.ll \n[.l]u
.ls \n[.L]
.ad \n[.j]
.ie \n[.u] .fi
.el .nf
.ce \n[.ce]
..
.nr 3ind \n[.i]
.nr 3fnt \n[.f]
.nr 3sz \n[.s]
.nr 3fll \n[.u]
.nr T. 0
.nr 3crow 0-1
.nr 3passed 0-1
.nr 3sflag 0
.ds 3trans
.ds 3quote
.nr 3brule 1
.nr 3supbot 0
.eo
.de 3rmk
.mk \$1
.if !'\n(.z'' \!.3rmk "\$1"
..
.de 3rvpt
.vpt \$1
.if !'\n(.z'' \!.3rvpt "\$1"
..
.de 3keep
.if '\n[.z]'' \{.ds 3quote \\
.ds 3trans \!
.di 3section
.nr 3sflag 1
.in 0
.\}
..
.de 3release
.if \n[3sflag] \{.di
.in \n[3ind]u
.nr 3dn \n[dn]
.ds 3quote
.ds 3trans
.nr 3sflag 0
.if \n[.t]<=\n[dn] \{.nr T. 1
.T#
.nr 3supbot 1
.sp \n[.t]u
.nr 3supbot 0
.mk #T
.\}
.if \n[.t]<=\n[3dn] .tm warning: page \n%: table text block will not fit on one page
.nf
.ls 1
.3section
.ls
.rm 3section
.\}
..
.nr 3tflag 0
.de 3tkeep
.if '\n[.z]'' \{.di 3table
.nr 3tflag 1
.\}
..
.de 3trelease
.if \n[3tflag] \{.br
.di
.nr 3dn \n[dn]
.ne \n[dn]u+\n[.V]u
.ie \n[.t]<=\n[3dn] .tm error: page \n%: table will not fit on one page; use .TS H/.TH with a supporting macro package
.el \{.in 0
.ls 1
.nf
.3table
.\}
.rm 3table
.\}
..
.ec
.ce 0
.nf
.nr 3sep 1n
.nr 3w0 \n(.H
.nr 3aw0 0
.nr 3lnw0 0
.nr 3rnw0 0
.nr 3w1 \n(.H
.nr 3aw1 0
.nr 3lnw1 0
.nr 3rnw1 0
.lf 226 xiterm.man
.nr 3w0 \n[3w0]>?\w\[tbl]\fBfont\fP: \[tbl]
.lf 226
.nr 3w1 \n[3w1]>?\w\[tbl]\ 7x14 \[tbl]
.lf 227
.nr 3w0 \n[3w0]>?\w\[tbl]\fBfont1\fP: \[tbl]
.lf 227
.nr 3w1 \n[3w1]>?\w\[tbl]\ 6x10 \[tbl]
.lf 228
.nr 3w0 \n[3w0]>?\w\[tbl]\fBfont2\fP: \[tbl]
.lf 228
.nr 3w1 \n[3w1]>?\w\[tbl]\ 6x13 \[tbl]
.lf 229
.nr 3w0 \n[3w0]>?\w\[tbl]\fBfont3\fP: \[tbl]
.lf 229
.nr 3w1 \n[3w1]>?\w\[tbl]\ 8x13 \[tbl]
.lf 230
.nr 3w0 \n[3w0]>?\w\[tbl]\fBfont4\fP: \[tbl]
.lf 230
.nr 3w1 \n[3w1]>?\w\[tbl]\ 9x15 \[tbl]
.nr 3w0 \n[3w0]>?(\n[3lnw0]+\n[3rnw0])
.if \n[3aw0] .nr 3w0 \n[3w0]>?(\n[3aw0]+2n)
.nr 3w1 \n[3w1]>?(\n[3lnw1]+\n[3rnw1])
.if \n[3aw1] .nr 3w1 \n[3w1]>?(\n[3aw1]+2n)
.nr 3cd0 0
.nr 3cl0 0*\n[3sep]
.nr 3ce0 \n[3cl0]+\n[3w0]
.nr 3cl1 \n[3ce0]+(3*\n[3sep])
.nr 3cd1 \n[3ce0]+\n[3cl1]/2
.nr 3ce1 \n[3cl1]+\n[3w1]
.nr 3cd2 \n[3ce1]+(0*\n[3sep])
.nr TW \n[3cd2]
.if \n[3cent] \{.in +(u;\n[.l]-\n[.i]-\n[TW]/2)
.nr 3ind \n[.i]
.\}
.eo
.de T#
.if !\n[3supbot] \{.3rvpt 0
.mk 3vert
.ls 1
.ls
.nr 3passed \n[3crow]
.sp |\n[3vert]u
.3rvpt 1
.\}
..
.ec
.fc 
.3keep
.3rmk 3rt0
\*[3trans].nr 3crow 0
.3keep
.mk 3rs0
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u
.lf 226
\&\h'|\n[3cl0]u'\fBfont\fP: \h'|\n[3cl1]u'\ 7x14 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs0]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt1
\*[3trans].nr 3crow 1
.3keep
.mk 3rs1
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u
.lf 227
\&\h'|\n[3cl0]u'\fBfont1\fP: \h'|\n[3cl1]u'\ 6x10 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs1]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt2
\*[3trans].nr 3crow 2
.3keep
.mk 3rs2
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u
.lf 228
\&\h'|\n[3cl0]u'\fBfont2\fP: \h'|\n[3cl1]u'\ 6x13 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs2]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt3
\*[3trans].nr 3crow 3
.3keep
.mk 3rs3
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u
.lf 229
\&\h'|\n[3cl0]u'\fBfont3\fP: \h'|\n[3cl1]u'\ 8x13 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs3]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt4
\*[3trans].nr 3crow 4
.3keep
.mk 3rs4
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u
.lf 230
\&\h'|\n[3cl0]u'\fBfont4\fP: \h'|\n[3cl1]u'\ 9x15 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs4]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.mk 3rt5
.nr 3brule 1
.nr T. 1
.T#
.3init
.fc
.cp \n(3c
.lf 231
.TE 
.RE 
.IP 
.IP "\fBboldFont:\fP \fIfontname\fP" 
Specify the name of the bold font to use if \fBcolorBD\fP has not been
specified and it is not possible to map the default foreground colour
to colour 8-15 [default NONE]\&.  This font must be the same height and
width as the normal font;
option \fB-fb\fP\&.
.IP "\fBmfont:\fP \fIfontname\fP" 
Select the main multiple-character text font used [default k14];
option \fB-fk\fP\&.
.IP "\fBmfont\fP\fIn\fP\fB:\fP \fIfontname\fP" 
Specify the alternative multiple-character font \fIn\fP\&.  If compiled
for multiple-character fonts, the Roman and multiple-character font
sizes should match\&.
.IP "\fBmultichar_encoding:\fP \fImode\fP" 
Set the encoding mode to be used when multicharacter encoding is
received;
\fBeucj\fP: EUC Japanese encoding [default for Kanji]\&.
\fBsjis\fP: Shift JIS encoding\&.
\fBbig5\fP: BIG5 encoding;
option \fB-km\fP\&.
.IP "\fBgreek_keyboard:\fP \fImode\fP" 
Set the Greek keyboard translation mode to be used;
\fBiso\fP: ISO-8859 mapping (elot-928) [default]\&.
\fBibm\fP: IBM-437 mapping (DOS codepage 737);
option \fB-grk\fP\&.
Use \fBMode_switch\fP to toggle keyboard input\&.  For more details,
see the distributed file \fBREADME\&.greek\fP\&.
.IP "\fBtitle:\fP \fItext\fP" 
Set window title string, the default title is the command-line
specified after the \fB-e\fP option, if any, otherwise the application
name;
option \fB-title\fP\&.
.IP "\fBiconName:\fP \fItext\fP" 
Set the name used to label the window\'s icon or displayed in an icon
manager window, it also sets the window\'s title unless it is
explicitly set;
option \fB-n\fP\&.
.IP "\fBmapAlert:\fP \fIboolean\fP" 
\fBTrue\fP: de-iconify (map) on receipt of a bell character\&.
\fBFalse\fP: no de-iconify (map) on receipt of a bell character
[default]\&.
.IP "\fBvisualBell:\fP \fIboolean\fP" 
\fBTrue\fP: use visual bell on receipt of a bell character;
option \fB-vb\fP\&.
\fBFalse\fP: no visual bell [default];
option \fB+vb\fP\&.
.IP "\fBloginShell:\fP \fIboolean\fP" 
\fBTrue\fP: start as a login shell by prepending a `-\' to \fBargv[0]\fP
of the shell;
option \fB-ls\fP\&.
\fBFalse\fP: start as a normal sub-shell [default];
option \fB+ls\fP\&.
.IP "\fButmpInhibit:\fP \fIboolean\fP" 
\fBTrue\fP: inhibit writing record into the system log file \fButmp\fP;
option \fB-ut\fP\&.
\fBFalse\fP: write record into the system log file \fButmp\fP [default];
option \fB+ut\fP\&.
.IP "\fBprint-pipe:\fP \fIstring\fP" 
Specify a command pipe for vt100 printer [default \fIlpr(1)\fP]\&.  Use
\fBPrint\fP to initiate a screen dump to the printer and \fBCtrl-Print\fP
or \fBShift-Print\fP to include the scrollback as well\&.
.IP "\fBscrollBar:\fP \fIboolean\fP" 
\fBTrue\fP: enable the scrollbar [default];
option \fB-sb\fP\&.
\fBFalse\fP: disable the scrollbar;
option \fB+sb\fP\&.
Note that the scrollbar type (with/without arrows) is compile-time
selected\&.
.IP "\fBsmallfont_key:\fP \fIkeysym\fP" 
If enabled, use \fBAlt-\fP\fIkeysym\fP to toggle to a smaller font
[default \fBAlt-<\fP]
.IP "\fBbigfont_key:\fP \fIkeysym\fP" 
If enabled, use \fBAlt-\fP\fIkeysym\fP to toggle to a bigger font
[default \fBAlt->\fP]
.IP "\fBsaveLines:\fP \fInumber\fP" 
Save \fInumber\fP lines in the scrollback buffer [default 64];
option \fB-sl\fP\&.
.IP "\fBtermName:\fP \fItermname\fP" 
Specifies the terminal type name to be set in the \fBTERM\fP
environment variable;
option \fB-tn\fP\&.
.IP "\fBmeta8:\fP \fIboolean\fP" 
\fBTrue\fP: handle Meta (Alt) + keypress to set the 8th bit\&.
\fBFalse\fP: handle Meta (Alt) + keypress as an escape prefix [default]\&.
.IP "\fBcutchars:\fP \fIstring\fP" 
The characters used as delimiters for double-click word selection\&. 
The built-in default: 
.br 
\fBBACKSLASH `"\'&()*,;<=>?@[]{|}\fP
.IP "\fBkeysym\&.\fP\fIsym\fP: \fIstring\fP" 
Associate \fIstring\fP with keysym \fIsym\fP (\fB0xFF00 - 0xFFFF\fP)\&.  It
may contain escape values (\ea: bell, \eb: backspace, \ee, \eE: escape,
\en: newline, \er: return, \et: tab, \e000: octal number) or control
characters (^?: delete, ^@: null, ^A \&.\&.\&.) and may enclosed with
double quotes so that it can start or end with whitespace\&.  The
intervening resource name \fBkeysym\&.\fP cannot be omitted\&.  This
resource is only available when compiled with KEYSYM_RESOURCE\&.
.SH "THE SCROLLBAR" 
.PP 
Lines of text that scroll off the top of the \fBxiterm\fP window (resource:
\fBsaveLines\fP) and can be scrolled back using the scrollbar or by keystrokes\&. 
The normal \fBxiterm\fP scrollbar has arrows and its behaviour is fairly
intuitive\&.  The \fBxterm-scrollbar\fP is without arrows and its behaviour
mimics that of \fIxterm\fP
.PP 
Scroll down with \fBButton1\fP (\fBxterm-scrollbar\fP) or \fBShift-Next\fP\&.
Scroll up with \fBButton3\fP (\fBxterm-scrollbar\fP) or \fBShift-Prior\fP\&.
Continuous scroll with \fBButton2\fP\&.
.SH "MOUSE REPORTING" 
.PP 
To temporarily override mouse reporting, for either the scrollbar or the
normal text selection/insertion, hold either the Shift or the Meta (Alt) key
while performing the desired mouse action\&.
.PP 
If mouse reporting mode is active, the normal scrollbar actions are disabled
-- on the assumption that we are using a fullscreen application\&.
Instead, pressing Button1 and Button3 sends
\fBESC[6~\fP (Next) and \fBESC[5~\fP (Prior), respectively\&.
Similarly, clicking on the up and down arrows sends \fBESC[A\fP (Up) and
\fBESC[B\fP (Down), respectively\&.
.SH "TEXT SELECTION AND INSERTION" 
.PP 
The behaviour of text selection and insertion mechanism is similar to
\fIxterm\fP(1)\&.
.PP 
.IP "\fBSelection\fP:" 
Left click at the beginning of the region, drag to the end of the
region and release; Right click to extend the marked region;
Left double-click to select a word; Left triple-click to select
the entire line\&.
.IP 
.IP "\fBInsertion\fP:" 
Pressing and releasing the Middle mouse button (or \fBShift-Insert\fP)
in an \fBxiterm\fP window causes the current text selection to be inserted
as if it had been typed on the keyboard\&.
.SH "CHANGING FONTS" 
.PP 
You can change fonts on-the-fly, which is to say cycle through the default
font and others of various sizes, by using \fBShift-KP_Add\fP and
\fBShift-KP_Subtract\fP\&.  Or, alternatively (if enabled) with
\fBAlt->\fP and \fBAlt-<\fP, where the actual key
can be selected using resources \fBsmallfont_key\fP/\fBbigfont_key\fP\&.
.SH "LOGIN STAMP" 
.PP 
\fBxiterm\fP tries to write an entry into the \fIutmp\fP(5) file so that it can be
seen via the \fIwho(1)\fP command, and can accept messages\&.  To allow this
feature, \fBxiterm\fP must be installed setuid root on some systems\&.
.SH "COLORS AND GRAPHICS" 
.PP 
If graphics support was enabled at compile-time, \fBxiterm\fP can be queried
with ANSI escape sequences and can address individual pixels instead of
text characters\&.  Note the graphics support is still considered beta code\&.
.PP 
In addition to the default foreground and background colours, \fBxiterm\fP
can display up to 16 colours (8 ANSI colours plus high-intensity bold/blink
versions of the same)\&.
Here is a list of the colours with their \fBrgb\&.txt\fP names\&.
.PP 
.TS 
.nr 3c \n(.C
.cp 0
.nr 3lps \n[.s]
.nr 3cent \n[.ce]
.de 3init
.ft \n[.f]
.ps \n[.s]
.vs \n[.v]u
.in \n[.i]u
.ll \n[.l]u
.ls \n[.L]
.ad \n[.j]
.ie \n[.u] .fi
.el .nf
.ce \n[.ce]
..
.nr 3ind \n[.i]
.nr 3fnt \n[.f]
.nr 3sz \n[.s]
.nr 3fll \n[.u]
.nr T. 0
.nr 3crow 0-1
.nr 3passed 0-1
.nr 3sflag 0
.ds 3trans
.ds 3quote
.nr 3brule 1
.nr 3supbot 0
.eo
.de 3rmk
.mk \$1
.if !'\n(.z'' \!.3rmk "\$1"
..
.de 3rvpt
.vpt \$1
.if !'\n(.z'' \!.3rvpt "\$1"
..
.de 3keep
.if '\n[.z]'' \{.ds 3quote \\
.ds 3trans \!
.di 3section
.nr 3sflag 1
.in 0
.\}
..
.de 3release
.if \n[3sflag] \{.di
.in \n[3ind]u
.nr 3dn \n[dn]
.ds 3quote
.ds 3trans
.nr 3sflag 0
.if \n[.t]<=\n[dn] \{.nr T. 1
.T#
.nr 3supbot 1
.sp \n[.t]u
.nr 3supbot 0
.mk #T
.\}
.if \n[.t]<=\n[3dn] .tm warning: page \n%: table text block will not fit on one page
.nf
.ls 1
.3section
.ls
.rm 3section
.\}
..
.nr 3tflag 0
.de 3tkeep
.if '\n[.z]'' \{.di 3table
.nr 3tflag 1
.\}
..
.de 3trelease
.if \n[3tflag] \{.br
.di
.nr 3dn \n[dn]
.ne \n[dn]u+\n[.V]u
.ie \n[.t]<=\n[3dn] .tm error: page \n%: table will not fit on one page; use .TS H/.TH with a supporting macro package
.el \{.in 0
.ls 1
.nf
.3table
.\}
.rm 3table
.\}
..
.ec
.ce 0
.nf
.nr 3sep 1n
.nr 3w0 \n(.H
.nr 3aw0 0
.nr 3lnw0 0
.nr 3rnw0 0
.nr 3w1 \n(.H
.nr 3aw1 0
.nr 3lnw1 0
.nr 3rnw1 0
.nr 3w2 \n(.H
.nr 3aw2 0
.nr 3lnw2 0
.nr 3rnw2 0
.lf 395 xiterm.man
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor0\fP \[tbl]
.lf 395
.nr 3w1 \n[3w1]>?\w\[tbl]\ (black) \[tbl]
.lf 395
.nr 3w2 \n[3w2]>?\w\[tbl]\ = Black \[tbl]
.lf 396
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor1\fP \[tbl]
.lf 396
.nr 3w1 \n[3w1]>?\w\[tbl]\ (red) \[tbl]
.lf 396
.nr 3w2 \n[3w2]>?\w\[tbl]\ = Red3 \[tbl]
.lf 397
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor2\fP \[tbl]
.lf 397
.nr 3w1 \n[3w1]>?\w\[tbl]\ (green) \[tbl]
.lf 397
.nr 3w2 \n[3w2]>?\w\[tbl]\ = Green3 \[tbl]
.lf 398
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor3\fP \[tbl]
.lf 398
.nr 3w1 \n[3w1]>?\w\[tbl]\ (yellow) \[tbl]
.lf 398
.nr 3w2 \n[3w2]>?\w\[tbl]\ = Yellow3 \[tbl]
.lf 399
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor4\fP \[tbl]
.lf 399
.nr 3w1 \n[3w1]>?\w\[tbl]\ (blue) \[tbl]
.lf 399
.nr 3w2 \n[3w2]>?\w\[tbl]\ = Blue3 \[tbl]
.lf 400
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor5\fP \[tbl]
.lf 400
.nr 3w1 \n[3w1]>?\w\[tbl]\ (magenta) \[tbl]
.lf 400
.nr 3w2 \n[3w2]>?\w\[tbl]\ = Magenta3 \[tbl]
.lf 401
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor6\fP \[tbl]
.lf 401
.nr 3w1 \n[3w1]>?\w\[tbl]\ (cyan) \[tbl]
.lf 401
.nr 3w2 \n[3w2]>?\w\[tbl]\ = Cyan3 \[tbl]
.lf 402
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor7\fP \[tbl]
.lf 402
.nr 3w1 \n[3w1]>?\w\[tbl]\ (white) \[tbl]
.lf 402
.nr 3w2 \n[3w2]>?\w\[tbl]\ = AntiqueWhite \[tbl]
.lf 403
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor8\fP \[tbl]
.lf 403
.nr 3w1 \n[3w1]>?\w\[tbl]\ (bright black) \[tbl]
.lf 403
.nr 3w2 \n[3w2]>?\w\[tbl]\ = Grey25 \[tbl]
.lf 404
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor9\fP \[tbl]
.lf 404
.nr 3w1 \n[3w1]>?\w\[tbl]\ (bright red) \[tbl]
.lf 404
.nr 3w2 \n[3w2]>?\w\[tbl]\ = Red \[tbl]
.lf 405
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor10\fP \[tbl]
.lf 405
.nr 3w1 \n[3w1]>?\w\[tbl]\ (bright green) \[tbl]
.lf 405
.nr 3w2 \n[3w2]>?\w\[tbl]\ = Green \[tbl]
.lf 406
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor11\fP \[tbl]
.lf 406
.nr 3w1 \n[3w1]>?\w\[tbl]\ (bright yellow) \[tbl]
.lf 406
.nr 3w2 \n[3w2]>?\w\[tbl]\ = Yellow \[tbl]
.lf 407
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor12\fP \[tbl]
.lf 407
.nr 3w1 \n[3w1]>?\w\[tbl]\ (bright blue) \[tbl]
.lf 407
.nr 3w2 \n[3w2]>?\w\[tbl]\ = Blue \[tbl]
.lf 408
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor13\fP \[tbl]
.lf 408
.nr 3w1 \n[3w1]>?\w\[tbl]\ (bright magenta) \[tbl]
.lf 408
.nr 3w2 \n[3w2]>?\w\[tbl]\ = Magenta \[tbl]
.lf 409
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor14\fP \[tbl]
.lf 409
.nr 3w1 \n[3w1]>?\w\[tbl]\ (bright cyan) \[tbl]
.lf 409
.nr 3w2 \n[3w2]>?\w\[tbl]\ = Cyan \[tbl]
.lf 410
.nr 3w0 \n[3w0]>?\w\[tbl]\fBcolor15\fP \[tbl]
.lf 410
.nr 3w1 \n[3w1]>?\w\[tbl]\ (bright white) \[tbl]
.lf 410
.nr 3w2 \n[3w2]>?\w\[tbl]\ = White \[tbl]
.lf 411
.nr 3w0 \n[3w0]>?\w\[tbl]\fBforeground\fP \[tbl]
.lf 411
.nr 3w1 \n[3w1]>?\w\[tbl]\  \[tbl]
.lf 411
.nr 3w2 \n[3w2]>?\w\[tbl]\ = Black \[tbl]
.lf 412
.nr 3w0 \n[3w0]>?\w\[tbl]\fBbackground\fP \[tbl]
.lf 412
.nr 3w1 \n[3w1]>?\w\[tbl]\  \[tbl]
.lf 412
.nr 3w2 \n[3w2]>?\w\[tbl]\ = White \[tbl]
.nr 3w0 \n[3w0]>?(\n[3lnw0]+\n[3rnw0])
.if \n[3aw0] .nr 3w0 \n[3w0]>?(\n[3aw0]+2n)
.nr 3w1 \n[3w1]>?(\n[3lnw1]+\n[3rnw1])
.if \n[3aw1] .nr 3w1 \n[3w1]>?(\n[3aw1]+2n)
.nr 3w2 \n[3w2]>?(\n[3lnw2]+\n[3rnw2])
.if \n[3aw2] .nr 3w2 \n[3w2]>?(\n[3aw2]+2n)
.nr 3cd0 0
.nr 3cl0 0*\n[3sep]
.nr 3ce0 \n[3cl0]+\n[3w0]
.nr 3cl1 \n[3ce0]+(3*\n[3sep])
.nr 3cd1 \n[3ce0]+\n[3cl1]/2
.nr 3ce1 \n[3cl1]+\n[3w1]
.nr 3cl2 \n[3ce1]+(3*\n[3sep])
.nr 3cd2 \n[3ce1]+\n[3cl2]/2
.nr 3ce2 \n[3cl2]+\n[3w2]
.nr 3cd3 \n[3ce2]+(0*\n[3sep])
.nr TW \n[3cd3]
.if \n[3cent] \{.in +(u;\n[.l]-\n[.i]-\n[TW]/2)
.nr 3ind \n[.i]
.\}
.eo
.de T#
.if !\n[3supbot] \{.3rvpt 0
.mk 3vert
.ls 1
.ls
.nr 3passed \n[3crow]
.sp |\n[3vert]u
.3rvpt 1
.\}
..
.ec
.fc 
.3keep
.3rmk 3rt0
\*[3trans].nr 3crow 0
.3keep
.mk 3rs0
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 395
\&\h'|\n[3cl0]u'\fBcolor0\fP \h'|\n[3cl1]u'\ (black) \h'|\n[3cl2]u'\ = Black 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs0]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt1
\*[3trans].nr 3crow 1
.3keep
.mk 3rs1
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 396
\&\h'|\n[3cl0]u'\fBcolor1\fP \h'|\n[3cl1]u'\ (red) \h'|\n[3cl2]u'\ = Red3 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs1]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt2
\*[3trans].nr 3crow 2
.3keep
.mk 3rs2
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 397
\&\h'|\n[3cl0]u'\fBcolor2\fP \h'|\n[3cl1]u'\ (green) \h'|\n[3cl2]u'\ = Green3 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs2]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt3
\*[3trans].nr 3crow 3
.3keep
.mk 3rs3
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 398
\&\h'|\n[3cl0]u'\fBcolor3\fP \h'|\n[3cl1]u'\ (yellow) \h'|\n[3cl2]u'\ = Yellow3 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs3]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt4
\*[3trans].nr 3crow 4
.3keep
.mk 3rs4
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 399
\&\h'|\n[3cl0]u'\fBcolor4\fP \h'|\n[3cl1]u'\ (blue) \h'|\n[3cl2]u'\ = Blue3 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs4]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt5
\*[3trans].nr 3crow 5
.3keep
.mk 3rs5
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 400
\&\h'|\n[3cl0]u'\fBcolor5\fP \h'|\n[3cl1]u'\ (magenta) \h'|\n[3cl2]u'\ = Magenta3 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs5]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt6
\*[3trans].nr 3crow 6
.3keep
.mk 3rs6
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 401
\&\h'|\n[3cl0]u'\fBcolor6\fP \h'|\n[3cl1]u'\ (cyan) \h'|\n[3cl2]u'\ = Cyan3 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs6]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt7
\*[3trans].nr 3crow 7
.3keep
.mk 3rs7
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 402
\&\h'|\n[3cl0]u'\fBcolor7\fP \h'|\n[3cl1]u'\ (white) \h'|\n[3cl2]u'\ = AntiqueWhite 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs7]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt8
\*[3trans].nr 3crow 8
.3keep
.mk 3rs8
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 403
\&\h'|\n[3cl0]u'\fBcolor8\fP \h'|\n[3cl1]u'\ (bright black) \h'|\n[3cl2]u'\ = Grey25 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs8]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt9
\*[3trans].nr 3crow 9
.3keep
.mk 3rs9
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 404
\&\h'|\n[3cl0]u'\fBcolor9\fP \h'|\n[3cl1]u'\ (bright red) \h'|\n[3cl2]u'\ = Red 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs9]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt10
\*[3trans].nr 3crow 10
.3keep
.mk 3rs10
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 405
\&\h'|\n[3cl0]u'\fBcolor10\fP \h'|\n[3cl1]u'\ (bright green) \h'|\n[3cl2]u'\ = Green 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs10]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt11
\*[3trans].nr 3crow 11
.3keep
.mk 3rs11
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 406
\&\h'|\n[3cl0]u'\fBcolor11\fP \h'|\n[3cl1]u'\ (bright yellow) \h'|\n[3cl2]u'\ = Yellow 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs11]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt12
\*[3trans].nr 3crow 12
.3keep
.mk 3rs12
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 407
\&\h'|\n[3cl0]u'\fBcolor12\fP \h'|\n[3cl1]u'\ (bright blue) \h'|\n[3cl2]u'\ = Blue 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs12]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt13
\*[3trans].nr 3crow 13
.3keep
.mk 3rs13
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 408
\&\h'|\n[3cl0]u'\fBcolor13\fP \h'|\n[3cl1]u'\ (bright magenta) \h'|\n[3cl2]u'\ = Magenta 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs13]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt14
\*[3trans].nr 3crow 14
.3keep
.mk 3rs14
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 409
\&\h'|\n[3cl0]u'\fBcolor14\fP \h'|\n[3cl1]u'\ (bright cyan) \h'|\n[3cl2]u'\ = Cyan 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs14]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt15
\*[3trans].nr 3crow 15
.3keep
.mk 3rs15
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 410
\&\h'|\n[3cl0]u'\fBcolor15\fP \h'|\n[3cl1]u'\ (bright white) \h'|\n[3cl2]u'\ = White 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs15]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt16
\*[3trans].nr 3crow 16
.3keep
.mk 3rs16
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 411
\&\h'|\n[3cl0]u'\fBforeground\fP \h'|\n[3cl1]u'\  \h'|\n[3cl2]u'\ = Black 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs16]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.3keep
.3rmk 3rt17
\*[3trans].nr 3crow 17
.3keep
.mk 3rs17
.mk 3bot
.3rvpt 0
.ta \n[3ce0]u \n[3ce1]u \n[3ce2]u
.lf 412
\&\h'|\n[3cl0]u'\fBbackground\fP \h'|\n[3cl1]u'\  \h'|\n[3cl2]u'\ = White 
.nr 3bot \n[3bot]>?\n[.d]
.sp |\n[3rs17]u
.3rvpt 1
.sp |\n[3bot]u
\*[3trans].nr 3brule 1
.3release
.mk 3rt18
.nr 3brule 1
.nr T. 1
.T#
.3init
.fc
.cp \n(3c
.lf 413
.TE 
.PP 
It is also possible to specify the colour values of \fBforeground\fP,
\fBbackground\fP, \fBcursorColor\fP, \fBcursorColor2\fP, \fBcolorBD\fP, \fBcolorUL\fP
as a number 0-15, as a convenient shorthand to reference the colour name of
color0-color15\&.
.PP 
Note that \fB-rv\fP (\fB"reverseVideo: True"\fP) simulates reverse video by
always swapping the foreground/background colours\&.  This is in contrast to
\fIxterm\fP(1) where the colours are only swapped if they have not otherwise been
specified\&.
For example,
.PP 
.IP "\fBxiterm -fg Black -bg White -rv\fP" 
would yield White on Black, while on \fIxterm\fP(1) it would yield
Black on White\&.
.SH "ENVIRONMENT" 
.PP 
\fBxiterm\fP sets the environment variables \fBTERM\fP, \fBCOLORTERM\fP and
\fBCOLORFGBG\fP\&.  The environment variable \fBWINDOWID\fP is set to the X window
id number of the \fBxiterm\fP window and it also uses and sets the environment
variable \fBDISPLAY\fP to specify which display terminal to use\&.  \fBxiterm\fP uses
the environment variables \fBXITERMPATH\fP and \fBPATH\fP to find XPM files\&.
.SH "FILES" 
.PP 
.IP "\fB/etc/utmp\fP" 
System file for login records\&.
.IP "\fB/usr/lib/X11/rgb\&.txt\fP" 
Color names\&.
.PP 
.SH "SEE ALSO" 
.PP 
\fIxterm\fP(1), \fIsh\fP(1), \fIresize\fP(1), \fIX\fP(1), \fIpty\fP(4), \fItty\fP(4),
\fIutmp\fP(5)
.PP 
See xiterm-doc.sgml for detailed information on recognized escape
sequences and menuBar syntax, etc\&.
.PP 
.SH "BUGS" 
.PP 
Check the BUGS file for an up-to-date list\&.
.PP 
.SH "AUTHORS" 
.PP 
.IP John Bovey, jdb@ukc.ac.uk
.IP R. Nation, nation@rocket.sanders.lockheed.com
.IP Garrett D'Amore, garrett@netcom.com
.IP Steven Hirsch, hirsch@emba.uvm.edu
.IP Jakub Jelinek, jj@gnu.ai.mit.edu
.IP Chuck Blake, cblake@BBN.COM
.IP Raul Garcia Garcia, gg@tid.es
.IP Mj Olesen, olesen@me.QueensU.CA
.IP Guylhem Aznar, guylhem@danmark.linux.eu.org
.IP Oezguer Kesim, kesim@math.fu-berlin.de
.IP Geoff Wing, mason@primnet.com.au

