.\" Source: transform.h 
.\" Generated with ROBODoc Version 3.2.3 (Jul 29 2001)
.\" ROBODoc (c) 1994-2001 by Frans Slothouber and Jacco van Weert.
.\" t
.\" @(#)transform.h.3
.TH transform.h 1 "Tue Jan 15 2002" transform.h 3
.PM Generated from transform.h with ROBODoc v3.2.3 on Tue Jan 15 15:08:04 2002

.SH libAfterImage/transform.h
.SS\fB SYNOPSIS\fP 
.nf
 Defines transformations that could be performed on \fBASImage\fP\.

.fi
.SS\fB DESCRIPTION\fP 
.nf

 Transformations can be performed with different degree of \fBquality\fP\.
 Internal engine uses 24\.8 bits per channel per \fBpixel\fP\. As the result
 there are no precision loss, while performing complex calculations\.
 Error diffusion algorithms could be used to transform it back into 8
 bit without \fBquality\fP loss\.

 Any Transformation could be performed with the result written directly
 into \fBXImage\fP, so that it could be displayed faster\.

 Complex interpolation algorithms are used to perform scaling
 operations, thus yielding very good \fBquality\fP\. All the transformations
 are performed in integer math, with the result of greater speeds\.
 Optional MMX inline assembly has been incorporated into some
 procedures, and allows to achieve considerably better performance on
 compatible CPUs\.


.fi
.SS\fB SEE ALSO\fP 
.nf
  Transformations :
          \fBscale_asimage()\fP, \fBtile_asimage()\fP, \fBmerge_layers()\fP, \fBmake_gradient()\fP,
          \fBflip_asimage()\fP, \fBmirror_asimage()\fP, \fBpad_asimage()\fP,
          \fBblur_asimage_gauss()\fP, \fBfill_asimage()\fP, \fBadjust_asimage_hsv()\fP

  Other \fBlibAfterImage\fP modules :
          \fBascmap.h\fP \fBasfont.h\fP \fBasimage.h\fP \fBasvisual.h\fP \fBblender.h\fP \fBexport.h\fP
          \fBimport.h\fP \fBtransform.h\fP \fBximage.h\fP

.fi
.SS\fB AUTHOR\fP 
.nf
\fB  Sasha Vasko <sasha at aftercode dot net>
\fP 
.fi

.PP
.SH libAfterImage/transform/scale_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *scale_asimage( struct \fBASVisual\fP *asv,
                         \fBASImage\fP *src,
                         unsigned int to_width,
                         unsigned int to_height,
                         ASAltImFormats out_format,
                         unsigned int \fBcompression\fP_out, int \fBquality\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv        \- pointer to valid \fBASVisual\fP structure
 src        \- source \fBASImage\fP
 to_width   \- desired width of the resulting image
 to_height  \- desired height of the resulting image
 out_format     \- optionally describes alternative \fBASImage\fP format that
                should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBcompression\fP_out\- \fBcompression\fP level of resulting image in range 0\-100\.
 \fBquality\fP    \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns newly created and encoded \fBASImage\fP on success, NULL of failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Scales source \fBASImage\fP into new image of requested dimensions\. If size
 has to be reduced \- then several neighboring pixels will be averaged
 into single \fBpixel\fP\. If size has to be increased then new pixels will
 be interpolated based on values of four neighboring pixels\.

.fi
.SS\fB EXAMPLE\fP 
.nf
 \fBASScale\fP

.fi

.PP
.SH libAfterImage/transform/tile_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *tile_asimage ( struct \fBASVisual\fP *asv,
                         \fBASImage\fP *src,
                         int offset_x,
                         int offset_y,
                         unsigned int to_width,
                         unsigned int to_height,
                         \fBARGB32\fP \fBtint\fP,
                         ASAltImFormats out_format,
                         unsigned int \fBcompression\fP_out, int \fBquality\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv          \- pointer to valid \fBASVisual\fP structure
 src          \- source \fBASImage\fP
 offset_x     \- left clip margin
 offset_y     \- right clip margin
 to_width     \- desired width of the resulting image
 to_height    \- desired height of the resulting image
 \fBtint\fP         \- \fBARGB32\fP value describing tinting color\.
 out_format     \- optionally describes alternative \fBASImage\fP format that
                should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBcompression\fP_out\- \fBcompression\fP level of resulting image in range 0\-100\.
 \fBquality\fP      \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns newly created and encoded \fBASImage\fP on success, NULL of failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Source \fBASImage\fP will be tiled into newly created image of specified
 size\. offset_x and offset_y define origin on source image from which
 tiling will start\. If offset_x or offset_y is outside of the image
 boundaries, then it will be reduced by whole number of image sizes to
 fit inside the image\. At the time of tiling image will be tinted
 unless \fBtint\fP == 0\.

.fi
.SS\fB EXAMPLE\fP 
.nf
 \fBASTile\fP

.fi

.PP
.SH libAfterImage/transform/merge_layers()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *merge_layers  ( struct \fBASVisual\fP *asv,
                          \fBASImageLayer\fP *layers, int count,
                          unsigned int dst_width,
                          unsigned int dst_height,
                          ASAltImFormats out_format,
                          unsigned int \fBcompression\fP_out, int \fBquality\fP);

.fi
.SS\fB INPUTS\fP 
.nf
 asv          \- pointer to valid \fBASVisual\fP structure
 layers       \- array of \fBASImageLayer\fP structures that will be rendered
                one on top of another\. First element corresponds to
                the bottommost layer\.
 dst_width    \- desired width of the resulting image
 dst_height   \- desired height of the resulting image
 out_format     \- optionally describes alternative \fBASImage\fP format that
                should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBcompression\fP_out \- \fBcompression\fP level of resulting image in range 0\-100\.
 \fBquality\fP      \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns newly created and encoded \fBASImage\fP on success, NULL of failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBmerge_layers()\fP will create new \fBASImage\fP of requested size\. It will then
 go through all the layers, and fill image with composition\.
 Bottommost layer will be used unchanged and above layers will be
 superimposed on it, using algorithm specified in \fBASImageLayer\fP
 structure of the overlaying layer\. \fBLayers\fP may have smaller size
 then destination image, and maybe placed in arbitrary locations\. Each
 layer will be padded to fit width of the destination image with all 0
 effectively making it transparent\.

.fi

.PP
.SH libAfterImage/transform/make_gradient()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *make_gradient ( struct \fBASVisual\fP *asv,
                          struct \fBASGradient\fP *grad,
                          unsigned int width,
                          unsigned int height,
                          ASFlagType filter,
                          ASAltImFormats out_format,
                          unsigned int \fBcompression\fP_out, int \fBquality\fP);

.fi
.SS\fB INPUTS\fP 
.nf
 asv          \- pointer to valid \fBASVisual\fP structure
 grad         \- \fBASGradient\fP structure defining how gradient should be
                drawn
 width        \- desired width of the resulting image
 height       \- desired height of the resulting image
 filter       \- only channels corresponding to set bits will be
                rendered\.
 out_format     \- optionally describes alternative \fBASImage\fP format that
                should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBcompression\fP_out\- \fBcompression\fP level of resulting image in range 0\-100\.
 \fBquality\fP      \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns newly created and encoded \fBASImage\fP on success, NULL of failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBmake_gradient()\fP will create new image of requested size and it will
 fill it with gradient, described in structure pointed to by grad\.
 Different dithering techniques will be applied to produce nicer
 looking gradients\.

.fi

.PP
.SH libAfterImage/transform/flip_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *\fBflip\fP_asimage ( struct \fBASVisual\fP *asv,
                         \fBASImage\fP *src,
                         int offset_x, int offset_y,
                         unsigned int to_width,
                         unsigned int to_height,
                         int \fBflip\fP, ASAltImFormats out_format,
                         unsigned int \fBcompression\fP_out, int \fBquality\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv          \- pointer to valid \fBASVisual\fP structure
 src          \- source \fBASImage\fP
 offset_x     \- left clip margin
 offset_y     \- right clip margin
 to_width     \- desired width of the resulting image
 to_height    \- desired height of the resulting image
 \fBflip\fP         \- \fBflip\fP flags determining degree of rotation\.
 out_format     \- optionally describes alternative \fBASImage\fP format that
                should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBcompression\fP_out \- \fBcompression\fP level of resulting image in range 0\-100\.
 \fBquality\fP      \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns newly created and encoded \fBASImage\fP on success, NULL of failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBflip_asimage()\fP will create new image of requested size, it will then
 tile source image based on offset_x, offset_y, and destination size,
 and it will rotate it then based on \fBflip\fP value\. Three rotation angles
 supported 90, 180 and 270 degrees\.

.fi

.PP
.SH libAfterImage/transform/mirror_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *mirror_asimage ( struct \fBASVisual\fP *asv,
                           \fBASImage\fP *src,
                           int offset_x, int offset_y,
                           unsigned int to_width,
                           unsigned int to_height,
                           Bool vertical, ASAltImFormats out_format,
                           unsigned int \fBcompression\fP_out, int \fBquality\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv          \- pointer to valid \fBASVisual\fP structure
 src          \- source \fBASImage\fP
 offset_x     \- left clip margin
 offset_y     \- right clip margin
 to_width     \- desired width of the resulting image
 to_height    \- desired height of the resulting image
 vertical     \- mirror in vertical direction\.
 out_format     \- optionally describes alternative \fBASImage\fP format that
                should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBcompression\fP_out \- \fBcompression\fP level of resulting image in range 0\-100\.
 \fBquality\fP      \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns newly created and encoded \fBASImage\fP on success, NULL of failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBmirror_asimage()\fP will create new image of requested size, it will then
 tile source image based on offset_x, offset_y, and destination size,
 and it will mirror it in vertical or horizontal direction\.

.fi

.PP
.SH libAfterImage/transform/pad_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *pad_asimage( \fBASVisual\fP *asv, \fBASImage\fP *src,
                      int dst_x, int dst_y,
                      unsigned int to_width,
                      unsigned int to_height,
                      \fBARGB32\fP color,
                      ASAltImFormats out_format,
                      unsigned int \fBcompression\fP_out, int \fBquality\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv          \- pointer to valid \fBASVisual\fP structure
 src          \- source \fBASImage\fP
 dst_x, dst_y \- placement of the source image relative to the origin of
                destination image
 to_width     \- width of the destination image
 to_height    \- height of the destination image
 color        \- \fBARGB32\fP color value to pad with\.
 out_format     \- optionally describes alternative \fBASImage\fP format that
                should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBcompression\fP_out \- \fBcompression\fP level of resulting image in range 0\-100\.
 \fBquality\fP      \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns newly created and encoded \fBASImage\fP on success, NULL of failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 enlarges \fBASImage\fP, padding it with specified color on each side in
 accordance with requested geometry\.

.fi

.PP
.SH libAfterImage/transform/blur_asimage_gauss()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP* blur_asimage_gauss( \fBASVisual\fP* asv, \fBASImage\fP* src,
                              double horz, double vert,
                              ASAltImFormats out_format,
                              unsigned int \fBcompression\fP_out, int \fBquality\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv          \- pointer to valid \fBASVisual\fP structure
 src          \- source \fBASImage\fP
 horz         \- horizontal radius of the blurr
 vert         \- vertical radius of the blurr
 out_format     \- optionally describes alternative \fBASImage\fP format that
                should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBcompression\fP_out \- \fBcompression\fP level of resulting image in range 0\-100\.
 \fBquality\fP      \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns newly created and encoded \fBASImage\fP on success, NULL of failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Performs Gaussian blurr of the image ( usefull fro drop shadows and
 the likes )\.

.fi

.PP
.SH libAfterImage/transform/fill_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 Bool fill_asimage( \fBASVisual\fP *asv, \fBASImage\fP *im,
                    int x, int y, int width, int height,
                    \fBARGB32\fP color );

.fi
.SS\fB INPUTS\fP 
.nf
 asv           \- pointer to valid \fBASVisual\fP structure
 im            \- \fBASImage\fP to fill with the color
 x, y          \- left\-top corner of the rectangle to fill\.
 width, height \- size of the rectangle to fill\.
 color         \- \fBARGB32\fP color value to fill rectangle with\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 True on success, False on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Fills rectangle within the existing \fBASImage\fP with specified color\.

.fi

.PP
.SH libAfterImage/transform/adjust_asimage_hsv()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *adjust_asimage_hsv( \fBASVisual\fP *asv, \fBASImage\fP *src,
                              int offset_x, int offset_y,
                              unsigned int to_width,
                              unsigned int to_height,
                              unsigned int affected_hue,
                              unsigned int affected_radius,
                              int hue_offset, int saturation_offset,
                              int value_offset,
                              ASAltImFormats out_format,
                              unsigned int \fBcompression\fP_out, int \fBquality\fP);

.fi
.SS\fB INPUTS\fP 
.nf
 asv           \- pointer to valid \fBASVisual\fP structure
 src           \- \fBASImage\fP to adjust colors of\.
 offset_x,
 offset_y      \- position on infinite surface tiled with original image,
                 of the left\-top corner of the area to be used for new
                 image\.
 to_width,
 to_height     \- size of the area of the original image to be used
                 for new image\.
 affected_hue  \- hue in degrees in range 0\-360\. This allows to limit
                 impact of color adjustment to affect only limited
                 range of hues\.
 affected_radius Sets the diapason of the range of affected hues\.
 hue_offset    \- value by which to change hues in affected range\.
 saturation_offset \-
                 value by which to change saturation of the pixels in
                 affected hue range\.
 value_offset  \- value by which to change Value(brightness) of pixels
                 in affected hue range\.
 out_format     \- optionally describes alternative \fBASImage\fP format that
                should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBcompression\fP_out\- \fBcompression\fP level of resulting image in range 0\-100\.
 \fBquality\fP      \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns newly created and encoded \fBASImage\fP on success, NULL of failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This function will tile original image to specified size with offsets
 requested, and then it will go though it and adjust hue, saturation and
 value of those pixels that have specific hue, set by affected_hue/
 affected_radius parameters\. When affected_radius is greater then 180
 entire image will be adjusted\. Note that since grayscale colors have
 no hue \- the will not get adjusted\. Only saturation and value will be
 adjusted in gray pixels\.
 Hue is measured as an angle on a 360 degree circle, The following is
 relationship of hue values to regular color names :
 red      \- 0
 yellow   \- 60
 green    \- 120
 cyan     \- 180
 blue     \- 240
 magenta  \- 300
 red      \- 360

 All the hue values in parameters will be adjusted to fall withing
 0\-360 range\.

.fi

.PP
.SH libAfterImage/transform/colorize_asimage_vector()
.SS\fB SYNOPSIS\fP 
.nf
 Bool colorize_asimage_vector( \fBASVisual\fP *asv, \fBASImage\fP *im,
                                 \fBASVectorPalette\fP *palette,
                               ASAltImFormats out_format,
                               int \fBquality\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv           \- pointer to valid \fBASVisual\fP structure
 im            \- \fBASImage\fP to update\.
 palette       \- palette to be used in conversion of double precision
                 values into colors\.
 out_format      \- optionally describes alternative \fBASImage\fP format that
                 should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBquality\fP       \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 True on success, False on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This function will try to convert double precision indexed image data
 into actuall color image using palette\. Original data should be attached
 to \fBASImage\fP using vector member\. Operation is relatively fast and allows
 representation of scientific data as color image with dynamically
 changing palette\.

.fi

.PP
.SH libAfterImage/transform/create_asimage_from_vector()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *create_asimage_from_vector( \fBASVisual\fP *asv, double *vector,
                                      unsigned int width,
                                      unsigned int height,
                                      \fBASVectorPalette\fP *palette,
                                      ASAltImFormats out_format,
                                      unsigned int \fBcompression\fP,
                                      int \fBquality\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv           \- pointer to valid \fBASVisual\fP structure
 vector        \- data to be attached to new \fBASImage\fP and used to generate
                 RGB image
 width, height \- size of the new image\.
 palette       \- palette to be used in conversion of double precision
                 values into colors\.
 out_format      \- optionally describes alternative \fBASImage\fP format that
                 should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBcompression\fP_out\- \fBcompression\fP level of resulting image in range 0\-100\.
 \fBquality\fP       \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 New \fBASImage\fP  on success, NULL on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This function is merely a convinience function allowing to create new
 \fBASImage\fP, set its vector data and colorize it using palette \- all in
 one step\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBcolorize_asimage_vector()\fP, \fBcreate_asimage()\fP, set_asimage_vector()

.fi

.PP
