.\" Source: export.h 
.\" Generated with ROBODoc Version 3.2.3 (Jul 29 2001)
.\" ROBODoc (c) 1994-2001 by Frans Slothouber and Jacco van Weert.
.\" t
.\" @(#)export.h.3
.TH export.h 1 "Tue Jan 15 2002" export.h 3
.PM Generated from export.h with ROBODoc v3.2.3 on Tue Jan 15 15:08:04 2002

.SH libAfterImage/export.h
.SS\fB DESCRIPTION\fP 
.nf
 Image output into different file formats\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 Structures :
          \fBASXpmExportParams\fP
          \fBASPngExportParams\fP
          \fBASJpegExportParams\fP
          \fBASGifExportParams\fP
          \fBASImageExportParams\fP

 Functions :
        \fBASImage2file()\fP

 Other \fBlibAfterImage\fP modules :
          \fBascmap.h\fP \fBasfont.h\fP \fBasimage.h\fP \fBasvisual.h\fP \fBblender.h\fP \fBexport.h\fP
          \fBimport.h\fP \fBtransform.h\fP \fBximage.h\fP

.fi
.SS\fB AUTHOR\fP 
.nf
\fB  Sasha Vasko <sasha at aftercode dot net>
\fP 
.fi

.PP
.SH libAfterImage/ExportFlags
.SS\fB FUNCTION\fP 
.nf
 Some common flags that could be used while writing images into
 different file formats\.

.fi
.SS\fB SOURCE\fP 
.nf
    #define EXPORT_GRAYSCALE            (0x01<<0)
    #define EXPORT_ALPHA                (0x01<<1)
    #define EXPORT_APPEND               (0x01<<3)  /* adds subimage  */
.fi

.PP
.SH libAfterImage/ASXpmExportParams
.SS\fB NAME\fP 
.nf
\fR  \fBASXpmExportParams\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASXpmExportParams\fP \- parameters for export into XPM file\.

.fi
.SS\fB DESCRIPTION\fP 
.SS\fB SEE ALSO\fP 
.SS\fB SOURCE\fP 
.nf
    typedef struct
    {
        \fBASImageFileTypes\fP type;
        ASFlagType flags ;
        int dither ;
        int opaque_threshold ;
        int max_colors ;
    }\fBASXpmExportParams\fP ;
.fi

.PP
.SH libAfterImage/ASPngExportParams
.SS\fB NAME\fP 
.nf
\fR  \fBASPngExportParams\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASPngExportParams\fP \- parameters for export into PNG file\.

.fi
.SS\fB DESCRIPTION\fP 
.SS\fB SEE ALSO\fP 
.SS\fB SOURCE\fP 
.nf
    typedef struct
    {
        \fBASImageFileTypes\fP type;
        ASFlagType flags ;
        int \fBcompression\fP ;
    }\fBASPngExportParams\fP ;
.fi

.PP
.SH libAfterImage/ASJpegExportParams
.SS\fB NAME\fP 
.nf
\fR  \fBASJpegExportParams\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASJpegExportParams\fP \- parameters for export into JPEG file\.

.fi
.SS\fB DESCRIPTION\fP 
.SS\fB SEE ALSO\fP 
.SS\fB SOURCE\fP 
.nf
    typedef struct
    {
        \fBASImageFileTypes\fP type;
        ASFlagType flags ;
        int \fBquality\fP ;
    }\fBASJpegExportParams\fP ;
.fi

.PP
.SH libAfterImage/ASGifExportParams
.SS\fB NAME\fP 
.nf
\fR  \fBASGifExportParams\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASGifExportParams\fP \- parameters for export into GIF file\.

.fi
.SS\fB DESCRIPTION\fP 
.SS\fB SEE ALSO\fP 
.SS\fB SOURCE\fP 
.nf
    typedef struct
    {
        \fBASImageFileTypes\fP type;
        ASFlagType flags ;
        int dither ;
        int opaque_threshold ;
        unsigned short animate_delay ;
    }\fBASGifExportParams\fP ;
.fi

.PP
.SH libAfterImage/ASTiffExportParams
.SS\fB NAME\fP 
.nf
\fR  \fBASTiffExportParams\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASTiffExportParams\fP \- parameters for export into TIFF file\.

.fi
.SS\fB DESCRIPTION\fP 
.SS\fB SEE ALSO\fP 
.SS\fB SOURCE\fP 
.nf
    typedef struct
    {
        \fBASImageFileTypes\fP type;
        ASFlagType flags ;
        CARD32 rows_per_strip ;
    
    /* these are suitable compressions : */
    #define TIFF_COMPRESSION_NONE       1
    #define TIFF_COMPRESSION_OJPEG      6   /* !6\.0 JPEG */
    #define TIFF_COMPRESSION_JPEG       7
    #define TIFF_COMPRESSION_PACKBITS   32773   /* Macintosh RLE */
    #define TIFF_COMPRESSION_DEFLATE    32946   /* Deflate \fBcompression\fP */
        /* you should be able to use other values from tiff\.h as well */
        CARD32 \fBcompression\fP_type ;
        int jpeg_quality ;
    
        int opaque_threshold ;
    }\fBASTiffExportParams\fP ;
.fi

.PP
.SH libAfterImage/ASImageExportParams
.SS\fB NAME\fP 
.nf
\fR  \fBASImageExportParams\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImageExportParams\fP \- union of structures holding parameters for
   export into different file formats\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Treatment of this union depends on what type of export was requested\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBASImageFileTypes\fP

.fi
.SS\fB SOURCE\fP 
.nf
    typedef union \fBASImageExportParams\fP
    {
        \fBASImageFileTypes\fP   type;
        \fBASXpmExportParams\fP  xpm;
        \fBASPngExportParams\fP  png;
        \fBASJpegExportParams\fP jpeg;
        \fBASGifExportParams\fP  gif;
        \fBASTiffExportParams\fP tiff;
    }\fBASImageExportParams\fP;
.fi

.PP
.SH libAfterImage/export/ASImage2file()
.SS\fB SYNOPSIS\fP 
.nf
 Bool ASImage2file( \fBASImage\fP *im, const char *dir, const char *file,
                  \fBASImageFileTypes\fP type, \fBASImageExportParams\fP *params );

.fi
.SS\fB INPUTS\fP 
.nf
 im         \- Image to write out\.
 dir          \- directory name to write file into (optional,
                could be NULL)
 file         \- file name with or without directory name\.
 type         \- output file format\. ( see \fBASImageFileTypes\fP )
 params       \- pointer to \fBASImageExportParams\fP union's member for the
                above type, with additional export parameters, such as
                \fBquality\fP, \fBcompression\fP, etc\. If NULL then all defaults
                will be used\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 True on success\. False \- failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 ASImage2file will construct filename out of dir and file components
 and then will call specific filter to write out file in requested
 format\.

.fi
.SS\fB NOTES\fP 
.nf
\fR  Some formats support \fBcompression\fP, others support lossy \fBcompression\fP,
 yet others allows you to limit number of colors and colordepth\.
 Each specific filter will try to interpret those parameters in its
 own way\.
\fP 
.fi
.SS\fB EXAMPLE\fP 
.nf
 asmerge\.c: \fBASMerge.3\fP

.fi

.PP
