.\" Source: import.h 
.\" Generated with ROBODoc Version 3.2.3 (Jun 26 2001)
.\" ROBODoc (c) 1994-2001 by Frans Slothouber and Jacco van Weert.
.\" t
.\" @(#)import.h.3
.TH import.h 1 "Wed Jul 11 2001" import.h 3
.PM Generated from import.h with ROBODoc v3.2.3 on Wed Jul 11 01:34:44 2001

.SH libAfterImage/import.h
.SS\fB DESCRIPTION\fP 
.nf
 Image file format autodetection, reading and decoding routines\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 Functions :
        \fBfile2ASImage()\fP, \fBfile2pixmap()\fP

 Other \fBlibAfterImage\fP modules :
     \fBasimage.h\fP, \fBasvisual.h\fP, \fBblender.h\fP, \fBasfont.h\fP

.fi
.SS\fB AUTHOR\fP 
.nf
\fB  Sasha Vasko <sashav at sprintmail dot com>
\fP 
.fi

.PP
.SH libAfterImage/gamma
.SS\fB FUNCTION\fP 
.nf
 Defines default value for screen \fBgamma\fP correction\.

.fi
.SS\fB SOURCE\fP 
.nf
    #define SCREEN_GAMMA 1\.0
.fi

.PP
.SH libAfterImage/ASImageFileTypes
.SS\fB NAME\fP 
.nf
\fR  \fBASImageFileTypes\fP
\fP 
.fi
.SS\fB DESCRIPTION\fP 
.nf
 List of known image file formats\.

.fi
.SS\fB SOURCE\fP 
.nf
    typedef enum
    {
        ASIT_Xpm = 0,
        ASIT_ZCompressedXpm,
        ASIT_GZCompressedXpm,
        ASIT_Png,
        ASIT_Jpeg,
        ASIT_Xcf,
        ASIT_Ppm,
        ASIT_Pnm,
        ASIT_Bmp,
        ASIT_Ico,
        ASIT_Cur,
        ASIT_Gif,
        ASIT_Tiff,
        ASIT_Xbm,
        /* reserved for future implementation : */
        ASIT_Targa,
        ASIT_Pcx,
        ASIT_Unknown
    }\fBASImageFileTypes\fP;
.fi

.PP
.SH libAfterImage/import/file2ASImage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *file2ASImage( const char *file, ASFlagType what,
                        double \fBgamma\fP,
                        unsigned int \fBcompression\fP, \.\.\. );

.fi
.SS\fB INPUTS\fP 
.nf
 file         \- file name with or without directory name
 what         \- reserved for future use
 \fBgamma\fP        \- \fBgamma\fP value to be used to correct image
 \fBcompression\fP  \- \fBcompression\fP level of the resulting \fBASImage\fP
 \.\.\.          \- NULL terminated list of strings, representing
                arbitrary number of directories to be searched each\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 Pointer to \fBASImage\fP structure holding image data on success\.
 NULL on failure

.fi
.SS\fB DESCRIPTION\fP 
.nf
 file2ASImage will attempt to interpret filename in the following way:
 1)It will try to find file using unmodified filename in all the
 provided search paths\.
 2)It will attempt to append \.gz and then \.Z to the filename and
 find such file in all the provided search paths\.
 3)If filename ends with extension consisting of digits only \- it will
 attempt to find file with this extension stripped off\. On success
 this extension will be used to load subimage from the file with that
 number\. Subimages are supported only for XCF, GIF, BMP, ICO and CUR
 files\.
 After the file is found \fBfile2ASImage()\fP attempts to detect file format,
 and if it is known it will load it into new \fBASImage\fP structure\.

.fi
.SS\fB EXAMPLE\fP 
.nf
 asview\.c: \fBASView.2\fP

.fi

.PP
.SH libAfterImage/import/file2pixmap()
.SS\fB SYNOPSIS\fP 
.nf
 \fBPixmap\fP file2pixmap( struct \fBASVisual\fP *asv, \fBWindow\fP root,
                     const char *realfilename,
                     \fBPixmap\fP *mask_out);

.fi
.SS\fB INPUTS\fP 
.nf
 asv          \- pointer to valid \fBASVisual\fP structure\.
 root         \- root \fBwindow\fP ID for the destination screen\.
 realfilename \- full image file's name with path\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 \fBPixmap\fP ID of the X \fBPixmap\fP filled with loaded image\. If mask_out is
 not NULL it will point to image mask \fBPixmap\fP ID if there is an \fBalpha\fP
 channel in image, None otherwise\.
 On failure None will be returned\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBfile2pixmap()\fP will attempt to open specified file and autodetect its
 format\. If format is known it will load it into \fBASImage\fP first, and
 then convert it into X \fBPixmap\fP\. In case image has \fBalpha\fP channel \-
 mask \fBPixmap\fP will be produced if mask_out is not NULL\.

.fi

.PP
