.\" Source: blender.h 
.\" Generated with ROBODoc Version 3.2.3 (Jun 26 2001)
.\" ROBODoc (c) 1994-2001 by Frans Slothouber and Jacco van Weert.
.\" t
.\" @(#)blender.h.3
.TH blender.h 1 "Wed Jul 11 2001" blender.h 3
.PM Generated from blender.h with ROBODoc v3.2.3 on Wed Jul 11 01:34:44 2001

.SH libAfterImage/blender.h
.SS\fB DESCRIPTION\fP 
.nf
 Defines implemented methods for \fBASScanline\fP combining, that could
 be passed to \fBmerge_layers()\fP via \fBASImageLayer\fP structure\.
 Also includes functions for \fBcolorspace\fP conversion RGB<\->HSV and
 RGB<\->HLS\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 Functions :
    Colorspace conversion :
          \fBrgb2value()\fP, rgb2saturation(), rgb2hue(), rgb2luminance(),
          \fBrgb2hsv()\fP, rgb2hls(), \fBhsv2rgb()\fP, hls2rgb()\.

    \fBmerge_scanline\fP methods :
          alphablend_scanlines(), allanon_scanlines(),
          \fBtint\fP_scanlines(), add_scanlines(), sub_scanlines(),
          diff_scanlines(), darken_scanlines(), lighten_scanlines(),
          screen_scanlines(), overlay_scanlines(), hue_scanlines(),
          saturate_scanlines(), value_scanlines(),
          colorize_scanlines(), dissipate_scanlines()\.

    usefull merging function name to function translator :
          \fBblend_scanlines_name2func()\fP

 Other \fBlibAfterImage\fP modules :
     \fBasimage.h\fP, \fBasvisual.h\fP, \fBimport.h\fP, \fBasfont.h\fP

.fi
.SS\fB AUTHOR\fP 
.nf
\fB  Sasha Vasko <sashav at sprintmail dot com>
\fP 
.fi

.PP
.SH libAfterImage/import/colorspace
.SS\fB DESCRIPTION\fP 
.nf
 RGB \fBcolorspace\fP: each color is represented as a combination of
 red, green and blue values\. Each value can be in 2 formats :
 8 bit and 24\.8 bit\. 24\.8 bit makes for 32bit value with lower 8 bits
 used as a fraction for better calculation precision\.

 HSV \fBcolorspace\fP: each color is represented as a combination of
 hue, saturation and value\. Hue is generally colorizing component where
 value represents brightness\.

 HLS \fBcolorspace\fP: each color is represented as a combination of
 hue, luminance and saturation\. It is analogous to HSV with value
 substituted by luminance, except that luminance could be both
 negative and positive\.

 \fBalpha\fP channel could be added to any of the above colorspaces\. \fBalpha\fP
 channel is generally used to define transparentness of the color\.
 \fBlibAfterImage\fP is using ARGB \fBcolorspace\fP as a base \fBcolorspace\fP, and
 represents most colors as \fBARGB32\fP values or \fBASScanline\fP scanlines of
 pixels\.

.fi

.PP
.SH libAfterImage/import/rgb2value()
.SS\fB SYNOPSIS\fP 
.nf
 CARD32 rgb2value( CARD32 red, CARD32 green, CARD32 blue );
 CARD32 rgb2saturation( CARD32 red, CARD32 green, CARD32 blue );
 CARD32 rgb2hue( CARD32 red, CARD32 green, CARD32 blue );
 CARD32 rgb2luminance (CARD32 red, CARD32 green, CARD32 blue );

.fi
.SS\fB INPUTS\fP 
.nf
 red   \- 32 bit value, 16 lower bits of which represent red channel
 green \- 32 bit value, 16 lower bits of which represent green channel
 blue  \- 32 bit value, 16 lower bits of which represent blue channel

.fi
.SS\fB RETURN VALUE\fP 
.nf
 32 bit value, 16 lower bits of which represent value, saturation, hue,
 or luminance respectively\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This functions translate RGB color into respective coordinates of
 HSV and HLS colorspaces\.

.fi

.PP
.SH libAfterImage/import/rgb2hsv()
.SS\fB SYNOPSIS\fP 
.nf
 CARD32 rgb2hsv( CARD32 red, CARD32 green, CARD32 blue,
                 CARD32 *saturation, CARD32 *value );
 CARD32 rgb2hls( CARD32 red, CARD32 green, CARD32 blue,
                 CARD32 *luminance, CARD32 *saturation );

.fi
.SS\fB INPUTS\fP 
.nf
 red   \- 32 bit value, 16 lower bits of which represent red channel
 green \- 32 bit value, 16 lower bits of which represent green channel
 blue  \- 32 bit value, 16 lower bits of which represent blue channel

.fi
.SS\fB RETURN VALUE\fP 
.nf
 32 bit value, 16 lower bits of which represent hue\.
 32bit value pointed to by luminance, value and saturation will be set
 respectively to color luminance, value and saturation\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This functions translate RGB color into full set of HSV and HLS
 coordinates at once\. These functions work faster then separate
 translation into each channel\.

.fi

.PP
.SH libAfterImage/import/hsv2rgb()
.SS\fB SYNOPSIS\fP 
.nf
 void hsv2rgb( CARD32 hue, CARD32 saturation, CARD32 value,
               CARD32 *red, CARD32 *green, CARD32 *blue);
 void hls2rgb( CARD32 hue, CARD32 luminance, CARD32 saturation,
               CARD32 *red, CARD32 *green, CARD32 *blue);

.fi
.SS\fB INPUTS\fP 
.nf
 hue        \- 32 bit value, 16 lower bits of which represent hue\.
 saturation \- 32 bit value, 16 lower bits of which represent saturation\.
 value      \- 32 bit value, 16 lower bits of which represent value\.
 luminance  \- 32 bit value, 16 lower bits of which represent luminance\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 32bit value pointed to by red, green and blue will be set
 respectively to RGB color channels\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This functions performs reverse translation from HSV and HSL to
 RGB color

.fi

.PP
.SH libAfterImage/import/merge_scanline
.SS\fB SYNOPSIS\fP 
.nf
 void alphablend_scanlines( \fBASScanline\fP *bottom, \fBASScanline\fP *top, int );
 void allanon_scanlines   ( \fBASScanline\fP *bottom, \fBASScanline\fP *top, int );
 void \fBtint\fP_scanlines      ( \fBASScanline\fP *bottom, \fBASScanline\fP *top, int );
 void add_scanlines       ( \fBASScanline\fP *bottom, \fBASScanline\fP *top, int );
 void sub_scanlines       ( \fBASScanline\fP *bottom, \fBASScanline\fP *top, int );
 void diff_scanlines      ( \fBASScanline\fP *bottom, \fBASScanline\fP *top, int );
 void darken_scanlines    ( \fBASScanline\fP *bottom, \fBASScanline\fP *top, int );
 void lighten_scanlines   ( \fBASScanline\fP *bottom, \fBASScanline\fP *top, int );
 void screen_scanlines    ( \fBASScanline\fP *bottom, \fBASScanline\fP *top, int );
 void overlay_scanlines   ( \fBASScanline\fP *bottom, \fBASScanline\fP *top, int );
 void hue_scanlines       ( \fBASScanline\fP *bottom, \fBASScanline\fP *top, int );
 void saturate_scanlines  ( \fBASScanline\fP *bottom, \fBASScanline\fP *top, int );
 void value_scanlines     ( \fBASScanline\fP *bottom, \fBASScanline\fP *top, int );
 void colorize_scanlines  ( \fBASScanline\fP *bottom, \fBASScanline\fP *top, int );
 void dissipate_scanlines ( \fBASScanline\fP *bottom, \fBASScanline\fP *top, int );

.fi
.SS\fB INPUTS\fP 
.nf
 bottom   \- pointer to the \fBASScanline\fP that will be overalayed
 top      \- pointer to \fBASScanline\fP that will overlay bottom\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This functions accept 2 scanlines as an arguments stored in
 \fBASScanline\fP structures with data in 24\.8 format\. Merging operation is
 performed on these scanlines and result is stored in bottom
 \fBASScanline\fP\.
 The following are merging methods used in each function :

 alphablend_scanlines \- combines top and bottom RGB components based
                        on \fBalpha\fP channel value:
                        bottom = bottom*(255\-top_alpha)+top*top_alpha;
 allanon_scanlines    \- averages each \fBpixel\fP between two scanlines\.
                        This method has been first implemented by
                        Ethan Fisher aka allanon as mode 130:
                        bottom = (bottom+top)/2;
 \fBtint\fP_scanlines       \- tints bottom scanline with top scanline( with
                        saturation to prevent overflow) :
                        bottom = (bottom*(top/2))/32768;
 add_scanlines        \- adds top scanline to bottom scanline with
                        saturation to prevent overflow:
                        bottom = bottom+top;
 sub_scanlines        \- substrates top scanline from bottom scanline
                        with saturation to prevent overflow:
                        bottom = bottom\-top;
 diff_scanlines       \- for each \fBpixel\fP calculates absolute difference
                        between bottom and top color value :
                        bottom = (bottom>top)?bottom\-top:top\-bottom;
 darken_scanlines     \- substitutes each \fBpixel\fP with minimum color
                        value of top and bottom :
                        bottom = (bottom>top)?top:bottom;
 lighten_scanlines    \- substitutes each \fBpixel\fP with maximum color
                        value of top and bottom :
                        bottom = (bottom>top)?bottom:top;
 screen_scanlines     \- some wierd merging algorithm taken from GIMP;
 overlay_scanlines    \- some wierd merging algorithm taken from GIMP;
 hue_scanlines        \- substitute hue of bottom scanline with hue of
                        top scanline;
 saturate_scanlines   \- substitute saturation of bottom scanline with
                        the saturation of top scanline;
 value_scanlines      \- substitute value of bottom scanline with
                        the value of top scanline;
 colorize_scanlines   \- combine luminance of bottom scanline with hue
                        and saturation of top scanline;
 dissipate_scanlines  \- randomly \fBalpha\fP\-blend bottom and top scanlines,
                        using \fBalpha\fP value of top scanline as a
                        threshold for random values\.

.fi

.PP
.SH libAfterImage/import/blend_scanlines_name2func()
.SS\fB SYNOPSIS\fP 
.nf
 merge_scanlines_func blend_scanlines_name2func( const char *name );
 void list_scanline_merging(FILE* stream, const char *format);

.fi
.SS\fB INPUTS\fP 
.nf
 name \- string, identifying scanline merging function\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns pointer to the scanline merging function on succes\.
 NULL on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBblend_scanlines_name2func()\fP will strip leading whitespaces off of
 the supplied name, and then will attempt to match it against the list
 of names of merging functions\. It will then return pointer to the
 function with matching name\.
 list_scanline_merging() simply prints out description of implemented
 blending/merging methods onto the supplied stream, in supplied format\.
 Format must include 2 string specs, like so : "%s \- %s" where first
 one will be substituted to short method name, and second \- description

.fi

.PP
