.\" Source: asimage.h 
.\" Generated with ROBODoc Version 3.2.3 (Jun 26 2001)
.\" ROBODoc (c) 1994-2001 by Frans Slothouber and Jacco van Weert.
.\" t
.\" @(#)asimage.h.3
.TH asimage.h 1 "Wed Jul 11 2001" asimage.h 3
.PM Generated from asimage.h with ROBODoc v3.2.3 on Wed Jul 11 01:34:44 2001

.SH libAfterImage/asimage.h
.SS\fB SYNOPSIS\fP 
.nf
 Defines main structures and function for image manipulation\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBlibAfterImage\fP provides powerful functionality to load, store
 and transform images\. It allows for smaller memory utilization by
 utilizing run\-length encoding of the image data\. There could be
 different levels of \fBcompression\fP selected, allowing to choose best
 speed/memory ratio\.

 \fBTransformations\fP can be performed with different degree of \fBquality\fP\.
 Internal engine uses 24\.8 bits per channel per \fBpixel\fP\. As the result
 there are no precision loss, while performing complex calculations\.
 Error diffusion algorithms could be used to transform it back into 8
 bit without \fBquality\fP loss\.

 Any Transformation could be performed with the result written directly
 into \fBXImage\fP, so that it could be displayed faster\.

 Complex interpolation algorithms are used to perform scaling
 operations, thus yielding very good \fBquality\fP\. All the transformations
 are performed in integer math, with the result of greater speeds\.
 Optional MMX inline assembly has been incorporated into some
 procedures, and allows to achieve considerably better performance on
 compatible CPUs\.


.fi
.SS\fB SEE ALSO\fP 
.nf
 Structures :
          \fBASImage\fP
          \fBASImageBevel\fP
          \fBASImageDecoder\fP
          \fBASImageOutput\fP
          \fBASImageLayer\fP
          \fBASGradient\fP

 Functions :
          \fBasimage_init()\fP, \fBasimage_start()\fP, \fBcreate_asimage()\fP,
          \fBdestroy_asimage()\fP

   \fBEncoding\fP :
          \fBasimage_add_line()\fP,   \fBasimage_add_line_mono()\fP,
          \fBasimage_print_line()\fP

   \fBDecoding\fP
          \fBstart_image_decoding()\fP, \fBstop_image_decoding()\fP

   \fBOutput\fP :
          \fBstart_image_output()\fP, \fBset_image_output_back_color()\fP,
          \fBtoggle_image_output_direction()\fP, \fBstop_image_output()\fP

   \fBX11\fP conversions :
          \fBximage2asimage()\fP, \fBpixmap2asimage()\fP, \fBasimage2ximage()\fP,
          \fBasimage2mask_ximage()\fP, \fBasimage2pixmap()\fP, \fBasimage2mask()\fP

   \fBTransformations\fP :
          \fBscale_asimage()\fP, \fBtile_asimage()\fP, \fBmerge_layers()\fP, \fBmake_gradient()\fP,
          \fBflip_asimage()\fP

 Other \fBlibAfterImage\fP modules :
          \fBasvisual.h\fP, \fBimport.h\fP, \fBblender.h\fP, \fBasfont.h\fP

.fi
.SS\fB AUTHOR\fP 
.nf
\fB  Sasha Vasko <sashav at sprintmail dot com>
\fP 
.fi

.PP
.SH libAfterImage/ASImage
.SS\fB NAME\fP 
.nf
\fR  \fBASImage\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP is main structure to hold image data\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Images are stored internally split into ARGB channels, each split
 into scanline\. Each scanline is stored the following format to allow
 for RLE \fBcompression\fP :
 component := <line><line>\.\.\.<line>
 line      := <block><block>\.\.\.<block><EOL>
 block     := <EOL>|<simple_block>|<long_block>|<direct_block>

 EOL       := 00000000 (all zero bits)

 simple_block  := <ctrl_byte1><value_byte>
 ctrl_byte1    := 00NNNNNN (first two bits are 0 remaining are length)

 long_block    := <ctrl_byte2><more_length_byte><value_byte>
 ctrl_byte2    := 01NNNNNN (NNNNNN are high 6 bits of length)
 more_length_byte := low 8 bits of length

 direct_block  := <ctrl_byte3><value_byte><value_byte>\.\.\.<value_byte>
 ctrl_byte3    := [1NNNNNNN|11111111] (first bit is 1, remaining are
                    length\. If it is all 1's \- then remaining part of
                    the line up until image width is monolithic
                    uncompressed direct block)

.fi
.SS\fB SEE ALSO\fP 
.nf
  \fBasimage_init()\fP
  \fBasimage_start()\fP
  \fBcreate_asimage()\fP
  \fBdestroy_asimage()\fP

.fi
.SS\fB SOURCE\fP 
.nf
    struct ASImageAlternative;
    
    typedef struct \fBASImage\fP
    {
      unsigned int width, height;       /* size of the image in pixels */
    
      /* pointers to arrays of scanlines of particular channel: */
      CARD8 **\fBalpha\fP,
            **red,
            **green,
            **blue;
      CARD8 **channels[IC_NUM_CHANNELS];/* merely a shortcut so we can
                                         * somewhat simplify code in loops */
    
      /* internal buffer used for \fBcompression\fP/decompression */
      CARD8 *buffer;
      unsigned int buf_used, buf_len;   /* allocated and used size */
    
      unsigned int max_compressed_width;/* effectively limits \fBcompression\fP to
                                         * speed things up */
    
      struct ASImageAlternative
      {  /* alternative forms of \fBASImage\fP storage : */
        \fBXImage\fP *ximage ;                /* pointer to \fBXImage\fP created as the
                                         * result of transformations whenever
                                         * we request it to output into
                                         * \fBXImage\fP ( see to_xim parameter ) */
        \fBXImage\fP *mask_ximage ;           /* \fBXImage\fP of depth 1 that could be
                                         * used to store mask of the image */
        \fBARGB32\fP *argb32 ;                /* array of widthxheight \fBARGB32\fP
                                         * values */
      }alt;
    
    } \fBASImage\fP;
.fi

.PP
.SH libAfterImage/ASAltImFormats
.SS\fB FUNCTION\fP 
.nf
 Identifies what output format should be used for storing the
 transformation result\.

.fi
.SS\fB SOURCE\fP 
.nf
    typedef enum {
        ASA_ASImage = 0,
        ASA_XImage,
        ASA_MaskXImage,
        ASA_ARGB32,
        ASA_Formats
    }\fBASAltImFormats\fP;
.fi

.PP
.SH libAfterImage/LIMITS
.SS\fB NAME\fP 
.nf
\fR  MAX_IMPORT_IMAGE_SIZE
 MAX_BEVEL_OUTLINE
\fP 
.fi
.SS\fB FUNCTION\fP 
.nf
    MAX_IMPORT_IMAGE_SIZE   effectively limits size of the allowed
                            images to be loaded from files\. That is
                            needed to be able to filter out corrupt files\.

    MAX_BEVEL_OUTLINE       Limit on bevel outline to be drawn around
                            the image\.

.fi
.SS\fB SOURCE\fP 
.nf
    #define MAX_IMPORT_IMAGE_SIZE   4000
    #define MAX_BEVEL_OUTLINE       10
.fi

.PP
.SH libAfterImage/ASImageBevel
.SS\fB NAME\fP 
.nf
\fR  \fBASImageBevel\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImageBevel\fP describes bevel to be drawn around the image\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Bevel is used to create 3D effect while drawing buttons, or any other
 image that needs to be framed\. Bevel is drawn using 2 primary colors:
 one for top and left sides \- hi color, and another for bottom and
 right sides \- low color\. There are additionally 3 auxiliary colors:
 hihi is used for the edge of top\-left corner, hilo is used for the
 edge of top\-right and bottom\-left corners, and lolo is used for the
 edge of bottom\-right corner\. Colors are specified as ARGB and contain
 \fBalpha\fP component, thus allowing for semitransparent bevels\.

 Bevel consists of outline and inline\. Outline is drawn outside of the
 image boundaries and its size adds to image size as the result\. Alpha
 component of the outline is constant\. Inline is drawn on top of the
 image and its \fBalpha\fP component is fading towards the center of the
 image, thus creating illusion of smooth disappearing edge\.

.fi
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASImageBevel\fP
    {
        ASFlagType type ;                          /* reserved for future use */
    
        /* primary bevel colors */
        \fBARGB32\fP      hi_color, lo_color ;
    
        /* these will be placed in the corners */
        \fBARGB32\fP      hihi_color, hilo_color, lolo_color ;
        unsigned short left_outline, top_outline, right_outline, bottom_outline;
        unsigned short left_inline, top_inline, right_inline, bottom_inline;
    }\fBASImageBevel\fP;
.fi

.PP
.SH libAfterImage/ASImageDecoder
.SS\fB NAME\fP 
.nf
\fR  \fBASImageDecoder\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImageDecoder\fP describes the status of reading any particular \fBASImage\fP,
 as well as providing detail on how it should be done\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBASImageDecoder\fP works as an abstraction layer and as the way to
 automate several operations\. Most of the transformations in
 \fBlibAfterImage\fP are performed as operations on \fBASScanline\fP data
 structure, that holds all or some of the channels of single image
 scanline\. In order to automate data extraction from \fBASImage\fP into
 \fBASScanline\fP \fBASImageDecoder\fP has been designed\.

 It has following features :
 1) All missing scanlines, or channels of scanlines will be filled with
 supplied back_color
 2) It is possible to leave out some channels of the image, extracting
 only subset of channels\. It is done by setting only needed flags in
 filter member\.
 3) It is possible to extract sub\-image of the image by setting offset_x
 and offset_y to top\-left corner of sub\-image, out_width \- to width of
 the sub\-image and calling decode_image_scanline method as many times
 as height of the sub\-image\.
 4) It is possible to apply bevel to extracted sub\-image, by setting
 bevel member to specific \fBASImageBevel\fP structure\.

 Extracted Scanlines will be stored in buffer and it will be updated
 after each call to decode_image_scanline()\.

.fi
.SS\fB SOURCE\fP 
.nf
    typedef void (*decode_image_scanline_func)(struct \fBASImageDecoder\fP *imdec);
    
    typedef struct \fBASImageDecoder\fP
    {
        \fBASVisual\fP       *asv;
        \fBASImage\fP        *im ;
        ASFlagType      filter;      /* flags that mask set of channels to
                                      * be extracted from the image */
    
        \fBARGB32\fP          back_color;  /* we fill missing scanlines with this
                                      * default \- black*/
        unsigned int    offset_x,    /* left margin on source image before
                                      * which we skip everything */
                        out_width;   /* actual length of the output scanline */
        unsigned int    offset_y,    /* top margin */
                        out_height;
        \fBASImageBevel\fP    *bevel;      /* bevel to wrap everything around with */
    
        /* scanline buffer containing current scanline */
        \fBASScanline\fP      buffer;
    
        /* internal data : */
        unsigned short   bevel_h_addon, bevel_v_addon ;
        int             next_line ;
        decode_image_scanline_func decode_image_scanline ;
    }\fBASImageDecoder\fP;
.fi

.PP
.SH libAfterImage/asimage/quality
.SS\fB FUNCTION\fP 
.nf
 Defines level of output \fBquality\fP/speed ratio

.fi
.SS\fB SOURCE\fP 
.nf
    #define ASIMAGE_QUALITY_DEFAULT \-1
    #define ASIMAGE_QUALITY_POOR    0
    #define ASIMAGE_QUALITY_FAST    1
    #define ASIMAGE_QUALITY_GOOD    2
    #define ASIMAGE_QUALITY_TOP     3
    
    #define MAX_GRADIENT_DITHER_LINES   ASIMAGE_QUALITY_TOP+1
.fi

.PP
.SH libAfterImage/asimage/ASImageOutput
.SS\fB NAME\fP 
.nf
\fR  \fBASImageOutput\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImageOutput\fP describes the output state of the transformation result\.
 It is used to transparently write results into \fBASImage\fP or \fBXImage\fP with
 different levels of \fBquality\fP\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBlibAfterImage\fP allows for transformation result to be stored in both
 \fBASImage\fP ( useful for long term storage and subsequent processing )
 and \fBXImage\fP ( useful for transfer of the result onto the X Server)\.
 At the same time there are 4 different \fBquality\fP levels of output
 implemented\. They differ in the way special technics, like error
 diffusion and interpolation are applyed, and allow for fine grained
 selection of \fBquality\fP/speed ratio\. ASIMAGE_QUALITY_GOOD should be good
 enough for most applications\.
 The following additional output features are implemented :
 1) Filling of the missing channels with supplied values\.
 2) Error diffusion to improve \fBquality\fP while converting from internal
      24\.8 format to 8 bit format\.
 3) Tiling of the output\. If tiling_step is greater then 0, then each
      scanlines will be copied into lines found tiling_step one from
      another, upto the edge of the image\.
 4) Reverse order of output\. \fBOutput\fP image will be mirrored along y
      axis if bottom_to_top is set to True\.

.fi
.SS\fB NOTES\fP 
.nf
\fR  The output_image_scanline method should be called for each scanline
 to be stored\. Convenience functions listed below should be used to
 safely alter state of the output instead of direct manipulation of
 the data members\. (makes you pity you don't write in C++ doesn't it ?)
\fP 
.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBstart_image_output()\fP
 \fBset_image_output_back_color()\fP
 \fBtoggle_image_output_direction()\fP
 \fBstop_image_output()\fP

.fi
.SS\fB SOURCE\fP 
.nf
    typedef void (*encode_image_scanline_func)( struct \fBASImageOutput\fP *imout,
                                                \fBASScanline\fP *to_store );
    typedef void (*output_image_scanline_func)( struct \fBASImageOutput\fP *,
                                                \fBASScanline\fP *, int );
    
    typedef struct \fBASImageOutput\fP
    {
        \fBASVisual\fP        *asv;
        \fBASImage\fP         *im ;
        \fBASAltImFormats\fP   out_format ;
        CARD32           chan_fill[4];
        int              buffer_shift;  /* \-1 means \- buffer is empty,
                                         * 0 \- no shift,
                                         * 8 \- use 8 bit precision */
        int              next_line ;    /* next scanline to be written */
        unsigned int     tiling_step;   /* each line written will be repeated
                                         * with this step until we exceed
                                         * image size */
        int              bottom_to_top; /* \-1 if we should output in
                                         * bottom to top order, +1 otherwise*/
    
        int              \fBquality\fP ;      /* see above */
    
        output_image_scanline_func
            output_image_scanline ;  /* high level interface \- division,
                                      * error diffusion as well as encoding */
        encode_image_scanline_func
            encode_image_scanline ;  /* low level interface \- encoding only */
    
        /* internal data members : */
        \fBASScanline\fP       buffer[2], *used, *available;
    }\fBASImageOutput\fP;
.fi

.PP
.SH libAfterImage/asimage/ASImageLayer
.SS\fB NAME\fP 
.nf
\fR  \fBASImageLayer\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImageLayer\fP specifies parameters of the image superimposition\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBlibAfterImage\fP allows for simultaneous superimposition (overlaying) of
 arbitrary number of images\. To facilitate this \fBASImageLayer\fP structure
 has been created in order to specify parameters of each image
 participating in overlaying operation\. Images need not to be exact
 same size\. For each image its position on destination is specified
 via dst_x and dst_y data members\. Each image maybe tiled and clipped
 to fit into rectangle specified by clip_x, clip_y, clip_width,
 clip_height ( in image coordinates \- not destination )\. Missing
 scanlines/channels of the image will be filled with back_color\.
 Entire image will be tinted using \fBtint\fP parameter prior to overlaying\.
 Bevel specified by bevel member will be drawn over image prior to
 overlaying\. Specific overlay method has to be specified\.
 merge_scanlines method is pointer to a function,
 that accepts 2 ASScanlines as arguments and performs overlaying of
 first one with the second one\.
 There are 15 different \fBmerge_scanline\fP methods implemented in
 \fBlibAfterImage\fP, including \fBalpha\fP\-blending, tinting, averaging,
 HSV and HSL \fBcolorspace\fP operations, etc\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBmerge_layers()\fP
 \fBblender.h\fP

.fi
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASImageLayer\fP
    {
        \fBASImage\fP *im;
    
        int dst_x, dst_y;                       /* placement in overall
                                                 * composition */
    
        /* clip area could be partially outside of the image \-
         * image gets tiled in it */
        int clip_x, clip_y;
        unsigned int clip_width, clip_height;
    
        \fBARGB32\fP back_color ;                     /* what we want to fill
                                                 * missing scanlines with */
        \fBARGB32\fP \fBtint\fP ;                           /* if 0 \- no \fBtint\fP */
        \fBASImageBevel\fP *bevel ;                   /* border to wrap layer with
                                                 * (for buttons, etc\.)*/
        int merge_mode ;                        /* reserved for future use */
        merge_scanlines_func merge_scanlines ;  /* overlay method */
        void *data;                             /* hook to hung data on */
    }\fBASImageLayer\fP;
.fi

.PP
.SH libAfterImage/asimage/GRADIENT_TYPE_flags
.SS\fB FUNCTION\fP 
.nf
 Combination of this flags defines the way gradient is rendered\.

.fi
.SS\fB SOURCE\fP 
.nf
    #define GRADIENT_TYPE_MASK          0x0003
    #define GRADIENT_TYPE_ORIENTATION   0x0002
    #define GRADIENT_TYPE_DIAG          0x0001
.fi

.PP
.SH libAfterImage/asimage/GRADIENT_TYPE
.SS\fB FUNCTION\fP 
.nf
 This are named combinations of above flags to define type of gradient\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBGRADIENT_TYPE_flags\fP

.fi
.SS\fB SOURCE\fP 
.nf
    #define GRADIENT_Left2Right             0
    #define GRADIENT_TopLeft2BottomRight    GRADIENT_TYPE_DIAG
    #define GRADIENT_Top2Bottom             GRADIENT_TYPE_ORIENTATION
    #define GRADIENT_BottomLeft2TopRight    (GRADIENT_TYPE_DIAG| \\
                                             GRADIENT_TYPE_ORIENTATION)
.fi

.PP
.SH libAfterImage/ASGradient
.SS\fB NAME\fP 
.nf
\fR  \fBASGradient\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASGradient\fP describes how gradient is to be drawn\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBlibAfterImage\fP includes functionality to draw multipoint gradients in
 4 different directions left\->right, top\->bottom and diagonal
 lefttop\->rightbottom and bottomleft\->topright\. Each gradient described
 by type, number of colors (or anchor points), ARGB values for each
 color and offsets of each point from the beginning of gradient in
 fractions of entire length\. There should be at least 2 anchor points\.
 very first point should have offset of 0\. and last point should have
 offset of 1\. Gradients are drawn in ARGB \fBcolorspace\fP, so it is possible
 to have semitransparent gradients\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBmake_gradient()\fP

.fi
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASGradient\fP
    {
        int         type;       /* see \fBGRADIENT_TYPE\fP above */
    
        int         npoints;    /* number of anchor points */
        \fBARGB32\fP     *color;      /* ARGB color values for each anchor point  */
        double     *offset;     /* offset of each point from the beginning in
                                 * fractions of entire length */
    }\fBASGradient\fP;    

.fi

.PP
.SH libAfterImage/asimage/flip
.SS\fB FUNCTION\fP 
.nf
 This are flags that define rotation angle\.
 FLIP_VERTICAL defines rotation of 90 degrees counterclockwise\.
 FLIP_UPSIDEDOWN defines rotation of 180 degrees counterclockwise\.
 combined they define rotation of 270 degrees counterclockwise\.

.fi
.SS\fB SOURCE\fP 
.nf
    #define FLIP_VERTICAL       (0x01<<0)
    #define FLIP_UPSIDEDOWN     (0x01<<1)
.fi

.PP
.SH libAfterImage/asimage/tint
.SS\fB FUNCTION\fP 
.nf
 We use 32 bit ARGB values to define how tinting should be done\.
 The formula for tinting particular channel data goes like that:
 tinted_data = (image_data * \fBtint\fP)/128
 So if \fBtint\fP channel value is greater then 127 \- same channel will be
 brighter in destination image; if it is lower then 127 \- same channel
 will be darker in destination image\. Tint channel value of 127
 ( or 0x7F hex ) does not change anything\.
 Alpha channel is tinted as well, allowing for creation of
 semitransparent images\. Calculations are performed in 24\.8 format \-
 with 8 bit precision\. Result is saturated to avoid overflow, and
 precision is carried over to next \fBpixel\fP ( error diffusion ), when con
 verting 24\.8 to 8 bit format\.

.fi
.SS\fB SOURCE\fP 
.nf
    #define TINT_NONE           0
    #define TINT_LEAVE_SAME     (0x7F7F7F7F)
    #define TINT_HALF_DARKER    (0x3F3F3F3F)
    #define TINT_HALF_BRIGHTER  (0xCFCFCFCF)
    #define TINT_RED            (0x7F7F0000)
    #define TINT_GREEN          (0x7F007F00)
    #define TINT_BLUE           (0x7F00007F)
.fi

.PP
.SH libAfterImage/asimage/compression
.SS\fB FUNCTION\fP 
.nf
 Defines the level of \fBcompression\fP to attempt on \fBASImage\fP scanlines\.
 valid values are in range of 0 to 100, with 100 being the highest
 \fBcompression\fP\.

.fi
.SS\fB SOURCE\fP 
.nf
    #define ASIM_COMPRESSION_NONE       0
    #define ASIM_COMPRESSION_FULL      100
.fi

.PP
.SH libAfterImage/asimage/asimage_init()
.SS\fB SYNOPSIS\fP 
.nf
 void asimage_init (\fBASImage\fP * im, Bool free_resources);

.fi
.SS\fB INPUTS\fP 
.nf
 im             \- pointer to valid \fBASImage\fP structure
 free_resources \- if True will make function attempt to free
                  all non\-NULL pointers\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
    frees datamembers of the supplied \fBASImage\fP structure, and
    initializes it to all 0\.

.fi

.PP
.SH libAfterImage/asimage/asimage_start()
.SS\fB SYNOPSIS\fP 
.nf
 void asimage_start (\fBASImage\fP * im, unsigned int width,
                                   unsigned int height,
                                   unsigned int \fBcompression\fP);

.fi
.SS\fB INPUTS\fP 
.nf
 im          \- pointer to valid \fBASImage\fP structure
 width       \- width of the image
 height      \- height of the image
 \fBcompression\fP \- level of \fBcompression\fP to perform on image data\.
               \fBcompression\fP has to be in range of 0\-100 with 100
               signifying highest level of \fBcompression\fP\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Allocates memory needed to store scanline of the image of supplied
 size\. Assigns all the data members valid values\. Makes sure that
 \fBASImage\fP structure is ready to store image data\.

.fi
.SS\fB NOTES\fP 
.nf
\fR  In order to resize \fBASImage\fP structure after \fBasimage_start()\fP has been
 called, \fBasimage_init()\fP must be invoked to free all the memory, and
 then \fBasimage_start()\fP has to be called with new dimensions\.
\fP 
.fi

.PP
.SH libAfterImage/asimage/asimage_sta()
.SS\fB SYNOPSIS\fP 
.nf
 void move_asimage_channel( \fBASImage\fP *dst, int channel_dst,
                            \fBASImage\fP *src, int channel_src );

.fi
.SS\fB INPUTS\fP 
.nf
 dst         \- \fBASImage\fP which will have its channel substituted;
 channel_dst \- what channel to move data to;
 src         \- \fBASImage\fP which will donate its channel to dst;
 channel_src \- what source image channel to move data from\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 MOves channel data from one \fBASImage\fP to another, while discarding
 what was already in destination's channel\.

.fi
.SS\fB NOTES\fP 
.nf
\fR  Source image (donor) will loose its channel data, as it will be
 moved to destination \fBASImage\fP\. Also there is a condition that both
 images must be of the same width \- otherwise function returns
 without doing anything\. If height is different \- the minimum of
 two will be used\.
\fP 
.fi

.PP
.SH libAfterImage/asimage/create_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *create_asimage( unsigned int width,
                          unsigned int height,
                          unsigned int \fBcompression\fP);

.fi
.SS\fB INPUTS\fP 
.nf
 width       \- desired image width
 height      \- desired image height
 \fBcompression\fP \- \fBcompression\fP level in new \fBASImage\fP( see \fBasimage_start()\fP
               for more )\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 Pointer to newly allocated and initialized \fBASImage\fP structure on
 Success\. NULL in case of any kind of error \- that should never happen\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Performs memory allocation for the new \fBASImage\fP structure, as well as
 initialization of allocated structure based on supplied parameters\.

.fi

.PP
.SH libAfterImage/asimage/destroy_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 void destroy_asimage( \fBASImage\fP **im );

.fi
.SS\fB INPUTS\fP 
.nf
 im             \- pointer to valid \fBASImage\fP structure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 frees all the memory allocated for specified \fBASImage\fP\. If there was
 \fBXImage\fP attached to it \- it will be deallocated as well\.

.fi
.SS\fB EXAMPLE\fP 
.nf
 asview\.c: \fBASView.5\fP

.fi

.PP
.SH libAfterImage/asimage/Encoding
.SS\fB DESCRIPTION\fP 
.nf
 \fBasimage_add_line()\fP       \- encode raw scanline data
 \fBasimage_add_line_mono()\fP  \- encode scanline to have all the same pixels
 \fBasimage_print_line()\fP     \- print stored scanline to stderr\.

.fi

.PP
.SH libAfterImage/asimage/asimage_add_line()
.SS\fB SYNOPSIS\fP 
.nf
 size_t asimage_add_line ( \fBASImage\fP * im, \fBColorPart\fP color,
                           CARD32 * data, unsigned int y);

.fi
.SS\fB INPUTS\fP 
.nf
 im      \- pointer to valid \fBASImage\fP structure
 color   \- color channel's number
 data    \- raw channel data of 32 bits per \fBpixel\fP \- only lowest 8 bits
           gets encoded\.
 y       \- image row starting with 0

.fi
.SS\fB RETURN VALUE\fP 
.nf
 \fBasimage_add_line()\fP return size of the encoded channel scanline in
 bytes\. On failure it will return 0\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Encodes raw data of the single channel into \fBASImage\fP channel scanline\.
 based on \fBcompression\fP level selected for this \fBASImage\fP all or part of
 the scanline will be RLE encoded\.

.fi

.PP
.SH libAfterImage/asimage/asimage_add_line_mono()
.SS\fB SYNOPSIS\fP 
.nf
 size_t asimage_add_line_mono ( \fBASImage\fP * im, \fBColorPart\fP color,
                                CARD8 value, unsigned int y);

.fi
.SS\fB INPUTS\fP 
.nf
 im             \- pointer to valid \fBASImage\fP structure
 color          \- color channel's number
 value          \- value for the channel
 y              \- image row starting with 0

.fi
.SS\fB RETURN VALUE\fP 
.nf
 \fBasimage_add_line_mono()\fP return size of the encoded channel scanline
 in bytes\. On failure it will return 0\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 encodes \fBASImage\fP channel scanline to have same color components
 value in every \fBpixel\fP\. Useful for vertical gradients for example\.

.fi

.PP
.SH libAfterImage/asimage/verbosity
.SS\fB FUNCTION\fP 
.nf
 This are flags that define what should be printed by
 asimage_print_line():
    VRB_LINE_SUMMARY    \- print only summary for each scanline
    VRB_LINE_CONTENT    \- print summary and data for each scanline
    VRB_CTRL_EXPLAIN    \- print summary, data and control codes for each
                          scanline

.fi
.SS\fB SOURCE\fP 
.nf
    #define VRB_LINE_SUMMARY    (0x01<<0)
    #define VRB_LINE_CONTENT    (0x01<<1)
    #define VRB_CTRL_EXPLAIN    (0x01<<2)
    #define VRB_EVERYTHING      (VRB_LINE_SUMMARY|VRB_CTRL_EXPLAIN| \\
                                 VRB_LINE_CONTENT)
.fi

.PP
.SH libAfterImage/asimage/asimage_print_line()
.SS\fB SYNOPSIS\fP 
.nf
    unsigned int asimage_print_line ( \fBASImage\fP * im, \fBColorPart\fP color,
                                      unsigned int y,
                                      unsigned long \fBverbosity\fP);

.fi
.SS\fB INPUTS\fP 
.nf
 im             \- pointer to valid \fBASImage\fP structure
 color          \- color channel's number
 y              \- image row starting with 0
 \fBverbosity\fP      \- \fBverbosity\fP level \- any combination of flags is
                  allowed

.fi
.SS\fB RETURN VALUE\fP 
.nf
 amount of memory used by this particular channel of specified
 scanline\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBasimage_print_line()\fP prints data stored in specified image scanline
 channel\. That may include simple summary of how much memory is used,
 actual visible data, and/or RLE control codes\. That helps to see
 how effectively data is encoded\.

 Useful mostly for debugging purposes\.

.fi

.PP
.SH libAfterImage/asimage/Decoding
.SS\fB DESCRIPTION\fP 
.nf
 \fBstart_image_decoding()\fP   \- allocates and initializes decoder
                            structure\.
 \fBstop_image_decoding()\fP    \- finishes decoding, frees all allocated
                            memory\.

.fi

.PP
.SH libAfterImage/asimage/start_image_decoding()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImageDecoder\fP *start_image_decoding( \fBASVisual\fP *asv,\fBASImage\fP *im,
                                       ASFlagType filter,
                                       int offset_x, int offset_y,
                                       unsigned int out_width,
                                       unsigned int out_height,
                                       \fBASImageBevel\fP *bevel );

.fi
.SS\fB INPUTS\fP 
.nf
 asv      \- pointer to valid \fBASVisual\fP structure ( needed mostly
            to see if we are in BGR mode or not );
 im       \- \fBASImage\fP we are going to decode;
 filter   \- bitmask where set bits mark channels that has to be
            decoded\.
 offset_x \- left margin inside im, from which we should start
            reading \fBpixel\fP data, effectively clipping source image\.
 offset_y \- top margin inside im, from which we should start
            reading scanlines, effectively clipping source image\.
            Note that when edge of the image is reached,
            subsequent requests for scanlines will wrap around to
            the top of the image, and not offset_y\.
 out_width\- width of the scanline needed\. If it is larger then
            source image \- then image data will be tiled in it\.
            If it is smaller \- then image data will be clipped\.
 out_height \- height of the output drawable\. \-1 means that same as
          image height\. if out_height is greater then image height,
          then image will be tiled\.
 bevel    \- NULL or pointer to valid \fBASImageBevel\fP structure if
            decoded data should be overlayed with bevel at the
            time of decoding\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 \fBstart_image_decoding()\fP returns pointer to newly allocated
 \fBASImageDecoder\fP structure on success, NULL on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Normal process of reading image data from \fBASImage\fP consists of
 3 steps :
 1) start decoding by calling start_image_decoding\.
 2) call decode_image_scanline() method of returned structure, for
 each scanline upto desired height of the target image\. Decoded data
 will be returned in buffer member of the \fBASImageDecoder\fP structure\.
 3) finish decoding and deallocated all the used memory by calling
 \fBstop_image_decoding()\fP

.fi

.PP
.SH libAfterImage/asimage/stop_image_decoding()
.SS\fB SYNOPSIS\fP 
.nf
 void stop_image_decoding( \fBASImageDecoder\fP **pimdec );

.fi
.SS\fB INPUTS\fP 
.nf
 pimdec   \- pointer to pointer to structure, previously created
            by start_image_decoding\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 pimdec \- pointer to \fBASImageDecoder\fP will be reset to NULL\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBstart_image_decoding()\fP

.fi

.PP
.SH libAfterImage/asimage/Output
.SS\fB DESCRIPTION\fP 
.nf
 start_image_output               \- initializes output structure
 set_image_output_back_color      \- changes background color of output
 toggle_image_output_direction    \- reverses vertical direction of
                                    output
 stop_image_output                \- finishes output, frees all the
                                    allocated memory\.

.fi

.PP
.SH libAfterImage/asimage/start_image_output()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImageOutput\fP *start_image_output ( struct \fBASVisual\fP *asv,
                                     \fBASImage\fP *im,
                                     \fBASAltImFormats\fP format,
                                     int shift, int \fBquality\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv      \- pointer to valid \fBASVisual\fP structure
 im       \- destination \fBASImage\fP
 format   \- indicates that output should be written into alternative
            format, such as supplied \fBXImage\fP, \fBARGB32\fP array etc\.
 shift    \- precision of scanline data\. Supported values are 0 \- no
            precision, and 8 \- 24\.8 precision\. Value of that argument
            defines by how much scanline data is shifted rightwards\.
 \fBquality\fP  \- what algorithms should be used while writing data out, i\.e\.
            full error diffusion, fast error diffusion, no error
            diffusion\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBstart_image_output()\fP creates and initializes new \fBASImageOutput\fP
 structure based on supplied parameters\. Created structure can be
 subsequently used to write scanlines into destination image\.
 It is effectively hiding differences of \fBXImage\fP and \fBASImage\fP and other
 available output formats\.
 outpt_image_scanline() method of the structure can be used to write
 out single scanline\. Each written scanlines moves internal pointer to
 the next image line, and possibly writes several scanlines at once if
 tiling_step member is not 0\.

.fi

.PP
.SH libAfterImage/asimage/set_image_output_back_color()
.SS\fB SYNOPSIS\fP 
.nf
 void set_image_output_back_color ( \fBASImageOutput\fP *imout,
                                    \fBARGB32\fP back_color );

.fi
.SS\fB INPUTS\fP 
.nf
 imout      \- \fBASImageOutput\fP structure, previously created with
              start_image_output();
 back_color \- new background color value in ARGB format\. This color
              will be used to fill empty parts of outgoing scanlines\.

.fi

.PP
.SH libAfterImage/asimage/toggle_image_output_direction()
.SS\fB SYNOPSIS\fP 
.nf
 void toggle_image_output_direction( \fBASImageOutput\fP *imout );

.fi
.SS\fB INPUTS\fP 
.nf
 imout      \- \fBASImageOutput\fP structure, previously created with
              start_image_output();

.fi
.SS\fB DESCRIPTION\fP 
.nf
 reverses vertical direction output\. If previously scanlines has
 been written from top to bottom, for example, after this function is
 called they will be written in opposite direction\. Current line does
 not change, unless it points to the very first or the very last
 image line\. In this last case it will be moved to the opposing end of
 the image\.

.fi

.PP
.SH libAfterImage/asimage/stop_image_output()
.SS\fB SYNOPSIS\fP 
.nf
 void stop_image_output( \fBASImageOutput\fP **pimout );

.fi
.SS\fB INPUTS\fP 
.nf
 pimout     \- pointer to pointer to \fBASImageOutput\fP structure,
              previously created with call to   \fBstart_image_output()\fP\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 pimout     \- pointer to \fBASImageOutput\fP will be reset to NULL\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Completes image output process\. Flushes all the internal buffers\.
 Deallocates all the allocated memory\. Resets pointer to NULL to
 avoid dereferencing invalid pointers\.

.fi

.PP
.SH libAfterImage/asimage/X11
.SS\fB DESCRIPTION\fP 
.nf
 \fBximage2asimage()\fP   \- convert \fBXImage\fP structure into \fBASImage\fP
 \fBpixmap2asimage()\fP   \- convert \fBX11\fP \fBpixmap\fP into \fBASImage\fP
 \fBasimage2ximage()\fP   \- convert \fBASImage\fP into \fBXImage\fP
 \fBasimage2mask_ximage()\fP \- convert \fBalpha\fP channel of \fBASImage\fP into \fBXImage\fP
 \fBasimage2pixmap()\fP   \- convert \fBASImage\fP into \fBPixmap\fP ( possibly using
                      precreated \fBXImage\fP )
 \fBasimage2mask()\fP     \- convert \fBalpha\fP channel of \fBASImage\fP into 1 bit
                      mask \fBPixmap\fP\.

.fi

.PP
.SH libAfterImage/asimage/ximage2asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *ximage2asimage ( struct \fBASVisual\fP *asv, \fBXImage\fP * xim,
                           unsigned int \fBcompression\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv         \- pointer to valid \fBASVisual\fP structure
 xim         \- source \fBXImage\fP
 \fBcompression\fP \- degree of \fBcompression\fP of resulting \fBASImage\fP\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 pointer to newly allocated \fBASImage\fP, containing encoded data, on
 success\. NULL on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 ximage2asimage will attempt to create new \fBASImage\fP with the same
 dimensions as supplied \fBXImage\fP\. \fBXImage\fP will be decoded based on
 supplied \fBASVisual\fP, and resulting scanlines will be encoded into
 \fBASImage\fP\.

.fi

.PP
.SH libAfterImage/asimage/pixmap2asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *pixmap2asimage ( struct \fBASVisual\fP *asv, \fBPixmap\fP p,
                           int x, int y,
                           unsigned int width,
                           unsigned int height,
                           unsigned long \fBplane_mask\fP,
                           Bool keep_cache,
                           unsigned int \fBcompression\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv          \- pointer to valid \fBASVisual\fP structure
 p            \- source \fBPixmap\fP
 x, y,
 width, height\- rectangle on \fBPixmap\fP to be encoded into \fBASImage\fP\.
 \fBplane_mask\fP   \- limits color planes to be copied from \fBPixmap\fP\.
 keep_cache   \- indicates if we should keep \fBXImage\fP, used to copy
                image data from the X server, and attached it to ximage
                member of resulting \fBASImage\fP\.
 \fBcompression\fP  \- degree of \fBcompression\fP of resulting \fBASImage\fP\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 pointer to newly allocated \fBASImage\fP, containing encoded data, on
 success\. NULL on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 pixmap2asimage will obtain \fBXImage\fP of the requested area of the
 X \fBPixmap\fP, and will encode it into \fBASImage\fP using \fBximage2asimage()\fP
 function\.

.fi

.PP
.SH libAfterImage/asimage/asimage2ximage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBXImage\fP  *asimage2ximage  (struct \fBASVisual\fP *asv, \fBASImage\fP *im);

.fi
.SS\fB INPUTS\fP 
.nf
 asv        \- pointer to valid \fBASVisual\fP structure
 im         \- source \fBASImage\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 On success returns newly created and encoded \fBXImage\fP of the same
 colordepth as the supplied \fBASVisual\fP\. NULL on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBasimage2ximage()\fP creates new \fBXImage\fP of the exact same size as
 supplied \fBASImage\fP, and depth of supplied \fBASVisual\fP\. REd, Green and
 Blue channels of \fBASImage\fP then gets decoded, and encoded into \fBXImage\fP\.
 Missing scanlines get filled with black color\.

.fi
.SS\fB NOTES\fP 
.nf
\fR  Returned pointer to \fBXImage\fP will also be stored in im\->alt\.ximage,
 and It will be destroyed when \fBXImage\fP is destroyed, or reused in any
 subsequent calls to \fBasimage2ximage()\fP\. If any other behaviour is
 desired \- make sure you set im\->alt\.ximage to NULL, to dissociate
 \fBXImage\fP object from \fBASImage\fP\.
\fP 
.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBcreate_visual_ximage()\fP

.fi

.PP
.SH libAfterImage/asimage/asimage2mask_ximage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBXImage\fP  *asimage2mask_ximage (struct \fBASVisual\fP *asv, \fBASImage\fP *im);

.fi
.SS\fB INPUTS\fP 
.nf
 asv        \- pointer to valid \fBASVisual\fP structure
 im         \- source \fBASImage\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 On success returns newly created and encoded \fBXImage\fP of the depth 1\.
 NULL on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBasimage2mask_ximage()\fP creates new \fBXImage\fP of the exact same size as
 supplied \fBASImage\fP, and depth 1\. Alpha channels of \fBASImage\fP then gets
 decoded, and encoded into \fBXImage\fP\. If \fBalpha\fP channel is greater the
 127 it is encoded as 1, otherwise as 0\.
 Missing scanlines get filled with 1s as they signify absence of mask\.

.fi
.SS\fB NOTES\fP 
.nf
\fR  Returned pointer to \fBXImage\fP will also be stored in im\->alt\.mask_ximage,
 and It will be destroyed when \fBXImage\fP is destroyed, or reused in any
 subsequent calls to \fBasimage2mask_ximage()\fP\. If any other behaviour is
 desired \- make sure you set im\->alt\.mask_ximage to NULL, to dissociate
 \fBXImage\fP object from \fBASImage\fP\.
\fP 
.fi

.PP
.SH libAfterImage/asimage/asimage2pixmap()
.SS\fB SYNOPSIS\fP 
.nf
 \fBPixmap\fP   asimage2pixmap  ( struct \fBASVisual\fP *asv, \fBWindow\fP root,
                            \fBASImage\fP *im, \fBGC\fP \fBgc\fP, Bool use_cached);

.fi
.SS\fB INPUTS\fP 
.nf
 asv        \- pointer to valid \fBASVisual\fP structure
 root       \- root \fBwindow\fP of destination screen
 im         \- source \fBASImage\fP
 \fBgc\fP         \- precreated \fBGC\fP to use for \fBXImage\fP transfer\. If NULL,
              \fBasimage2pixmap()\fP will use \fBDefaultGC\fP\.
 use_cached \- If True will make \fBasimage2pixmap()\fP to use \fBXImage\fP
              attached to \fBASImage\fP, instead of creating new one\. Only
              works if \fBASImage\fP\->ximage data member is not NULL\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 On success returns newly \fBpixmap\fP of the same colordepth as \fBASVisual\fP\.
 None on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBasimage2pixmap()\fP creates new \fBpixmap\fP of exactly same size as
 supplied \fBASImage\fP\. It then checks if it needs to encode \fBXImage\fP
 from \fBASImage\fP data, and calls \fBasimage2ximage()\fP if yes, it has to\.
 It then uses supplied \fBgc\fP or \fBDefaultGC\fP of the screen to transfer
 \fBXImage\fP to the server and put it on \fBPixmap\fP\.
 Missing scanlines get filled with black color\.

.fi
.SS\fB EXAMPLE\fP 
.nf
 asview\.c: \fBASView.5\fP

.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBasimage2ximage()\fP
 \fBcreate_visual_pixmap()\fP

.fi

.PP
.SH libAfterImage/asimage/asimage2mask()
.SS\fB SYNOPSIS\fP 
.nf
 \fBPixmap\fP   asimage2mask ( struct \fBASVisual\fP *asv, \fBWindow\fP root,
                         \fBASImage\fP *im, \fBGC\fP \fBgc\fP, Bool use_cached);
 asv        \- pointer to valid \fBASVisual\fP structure
 root       \- root \fBwindow\fP of destination screen
 im         \- source \fBASImage\fP
 \fBgc\fP         \- precreated \fBGC\fP for 1 bit deep drawables to use for
              \fBXImage\fP transfer\. If NULL, \fBasimage2mask()\fP will create one\.
 use_cached \- If True will make \fBasimage2mask()\fP to use mask \fBXImage\fP
            attached to \fBASImage\fP, instead of creating new one\. Only
            works if \fBASImage\fP\->alt\.mask_ximage data member is not NULL\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 On success returns newly created \fBpixmap\fP of the colordepth 1\.
 None on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBasimage2mask()\fP creates new \fBpixmap\fP of exactly same size as
 supplied \fBASImage\fP\. It then calls \fBasimage2mask_ximage()\fP\.
 It then uses supplied \fBgc\fP, or creates new \fBgc\fP, to transfer
 \fBXImage\fP to the server and put it on \fBPixmap\fP\.
 Missing scanlines get filled with 1s\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBasimage2mask_ximage()\fP

.fi

.PP
.SH libAfterImage/asimage/Transformations
.SS\fB DESCRIPTION\fP 
.nf
 \fBscale_asimage()\fP  \- scale supplied image into new image of requested
                    size\.
 \fBtile_asimage()\fP   \- tile image into new image of requested size,
                    optionally tinting it\.
 \fBmerge_layers()\fP   \- overlay arbitrary number of images
 \fBmake_gradient()\fP  \- render gradient filled image
 \fBflip_asimage()\fP   \- rotate image in 90 degree increments
                    counterclockwise\.

.fi

.PP
.SH libAfterImage/asimage/scale_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *scale_asimage( struct \fBASVisual\fP *asv,
                         \fBASImage\fP *src,
                         unsigned int to_width,
                         unsigned int to_height,
                         \fBASAltImFormats\fP out_format,
                         unsigned int \fBcompression\fP_out, int \fBquality\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv        \- pointer to valid \fBASVisual\fP structure
 src        \- source \fBASImage\fP
 to_width   \- desired width of the resulting image
 to_height  \- desired height of the resulting image
 out_format     \- optionally describes alternative \fBASImage\fP format that
                should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBcompression\fP_out\- \fBcompression\fP level of resulting image in range 0\-100\.
 \fBquality\fP    \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns newly created and encoded \fBASImage\fP on success, NULL of failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Scales source \fBASImage\fP into new image of requested dimensions\. If size
 has to be reduced \- then several neighboring pixels will be averaged
 into single \fBpixel\fP\. If size has to be increased then new pixels will
 be interpolated based on values of four neighboring pixels\.

.fi
.SS\fB EXAMPLE\fP 
.nf
 \fBASScale\fP

.fi

.PP
.SH libAfterImage/asimage/tile_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *tile_asimage ( struct \fBASVisual\fP *asv,
                         \fBASImage\fP *src,
                         int offset_x,
                         int offset_y,
                         unsigned int to_width,
                         unsigned int to_height,
                         \fBARGB32\fP \fBtint\fP,
                         \fBASAltImFormats\fP out_format,
                         unsigned int \fBcompression\fP_out, int \fBquality\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv          \- pointer to valid \fBASVisual\fP structure
 src          \- source \fBASImage\fP
 offset_x     \- left clip margin
 offset_y     \- right clip margin
 to_width     \- desired width of the resulting image
 to_height    \- desired height of the resulting image
 \fBtint\fP         \- \fBARGB32\fP value describing tinting color\.
 out_format     \- optionally describes alternative \fBASImage\fP format that
                should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBcompression\fP_out\- \fBcompression\fP level of resulting image in range 0\-100\.
 \fBquality\fP      \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns newly created and encoded \fBASImage\fP on success, NULL of failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Source \fBASImage\fP will be tiled into newly created image of specified
 size\. offset_x and offset_y define origin on source image from which
 tiling will start\. If offset_x or offset_y is outside of the image
 boundaries, then it will be reduced by whole number of image sizes to
 fit inside the image\. At the time of tiling image will be tinted
 unless \fBtint\fP == 0\.

.fi
.SS\fB EXAMPLE\fP 
.nf
 \fBASTile\fP

.fi

.PP
.SH libAfterImage/asimage/merge_layers()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *merge_layers  ( struct \fBASVisual\fP *asv,
                          \fBASImageLayer\fP *layers, int count,
                          unsigned int dst_width,
                          unsigned int dst_height,
                          \fBASAltImFormats\fP out_format,
                          unsigned int \fBcompression\fP_out, int \fBquality\fP);

.fi
.SS\fB INPUTS\fP 
.nf
 asv          \- pointer to valid \fBASVisual\fP structure
 layers       \- array of \fBASImageLayer\fP structures that will be rendered
                one on top of another\. First element corresponds to
                the bottommost layer\.
 dst_width    \- desired width of the resulting image
 dst_height   \- desired height of the resulting image
 out_format     \- optionally describes alternative \fBASImage\fP format that
                should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBcompression\fP_out \- \fBcompression\fP level of resulting image in range 0\-100\.
 \fBquality\fP      \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns newly created and encoded \fBASImage\fP on success, NULL of failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBmerge_layers()\fP will create new \fBASImage\fP of requested size\. It will then
 go through all the layers, and fill image with composition\.
 Bottommost layer will be used unchanged and above layers will be
 superimposed on it, using algorithm specified in \fBASImageLayer\fP
 structure of the overlaying layer\. Layers may have smaller size
 then destination image, and maybe placed in arbitrary locations\. Each
 layer will be padded to fit width of the destination image with all 0
 effectively making it transparent\.

.fi

.PP
.SH libAfterImage/asimage/make_gradient()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *make_gradient ( struct \fBASVisual\fP *asv,
                          struct \fBASGradient\fP *grad,
                          unsigned int width,
                          unsigned int height,
                          ASFlagType filter,
                          \fBASAltImFormats\fP out_format,
                          unsigned int \fBcompression\fP_out, int \fBquality\fP);

.fi
.SS\fB INPUTS\fP 
.nf
 asv          \- pointer to valid \fBASVisual\fP structure
 grad         \- \fBASGradient\fP structure defining how gradient should be
                drawn
 width        \- desired width of the resulting image
 height       \- desired height of the resulting image
 filter       \- only channels corresponding to set bits will be
                rendered\.
 out_format     \- optionally describes alternative \fBASImage\fP format that
                should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBcompression\fP_out\- \fBcompression\fP level of resulting image in range 0\-100\.
 \fBquality\fP      \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns newly created and encoded \fBASImage\fP on success, NULL of failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBmake_gradient()\fP will create new image of requested size and it will
 fill it with gradient, described in structure pointed to by grad\.
 Different dithering techniques will be applied to produce nicer
 looking gradients\.

.fi

.PP
.SH libAfterImage/asimage/flip_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *\fBflip\fP_asimage ( struct \fBASVisual\fP *asv,
                         \fBASImage\fP *src,
                         int offset_x, int offset_y,
                         unsigned int to_width,
                         unsigned int to_height,
                         int \fBflip\fP, \fBASAltImFormats\fP out_format,
                         unsigned int \fBcompression\fP_out, int \fBquality\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv          \- pointer to valid \fBASVisual\fP structure
 src          \- source \fBASImage\fP
 offset_x     \- left clip margin
 offset_y     \- right clip margin
 to_width     \- desired width of the resulting image
 to_height    \- desired height of the resulting image
 \fBflip\fP         \- \fBflip\fP flags determining degree of rotation\.
 out_format     \- optionally describes alternative \fBASImage\fP format that
                should be produced as the result \- \fBXImage\fP, \fBARGB32\fP, etc\.
 \fBcompression\fP_out \- \fBcompression\fP level of resulting image in range 0\-100\.
 \fBquality\fP      \- output \fBquality\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns newly created and encoded \fBASImage\fP on success, NULL of failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBflip_asimage()\fP will create new image of requested size, it will then
 tile source image based on offset_x, offset_y, and destination size,
 and it will rotate it then based on \fBflip\fP value\. Three rotation angles
 supported 90, 180 and 270 degrees\.

.fi

.PP
