.\" Source: asfont.h 
.\" Generated with ROBODoc Version 3.2.3 (Jun 26 2001)
.\" ROBODoc (c) 1994-2001 by Frans Slothouber and Jacco van Weert.
.\" t
.\" @(#)asfont.h.3
.TH asfont.h 1 "Wed Jul 11 2001" asfont.h 3
.PM Generated from asfont.h with ROBODoc v3.2.3 on Wed Jul 11 01:34:44 2001

.SH libAfterImage/asfont.h
.SS\fB DESCRIPTION\fP 
.nf
 Text drawing functionality\.
 Text is drawn as an \fBASImage\fP with only \fBalpha\fP channel\. Since \fBalpha\fP
 channel is 8 bit widths that allows for 256 shades to be used in
 rendered glyphs\. That in turn allows for smoothing and antialiasing
 of the drawn text\. Such an approcah allows for easy manipulation of
 the drawn text, such as changing color, making it transparent,
 texturizing, rotation, etc\.

 \fBlibAfterImage\fP supports two types of fonts :
 Fonts that could be rendered using standard \fBXlib\fP functionality, and
 fonts rendered by \fBFreeType\fP 2 library\. That may include \fBTrueType\fP
 fonts\. When fonts are obtained via \fBXlib\fP special processing is
 performed in order to smooth its shape and leverage 256 shades
 palette available\.

 Any font being used is has to be opened first\. At that time its
 properties are analysed and glyphs are cached in clients memory\.
 Special RLE \fBcompression\fP method is used for font glyphs, significantly
 reducing memory utilization without any effect on performance\.

 Font management and drawing functionality has been designed with
 internatiolization in mind, althou support for locales is not
 complete yet\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 Structures :
          \fBASFontManager\fP
          \fBASFont\fP
          \fBASGlyph\fP
          \fBASGlyphRange\fP

 Functions :
          \fBcreate_font_manager()\fP, \fBdestroy_font_manager()\fP,
          \fBopen_freetype_font()\fP, \fBopen_X11_font()\fP, \fBget_asfont()\fP,
          \fBdestroy_font()\fP, \fBprint_asfont()\fP, \fBprint_asglyph()\fP,
          \fBdraw_text()\fP

 Other \fBlibAfterImage\fP modules :
     \fBasimage.h\fP, \fBasvisual.h\fP, \fBblender.h\fP, \fBimport.h\fP

.fi
.SS\fB AUTHOR\fP 
.nf
\fB  Sasha Vasko <sashav at sprintmail dot com>
\fP 
.fi

.PP
.SH libAfterImage/MAX_GLYPHS_PER_FONT
.SS\fB FUNCTION\fP 
.nf
 Max value of glyphs per font allowed\. We need that so we can detect
 and avoid broken fonts somehow\.

.fi
.SS\fB SOURCE\fP 
.nf
    #define \fBMAX_GLYPHS_PER_FONT\fP  2048
.fi

.PP
.SH libAfterImage/ASFontType
.SS\fB FUNCTION\fP 
.nf
 Supported types of fonts \- \fBXlib\fP or \fBFreeType\fP 2
 ASF_GuessWho will enable autodetection of the font type\.
 It is attempted to be opened as \fBFreeType\fP font first, and if that
 fails \- it will be opened as \fBXlib\fP font\.

.fi
.SS\fB SOURCE\fP 
.nf
    typedef enum
    {
        ASF_X11 = 0,
        ASF_Freetype,
        ASF_GuessWho
    }\fBASFontType\fP;
.fi

.PP
.SH libAfterImage/CHAR_SIZE
.SS\fB FUNCTION\fP 
.nf
 Convinient macro so we can transparently determine the number of
 bytes that character spans\. It assumes UTF\-8 encoding when I18N is
 enabled\.

.fi
.SS\fB SOURCE\fP 
.nf
    #ifdef I18N
    /* size of the UTF\-8 encoded character is based on value of the first byte : */
    #define \fBCHAR_SIZE\fP(c)    (((c)&0x80)?(((c)&0x40)?(((c)&0x20)?(((c)&0x10)?5:4):3):2):1)
    #else
    #define \fBCHAR_SIZE\fP(c)    1
    #endif
.fi

.PP
.SH libAfterImage/ASGlyph
.SS\fB NAME\fP 
.nf
\fR  \fBASGlyph\fP
\fP 
.fi
.SS\fB DESCRIPTION\fP 
.nf
 Stores glyph's image, as well as width, height and other
 characteristics of the glyph\.

.fi
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASGlyph\fP
    {
        CARD8          *\fBpixmap\fP ;        /* glyph's RLE encoded \fBpixmap\fP */
        unsigned short  width, height ; /* meaningfull width and height
                                         * of the glyphs \fBpixmap\fP */
        short  lead, step ;             /* distance pen position to glyph
                                         * beginning and to the next glyph */
        short  ascend, descend ;        /* distance of the top of the
                                         * glyph from the baseline */
    }\fBASGlyph\fP;
.fi

.PP
.SH libAfterImage/ASGlyphRange
.SS\fB NAME\fP 
.nf
\fR  \fBASGlyphRange\fP
\fP 
.fi
.SS\fB DESCRIPTION\fP 
.nf
 Organizes glyphs that belongs to the continuos range of char codes\.
 \fBASGlyphRange\fP structures could be tied together to cover entire
 codeset supported by the font\.

.fi
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASGlyphRange\fP
    {
        unsigned long   min_char, max_char; /* Code range\.
                                             * for some locales that would
                                             * be sufficient to simply set
                                             * range of characteres
                                             * supported by font */
        \fBASGlyph\fP *glyphs;                    /* array of glyphs belonging to
                                             * that code range */
        struct \fBASGlyphRange\fP *below, *above;
    }\fBASGlyphRange\fP;
.fi

.PP
.SH libAfterImage/ASFont
.SS\fB NAME\fP 
.nf
\fR  \fBASFont\fP
\fP 
.fi
.SS\fB DESCRIPTION\fP 
.nf
 Structure to contain all the font characteristics, as well as
 set of glyph images\. Such structure has to be created/opened prior to
 being able to draw characters with any font\.

.fi
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASFont\fP
    {
        unsigned long   magic ;
    
        struct \fBASFontManager\fP *fontman;  /* our owner */
        char                 *name;
    
        \fBASFontType\fP      type ;
        \fBASGlyphRange\fP   *codemap;        /* linked list of glyphsets, each
                                         * representing continuos range of
                                         * available codes */
        \fBASGlyph\fP         default_glyph;  /* valid glyph to be drawn when
                                         * code is not valid */
    
        unsigned int    max_height,     /* maximiu height of the character
                                         * glyph */
                        max_ascend,     /* maximum distance from the baseline
                                         * to the top of the character glyph */
                        space_size;     /* fixed width value to be used when
                                         * rendering spaces and tabs */
    #define LEFT_TO_RIGHT    1
    #define RIGHT_TO_LEFT   \-1
        int             pen_move_dir ;  /* direction of the text flow */
    #ifdef HAVE_FREETYPE
        \fBFT_Face\fP         ft_face;        /* free type font handle */
    #else
        CARD32         *pad;
    #endif
    
    }\fBASFont\fP;
.fi

.PP
.SH libAfterImage/ASFontManager
.SS\fB NAME\fP 
.nf
\fR  \fBASFontManager\fP
\fP 
.fi
.SS\fB DESCRIPTION\fP 
.nf
 Global data identifying connection to external libraries, as well as
 fonts location paths\.
 This structure has to be created/initialized prior to any font being
 loaded\.
 It also holds list of fonts that are currently open, allowing for
 easy access to fonts\.
 When ASFontManagaer object is destroyd it automagically closes all
 the open fonts\.

.fi
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASFontManager\fP
    {
        \fBDisplay\fP    *dpy;
        char       *font_path ;
    
        ASHashTable *fonts_hash ;
    
        size_t       unicode_used;
        CARD32      *local_unicode;                /* list of unicodes from current locale
                                                    * \- we use it to limit number of glyphs
                                                    * we load */
        Bool        ft_ok ;
    #ifdef HAVE_FREETYPE
        \fBFT_Library\fP  ft_library;                    /* free type library handle */
    #else
        void       *pad ;
    #endif
    }\fBASFontManager\fP;
.fi

.PP
.SH libAfterImage/ASText3DType
.SS\fB FUNCTION\fP 
.nf
 Available types of 3D text to be drawn\.

.fi
.SS\fB SOURCE\fP 
.nf
    typedef enum \fBASText3DType\fP{
        AST_Plain =0,                              /* regular 2D text */
        AST_Embossed,
        AST_Sunken,
        AST_ShadeAbove,
        AST_ShadeBelow,
        AST_EmbossedThick,
        AST_SunkenThick,
        AST_3DTypes
    }\fBASText3DType\fP;
.fi

.PP
.SH libAfterImage/asfont/create_font_manager()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASFontManager\fP *create_font_manager( \fBDisplay\fP *dpy,
                                     const char *font_path,
                                     \fBASFontManager\fP *reusable_memory );

.fi
.SS\fB INPUTS\fP 
.nf
 dpy             \- pointer to valid and opened \fBDisplay\fP\.
 font_path       \- string, representing colon separated list of
                   directories to search for \fBFreeType\fP fonts\.
 reusable_memory \- optional preallocated memory for the ASFontMagaer
                   object

.fi
.SS\fB RETURN VALUE\fP 
.nf
 Pointer to Initialized \fBASFontManager\fP object on success\.
 NULL otherwise\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBcreate_font_manager()\fP will create new \fBASFontManager\fP structure if
 needed\. It wioll then store copy of font_path and supplied pointer to
 \fBDisplay\fP in it\. At that time Hash table of loaded fonts is initialized,
 and if needed \fBFreeType\fP library is initialized as well\.
 \fBASFontManager\fP object returned by this functions has to be open at all
 times untill text drawing is no longer needed\.

.fi

.PP
.SH libAfterImage/asfont/destroy_font_manager()
.SS\fB SYNOPSIS\fP 
.nf
 void destroy_font_manager( \fBASFontManager\fP *fontman,
                            Bool reusable );

.fi
.SS\fB INPUTS\fP 
.nf
 fontman  \- pointer to valid \fBASFontManager\fP object to be deallocated\.
 reusable \- If True, then memory holding object itself will not be
            freed \- only resources will be deallocated\. That is
            usefull for structures created on stack\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBdestroy_font_manager()\fP closes all the fonts open with this
 \fBASFontManager\fP\. It will also close connection to \fBFreeType\fP library, and
 deallocate all cached data\. If reusable is False \- then memory used
 for object itself will not be freed\.

.fi

.PP
.SH libAfterImage/asfont/open_freetype_font()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASFont\fP *open_freetype_font( \fBASFontManager\fP *fontman,
                             const char *font_string,
                             int face_no,
                             int size, Bool verbose);

.fi
.SS\fB INPUTS\fP 
.nf
 fontman     \- pointer to previously created \fBASFontManager\fP\. Needed for
               connection to \fBFreeType\fP library, as well as path to
               search fonts in\.
 font_string \- filename of the file containing font's data\.
 face_no     \- number of face within the font file
 size        \- font size in points\. Applicable only to scalable fonts,
               such as \fBTrueType\fP\.
 verbose     \- if True, extensive error messages will be printed if
               problems encountered\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 pointer to Opened \fBASFont\fP structure, containing all the glyphs of the
 font, as well as other relevant info\. On failure returns NULL\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBopen_freetype_font()\fP will attempt to find font file in any of the
 directories specified in \fBASFontManager\fP's font_path\. If it fails to do
 so \- then it will check if filename has alldigit extentions\. It will
 then try to interpret that extention as a face number, and try and
 find the file with extention stripped off\.
 If file was found function will atempt to read it using \fBFreeType\fP
 library\. If requested face is not available in the font \- face 0 will
 be used\.
 On success all the font's glyphs will be rendered and cached, and
 needed font geometry info collected\.
 When \fBFreeType\fP Library is not available that function does nothing\.

.fi

.PP
.SH libAfterImage/asfont/open_X11_font()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASFont\fP *open_X11_font( \fBASFontManager\fP *fontman,
                        const char *font_string);

.fi
.SS\fB INPUTS\fP 
.nf
 fontman     \- pointer to previously created \fBASFontManager\fP\. Needed for
               connection X Server\.
 font_string \- name of the font as recognized by \fBXlib\fP\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 pointer to Opened \fBASFont\fP structure, containing all the glyphs of the
 font, as well as other relevant info\. On failure returns NULL\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBopen_X11_font()\fP attempts to load and query font using \fBXlib\fP calls\.
 On success it goes thgroughthe codemap of the font and renders all
 the glyphs available\. Glyphs then gets transfered to the client's
 memory and encoded using RLE \fBcompression\fP\. At this time smoothing
 filters are applied on glyph pixmaps, if its size exceeds threshold\.

.fi
.SS\fB TODO\fP 
.nf
 implement proper XFontSet support, when used with I18N enabled\.

.fi

.PP
.SH libAfterImage/asfont/get_asfont()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASFont\fP *get_asfont( \fBASFontManager\fP *fontman,
                     const char *font_string,
                     int face_no, int size,
                     \fBASFontType\fP type );

.fi
.SS\fB INPUTS\fP 
.nf
 fontman     \- pointer to previously created \fBASFontManager\fP\. Needed for
               connection to \fBFreeType\fP library, path to search fonts
               in, and X Server connection\.
 font_string \- font name or filename of the file containing font's data\.
 face_no     \- number of face within the font file
 size        \- font size in points\. Applicable only to scalable fonts,
               such as \fBTrueType\fP\.
 type        \- specifies the type of the font, or GuessWho for
               autodetection\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 pointer to Opened \fBASFont\fP structure, containing all the glyphs of the
 font, as well as other relevant info\. On failure returns NULL\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This function provides unified interface to font loading\. It performs
 search in \fBASFontManager\fP's list to see if this specific font has been
 loaded already, and if so \- returns pointer to relevant structure\.
 Otherwise it tryes to load font as \fBFreeType\fP font first, and then
 \fBXlib\fP font, unless exact font type is specifyed\.

.fi

.PP
.SH libAfterImage/asfont/destroy_font()
.SS\fB SYNOPSIS\fP 
.nf
 void destroy_font( \fBASFont\fP *font );

.fi
.SS\fB INPUTS\fP 
.nf
 font \- pointer to the valid \fBASFont\fP structure containing loaded font\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This function will close the font, remove it from \fBASFontManager\fP's
 list, destroy all the glyphs and generally free everything else used
 by \fBASFont\fP\.

.fi

.PP
.SH libAfterImage/asfont/print_asfont()
.SS\fB SYNOPSIS\fP 
.nf
 void    print_asfont( FILE* stream,
                       \fBASFont\fP* font);

.fi
.SS\fB INPUTS\fP 
.nf
 stream \- output file pointer
 font   \- pointer to \fBASFont\fP structure to print\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 prints all the geometry information about font\.

.fi

.PP
.SH libAfterImage/asfont/print_asglyph()
.SS\fB SYNOPSIS\fP 
.nf
 void   print_asglyph( FILE* stream,
                         \fBASFont\fP* font, unsigned long c);

.fi
.SS\fB INPUTS\fP 
.nf
 stream \- output file pointer
 font   \- pointer to \fBASFont\fP structure to print\.
 c      \- character code to print glyph for

.fi
.SS\fB DESCRIPTION\fP 
.nf
 prints out contents of the cached glyph for specifyed character code\.

.fi

.PP
.SH libAfterImage/asfont/draw_text()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *draw_text( const char *text,
                     \fBASFont\fP *font, \fBASText3DType\fP type,
                     int \fBcompression\fP );
 Bool get_text_size( const char *text,
                     \fBASFont\fP *font, \fBASText3DType\fP type,
                     unsigned int *width, unsigned int *height );

.fi
.SS\fB INPUTS\fP 
.nf
 text       \- actuall text to render
 font       \- pointer to \fBASFont\fP to render text with
 type         \- one of the few available types of 3D text\.
 \fBcompression\fP  \- \fBcompression\fP level to attempt on resulting \fBASImage\fP\.
 width        \- pointer to value to be set to text width\.
 height       \- pointer to value to be set to text height\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 Pointer to new \fBASImage\fP containing rendered text on success\.
 NULL on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBdraw_text()\fP creates new \fBASImage\fP of the size big enough to contain
 entire text\. It then renders the text using supplied font as an \fBalpha\fP
 channel of \fBASImage\fP\.
 get_text_size() can be used to determine the size of the text about
 to be drawn, so that appropriate drawable can be prepared\.

.fi

.PP
