.\" Source: afterimage.h 
.\" Generated with ROBODoc Version 3.2.3 (Jun 26 2001)
.\" ROBODoc (c) 1994-2001 by Frans Slothouber and Jacco van Weert.
.\" t
.\" @(#)afterimage.h.3
.TH afterimage.h 1 "Wed Jul 11 2001" afterimage.h 3
.PM Generated from afterimage.h with ROBODoc v3.2.3 on Wed Jul 11 01:34:44 2001

.SH libAfterImage/libAfterImage
.SS\fB NAME\fP 
.nf
\fR  \fBlibAfterImage\fP

\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 Generic imaging library originally designed for AfterStep X \fBWindow\fP
 Manager\.


.fi
.SS\fB PURPOSE\fP 
.nf
 \fBlibAfterImage\fP is the imaging library implemented for AfterStep
 X \fBWindow\fP Manager\. It has been generalized to be suitable for any
 application in need of robust graphics engine\.

 It provides facilities for loading images from files of different
 formats, compressed in memory storage of images, scaling,
 tinting/shading, flipping and superimposition of arbitrary number of
 images over each other\. In addition it allows for linear gradients
 drawing, and antialiased/smoothed text drawing using both  \fBFreeType\fP
 library and X \fBWindow\fP fonts\.

 Primary goals of this library are to achieve exceptional \fBquality\fP of
 images and text, making code fast and small at the same time\.
 Additional steps are taken to compensate for screen colordepth
 limitation, and different error diffusion algorithms are used to
 provide for smooth images even in low colordepth modes\.


.fi
.SS\fB HISTORY\fP 
.nf
 \fBlibAfterImage\fP has been implemented as an attempt to address several
 issues\. First one, and most important is that X \fBWindow\fP System
 completely lacks any tools for image manipulation, except for very
 rudimentary operations\. With Introduction of Render extentions in
 XFree86 4\.0 that situation is changing, but still is far from
 perfect\. There need is therefore to implement client side image
 manipulation\. That inturn creates a problem of image data transfer
 between Server and client\.

 To avoid that full\-time image storage on the client side is needed\.
 Which is memory extensive\. So there appears to be a need for some
 in\-memory \fBcompression\fP\.

 On the other side there is an image \fBquality\fP issue\. Its easy to write
 a scaling function by simply dropping out or duplicating pixels,
 but \fBquality\fP is awfull\. What is needed is very fast
 averaging/interpolation code\. That brings us to the issue of 8 bits
 per channel\. Add two pixels together and you get overflow\. So all the
 math has to be performed in different \fBcolorspace\fP and then converted
 back\. On the other side, such a conversion may discard valuable bits,
 so some compensation method has to be implemented\.

 On the text drawing side of things, there are numerous problems just
 as well\. Native X fonts look ugly as soon as you try to show any
 decently sized text\. That is supposed to be solved with said Render
 extensions to XFree86, but as experiense has shown, things aren't as
 easy as it looks, besides one wants his app to run well under any X
 Server\. \fBFreeType\fP library provides a solution, but not always
 available\. Another problem is that if you keep all your images on the
 client side, you want to draw text on client side as well\.

 The solution is to provide transparent interface that could use both
 X fonts and \fBFreeType\fP, cache glyphs on the client side and possibly
 perform smoothing of ugly X fonts\.

 There is no library solving all this problems in one fell swoop,
 except for monstrous ones, like ImLib\.

 Hence \fBlibAfterImage\fP has come to life\.


.fi
.SS\fB DESCRIPTION\fP 
.nf
 libAfterStep provides sevarl facilities\.

 1\. X \fBVisual\fP abstruction layer via \fBASVisual\fP\. This layer handles color
 management, transfer of data to and from X Server, and other screen
 related stuff\.

 2\. Scanline handling facility via \fBASScanline\fP\. \fBASScanline\fP is the most
 widely used structure since image handling is implemented on
 per\-scanline basis\.

 3\. Image storage, trasformation and rendering via \fBASImage\fP\. \fBASImage\fP
 provides for generic container used for any image or text
 manipulation\. It incorporates such a robust facilities as in\-memory
 RLE \fBcompression\fP, separate channel storage of 4 channels ( Alpha, Red,
 Green, and Blue ) with 8 bit per channel\.

 4\. Simplified font handling facility via \fBASFont\fP and ASFointManager\.
 All the font handling is done using \fBASFont\fP structure, no matter what
 type of font is used\. Any font supported by \fBX11\fP and \fBFreeType\fP can be
 used\.

 5\. Transparent image file reading for many different formats\. Included
 built\-in XPM reading code and XCF ( GIMP's native format )\.
 Overall supported:
 via external libraries :
 XPM, JPEG, PNG, TIFF, GIF
 via built in code :
 XPM, XCF, PNM, PPM, BMP, ICO, CUR
 Note that XPM can be supported both via built\-in code or via libXpm,
 depending on compilation configuration\.
 Actuall image file format is autodetected from the file contents \-
 file name extention is not used and can be anything at all\.


.fi
.SS\fB USES\fP 
.nf
 libAfterBase \- AfterStep basic functionality library\. That Includes
 Hash tables, file search methods, message output, generic types\.
 However effort has been made to allow for standalone configuration as
 well\. If libAfterBase is not found at compilation time \- \fBlibAfterImage\fP
 will use extract from libAfterBase included with \fBlibAfterImage\fP\.


.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBExamples\fP
 \fBAPI\fP Reference


.fi
.SS\fB TODO\fP 
.nf
 Implement support for Targa and PCX image format and maybe some other
 formats as well\.

 Implement complete support for I18N internationalization\.

 Implement color<\->\fBpixel\fP conversion for all colordepths\.


.fi
.SS\fB AUTHOR\fP 
.nf
\fB  Sasha Vasko <sashav at sprintmail dot com>
\fP 
.fi

.PP
.SH libAfterImage/Examples
.SS\fB EXAMPLE\fP 
.nf
 \fBASView\fP  \- image loading from the file and displaying in \fBwindow\fP\.
 \fBASScale\fP \- image loading from file and scaling to arbitrary size\.
 \fBASTile\fP  \- image loading from file, tiling and tinting to arbitrary
           size and color\.
 \fBASMerge\fP \- imgae loading and merging with another image\.
 \fBASGrad\fP  \- mutlipoint gradient drawing\.
 \fBASFlip\fP  \- image loading from file and rotation\.
 \fBASText\fP  \- trexturized semitransparent antialised text drawing\.


.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBAPI\fP Reference

.fi

.PP
.SH libAfterImage/API
.SS\fB CHILDREN\fP 
.nf
 Headers :
          \fBasvisual.h\fP, \fBblender.h\fP, \fBasimage.h\fP, \fBimport.h\fP, \fBasfont.h\fP
 Structures :
          \fBColorPair\fP
          \fBASScanline\fP
          \fBASVisual\fP
          \fBASImage\fP
          \fBASImageBevel\fP
          \fBASImageDecoder\fP
          \fBASImageOutput\fP
          \fBASImageLayer\fP
          \fBASGradient\fP
          \fBASFontManager\fP
          \fBASFont\fP
          \fBASGlyph\fP
          \fBASGlyphRange\fP
 Functions :
   \fBASScanline\fP handling:
        \fBprepare_scanline()\fP, \fBfree_scanline()\fP

   \fBASVisual\fP initialization :
        \fBquery_screen_visual()\fP, \fBsetup_truecolor_visual()\fP,
        \fBsetup_pseudo_visual()\fP, setup_as_colormap(),\fBcreate_asvisual()\fP,
        \fBdestroy_asvisual()\fP

   \fBASVisual\fP encoding/decoding :
        \fBvisual2visual_prop()\fP, \fBvisual_prop2visual()\fP

   \fBASVisual\fP convenience functions :
        \fBcreate_visual_window()\fP, \fBcreate_visual_pixmap()\fP,
        \fBcreate_visual_ximage()\fP

   Colorspace conversion :
          \fBrgb2value()\fP, rgb2saturation(), rgb2hue(), rgb2luminance(),
          \fBrgb2hsv()\fP, rgb2hls(), \fBhsv2rgb()\fP, hls2rgb()\.

   \fBmerge_scanline\fP methods :
          alphablend_scanlines(), allanon_scanlines(),
          \fBtint\fP_scanlines(), add_scanlines(), sub_scanlines(),
          diff_scanlines(), darken_scanlines(), lighten_scanlines(),
          screen_scanlines(), overlay_scanlines(), hue_scanlines(),
          saturate_scanlines(), value_scanlines(),
          colorize_scanlines(), dissipate_scanlines()\.

   \fBASImage\fP handling :
          \fBasimage_init()\fP, \fBasimage_start()\fP, \fBcreate_asimage()\fP,
          \fBdestroy_asimage()\fP

   \fBEncoding\fP :
          \fBasimage_add_line()\fP,   \fBasimage_add_line_mono()\fP,
          \fBasimage_print_line()\fP

   \fBDecoding\fP
          \fBstart_image_decoding()\fP, \fBstop_image_decoding()\fP

   \fBOutput\fP :
          \fBstart_image_output()\fP, \fBset_image_output_back_color()\fP,
          \fBtoggle_image_output_direction()\fP, \fBstop_image_output()\fP

   \fBX11\fP conversions :
          \fBximage2asimage()\fP, \fBpixmap2asimage()\fP, \fBasimage2ximage()\fP,
          \fBasimage2mask_ximage()\fP, \fBasimage2pixmap()\fP, \fBasimage2mask()\fP

   \fBTransformations\fP :
          \fBscale_asimage()\fP, \fBtile_asimage()\fP, \fBmerge_layers()\fP, \fBmake_gradient()\fP,
          \fBflip_asimage()\fP

   Import :
          \fBfile2ASImage()\fP, \fBfile2pixmap()\fP

   Text Drawing :
          \fBcreate_font_manager()\fP, \fBdestroy_font_manager()\fP,
          \fBopen_freetype_font()\fP, \fBopen_X11_font()\fP, \fBget_asfont()\fP,
          \fBdestroy_font()\fP, \fBprint_asfont()\fP, \fBprint_asglyph()\fP,
          \fBdraw_text()\fP

.fi

.PP
