.\" Source: asimage.h 
.\" Generated with ROBODoc Version 3.2.3 (Jul 29 2001)
.\" ROBODoc (c) 1994-2001 by Frans Slothouber and Jacco van Weert.
.\" t
.\" @(#)asimage.h.3
.TH asimage.h 1 "Tue Jan 15 2002" asimage.h 3
.PM Generated from asimage.h with ROBODoc v3.2.3 on Tue Jan 15 15:08:04 2002

.SH libAfterImage/asimage.h
.SS\fB SYNOPSIS\fP 
.nf
 Defines main structures and function for image manipulation\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBlibAfterImage\fP provides powerful functionality to load, store
 and transform images\. It allows for smaller memory utilization by
 utilizing run\-length encoding of the image data\. There could be
 different levels of \fBcompression\fP selected, allowing to choose best
 speed/memory ratio\.


.fi
.SS\fB SEE ALSO\fP 
.nf
 Structures :
          \fBASImage\fP
          \fBASImageManager\fP
          \fBASImageBevel\fP
          \fBASImageDecoder\fP
          \fBASImageOutput\fP
          \fBASImageLayer\fP
          \fBASGradient\fP

 Functions :
          \fBasimage_init()\fP, \fBasimage_start()\fP, \fBcreate_asimage()\fP,
          \fBclone_asimage()\fP, \fBdestroy_asimage()\fP

   \fBImageManager\fP Reference counting and managing :
          \fBcreate_image_manager()\fP, \fBdestroy_image_manager()\fP,
          \fBstore_asimage()\fP, \fBfetch_asimage()\fP, \fBdup_asimage()\fP,
          \fBrelease_asimage()\fP, \fBrelease_asimage_by_name()\fP

   \fBLayers\fP helper functions :
          \fBinit_image_layers()\fP, \fBcreate_image_layers()\fP,
          \fBdestroy_image_layers()\fP

   \fBEncoding\fP :
          \fBasimage_add_line()\fP,   \fBasimage_add_line_mono()\fP,
          \fBasimage_print_line()\fP, \fBget_asimage_chanmask()\fP,
          \fBmove_asimage_channel()\fP, \fBcopy_asimage_channel()\fP,
          \fBcopy_asimage_lines()\fP

   \fBDecoding\fP
          \fBstart_image_decoding()\fP, \fBstop_image_decoding()\fP,
          asimage_decode_line (), \fBset_decoder_shift()\fP,
          \fBset_decoder_back_color()\fP

   \fBOutput\fP :
          \fBstart_image_output()\fP, \fBset_image_output_back_color()\fP,
          \fBtoggle_image_output_direction()\fP, \fBstop_image_output()\fP

 Other \fBlibAfterImage\fP modules :
          \fBascmap.h\fP \fBasfont.h\fP \fBasimage.h\fP \fBasvisual.h\fP \fBblender.h\fP \fBexport.h\fP
          \fBimport.h\fP \fBtransform.h\fP \fBximage.h\fP

.fi
.SS\fB AUTHOR\fP 
.nf
\fB  Sasha Vasko <sasha at aftercode dot net>
\fP 
.fi

.PP
.SH libAfterImage/ASImage
.SS\fB NAME\fP 
.nf
\fR  \fBASImage\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP is main structure to hold image data\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Images are stored internally split into ARGB channels, each split
 into scanline\. Each scanline is stored the following format to allow
 for RLE \fBcompression\fP :
 component := <line><line>\.\.\.<line>
 line      := <block><block>\.\.\.<block><EOL>
 block     := <EOL>|<simple_block>|<long_block>|<direct_block>

 EOL       := 00000000 (all zero bits)

 simple_block  := <ctrl_byte1><value_byte>
 ctrl_byte1    := 00NNNNNN (first two bits are 0 remaining are length)

 long_block    := <ctrl_byte2><more_length_byte><value_byte>
 ctrl_byte2    := 01NNNNNN (NNNNNN are high 6 bits of length)
 more_length_byte := low 8 bits of length

 direct_block  := <ctrl_byte3><value_byte><value_byte>\.\.\.<value_byte>
 ctrl_byte3    := [1NNNNNNN|11111111] (first bit is 1, remaining are
                    length\. If it is all 1's \- then remaining part of
                    the line up until image width is monolithic
                    uncompressed direct block)

.fi
.SS\fB SEE ALSO\fP 
.nf
  \fBasimage_init()\fP
  \fBasimage_start()\fP
  \fBcreate_asimage()\fP
  \fBdestroy_asimage()\fP

.fi
.SS\fB SOURCE\fP 
.nf
    struct ASImageAlternative;
    struct \fBASImageManager\fP;
    
    /* magic number identifying \fBASFont\fP data structure */
    #define MAGIC_ASIMAGE            0xA3A314AE    

.fi

.PP
.SH libAfterImage/LIMITS
.SS\fB NAME\fP 
.nf
\fR  MAX_IMPORT_IMAGE_SIZE
 MAX_BEVEL_OUTLINE
\fP 
.fi
.SS\fB FUNCTION\fP 
.nf
    MAX_IMPORT_IMAGE_SIZE   effectively limits size of the allowed
                            images to be loaded from files\. That is
                            needed to be able to filter out corrupt files\.

    MAX_BEVEL_OUTLINE       Limit on bevel outline to be drawn around
                            the image\.

.fi
.SS\fB SOURCE\fP 
.nf
    #define MAX_IMPORT_IMAGE_SIZE   4000
    #define MAX_BEVEL_OUTLINE       100
    #define MAX_SEARCH_PATHS        8      /* prudently limiting ourselfs */
.fi

.PP
.SH libAfterImage/ASImageManager
.SS\fB NAME\fP 
.nf
\fR  \fBASImageManager\fP
\fP 
.fi
.SS\fB DESCRIPTION\fP 
.nf
 Global data identifying connection to external libraries, as well as
 images location paths\.
 This structure could be used to maintain repository of loaded images
 in order to avoid loading same image more then once\.
 It holds hash of loaded image names\.


.fi
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASImageManager\fP
    {
        ASHashTable  *image_hash ;
        /* misc stuff that may come handy : */
        char         *search_path[MAX_SEARCH_PATHS+1];
        double        \fBgamma\fP ;
    }\fBASImageManager\fP;
.fi

.PP
.SH libAfterImage/ASVectorPalette
.SS\fB NAME\fP 
.nf
\fR  ASScientificPalette
\fP 
.fi
.SS\fB DESCRIPTION\fP 
.nf
 Contains pallette allowing us to map double values in vector image
 data into actuall ARGB values\.

.fi
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASVectorPalette\fP
    {
        unsigned int npoints ;
        double *points ;
        CARD16 *channels[IC_NUM_CHANNELS] ;        /* ARGB data for key points\. */
        \fBARGB32\fP  default_color;
    }\fBASVectorPalette\fP;
.fi

.PP
.SH libAfterImage/ASImageBevel
.SS\fB NAME\fP 
.nf
\fR  \fBASImageBevel\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImageBevel\fP describes bevel to be drawn around the image\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Bevel is used to create 3D effect while drawing buttons, or any other
 image that needs to be framed\. Bevel is drawn using 2 primary colors:
 one for top and left sides \- hi color, and another for bottom and
 right sides \- low color\. There are additionally 3 auxiliary colors:
 hihi is used for the edge of top\-left corner, hilo is used for the
 edge of top\-right and bottom\-left corners, and lolo is used for the
 edge of bottom\-right corner\. Colors are specified as ARGB and contain
 \fBalpha\fP component, thus allowing for semitransparent bevels\.

 Bevel consists of outline and inline\. Outline is drawn outside of the
 image boundaries and its size adds to image size as the result\. Alpha
 component of the outline is constant\. Inline is drawn on top of the
 image and its \fBalpha\fP component is fading towards the center of the
 image, thus creating illusion of smooth disappearing edge\.

.fi
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASImageBevel\fP
    {
    #define BEVEL_SOLID_INLINE  (0x01<<0)
        ASFlagType type ;                          /* reserved for future use */
    
        /* primary bevel colors */
        \fBARGB32\fP      hi_color, lo_color ;
    
        /* these will be placed in the corners */
        \fBARGB32\fP      hihi_color, hilo_color, lolo_color ;
        unsigned short left_outline, top_outline, right_outline, bottom_outline;
        unsigned short left_inline, top_inline, right_inline, bottom_inline;
    }\fBASImageBevel\fP;
.fi

.PP
.SH libAfterImage/ASImageDecoder
.SS\fB NAME\fP 
.nf
\fR  \fBASImageDecoder\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImageDecoder\fP describes the status of reading any particular \fBASImage\fP,
 as well as providing detail on how it should be done\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBASImageDecoder\fP works as an abstraction layer and as the way to
 automate several operations\. Most of the transformations in
 \fBlibAfterImage\fP are performed as operations on \fBASScanline\fP data
 structure, that holds all or some of the channels of single image
 scanline\. In order to automate data extraction from \fBASImage\fP into
 \fBASScanline\fP \fBASImageDecoder\fP has been designed\.

 It has following features :
 1) All missing scanlines, or channels of scanlines will be filled with
 supplied back_color
 2) It is possible to leave out some channels of the image, extracting
 only subset of channels\. It is done by setting only needed flags in
 filter member\.
 3) It is possible to extract sub\-image of the image by setting offset_x
 and offset_y to top\-left corner of sub\-image, out_width \- to width of
 the sub\-image and calling decode_image_scanline method as many times
 as height of the sub\-image\.
 4) It is possible to apply bevel to extracted sub\-image, by setting
 bevel member to specific \fBASImageBevel\fP structure\.

 Extracted Scanlines will be stored in buffer and it will be updated
 after each call to decode_image_scanline()\.

.fi
.SS\fB SOURCE\fP 
.nf
    typedef void (*decode_image_scanline_func)(struct \fBASImageDecoder\fP *imdec);
    
    typedef struct \fBASImageDecoder\fP
    {
        \fBASVisual\fP       *asv;
        \fBASImage\fP        *im ;
        ASFlagType      filter;      /* flags that mask set of channels to
                                      * be extracted from the image */
    
        \fBARGB32\fP          back_color;  /* we fill missing scanlines with this
                                      * default \- black*/
        unsigned int    offset_x,    /* left margin on source image before
                                      * which we skip everything */
                        out_width;   /* actual length of the output scanline */
        unsigned int    offset_y,    /* top margin */
                        out_height;
        \fBASImageBevel\fP    *bevel;      /* bevel to wrap everything around with */
    
        /* offsets of the drawn bevel baseline on resulting image : */
        int            bevel_left, bevel_top, bevel_right, bevel_bottom ;
    
        /* scanline buffer containing current scanline */
        \fBASScanline\fP      buffer;
    
        /* internal data : */
        unsigned short   bevel_h_addon, bevel_v_addon ;
        int             next_line ;
        decode_image_scanline_func decode_image_scanline ;
    }\fBASImageDecoder\fP;
.fi

.PP
.SH libAfterImage/asimage/quality
.SS\fB FUNCTION\fP 
.nf
 Defines level of output \fBquality\fP/speed ratio

.fi
.SS\fB SOURCE\fP 
.nf
    #define ASIMAGE_QUALITY_DEFAULT \-1
    #define ASIMAGE_QUALITY_POOR    0
    #define ASIMAGE_QUALITY_FAST    1
    #define ASIMAGE_QUALITY_GOOD    2
    #define ASIMAGE_QUALITY_TOP     3
    
    #define MAX_GRADIENT_DITHER_LINES   ASIMAGE_QUALITY_TOP+1
.fi

.PP
.SH libAfterImage/asimage/ASImageOutput
.SS\fB NAME\fP 
.nf
\fR  \fBASImageOutput\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImageOutput\fP describes the output state of the transformation result\.
 It is used to transparently write results into \fBASImage\fP or \fBXImage\fP with
 different levels of \fBquality\fP\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBlibAfterImage\fP allows for transformation result to be stored in both
 \fBASImage\fP ( useful for long term storage and subsequent processing )
 and \fBXImage\fP ( useful for transfer of the result onto the X Server)\.
 At the same time there are 4 different \fBquality\fP levels of output
 implemented\. They differ in the way special technics, like error
 diffusion and interpolation are applyed, and allow for fine grained
 selection of \fBquality\fP/speed ratio\. ASIMAGE_QUALITY_GOOD should be good
 enough for most applications\.
 The following additional output features are implemented :
 1) Filling of the missing channels with supplied values\.
 2) Error diffusion to improve \fBquality\fP while converting from internal
      24\.8 format to 8 bit format\.
 3) Tiling of the output\. If tiling_step is greater then 0, then each
      scanlines will be copied into lines found tiling_step one from
      another, upto the edge of the image\.
 4) Reverse order of output\. \fBOutput\fP image will be mirrored along y
      axis if bottom_to_top is set to True\.

.fi
.SS\fB NOTES\fP 
.nf
\fR  The output_image_scanline method should be called for each scanline
 to be stored\. Convenience functions listed below should be used to
 safely alter state of the output instead of direct manipulation of
 the data members\. (makes you pity you don't write in C++ doesn't it ?)

 Also There is a trick in the way how output_image_scanline handles
 empty scanlines while writing \fBASImage\fP\. If back_color of empty scanline
 matches back_color of \fBASImageOutput\fP \- then particular line is erased!
 If back_colors are same \- then particular line of \fBASImage\fP gets filled
 with the back_color of \fBASScanline\fP\. First approach is usefull when
 resulting image will be used in subsequent call to merge_layers \- in
 such case knowing back_color of image is good enough and we don't need
 to store lines with the same color\. In case where \fBASImage\fP will be
 converted into \fBPixmap\fP/\fBXImage\fP \- second approach is preferable, since
 that conversion does not take into consideration image's back color \-
 we may want to change it in the future\.

\fP 
.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBstart_image_output()\fP
 \fBset_image_output_back_color()\fP
 \fBtoggle_image_output_direction()\fP
 \fBstop_image_output()\fP

.fi
.SS\fB SOURCE\fP 
.nf
    typedef void (*encode_image_scanline_func)( struct \fBASImageOutput\fP *imout,
                                                \fBASScanline\fP *to_store );
    typedef void (*output_image_scanline_func)( struct \fBASImageOutput\fP *,
                                                \fBASScanline\fP *, int );
    
    typedef struct \fBASImageOutput\fP
    {
        \fBASVisual\fP        *asv;
        \fBASImage\fP         *im ;
        ASAltImFormats   out_format ;
        CARD32           chan_fill[4];
        int              buffer_shift;  /* \-1 means \- buffer is empty,
                                         * 0 \- no shift,
                                         * 8 \- use 8 bit precision */
        int              next_line ;    /* next scanline to be written */
        unsigned int     tiling_step;   /* each line written will be repeated
                                         * with this step until we exceed
                                         * image size */
        unsigned int     tiling_range;  /* Limits region in which we need to
                                         * tile\. If set to 0 then image height
                                         * is used */
        int              bottom_to_top; /* \-1 if we should output in
                                         * bottom to top order, +1 otherwise*/
    
        int              \fBquality\fP ;      /* see above */
    
        output_image_scanline_func
            output_image_scanline ;  /* high level interface \- division,
                                      * error diffusion as well as encoding */
        encode_image_scanline_func
            encode_image_scanline ;  /* low level interface \- encoding only */
    
        /* internal data members : */
        \fBASScanline\fP       buffer[2], *used, *available;
    }\fBASImageOutput\fP;
.fi

.PP
.SH libAfterImage/asimage/ASImageLayer
.SS\fB NAME\fP 
.nf
\fR  \fBASImageLayer\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImageLayer\fP specifies parameters of the image superimposition\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBlibAfterImage\fP allows for simultaneous superimposition (overlaying) of
 arbitrary number of images\. To facilitate this \fBASImageLayer\fP structure
 has been created in order to specify parameters of each image
 participating in overlaying operation\. Images need not to be exact
 same size\. For each image its position on destination is specified
 via dst_x and dst_y data members\. Each image maybe tiled and clipped
 to fit into rectangle specified by clip_x, clip_y, clip_width,
 clip_height ( in image coordinates \- not destination )\. If image is
 missing, then area specified by dst_x, dst_y, clip_width, clip_height
 will be filled with solid_color\.
 Entire image will be tinted using \fBtint\fP parameter prior to overlaying\.
 Bevel specified by bevel member will be drawn over image prior to
 overlaying\. Specific overlay method has to be specified\.
 merge_scanlines method is pointer to a function,
 that accepts 2 ASScanlines as arguments and performs overlaying of
 first one with the second one\.
 There are 15 different \fBmerge_scanline\fP methods implemented in
 \fBlibAfterImage\fP, including \fBalpha\fP\-blending, tinting, averaging,
 HSV and HSL \fBcolorspace\fP operations, etc\.

.fi
.SS\fB NOTES\fP 
.nf
\fR  \fBASImageLayer\fP s could be organized into chains using next pointers\.
 Since there could be a need to rearrange layers and maybe bypass some
 layers \- we need to provide for flexibility, while at the same time
 allowing for simplicity of arrays\. As the result next pointers could
 be used to link together continuous arrays of layer, like so :
 array1: [layer1(next==NULL)][layer2(next!=NULL)]
          ____________________________|
          V
 array2: [layer3(next==NULL)][layer4(next==NULL)][layer5(next!=NULL)]
          ________________________________________________|
          V
 array3: [layer6(next==NULL)][layer7(next==layer7)]
                                ^______|

 While iterating throught such a list we check for two conditions \-
 exceeding count of layers and layer pointing to self\. When any of
 that is met \- we stopping iteration\.
\fP 
.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBmerge_layers()\fP
 \fBblender.h\fP

.fi
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASImageLayer\fP
    {
        \fBASImage\fP *im;
        \fBARGB32\fP   solid_color ;                  /* If im == NULL, then fill
                                                 * the area with this color\. */
    
        int dst_x, dst_y;                       /* placement in overall
                                                 * composition */
    
        /* clip area could be partially outside of the image \-
         * image gets tiled in it */
        int clip_x, clip_y;
        unsigned int clip_width, clip_height;
    
        \fBARGB32\fP \fBtint\fP ;                           /* if 0 \- no \fBtint\fP */
        \fBASImageBevel\fP *bevel ;                   /* border to wrap layer with
                                                 * (for buttons, etc\.)*/
    
        /* if image is clipped then we need to specify offsets of bevel as
         * related to clipped rectangle\. Normally it should be :
         * 0, 0, im\->width, im\->height\. And if width/height left 0 \- it will
         * default to this values\. Note that clipped image MUST be entirely
         * inside the bevel rectangle\. !!!*/
        int bevel_x, bevel_y;
        unsigned int bevel_width, bevel_height;
    
        int merge_mode ;                        /* reserved for future use */
        merge_scanlines_func merge_scanlines ;  /* overlay method */
        struct \fBASImageLayer\fP *next;              /* optional pointer to next
                                                 * layer\. If it points to
                                                 * itself \- then end of the
                                                 * chain\.*/
        void *data;                             /* hook to hung data on */
    }\fBASImageLayer\fP;
.fi

.PP
.SH libAfterImage/asimage/GRADIENT_TYPE_flags
.SS\fB FUNCTION\fP 
.nf
 Combination of this flags defines the way gradient is rendered\.

.fi
.SS\fB SOURCE\fP 
.nf
    #define GRADIENT_TYPE_MASK          0x0003
    #define GRADIENT_TYPE_ORIENTATION   0x0002
    #define GRADIENT_TYPE_DIAG          0x0001
.fi

.PP
.SH libAfterImage/asimage/GRADIENT_TYPE
.SS\fB FUNCTION\fP 
.nf
 This are named combinations of above flags to define type of gradient\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBGRADIENT_TYPE_flags\fP

.fi
.SS\fB SOURCE\fP 
.nf
    #define GRADIENT_Left2Right             0
    #define GRADIENT_TopLeft2BottomRight    GRADIENT_TYPE_DIAG
    #define GRADIENT_Top2Bottom             GRADIENT_TYPE_ORIENTATION
    #define GRADIENT_BottomLeft2TopRight    (GRADIENT_TYPE_DIAG| \\
                                             GRADIENT_TYPE_ORIENTATION)
.fi

.PP
.SH libAfterImage/ASGradient
.SS\fB NAME\fP 
.nf
\fR  \fBASGradient\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASGradient\fP describes how gradient is to be drawn\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBlibAfterImage\fP includes functionality to draw multipoint gradients in
 4 different directions left\->right, top\->bottom and diagonal
 lefttop\->rightbottom and bottomleft\->topright\. Each gradient described
 by type, number of colors (or anchor points), ARGB values for each
 color and offsets of each point from the beginning of gradient in
 fractions of entire length\. There should be at least 2 anchor points\.
 very first point should have offset of 0\. and last point should have
 offset of 1\. Gradients are drawn in ARGB \fBcolorspace\fP, so it is possible
 to have semitransparent gradients\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBmake_gradient()\fP

.fi
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASGradient\fP
    {
        int         type;       /* see \fBGRADIENT_TYPE\fP above */
    
        int         npoints;    /* number of anchor points */
        \fBARGB32\fP     *color;      /* ARGB color values for each anchor point  */
        double     *offset;     /* offset of each point from the beginning in
                                 * fractions of entire length */
    }\fBASGradient\fP;    

.fi

.PP
.SH libAfterImage/asimage/flip
.SS\fB FUNCTION\fP 
.nf
 This are flags that define rotation angle\.
 FLIP_VERTICAL defines rotation of 90 degrees counterclockwise\.
 FLIP_UPSIDEDOWN defines rotation of 180 degrees counterclockwise\.
 combined they define rotation of 270 degrees counterclockwise\.

.fi
.SS\fB SOURCE\fP 
.nf
    #define FLIP_VERTICAL       (0x01<<0)
    #define FLIP_UPSIDEDOWN     (0x01<<1)
    #define FLIP_MASK           (FLIP_UPSIDEDOWN|FLIP_VERTICAL)
.fi

.PP
.SH libAfterImage/asimage/tint
.SS\fB FUNCTION\fP 
.nf
 We use 32 bit ARGB values to define how tinting should be done\.
 The formula for tinting particular channel data goes like that:
 tinted_data = (image_data * \fBtint\fP)/128
 So if \fBtint\fP channel value is greater then 127 \- same channel will be
 brighter in destination image; if it is lower then 127 \- same channel
 will be darker in destination image\. Tint channel value of 127
 ( or 0x7F hex ) does not change anything\.
 Alpha channel is tinted as well, allowing for creation of
 semitransparent images\. Calculations are performed in 24\.8 format \-
 with 8 bit precision\. Result is saturated to avoid overflow, and
 precision is carried over to next \fBpixel\fP ( error diffusion ), when con
 verting 24\.8 to 8 bit format\.

.fi
.SS\fB SOURCE\fP 
.nf
    #define TINT_NONE           0
    #define TINT_LEAVE_SAME     (0x7F7F7F7F)
    #define TINT_HALF_DARKER    (0x3F3F3F3F)
    #define TINT_HALF_BRIGHTER  (0xCFCFCFCF)
    #define TINT_RED            (0x7F7F0000)
    #define TINT_GREEN          (0x7F007F00)
    #define TINT_BLUE           (0x7F00007F)
.fi

.PP
.SH libAfterImage/asimage/compression
.SS\fB FUNCTION\fP 
.nf
 Defines the level of \fBcompression\fP to attempt on \fBASImage\fP scanlines\.
 valid values are in range of 0 to 100, with 100 being the highest
 \fBcompression\fP\.

.fi
.SS\fB SOURCE\fP 
.nf
    #define ASIM_COMPRESSION_NONE       0
    #define ASIM_COMPRESSION_FULL      100
.fi

.PP
.SH libAfterImage/asimage/asimage_init()
.SS\fB SYNOPSIS\fP 
.nf
 void asimage_init (\fBASImage\fP * im, Bool free_resources);

.fi
.SS\fB INPUTS\fP 
.nf
 im             \- pointer to valid \fBASImage\fP structure
 free_resources \- if True will make function attempt to free
                  all non\-NULL pointers\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
    frees datamembers of the supplied \fBASImage\fP structure, and
    initializes it to all 0\.

.fi

.PP
.SH libAfterImage/asimage/asimage_start()
.SS\fB SYNOPSIS\fP 
.nf
 void asimage_start (\fBASImage\fP * im, unsigned int width,
                                   unsigned int height,
                                   unsigned int \fBcompression\fP);

.fi
.SS\fB INPUTS\fP 
.nf
 im          \- pointer to valid \fBASImage\fP structure
 width       \- width of the image
 height      \- height of the image
 \fBcompression\fP \- level of \fBcompression\fP to perform on image data\.
               \fBcompression\fP has to be in range of 0\-100 with 100
               signifying highest level of \fBcompression\fP\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Allocates memory needed to store scanline of the image of supplied
 size\. Assigns all the data members valid values\. Makes sure that
 \fBASImage\fP structure is ready to store image data\.

.fi
.SS\fB NOTES\fP 
.nf
\fR  In order to resize \fBASImage\fP structure after \fBasimage_start()\fP has been
 called, \fBasimage_init()\fP must be invoked to free all the memory, and
 then \fBasimage_start()\fP has to be called with new dimensions\.
\fP 
.fi

.PP
.SH libAfterImage/asimage/create_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *create_asimage( unsigned int width,
                          unsigned int height,
                          unsigned int \fBcompression\fP);

.fi
.SS\fB INPUTS\fP 
.nf
 width       \- desired image width
 height      \- desired image height
 \fBcompression\fP \- \fBcompression\fP level in new \fBASImage\fP( see \fBasimage_start()\fP
               for more )\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 Pointer to newly allocated and initialized \fBASImage\fP structure on
 Success\. NULL in case of any kind of error \- that should never happen\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Performs memory allocation for the new \fBASImage\fP structure, as well as
 initialization of allocated structure based on supplied parameters\.

.fi

.PP
.SH libAfterImage/asimage/clone_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *clone_asimage(\fBASImage\fP *src, ASFlagType filter );

.fi
.SS\fB INPUTS\fP 
.nf
 src      \- original \fBASImage\fP\.
 filter   \- bitmask of channels to be copied from one image to another\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 New \fBASImage\fP, as a copy of original image\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Creates exact clone of the original \fBASImage\fP, with same \fBcompression\fP,
 back_color and rest of the attributes\. Only \fBASImage\fP data will be
 carried over\. Any attached alternative forms of images (XImages, etc\.)
 will not be copied\. Any channel with unset bit in filter will not be
 copied\. Image name, \fBASImageManager\fP and ref_count will not be copied \-
 use \fBstore_asimage()\fP afterwards and make sure you use different name,
 to avoid clashes with original image\.

.fi

.PP
.SH libAfterImage/asimage/destroy_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 void destroy_asimage( \fBASImage\fP **im );

.fi
.SS\fB INPUTS\fP 
.nf
 im             \- pointer to valid \fBASImage\fP structure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 frees all the memory allocated for specified \fBASImage\fP\. If there was
 \fBXImage\fP attached to it \- it will be deallocated as well\.

.fi
.SS\fB EXAMPLE\fP 
.nf
 asview\.c: \fBASView.5\fP

.fi

.PP
.SH libAfterImage/asimage/destroy_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 set_asimage_vector( \fBASImage\fP *im, register double *vector );

.fi
.SS\fB INPUTS\fP 
.nf
 im             \- pointer to valid \fBASImage\fP structure\.
 vector           \- scientific data to attach to the image\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This function replaces contents of the vector member of \fBASImage\fP
 structure with new double precision data\. Data must have size
 of width*height ahere width and height are size of the \fBASImage\fP\.

.fi

.PP
.SH libAfterImage/asimage/ImageManager
.SS\fB DESCRIPTION\fP 
.nf
 \fBcreate_image_manager()\fP  \- create \fBASImage\fP management and reference
                           counting object\.
 \fBdestroy_image_manager()\fP \- destroy management obejct\.
 \fBstore_asimage()\fP         \- add \fBASImage\fP to the refererence\.
 \fBfetch_asimage()\fP         \- retrieve previously stored image, incrementing
                           reference count\.
 \fBdup_asimage()\fP           \- increment reference count of stored \fBASImage\fP\.
 \fBrelease_asimage()\fP       \- decrement reference count/destroy \fBASImage\fP\.
 \fBrelease_asimage_by_name()\fP

.fi

.PP
.SH libAfterImage/asimage/create_image_manager()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImageManager\fP *create_image_manager( \fBASImageManager\fP *reusable_memory,
                                       double \fBgamma\fP, \.\.\. );

.fi
.SS\fB INPUTS\fP 
.nf
 reusable_memory \- optional pointer to a block of memory to be used to
                   store \fBASImageManager\fP object\.
 double \fBgamma\fP    \- value of \fBgamma\fP correction to be used while loading
                   images from files\.
 \.\.\.             \- NULL terminated list of up to 8 PATH strings to list
                   locations at which images could be found\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Creates \fBASImageManager\fP object in memory and initializes it with
 requested \fBgamma\fP value and PATH list\. This Object will contain a hash
 table referencing all the loaded images\. When such object is used while
 loading images from the file \- \fBgamma\fP and PATH values will be used, so
 that all the loaded and referenced images will have same parameters\.
 File name will be used as the image name, and if same file is attempted
 to be loaded again \- instead reference will be incremented, and
 previously loaded image will be retyrned\. All the images stored in
 \fBASImageManager\fP's table will contain a back pointer to it, and they must
 be deallocated only by calling \fBrelease_asimage()\fP\. \fBdestroy_asimage()\fP will
 refuse to deallocate such an image\.

.fi

.PP
.SH libAfterImage/asimage/destroy_image_manager()
.SS\fB SYNOPSIS\fP 
.nf
 void destroy_image_manager( struct \fBASImageManager\fP *imman, Bool reusable );

.fi
.SS\fB INPUTS\fP 
.nf
 imman           \- pointer to \fBASImageManager\fP object to be deallocated
 reusable        \- if True, then memory that holds object itself will
                   not be deallocated\. Usefull when object is created
                   on stack\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Destroys all the referenced images, PATH values and if reusable is False,
 also deallocates object's memory\.

.fi

.PP
.SH libAfterImage/asimage/store_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 Bool store_asimage( \fBASImageManager\fP* imageman, \fBASImage\fP *im, const char *name );

.fi
.SS\fB INPUTS\fP 
.nf
 imageman        \- pointer to valid \fBASImageManager\fP object\.
 im              \- pointer to the image to be stored\.
 name            \- unique name of the image\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Adds specifyed image to the \fBASImageManager\fP's list of referenced images\.
 Stored \fBASImage\fP could be deallocated only by \fBrelease_asimage()\fP, or when
 \fBASImageManager\fP object itself is destroyed\.

.fi

.PP
.SH libAfterImage/asimage/fetch_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *fetch_asimage( \fBASImageManager\fP* imageman, const char *name );

.fi
.SS\fB INPUTS\fP 
.nf
 imageman        \- pointer to valid \fBASImageManager\fP object\.
 name            \- unique name of the image\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Looks for image with the name in \fBASImageManager\fP's list and if found,
 it will increment reference count and return pointer to it\.

.fi

.PP
.SH libAfterImage/asimage/dup_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *dup_asimage( \fBASImage\fP* im );

.fi
.SS\fB INPUTS\fP 
.nf
 im              \- pointer to already referenced image\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Increments reference count on the specifyed \fBASImage\fP\.

.fi

.PP
.SH libAfterImage/asimage/release_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 int    release_asimage( \fBASImage\fP *im );

.fi
.SS\fB INPUTS\fP 
.nf
 im              \- pointer to already referenced image\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Decrements reference count on the \fBASImage\fP object and destroys it if
 reference count is below zero\.

.fi

.PP
.SH libAfterImage/asimage/release_asimage_by_name()
.SS\fB SYNOPSIS\fP 
.nf
 int release_asimage_by_name( \fBASImageManager\fP *imman, char *name );

.fi
.SS\fB INPUTS\fP 
.nf
 imageman        \- pointer to valid \fBASImageManager\fP object\.
 name            \- unique name of the image\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Finds \fBASImage\fP known by specified name in \fBASImageManager\fP's list and
 then calls \fBrelease_asimage()\fP on that image\.

.fi

.PP
.SH libAfterImage/asimage/Layers
.SS\fB DESCRIPTION\fP 
.nf
 \fBinit_image_layers()\fP    \- initialize set of \fBASImageLayer\fP structures\.
 \fBcreate_image_layers()\fP  \- allocate and initialize set of \fBASImageLayer\fP's\.
 \fBdestroy_image_layers()\fP \- destroy set of \fBASImageLayer\fP structures\.

.fi

.PP
.SH libAfterImage/asimage/init_image_layers()
.SS\fB SYNOPSIS\fP 
.nf
 inline void init_image_layers( register \fBASImageLayer\fP *l, int count );

.fi
.SS\fB INPUTS\fP 
.nf
 l              \- pointer to valid \fBASImage\fP structure\.
 count          \- number of elements to initialize\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Initializes array on \fBASImageLayer\fP structures to sensible defaults\.
 Basically \- all zeros and merge_scanlines == alphablend_scanlines\.

.fi

.PP
.SH libAfterImage/asimage/create_image_layers()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImageLayer\fP *create_image_layers( int count );

.fi
.SS\fB INPUTS\fP 
.nf
 count       \- number of \fBASImageLayer\fP structures in allocated array\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 Pointer to newly allocated and initialized array of \fBASImageLayer\fP
 structures on Success\. NULL in case of any kind of error \- that
 should never happen\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Performs memory allocation for the new array of \fBASImageLayer\fP
 structures, as well as initialization of allocated structure to
 sensible defaults \- merge_func will be set to alphablend_scanlines\.

.fi

.PP
.SH libAfterImage/asimage/destroy_image_layers()
.SS\fB SYNOPSIS\fP 
.nf
 void destroy_image_layers( register \fBASImageLayer\fP *l,
                            int count,
                            Bool reusable );
 l              \- pointer to pointer to valid array of \fBASImageLayer\fP
                    structures\.
 count            \- number of structures in array\.
 reusable         \- if True \- then array itself will not be deallocates \-
                    which is usable when it was allocated on stack\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 frees all the memory allocated for specified array of \fBASImageLayer\fP s\.
 If there was \fBASImage\fP and/or \fBASImageBevel\fP attached to it \- it will be
 deallocated as well\.

.fi

.PP
.SH libAfterImage/asimage/Encoding
.SS\fB DESCRIPTION\fP 
.nf
 \fBasimage_add_line()\fP       \- encode raw scanline data
 \fBasimage_add_line_mono()\fP  \- encode scanline to have all the same pixels
 \fBget_asimage_chanmask()\fP   \- determine what channels contain data\.
 \fBasimage_print_line()\fP     \- print stored scanline to stderr\.
 asimage_decode_line()    \- decode single scanline of the \fBASImage\fP
 \fBmove_asimage_channel()\fP   \- move channel's data from one image to another\.
 \fBcopy_asimage_channel()\fP   \- duplicate channel's data from one image to
                            another\.
 \fBcopy_asimage_lines()\fP     \- duplicate range of scanline from one image
                            to another\.

.fi

.PP
.SH libAfterImage/asimage/asimage_add_line()
.SS\fB SYNOPSIS\fP 
.nf
 size_t asimage_add_line ( \fBASImage\fP * im, \fBColorPart\fP color,
                           CARD32 * data, unsigned int y);

.fi
.SS\fB INPUTS\fP 
.nf
 im      \- pointer to valid \fBASImage\fP structure
 color   \- color channel's number
 data    \- raw channel data of 32 bits per \fBpixel\fP \- only lowest 8 bits
           gets encoded\.
 y       \- image row starting with 0

.fi
.SS\fB RETURN VALUE\fP 
.nf
 \fBasimage_add_line()\fP return size of the encoded channel scanline in
 bytes\. On failure it will return 0\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Encodes raw data of the single channel into \fBASImage\fP channel scanline\.
 based on \fBcompression\fP level selected for this \fBASImage\fP all or part of
 the scanline will be RLE encoded\.

.fi

.PP
.SH libAfterImage/asimage/asimage_add_line_mono()
.SS\fB SYNOPSIS\fP 
.nf
 size_t asimage_add_line_mono ( \fBASImage\fP * im, \fBColorPart\fP color,
                                CARD8 value, unsigned int y);

.fi
.SS\fB INPUTS\fP 
.nf
 im             \- pointer to valid \fBASImage\fP structure
 color          \- color channel's number
 value          \- value for the channel
 y              \- image row starting with 0

.fi
.SS\fB RETURN VALUE\fP 
.nf
 \fBasimage_add_line_mono()\fP return size of the encoded channel scanline
 in bytes\. On failure it will return 0\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 encodes \fBASImage\fP channel scanline to have same color components
 value in every \fBpixel\fP\. Useful for vertical gradients for example\.

.fi

.PP
.SH libAfterImage/asimage/get_asimage_chanmask()
.SS\fB SYNOPSIS\fP 
.nf
 ASFlagType get_asimage_chanmask( \fBASImage\fP *im);

.fi
.SS\fB INPUTS\fP 
.nf
 im         \- valid \fBASImage\fP object\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 goes throu all the scanlines of the \fBASImage\fP and toggles bits representing
 those components that have at least some data\.

.fi

.PP
.SH libAfterImage/asimage/move_asimage_channel()
.SS\fB SYNOPSIS\fP 
.nf
 void move_asimage_channel( \fBASImage\fP *dst, int channel_dst,
                            \fBASImage\fP *src, int channel_src );

.fi
.SS\fB INPUTS\fP 
.nf
 dst         \- \fBASImage\fP which will have its channel substituted;
 channel_dst \- what channel to move data to;
 src         \- \fBASImage\fP which will donate its channel to dst;
 channel_src \- what source image channel to move data from\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 MOves channel data from one \fBASImage\fP to another, while discarding
 what was already in destination's channel\.

.fi
.SS\fB NOTES\fP 
.nf
\fR  Source image (donor) will loose its channel data, as it will be
 moved to destination \fBASImage\fP\. Also there is a condition that both
 images must be of the same width \- otherwise function returns
 without doing anything\. If height is different \- the minimum of
 two will be used\.
\fP 
.fi

.PP
.SH libAfterImage/asimage/copy_asimage_channel()
.SS\fB SYNOPSIS\fP 
.nf
 void copy_asimage_channel( \fBASImage\fP *dst, int channel_dst,
                            \fBASImage\fP *src, int channel_src );

.fi
.SS\fB INPUTS\fP 
.nf
 dst         \- \fBASImage\fP which will have its channel substituted;
 channel_dst \- what channel to copy data to;
 src         \- \fBASImage\fP which will donate its channel to dst;
 channel_src \- what source image channel to copy data from\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Same as \fBmove_asimage_channel()\fP but makes copy of channel's data
 instead of simply moving it from one image to another\.

.fi

.PP
.SH libAfterImage/asimage/copy_asimage_lines()
.SS\fB SYNOPSIS\fP 
.nf
 void copy_asimage_lines( \fBASImage\fP *dst, unsigned int offset_dst,
                          \fBASImage\fP *src, unsigned int offset_src,
                          unsigned int nlines, ASFlagType filter );

.fi
.SS\fB INPUTS\fP 
.nf
 dst         \- \fBASImage\fP which will have its channel substituted;
 offset_dst  \- scanline in destination image to copy to;
 src         \- \fBASImage\fP which will donate its channel to dst;
 offset_src  \- scanline in source image to copy data from;
 nlines      \- number of scanlines to be copied;
 filter      \- specifies what channels should be copied\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Makes copy of scanline data for continuos set of scanlines, affecting
 only those channels marked in filter\.
 NOTE
 Images must be of the same width\.

.fi

.PP
.SH libAfterImage/asimage/verbosity
.SS\fB FUNCTION\fP 
.nf
 This are flags that define what should be printed by
 asimage_print_line():
    VRB_LINE_SUMMARY    \- print only summary for each scanline
    VRB_LINE_CONTENT    \- print summary and data for each scanline
    VRB_CTRL_EXPLAIN    \- print summary, data and control codes for each
                          scanline

.fi
.SS\fB SOURCE\fP 
.nf
    #define VRB_LINE_SUMMARY    (0x01<<0)
    #define VRB_LINE_CONTENT    (0x01<<1)
    #define VRB_CTRL_EXPLAIN    (0x01<<2)
    #define VRB_EVERYTHING      (VRB_LINE_SUMMARY|VRB_CTRL_EXPLAIN| \\
                                 VRB_LINE_CONTENT)
.fi

.PP
.SH libAfterImage/asimage/asimage_print_line()
.SS\fB SYNOPSIS\fP 
.nf
    unsigned int asimage_print_line ( \fBASImage\fP * im, \fBColorPart\fP color,
                                      unsigned int y,
                                      unsigned long \fBverbosity\fP);

.fi
.SS\fB INPUTS\fP 
.nf
 im             \- pointer to valid \fBASImage\fP structure
 color          \- color channel's number
 y              \- image row starting with 0
 \fBverbosity\fP      \- \fBverbosity\fP level \- any combination of flags is
                  allowed

.fi
.SS\fB RETURN VALUE\fP 
.nf
 amount of memory used by this particular channel of specified
 scanline\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBasimage_print_line()\fP prints data stored in specified image scanline
 channel\. That may include simple summary of how much memory is used,
 actual visible data, and/or RLE control codes\. That helps to see
 how effectively data is encoded\.

 Useful mostly for debugging purposes\.

.fi

.PP
.SH libAfterImage/asimage/Decoding
.SS\fB DESCRIPTION\fP 
.nf
 \fBstart_image_decoding()\fP   \- allocates and initializes decoder
                            structure\.
 \fBset_decoder_shift()\fP      \- changes the shift value of decoder \- 8 or 0\.
 \fBset_decoder_back_color()\fP \- changes the back color to be used while
                            decoding the image\.
 \fBstop_image_decoding()\fP    \- finishes decoding, frees all allocated
                            memory\.

.fi

.PP
.SH libAfterImage/asimage/start_image_decoding()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImageDecoder\fP *start_image_decoding( \fBASVisual\fP *asv,\fBASImage\fP *im,
                                       ASFlagType filter,
                                       int offset_x, int offset_y,
                                       unsigned int out_width,
                                       unsigned int out_height,
                                       \fBASImageBevel\fP *bevel );

.fi
.SS\fB INPUTS\fP 
.nf
 asv      \- pointer to valid \fBASVisual\fP structure ( needed mostly
            to see if we are in BGR mode or not );
 im       \- \fBASImage\fP we are going to decode;
 filter   \- bitmask where set bits mark channels that has to be
            decoded\.
 offset_x \- left margin inside im, from which we should start
            reading \fBpixel\fP data, effectively clipping source image\.
 offset_y \- top margin inside im, from which we should start
            reading scanlines, effectively clipping source image\.
            Note that when edge of the image is reached,
            subsequent requests for scanlines will wrap around to
            the top of the image, and not offset_y\.
 out_width\- width of the scanline needed\. If it is larger then
            source image \- then image data will be tiled in it\.
            If it is smaller \- then image data will be clipped\.
 out_height \- height of the output drawable\. \-1 means that same as
          image height\. if out_height is greater then image height,
          then image will be tiled\.
 bevel    \- NULL or pointer to valid \fBASImageBevel\fP structure if
            decoded data should be overlayed with bevel at the
            time of decoding\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 \fBstart_image_decoding()\fP returns pointer to newly allocated
 \fBASImageDecoder\fP structure on success, NULL on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Normal process of reading image data from \fBASImage\fP consists of
 3 steps :
 1) start decoding by calling start_image_decoding\.
 2) call decode_image_scanline() method of returned structure, for
 each scanline upto desired height of the target image\. Decoded data
 will be returned in buffer member of the \fBASImageDecoder\fP structure\.
 3) finish decoding and deallocated all the used memory by calling
 \fBstop_image_decoding()\fP

.fi

.PP
.SH libAfterImage/asimage/set_decoder_bevel_geom()
.SS\fB SYNOPSIS\fP 
.nf
 void set_decoder_bevel_geom( \fBASImageDecoder\fP *imdec, int x, int y,
                              unsigned int width, unsigned int height );

.fi
.SS\fB INPUTS\fP 
.nf
 imdec   \- pointer to pointer to structure, previously created
           by start_image_decoding\.
 x,y     \- left top position of the inner border of the Bevel outline
           as related to the origin of subimage being decoded\.
 width,
 height  \- widtha and height of the inner border of the bevel outline\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This function should be used to change default placement of the bevel
 on decoded image\. For example if you only need to render small part of
 the button, that is being rendered from transparency image\.
 NOTE
 This call modifies bevel_h_addon and bevel_v_addon of
 \fBASImageDecoder\fP structure\.

.fi

.PP
.SH libAfterImage/asimage/set_decoder_shift()
.SS\fB SYNOPSIS\fP 
.nf
 void set_decoder_shift( \fBASImageDecoder\fP *imdec, int shift );

.fi
.SS\fB INPUTS\fP 
.nf
 imdec   \- pointer to pointer to structure, previously created
            by start_image_decoding\.
 shift   \- new value to be used as the shift while decoding image\.
           valid values are 8 and 0\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This function should be used instead of directly modifyeing value of
 shift memebr of \fBASImageDecoder\fP structure\.

.fi

.PP
.SH libAfterImage/asimage/set_decoder_back_color()
.SS\fB SYNOPSIS\fP 
.nf
 void set_decoder_back_color( \fBASImageDecoder\fP *imdec, \fBARGB32\fP back_color );

.fi
.SS\fB INPUTS\fP 
.nf
 imdec      \- pointer to pointer to structure, previously created
              by start_image_decoding\.
 back_color \- \fBARGB32\fP color value to be used as the background color to
              fill empty spaces in decoded \fBASImage\fP\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This function should be used instead of directly modifyeing value of
 back_color memebr of \fBASImageDecoder\fP structure\.

.fi

.PP
.SH libAfterImage/asimage/stop_image_decoding()
.SS\fB SYNOPSIS\fP 
.nf
 void stop_image_decoding( \fBASImageDecoder\fP **pimdec );

.fi
.SS\fB INPUTS\fP 
.nf
 pimdec   \- pointer to pointer to structure, previously created
            by start_image_decoding\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 pimdec \- pointer to \fBASImageDecoder\fP will be reset to NULL\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBstart_image_decoding()\fP

.fi

.PP
.SH libAfterImage/asimage/Output
.SS\fB DESCRIPTION\fP 
.nf
 start_image_output               \- initializes output structure
 set_image_output_back_color      \- changes background color of output
 toggle_image_output_direction    \- reverses vertical direction of
                                    output
 stop_image_output                \- finishes output, frees all the
                                    allocated memory\.

.fi

.PP
.SH libAfterImage/asimage/start_image_output()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImageOutput\fP *start_image_output ( struct \fBASVisual\fP *asv,
                                     \fBASImage\fP *im,
                                     ASAltImFormats format,
                                     int shift, int \fBquality\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv      \- pointer to valid \fBASVisual\fP structure
 im       \- destination \fBASImage\fP
 format   \- indicates that output should be written into alternative
            format, such as supplied \fBXImage\fP, \fBARGB32\fP array etc\.
 shift    \- precision of scanline data\. Supported values are 0 \- no
            precision, and 8 \- 24\.8 precision\. Value of that argument
            defines by how much scanline data is shifted rightwards\.
 \fBquality\fP  \- what algorithms should be used while writing data out, i\.e\.
            full error diffusion, fast error diffusion, no error
            diffusion\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBstart_image_output()\fP creates and initializes new \fBASImageOutput\fP
 structure based on supplied parameters\. Created structure can be
 subsequently used to write scanlines into destination image\.
 It is effectively hiding differences of \fBXImage\fP and \fBASImage\fP and other
 available output formats\.
 outpt_image_scanline() method of the structure can be used to write
 out single scanline\. Each written scanlines moves internal pointer to
 the next image line, and possibly writes several scanlines at once if
 tiling_step member is not 0\.

.fi

.PP
.SH libAfterImage/asimage/set_image_output_back_color()
.SS\fB SYNOPSIS\fP 
.nf
 void set_image_output_back_color ( \fBASImageOutput\fP *imout,
                                    \fBARGB32\fP back_color );

.fi
.SS\fB INPUTS\fP 
.nf
 imout      \- \fBASImageOutput\fP structure, previously created with
              start_image_output();
 back_color \- new background color value in ARGB format\. This color
              will be used to fill empty parts of outgoing scanlines\.

.fi

.PP
.SH libAfterImage/asimage/toggle_image_output_direction()
.SS\fB SYNOPSIS\fP 
.nf
 void toggle_image_output_direction( \fBASImageOutput\fP *imout );

.fi
.SS\fB INPUTS\fP 
.nf
 imout      \- \fBASImageOutput\fP structure, previously created with
              start_image_output();

.fi
.SS\fB DESCRIPTION\fP 
.nf
 reverses vertical direction output\. If previously scanlines has
 been written from top to bottom, for example, after this function is
 called they will be written in opposite direction\. Current line does
 not change, unless it points to the very first or the very last
 image line\. In this last case it will be moved to the opposing end of
 the image\.

.fi

.PP
.SH libAfterImage/asimage/stop_image_output()
.SS\fB SYNOPSIS\fP 
.nf
 void stop_image_output( \fBASImageOutput\fP **pimout );

.fi
.SS\fB INPUTS\fP 
.nf
 pimout     \- pointer to pointer to \fBASImageOutput\fP structure,
              previously created with call to   \fBstart_image_output()\fP\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 pimout     \- pointer to \fBASImageOutput\fP will be reset to NULL\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Completes image output process\. Flushes all the internal buffers\.
 Deallocates all the allocated memory\. Resets pointer to NULL to
 avoid dereferencing invalid pointers\.

.fi

.PP
