.\" Source: ximage.h 
.\" Generated with ROBODoc Version 3.2.3 (Jul 29 2001)
.\" ROBODoc (c) 1994-2001 by Frans Slothouber and Jacco van Weert.
.\" t
.\" @(#)ximage.h.3
.TH ximage.h 1 "Tue Jan 15 2002" ximage.h 3
.PM Generated from ximage.h with ROBODoc v3.2.3 on Tue Jan 15 15:08:04 2002

.SH libAfterImage/ximage.h
.SS\fB SYNOPSIS\fP 
.nf
 Defines conversion to and from XImages and Pixmaps\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBximage2asimage()\fP   \- convert \fBXImage\fP structure into \fBASImage\fP
 \fBpixmap2asimage()\fP   \- convert X11 \fBpixmap\fP into \fBASImage\fP
 \fBasimage2ximage()\fP   \- convert \fBASImage\fP into \fBXImage\fP
 \fBasimage2mask_ximage()\fP \- convert \fBalpha\fP channel of \fBASImage\fP into \fBXImage\fP
 \fBasimage2pixmap()\fP   \- convert \fBASImage\fP into \fBPixmap\fP ( possibly using
                      precreated \fBXImage\fP )
 \fBasimage2mask()\fP     \- convert \fBalpha\fP channel of \fBASImage\fP into 1 bit
                      mask \fBPixmap\fP\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 Other \fBlibAfterImage\fP modules :
          \fBascmap.h\fP \fBasfont.h\fP \fBasimage.h\fP \fBasvisual.h\fP \fBblender.h\fP \fBexport.h\fP
          \fBimport.h\fP \fBtransform.h\fP \fBximage.h\fP

.fi
.SS\fB AUTHOR\fP 
.nf
\fB  Sasha Vasko <sasha at aftercode dot net>
\fP 
.fi

.PP
.SH libAfterImage/ximage/ximage2asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *ximage2asimage ( struct \fBASVisual\fP *asv, \fBXImage\fP * xim,
                           unsigned int \fBcompression\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv         \- pointer to valid \fBASVisual\fP structure
 xim         \- source \fBXImage\fP
 \fBcompression\fP \- degree of \fBcompression\fP of resulting \fBASImage\fP\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 pointer to newly allocated \fBASImage\fP, containing encoded data, on
 success\. NULL on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 ximage2asimage will attempt to create new \fBASImage\fP with the same
 dimensions as supplied \fBXImage\fP\. \fBXImage\fP will be decoded based on
 supplied \fBASVisual\fP, and resulting scanlines will be encoded into
 \fBASImage\fP\.

.fi

.PP
.SH libAfterImage/ximage/pixmap2asimage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASImage\fP *pixmap2asimage ( struct \fBASVisual\fP *asv, \fBPixmap\fP p,
                           int x, int y,
                           unsigned int width,
                           unsigned int height,
                           unsigned long \fBplane_mask\fP,
                           Bool keep_cache,
                           unsigned int \fBcompression\fP );

.fi
.SS\fB INPUTS\fP 
.nf
 asv          \- pointer to valid \fBASVisual\fP structure
 p            \- source \fBPixmap\fP
 x, y,
 width, height\- rectangle on \fBPixmap\fP to be encoded into \fBASImage\fP\.
 \fBplane_mask\fP   \- limits color planes to be copied from \fBPixmap\fP\.
 keep_cache   \- indicates if we should keep \fBXImage\fP, used to copy
                image data from the X server, and attached it to ximage
                member of resulting \fBASImage\fP\.
 \fBcompression\fP  \- degree of \fBcompression\fP of resulting \fBASImage\fP\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 pointer to newly allocated \fBASImage\fP, containing encoded data, on
 success\. NULL on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 pixmap2asimage will obtain \fBXImage\fP of the requested area of the
 X \fBPixmap\fP, and will encode it into \fBASImage\fP using \fBximage2asimage()\fP
 function\.

.fi

.PP
.SH libAfterImage/ximage/asimage2ximage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBXImage\fP  *asimage2ximage  (struct \fBASVisual\fP *asv, \fBASImage\fP *im);

.fi
.SS\fB INPUTS\fP 
.nf
 asv        \- pointer to valid \fBASVisual\fP structure
 im         \- source \fBASImage\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 On success returns newly created and encoded \fBXImage\fP of the same
 colordepth as the supplied \fBASVisual\fP\. NULL on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBasimage2ximage()\fP creates new \fBXImage\fP of the exact same size as
 supplied \fBASImage\fP, and depth of supplied \fBASVisual\fP\. REd, Green and
 Blue channels of \fBASImage\fP then gets decoded, and encoded into \fBXImage\fP\.
 Missing scanlines get filled with black color\.

.fi
.SS\fB NOTES\fP 
.nf
\fR  Returned pointer to \fBXImage\fP will also be stored in im\->alt\.ximage,
 and It will be destroyed when \fBXImage\fP is destroyed, or reused in any
 subsequent calls to \fBasimage2ximage()\fP\. If any other behaviour is
 desired \- make sure you set im\->alt\.ximage to NULL, to dissociate
 \fBXImage\fP object from \fBASImage\fP\.
\fP 
.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBcreate_visual_ximage()\fP

.fi

.PP
.SH libAfterImage/ximage/asimage2mask_ximage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBXImage\fP  *asimage2mask_ximage (struct \fBASVisual\fP *asv, \fBASImage\fP *im);

.fi
.SS\fB INPUTS\fP 
.nf
 asv        \- pointer to valid \fBASVisual\fP structure
 im         \- source \fBASImage\fP

.fi
.SS\fB RETURN VALUE\fP 
.nf
 On success returns newly created and encoded \fBXImage\fP of the depth 1\.
 NULL on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBasimage2mask_ximage()\fP creates new \fBXImage\fP of the exact same size as
 supplied \fBASImage\fP, and depth 1\. Alpha channels of \fBASImage\fP then gets
 decoded, and encoded into \fBXImage\fP\. If \fBalpha\fP channel is greater the
 127 it is encoded as 1, otherwise as 0\.
 Missing scanlines get filled with 1s as they signify absence of mask\.

.fi
.SS\fB NOTES\fP 
.nf
\fR  Returned pointer to \fBXImage\fP will also be stored in im\->alt\.mask_ximage,
 and It will be destroyed when \fBXImage\fP is destroyed, or reused in any
 subsequent calls to \fBasimage2mask_ximage()\fP\. If any other behaviour is
 desired \- make sure you set im\->alt\.mask_ximage to NULL, to dissociate
 \fBXImage\fP object from \fBASImage\fP\.
\fP 
.fi

.PP
.SH libAfterImage/ximage/asimage2pixmap()
.SS\fB SYNOPSIS\fP 
.nf
 Bool    asimage2drawable( struct \fBASVisual\fP *asv, Drawable d, \fBASImage\fP *im,
                         \fBGC\fP \fBgc\fP,
                           int src_x, int src_y, int dest_x, int dest_y,
                       unsigned int width, unsigned int height,
                           Bool use_cached);

.fi
.SS\fB INPUTS\fP 
.nf
 asv        \- pointer to valid \fBASVisual\fP structure
 d              \- destination drawable \- \fBPixmap\fP or \fBWindow\fP
 im         \- source \fBASImage\fP
 \fBgc\fP         \- precreated \fBGC\fP to use for \fBXImage\fP transfer\. If NULL,
              asimage2drawable() will use \fBDefaultGC\fP\.
 src_x        \- Specifies the offset in X from the left edge of the image
                defined by the \fBASImage\fP structure\.
 src_y        \- Specifies the offset in Y from the top edge of the image
                defined by the \fBASImage\fP structure\.
 dest_x,dest_y\- Specify the x and y coordinates, which are relative to
                the origin of the drawable and are the coordinates of
                the subimage\.
 width,height \- Specify the width and height of the subimage, which
                define the dimensions of the rectangle\.
 use_cached \- If True will make \fBasimage2pixmap()\fP to use \fBXImage\fP
              attached to \fBASImage\fP, instead of creating new one\. Only
              works if \fBASImage\fP\->ximage data member is not NULL\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 On success returns True\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 asimage2drawable() creates will copy portion of \fBASImage\fP onto the X
 Drawable\. It checks if it needs to encode \fBXImage\fP
 from \fBASImage\fP data, and calls \fBasimage2ximage()\fP if yes, it has to\.
 It then supplied \fBgc\fP or \fBDefaultGC\fP of the screen to transfer
 \fBXImage\fP to the server\.
 Missing scanlines get filled with black color\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBasimage2ximage()\fP
 \fBasimage2pixmap()\fP
 \fBcreate_visual_pixmap()\fP

.fi

.PP
.SH libAfterImage/ximage/asimage2pixmap()
.SS\fB SYNOPSIS\fP 
.nf
 \fBPixmap\fP   asimage2pixmap  ( struct \fBASVisual\fP *asv, \fBWindow\fP root,
                            \fBASImage\fP *im, \fBGC\fP \fBgc\fP, Bool use_cached);

.fi
.SS\fB INPUTS\fP 
.nf
 asv        \- pointer to valid \fBASVisual\fP structure
 root       \- root \fBwindow\fP of destination screen
 im         \- source \fBASImage\fP
 \fBgc\fP         \- precreated \fBGC\fP to use for \fBXImage\fP transfer\. If NULL,
              \fBasimage2pixmap()\fP will use \fBDefaultGC\fP\.
 use_cached \- If True will make \fBasimage2pixmap()\fP to use \fBXImage\fP
              attached to \fBASImage\fP, instead of creating new one\. Only
              works if \fBASImage\fP\->ximage data member is not NULL\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 On success returns newly \fBpixmap\fP of the same colordepth as \fBASVisual\fP\.
 None on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBasimage2pixmap()\fP creates new \fBpixmap\fP of exactly same size as
 supplied \fBASImage\fP\. It then calls asimage2drawable to copy entire content
 of the \fBASImage\fP onto that created \fBpixmap\fP\.

.fi
.SS\fB EXAMPLE\fP 
.nf
 asview\.c: \fBASView.5\fP

.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBasimage2ximage()\fP
 asimage2drawable()
 \fBcreate_visual_pixmap()\fP

.fi

.PP
.SH libAfterImage/ximage/asimage2mask()
.SS\fB SYNOPSIS\fP 
.nf
 \fBPixmap\fP   asimage2mask ( struct \fBASVisual\fP *asv, \fBWindow\fP root,
                         \fBASImage\fP *im, \fBGC\fP \fBgc\fP, Bool use_cached);
 asv        \- pointer to valid \fBASVisual\fP structure
 root       \- root \fBwindow\fP of destination screen
 im         \- source \fBASImage\fP
 \fBgc\fP         \- precreated \fBGC\fP for 1 bit deep drawables to use for
              \fBXImage\fP transfer\. If NULL, \fBasimage2mask()\fP will create one\.
 use_cached \- If True will make \fBasimage2mask()\fP to use mask \fBXImage\fP
            attached to \fBASImage\fP, instead of creating new one\. Only
            works if \fBASImage\fP\->alt\.mask_ximage data member is not NULL\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 On success returns newly created \fBpixmap\fP of the colordepth 1\.
 None on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBasimage2mask()\fP creates new \fBpixmap\fP of exactly same size as
 supplied \fBASImage\fP\. It then calls \fBasimage2mask_ximage()\fP\.
 It then uses supplied \fBgc\fP, or creates new \fBgc\fP, to transfer
 \fBXImage\fP to the server and put it on \fBPixmap\fP\.
 Missing scanlines get filled with 1s\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBasimage2mask_ximage()\fP

.fi

.PP
