.\" Source: asvisual.h 
.\" Generated with ROBODoc Version 3.2.3 (Jul 29 2001)
.\" ROBODoc (c) 1994-2001 by Frans Slothouber and Jacco van Weert.
.\" t
.\" @(#)asvisual.h.3
.TH asvisual.h 1 "Tue Jan 15 2002" asvisual.h 3
.PM Generated from asvisual.h with ROBODoc v3.2.3 on Tue Jan 15 15:08:04 2002

.SH libAfterImage/asvisual.h
.SS\fB DESCRIPTION\fP 
.nf
 Defines abstraction layer on top of X Visuals, as well as several
 fundamental color datatypes\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 Structures:
        \fBColorPair\fP
        \fBASScanline\fP
        \fBASVisual\fP

 Functions :
   \fBASScanline\fP handling:
        \fBprepare_scanline()\fP, \fBfree_scanline()\fP

   \fBASVisual\fP initialization :
        \fBquery_screen_visual()\fP, \fBsetup_truecolor_visual()\fP,
        \fBsetup_pseudo_visual()\fP, setup_as_colormap(),\fBcreate_asvisual()\fP,
        \fBdestroy_asvisual()\fP

   \fBASVisual\fP encoding/decoding :
        \fBvisual2visual_prop()\fP, \fBvisual_prop2visual()\fP

   \fBASVisual\fP convenience functions :
        \fBcreate_visual_window()\fP, \fBcreate_visual_pixmap()\fP,
        \fBcreate_visual_ximage()\fP

 Other \fBlibAfterImage\fP modules :
          \fBascmap.h\fP \fBasfont.h\fP \fBasimage.h\fP \fBasvisual.h\fP \fBblender.h\fP \fBexport.h\fP
          \fBimport.h\fP \fBtransform.h\fP \fBximage.h\fP

.fi
.SS\fB AUTHOR\fP 
.nf
\fB  Sasha Vasko <sasha at aftercode dot net>
\fP 
.fi

.PP
.SH libAfterImage/alpha
.SS\fB FUNCTION\fP 
.nf
 Alpha channel adds visibility parameter to color value\.
 Alpha channel's value of 0xFF signifies complete visibility, while 0
 makes \fBpixel\fP completely transparent\.

.fi
.SS\fB SOURCE\fP 
.nf
    #define ALPHA_TRANSPARENT       0x00
    #define ALPHA_SEMI_TRANSPARENT  0x7F
    #define ALPHA_SOLID             0xFF
.fi

.PP
.SH libAfterImage/ARGB32
.SS\fB FUNCTION\fP 
.nf
 \fBARGB32\fP is fundamental datatype that hold 32bit value corresponding to
 pixels color and transparency value (\fBalpha\fP channel) in ARGB
 \fBcolorspace\fP\. It is encoded as follows :
 Lowermost 8 bits \- Blue channel
 bits 8 to 15     \- Green channel
 bits 16 to 23    \- Red channel
 bits 24 to 31    \- Alpha channel

.fi
.SS\fB EXAMPLE\fP 
.nf
 \fBASTile.1\fP

.fi
.SS\fB SOURCE\fP 
.nf
    typedef CARD32 \fBARGB32\fP;
    #define \fBARGB32\fP_White            0xFFFFFFFF
    #define \fBARGB32\fP_Black            0xFF000000
    /* default background color is #FF000000 : */
    #define \fBARGB32\fP_DEFAULT_BACK_COLOR   \fBARGB32\fP_Black
    
    #define \fBARGB32\fP_ALPHA_CHAN       3
    #define \fBARGB32\fP_RED_CHAN         2
    #define \fBARGB32\fP_GREEN_CHAN       1
    #define \fBARGB32\fP_BLUE_CHAN        0
    #define \fBARGB32\fP_CHANNELS         4
    
    #if 1
    #define MAKE_ARGB32(a,r,g,b)    ((( (CARD32)a)        <<24)|((((CARD32)r)&0x00FF)<<16)| \\
                                     ((((CARD32)g)&0x00FF)<<8 )|(( (CARD32)b)&0x00FF))
    #else
    #define MAKE_ARGB32(a,r,g,b)    ((((a)&0x00FF)<<24)|(((r)&0x00FF)<<16)| \\
                                     (((g)&0x00FF)<<8)|((b)&0x00FF))
    #endif
    
    #define MAKE_ARGB32_GREY(a,l)   (((a)<<24)|(((l)&0x00FF)<<16)| \\
                                     (((l)&0x00FF)<<8)|((l)&0x00FF))
    #define \fBARGB32\fP_ALPHA8(c)        (((c)>>24)&0x00FF)
    #define \fBARGB32\fP_RED8(c)          (((c)>>16)&0x00FF)
    #define \fBARGB32\fP_GREEN8(c)        (((c)>>8 )&0x00FF)
    #define \fBARGB32\fP_BLUE8(c)         ( (c)     &0x00FF)
    #define \fBARGB32\fP_CHAN8(c,i)       (((c)>>((i)<<3))&0x00FF)
    #define MAKE_ARGB32_CHAN8(v,i)  (((v)&0x0000FF)<<((i)<<3))
    
    #define \fBARGB32\fP_ALPHA16(c)       ((((c)>>16)&0x00FF00)|0x00FF)
    #define \fBARGB32\fP_RED16(c)         ((((c)>>8)&0x00FF00)|0x00FF)
    #define \fBARGB32\fP_GREEN16(c)       (( (c)    &0x00FF00)|0x00FF)
    #define \fBARGB32\fP_BLUE16(c)        ((((c)<<8)&0x00FF00)|0x00FF)
    #define \fBARGB32\fP_CHAN16(c,i)      ((\fBARGB32\fP_CHAN8(c,i)<<8)|0x00FF)
    #define MAKE_ARGB32_CHAN16(v,i) ((((v)&0x00FF00)>>8)<<((i)<<3))
.fi

.PP
.SH libAfterImage/ColorPart
.SS\fB FUNCTION\fP 
.nf
 Ids of the channels\. These are basically synonyms to related \fBARGB32\fP
 channel numbers

.fi
.SS\fB SOURCE\fP 
.nf
    typedef enum
    {
      IC_BLUE   = \fBARGB32\fP_BLUE_CHAN ,
      IC_GREEN  = \fBARGB32\fP_GREEN_CHAN,
      IC_RED    = \fBARGB32\fP_RED_CHAN  ,
      IC_ALPHA  = \fBARGB32\fP_ALPHA_CHAN,
      IC_NUM_CHANNELS = \fBARGB32\fP_CHANNELS
    }
    \fBColorPart\fP;
.fi

.PP
.SH libAfterImage/ColorPair
.SS\fB NAME\fP 
.nf
\fR  \fBColorPair\fP
\fP 
.fi
.SS\fB DESCRIPTION\fP 
.nf
 Convenient structure to hold pair of colors\.

.fi
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBColorPair\fP
    {
      \fBARGB32\fP fore;
      \fBARGB32\fP back;
    }\fBColorPair\fP;
.fi

.PP
.SH libAfterImage/ASScanline
.SS\fB NAME\fP 
.nf
\fR  \fBASScanline\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASScanline\fP is a structure to hold contents of the single scanline\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBASScanline\fP holds data for the single scanline, split into channels
 with 32 bits per \fBpixel\fP per channel\. All the memory is allocated at
 once, and then split in between channels\. There are three ways to
 access channel data :
 1) using blue, green, red, \fBalpha\fP pointers\.
 2) using channels[] array of pointers \- convenient in loops
 4) using xc3, xc2, xc1 pointers\. These are different from red, green,
 blue in the way that xc3 will point to blue when BGR mode is specified
 at the time of creation, otherwise it will point to red channel\.
 Likewise xc1 will point to red in BGR mode and blue otherwise\.
 xc2 always points to green channel's data\. This is convenient while
 writing XImages and when channels in source and destination has to be
 reversed, while reading images from files\.
 Channel data is always aligned by 8 byte boundary allowing for
 utilization of MMX, floating point and other 64bit registers for
 transfer and processing\.

.fi
.SS\fB SEE ALSO\fP 
.nf
 \fBASImage\fP

.fi
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASScanline\fP
    {
    #define SCL_DO_BLUE         (0x01<<\fBARGB32\fP_BLUE_CHAN )
    #define SCL_DO_GREEN        (0x01<<\fBARGB32\fP_GREEN_CHAN)
    #define SCL_DO_RED          (0x01<<\fBARGB32\fP_RED_CHAN  )
    #define SCL_DO_ALPHA        (0x01<<\fBARGB32\fP_ALPHA_CHAN)
    #define SCL_DO_COLOR        (SCL_DO_RED|SCL_DO_GREEN|SCL_DO_BLUE)
    #define SCL_DO_ALL          (SCL_DO_RED|SCL_DO_GREEN|SCL_DO_BLUE| \\
                                 SCL_DO_ALPHA)
        CARD32         flags ;            /* combination of  the above values */
        CARD32        *buffer ;
        CARD32        *blue, *green, *red, *\fBalpha\fP ;
        CARD32        *channels[IC_NUM_CHANNELS];
        CARD32        *xc3, *xc2, *xc1;   /* since some servers require
                                           * BGR mode here we store what
                                           * goes into what color component
                                           * in \fBXImage\fP */
        \fBARGB32\fP         back_color;
        unsigned int   width, shift;
        unsigned int   offset_x ;
    }\fBASScanline\fP;
.fi

.PP
.SH libAfterImage/asvisual/prepare_scanline()
.SS\fB SYNOPSIS\fP 
.nf
 long \fBARGB32\fP_manhattan_distance (long a, long b);

.fi
.SS\fB INPUTS\fP 
.nf
 a, b \- \fBARGB32\fP color values to calculate Manhattan distance in between

.fi
.SS\fB RETURN VALUE\fP 
.nf
 returns calculated Manhattan distance\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This function can be used to evaluate closeness of two colors\.

.fi

.PP
.SH libAfterImage/asvisual/prepare_scanline()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASScanline\fP *prepare_scanline ( unsigned int width,
                                unsigned int shift,
                                \fBASScanline\fP *reusable_memory,
                                Bool BGR_mode);

.fi
.SS\fB INPUTS\fP 
.nf
 width           \- width of the scanline\.
 shift           \- format of contained data\. 0 means \- 32bit unshifted
                   8 means \- 24\.8bit ( 8 bit left shifted )\.
 reusable_memory \- preallocated object\.
 BGR_mode        \- if True will cause xc3 to point to Blue and xc1 to
                   point to red\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This function allocates memory ( if reusable_memory is NULL ) for
 the new \fBASScanline\fP structure\. Structures buffers gets allocated to
 hold scanline data of at least width \fBpixel\fP wide\. Buffers are adjusted
 to start on 8 byte boundary\.

.fi

.PP
.SH libAfterImage/asvisual/free_scanline()
.SS\fB SYNOPSIS\fP 
.nf
 void       free_scanline ( \fBASScanline\fP *sl, Bool reusable );

.fi
.SS\fB INPUTS\fP 
.nf
 sl       \- pointer to previously allocated \fBASScanline\fP structure to be
            deallocated\.
 reusable \- if true then \fBASScanline\fP object itself will not be
            deallocated\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBfree_scanline()\fP frees all the buffer memory allocated for \fBASScanline\fP\.
 If reusable is false then object itself in not freed\. That is usable
 for declaring \fBASScanline\fP on stack\.

.fi

.PP
.SH libAfterImage/ASVisual
.SS\fB NAME\fP 
.nf
\fR  \fBASVisual\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASVisual\fP is abstraction layer on top of X Server \fBVisual\fP\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This structure has been introduced in order to compensate for the
 fact that X may have so many different types of Visuals\. It provides
 shortcuts to most \fBVisual\fP data, compensated for differences in Visuals\.
 For \fBPseudoColor\fP visual it also contains preallocated set of colors\.
 This colormap allows us to write XImages very fast and without
 exhausting available X colors\. This colormap consist of 8, 64, or 4096
 colors and constitutes fraction of colors available in particular
 colordepth\. This colors are allocated to be evenly spread around RGB
 spectrum\. Thus when converting from internal presentation \- all we
 need to do is to discard unused bits, and use rest of them bits as
 an index in our colormap\. Opposite conversion is much trickier and we
 engage into nasty business of having hash table mapping \fBpixel\fP values
 into colors, or straight table doing same in lower colordepths\.
 Idea is that we do all internal processing in 32bit colordepth, and
 \fBASVisual\fP provides us with means to convert it to actual X display
 format\. Respectively \fBASVisual\fP has methods to write out \fBXImage\fP lines
 and read \fBXImage\fP lines\.
 \fBASVisual\fP creation is a tricky process\. Basically first we have to go
 through the list of available Visuals and choose the best suitable\.
 Then based on the type of this \fBVisual\fP we have to setup our data
 members and method hooks\. Several functions provided for that :
  \fBquery_screen_visual()\fP    \- will lookup best suitable visual
  \fBsetup_truecolor_visual()\fP \- will setup hooks if visual is \fBTrueColor\fP
  \fBsetup_pseudo_visual()\fP  \- will setup hooks and data if \fBVisual\fP is
                             \fBPseudoColor\fP\.
  \fBsetup_as_colormap()\fP      \- will preallocate colors for \fBPseudoColor\fP\.
 Alternative to the above is :
  \fBcreate_asvisual()\fP        \- it encapsulates all of the above
                             functionality, and returns completely set
                             up \fBASVisual\fP object\.
 Since \fBVisual\fP selected for \fBASVisual\fP may differ from default
 ( we choose the best suitable ), all the \fBwindow\fP creation function
 must provide colormap and some other parameters, like border color
 for example\. Thus we created some convenience functions\.
 These should be used instead of standard \fBXlib\fP calls :
  \fBcreate_visual_window()\fP \- to create \fBwindow\fP
  \fBcreate_visual_pixmap()\fP \- to create \fBpixmap\fP
  \fBcreate_visual_ximage()\fP \- to create \fBXImage\fP
 \fBASVisual\fP could be dealolocated and its resources freed with :
  \fBdestroy_asvisual()\fP

.fi
.SS\fB EXAMPLE\fP 
.nf
 asview\.c: \fBASView\fP

.fi
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASVisual\fP
    {
        \fBDisplay\fP      *dpy;
    
        /* This envvar will be used to determine what X \fBVisual\fP (in hex) to use\.
         * If unset then best possible will be selected automagically : */
    #define ASVISUAL_ID_ENVVAR "AFTERIMAGE_VISUAL_ID"
    
        \fBXVisualInfo\fP   visual_info;
        /* this things are calculated based on \fBVisual\fP : */
        unsigned long rshift, gshift, bshift;
        unsigned long rbits,  gbits,  bbits;
        unsigned long true_depth;   /* could be 15 when X reports 16 */
        Bool          BGR_mode;
        Bool          msb_first;
        /* we must have colormap so that we can safely create windows
         * with different visuals even if we are in \fBTrueColor\fP mode : */
        \fBColormap\fP      colormap;
        Bool          own_colormap; /* tells us to free colormap when we
                                     * done */
        unsigned long black_pixel, white_pixel;
        /* for \fBPseudoColor\fP mode we need some more stuff : */
        enum {
            ACM_None = 0,
            ACM_3BPP,
            ACM_6BPP,
            ACM_12BPP
        } as_colormap_type ;        /* there can only be 64 or 4096 entries
                                     * so far ( 6 or 12 bpp) */
        unsigned long *as_colormap; /* array of preallocated colors for
                                     * \fBPseudoColor\fP mode */
        union                       /* reverse color lookup tables : */
        {
            \fBARGB32\fP              *xref;
            struct ASHashTable  *hash;
        }as_colormap_reverse ;
    
        /* different useful callbacks : */
        CARD32 (*color2pixel_func)    ( struct \fBASVisual\fP *asv,
                                        CARD32 encoded_color,
                                        unsigned long *\fBpixel\fP);
        void   (*pixel2color_func)    ( struct \fBASVisual\fP *asv,
                                        unsigned long \fBpixel\fP,
                                        CARD32 *red, CARD32 *green,
                                        CARD32 *blue);
        void   (*ximage2scanline_func)( struct \fBASVisual\fP *asv, \fBXImage\fP *xim,
                                        \fBASScanline\fP *sl, int y,
                                        unsigned char *xim_data );
        void   (*scanline2ximage_func)( struct \fBASVisual\fP *asv, \fBXImage\fP *xim,
                                        \fBASScanline\fP *sl, int y,
                                        unsigned char *xim_data );
    #ifndef X_DISPLAY_MISSING
    #define ARGB2PIXEL(asv,argb,\fBpixel\fP)         \\
        (asv)\->color2pixel_func((asv),(argb),(\fBpixel\fP))
    #define GET_SCANLINE(asv,xim,sl,y,xim_data) \\
        (asv)\->ximage2scanline_func((asv),(xim),(sl),(y),(xim_data))
    #define PUT_SCANLINE(asv,xim,sl,y,xim_data) \\
        (asv)\->scanline2ximage_func((asv),(xim),(sl),(y),(xim_data))
    #else
    #define ARGB2PIXEL(asv,argb,\fBpixel\fP)         \\
        do{ break; }while(0)
    #define GET_SCANLINE(asv,xim,sl,y,xim_data) \\
        do{ break; }while(0)
    #define PUT_SCANLINE(asv,xim,sl,y,xim_data) \\
        do{ break; }while(0)
    #endif
    }\fBASVisual\fP;
.fi

.PP
.SH libAfterImage/asvisual/query_screen_visual()
.SS\fB SYNOPSIS\fP 
.nf
 Bool query_screen_visual( \fBASVisual\fP *asv, \fBDisplay\fP *dpy, int screen,
                           \fBWindow\fP root, int default_depth );

.fi
.SS\fB INPUTS\fP 
.nf
 asv        \- preallocated \fBASVisual\fP structure\.
 dpy        \- valid pointer to opened X display\.
 screen     \- screen number on which to query visuals\.
 root       \- root \fBwindow\fP on that screen\.
 default_depth\- default colordepth of the screen\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 True on success, False on failure
 \fBASVisual\fP structure pointed by asv will have the following data
 members set on success :
 dpy, visual_info, colormap, own_colormap, black_pixel, white_pixel\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBquery_screen_visual()\fP will go though prioritized list of possible
 Visuals and attempt to match those to what is available on the
 specified screen\. If all items from list fail, then it goes about
 querying default visual\.
 Once X \fBVisual\fP has been identified, we create X colormap and allocate
 white and black pixels from it\.

.fi

.PP
.SH libAfterImage/asvisual/setup_truecolor_visual()
.SS\fB SYNOPSIS\fP 
.nf
 Bool setup_truecolor_visual( \fBASVisual\fP *asv );

.fi
.SS\fB INPUTS\fP 
.nf
 asv        \- preallocated \fBASVisual\fP structure\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 True on success, False if visual is not \fBTrueColor\fP\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBsetup_truecolor_visual()\fP checks if \fBVisual\fP is indeed \fBTrueColor\fP and if
 so it goes about querying color masks, deducing real \fBXImage\fP
 colordepth, and whether we work in BGR mode\. It then goes about
 setting up correct hooks to X IO functions\.

.fi

.PP
.SH libAfterImage/asvisual/setup_pseudo_visual()
.SS\fB SYNOPSIS\fP 
.nf
 void setup_pseudo_visual( \fBASVisual\fP *asv  );

.fi
.SS\fB INPUTS\fP 
.nf
 asv        \- preallocated \fBASVisual\fP structure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBsetup_pseudo_visual()\fP assumes that \fBVisual\fP is \fBPseudoColor\fP\. It then
 tries to decide as to how many colors preallocate, and goes about
 setting up correct X IO hooks and possibly initialization of reverse
 colormap in case \fBASVisual\fP already has colormap preallocated\.

.fi

.PP
.SH libAfterImage/asvisual/setup_as_colormap()
.SS\fB SYNOPSIS\fP 
.nf
 void setup_as_colormap( \fBASVisual\fP *asv );

.fi
.SS\fB INPUTS\fP 
.nf
 asv        \- preallocated \fBASVisual\fP structure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 That has to be called in order to pre\-allocate sufficient number of
 colors\. It uses colormap size identification supplied in \fBASVisual\fP
 structure\. If colors where preallocated successfully \- it will also
 create reverse lookup colormap\.

.fi

.PP
.SH libAfterImage/asvisual/create_asvisual_for_id()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASVisual\fP *create_asvisual_for_id( \fBDisplay\fP *dpy, int screen,
                                   int default_depth,
                                   VisualID visual_id,
                                   \fBASVisual\fP *reusable_memory );

.fi
.SS\fB INPUTS\fP 
.nf
 dpy        \- valid pointer to opened X display\.
 screen     \- screen number on which to query visuals\.
 root       \- root \fBwindow\fP on that screen\.
 default_depth\- default colordepth of the screen\.
 visual_id    \- ID of X visual to use\.
 reusable_memory \- pointer to preallocated \fBASVisual\fP structure\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 Pointer to \fBASVisual\fP structure initialized with enough information
 to be able to deal with current X \fBVisual\fP\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This function calls all the needed functions in order to setup new
 \fBASVisual\fP structure for the specified screen and visual\. If
 reusable_memory is not null \- it will not allocate new \fBASVisual\fP
 structure, but instead will use supplied one\. Useful for allocating
 \fBASVisual\fP on stack\.
 This particular function will not do any autodetection and will use
 \fBVisual\fP ID supplied\. That is usefull when \fBlibAfterImage\fP is used with
 an app that has its own approach to \fBVisual\fP handling, and since Visuals
 on all Windows, Pixmaps and colormaps must match, there is a need to
 synchronise visuals used by an app and \fBlibAfterImage\fP\.

.fi

.PP
.SH libAfterImage/asvisual/create_asvisual()
.SS\fB SYNOPSIS\fP 
.nf
 \fBASVisual\fP *create_asvisual( \fBDisplay\fP *dpy, int screen,
                            int default_depth,
                            \fBASVisual\fP *reusable_memory );

.fi
.SS\fB INPUTS\fP 
.nf
 dpy        \- valid pointer to opened X display\.
 screen     \- screen number on which to query visuals\.
 root       \- root \fBwindow\fP on that screen\.
 default_depth\- default colordepth of the screen\.
 reusable_memory \- pointer to preallocated \fBASVisual\fP structure\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 Pointer to \fBASVisual\fP structure initialized with enough information
 to be able to deal with current X \fBVisual\fP\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This function calls all the needed functions in order to setup new
 \fBASVisual\fP structure for the specified screen\. If reusable_memory is
 not null \- it will not allocate new \fBASVisual\fP structure, but instead
 will use supplied one\. Useful for allocating \fBASVisual\fP on stack\.
 It is different from create_asvisualfor_id() in that it will attempt
 to autodetect best possible visual for the screen\. For example on some
 SUN Solaris X servers there will be both 8bpp pseudocolor and 24bpp
 truecolor, and default will be 8bpp\. In this scenario \fBlibAfterImage\fP
 will detect and use 24bpp true color visual, thus producing much better
 results\.

.fi

.PP
.SH libAfterImage/asvisual/destroy_asvisual()
.SS\fB SYNOPSIS\fP 
.nf
 void destroy_asvisual( \fBASVisual\fP *asv, Bool reusable );

.fi
.SS\fB INPUTS\fP 
.nf
 asv      \- valid \fBASVisual\fP structure\.
 reusable \- if True it will cause function to not free object
            itself\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Cleanup function\. Frees all the memory and deallocates all the
 resources\. If reusable is False it will also free the object, pointed
 to by asv\.

.fi
.SS\fB EXAMPLE\fP 
.nf
 asview\.c: \fBASView.2\fP

.fi

.PP
.SH libAfterImage/asvisual/visual2visual_prop()
.SS\fB SYNOPSIS\fP 
.nf
 Bool visual2visual_prop( \fBASVisual\fP *asv, size_t *size,
                          unsigned long *version, unsigned long **data );

.fi
.SS\fB INPUTS\fP 
.nf
 asv        \- valid \fBASVisual\fP structure\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 size         \- size of the encoded memory block\.
 version      \- version of the encoding
 data         \- actual encoded memory block
 True on success, False on failure

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This function will encode \fBASVisual\fP structure into memory block of
 32 bit values, suitable for storing in X property\.

.fi

.PP
.SH libAfterImage/asvisual/visual_prop2visual()
.SS\fB SYNOPSIS\fP 
.nf
 Bool visual_prop2visual( \fBASVisual\fP *asv, \fBDisplay\fP *dpy, int screen,
                          size_t size,
                          unsigned long version, unsigned long *data );

.fi
.SS\fB INPUTS\fP 
.nf
 asv       \- valid \fBASVisual\fP structure\.
 dpy       \- valid pointer to open X display\.
 screen    \- screen number\.
 size      \- encoded memory block's size\.
 version   \- version of encoding\.
 data      \- actual encoded memory block\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 True on success, False on failure

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBvisual_prop2visual()\fP will read \fBASVisual\fP data from the memory block
 encoded by \fBvisual2visual_prop()\fP\. It could be used to read data from
 X property and convert it into usable information \- such as colormap,
 visual info, etc\.
 Note: \fBsetup_truecolor_visual()\fP or \fBsetup_pseudo_visual()\fP has to be
 invoked in order to complete \fBASVisual\fP setup\.

.fi

.PP
.SH libAfterImage/asvisual/create_visual_window()
.SS\fB SYNOPSIS\fP 
.nf
 \fBWindow\fP  create_visual_window( \fBASVisual\fP *asv, \fBWindow\fP parent,
                               int x, int y,
                               unsigned int width, unsigned int height,
                               unsigned int border_width,
                               unsigned int wclass,
                               unsigned long mask,
                               XSetWindowAttributes *attributes );

.fi
.SS\fB INPUTS\fP 
.nf
 asv           \- pointer to the valid \fBASVisual\fP structure\.
 parent        \- \fBWindow\fP ID of the parent the \fBwindow\fP\.
 x, y          \- initial position of the new \fBwindow\fP\.
 width, height \- initial size of the new \fBwindow\fP\.
 border_width  \- initial border width of the new \fBwindow\fP\.
 wclass         \- \fBWindow\fP class  \- InputOnly or InputOutput\.
 mask          \- defines what attributes are set\.
 attributes    \- different \fBwindow\fP attributes\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 ID of the newly created \fBwindow\fP on success\. None on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBcreate_visual_window()\fP will do sanity checks on passed parameters,
 it will then add mandatory attributes if needed, and attempt to
 create \fBwindow\fP for the specified \fBASVisual\fP\.

.fi

.PP
.SH libAfterImage/asvisual/create_visual_pixmap()
.SS\fB SYNOPSIS\fP 
.nf
 \fBGC\fP      create_visual_gc( \fBASVisual\fP *asv, \fBWindow\fP root,
                           unsigned long mask, XGCValues *gcvalues );

.fi
.SS\fB INPUTS\fP 
.nf
 asv            \- pointer to the valid \fBASVisual\fP structure\.
 root           \- \fBWindow\fP ID of the root \fBwindow\fP of destination screen
 mask, gcvalues \- values for creation of new \fBGC\fP \- see \fBXCreateGC\fP() for
                  details\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 New \fBGC\fP created for regular \fBwindow\fP on success\. NULL on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 create_visual_gc() will create temporary \fBwindow\fP for the \fBASVisual\fP
 specific depth and \fBVisual\fP and it will then create \fBGC\fP for such \fBwindow\fP\.
 Obtained \fBGC\fP should be good to be used for manipulation of windows and
 Pixmaps created for the same \fBASVisual\fP\.

.fi

.PP
.SH libAfterImage/asvisual/create_visual_pixmap()
.SS\fB SYNOPSIS\fP 
.nf
 \fBPixmap\fP  create_visual_pixmap( \fBASVisual\fP *asv, \fBWindow\fP root,
                               unsigned int width, unsigned int height,
                               unsigned int depth );

.fi
.SS\fB INPUTS\fP 
.nf
 asv            \- pointer to the valid \fBASVisual\fP structure\.
 root           \- \fBWindow\fP ID of the root \fBwindow\fP of destination screen
 width, height  \- size of the \fBpixmap\fP to create\.
 depth          \- depth of the \fBpixmap\fP to create\. If 0 asv\->true_depth
                  will be used\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 ID of the newly created \fBpixmap\fP on success\. None on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBcreate_visual_pixmap()\fP will perform sanity checks on passed
 parameters, and attempt to create \fBpixmap\fP for the specified \fBASVisual\fP,
 root and depth\.

.fi

.PP
.SH libAfterImage/asvisual/create_visual_ximage()
.SS\fB SYNOPSIS\fP 
.nf
 \fBXImage\fP* create_visual_ximage( \fBASVisual\fP *asv,
                               unsigned int width, unsigned int height,
                               unsigned int depth );

.fi
.SS\fB INPUTS\fP 
.nf
 asv            \- pointer to the valid \fBASVisual\fP structure\.
 width, height  \- size of the \fBXImage\fP to create\.
 depth          \- depth of the \fBXImage\fP to create\. If 0 asv\->true_depth
                  will be used\.

.fi
.SS\fB RETURN VALUE\fP 
.nf
 pointer to newly created \fBXImage\fP on success\. NULL on failure\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 \fBcreate_visual_ximage()\fP will perform sanity checks on passed
 parameters, and it will attempt to create \fBXImage\fP of sufficient size,
 and specified colordepth\. It will also setup hooks for \fBXImage\fP
 deallocation to be handled by custom function\.

.fi

.PP
