.\" Source: ascmap.h 
.\" Generated with ROBODoc Version 3.2.3 (Jul 29 2001)
.\" ROBODoc (c) 1994-2001 by Frans Slothouber and Jacco van Weert.
.\" t
.\" @(#)ascmap.h.3
.TH ascmap.h 1 "Tue Jan 15 2002" ascmap.h 3
.PM Generated from ascmap.h with ROBODoc v3.2.3 on Tue Jan 15 15:08:04 2002

.SH libAfterImage/ascmap.h
.SS\fB SYNOPSIS\fP 
.nf
 Defines main structures and function for image quantization\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Image quantization is needed primarily in order to be able to export
 images into file, with colormap format, such as GIF and XPM\.
 \fBlibAfterImage\fP attempts to allocate colorcells to the most used colors,
 and then approximate remaining colors with the closest colorcell\.

 Since \fBquality\fP of quantization is in reverse proportion to the number
 of colors in original image, \fBlibAfterImage\fP allows to set arbitrary
 level of downsampling of the color spectrum in the range of 8 bit per
 channel to 1 bit per channel\. Downsampling is performed by simple
 dropping of less significant bits off of color values\.

 In order to be able to determine closeness of colors, 3\-channel RGB
 values are converted into flat 24bit (or less if downsampling is used)
 index\. That is done by intermixing bits from different channels, like
 so : R8G8B8R7G7B7\.\.\.R1G1B1\. That flat index is used to arrange colors
 in ascending order, and later on to be able to find closest mapped
 color\. Simple hashing technique is used to speed up the
 sorting/searching, as it allows to limit linked lists traversals\.


.fi
.SS\fB SEE ALSO\fP 
.nf
 Structures :
          \fBASColormapEntry\fP
          \fBASColormap\fP

 Functions :
          \fBcolormap_asimage()\fP, \fBdestroy_colormap()\fP

 Other \fBlibAfterImage\fP modules :
          \fBascmap.h\fP \fBasfont.h\fP \fBasimage.h\fP \fBasvisual.h\fP \fBblender.h\fP \fBexport.h\fP
          \fBimport.h\fP \fBtransform.h\fP \fBximage.h\fP

.fi
.SS\fB AUTHOR\fP 
.nf
\fB  Sasha Vasko <sasha at aftercode dot net>
\fP 
.fi

.PP
.SH libAfterImage/ASColormapEntry
.SS\fB NAME\fP 
.nf
\fR  \fBASColormapEntry\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASColormapEntry\fP represents single colorcell in the colormap\.

.fi
.SS\fB DESCRIPTION\fP 
.SS\fB SEE ALSO\fP 
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASColormapEntry\fP
    {
        CARD8 red, green, blue;
    }\fBASColormapEntry\fP;
.fi

.PP
.SH libAfterImage/ASColormap
.SS\fB NAME\fP 
.nf
\fR  \fBASColormap\fP
\fP 
.fi
.SS\fB SYNOPSIS\fP 
.nf
 \fBASColormap\fP represents entire colormap generated for the image\.

.fi
.SS\fB DESCRIPTION\fP 
.SS\fB SEE ALSO\fP 
.SS\fB SOURCE\fP 
.nf
    typedef struct \fBASColormap\fP
    {
        \fBASColormapEntry\fP *entries ;  /* array of colorcells */
        unsigned int count ;        /* number of used colorcells */
        ASSortedColorHash *hash ;   /* internal data */
        Bool has_opaque ;           /* If True then Image has opaque pixels */
    }\fBASColormap\fP;
.fi

.PP
.SH libAfterImage/ascmap/colormap_asimage()
.SS\fB SYNOPSIS\fP 
.nf
 int *colormap_asimage( \fBASImage\fP *im, \fBASColormap\fP *cmap,
                        unsigned int max_colors, unsigned int dither,
                        int opaque_threshold );

.fi
.SS\fB INPUTS\fP 
.nf
 im             \- pointer to valid \fBASImage\fP structure\.
 cmap             \- preallocated structure to store colormap in\.
 max_colors       \- maximum size of the colormap\.
 dither           \- number of bits to strip off the color data ( 0\.\.\.7 )
 opaque_threshold \- \fBalpha\fP channel threshold at which \fBpixel\fP should be
                    treated as opaque

.fi
.SS\fB RETURN VALUE\fP 
.nf
 pointer to the array of indexes representing \fBpixel\fP's colorcells\. This
 array has size of WIDTHxHEIGHT where WIDTH and HEIGHT are size of the
 source image\.

.fi
.SS\fB DESCRIPTION\fP 
.nf
 This function is all that is needed to quantize the \fBASImage\fP\. In order
 to obtain colorcell of the \fBpixel\fP at (x,y) from result, the following
 code could be used :
 cmap\->entries[res[y*width+x]]
 where res is returned pointer\.
 Recommended value for dither parameter is 4 while quantizing photos to
 256 colors, and it could be less , if original has limited number of
 colors\.


.fi

.PP
.SH libAfterImage/ascmap/destroy_colormap()
.SS\fB SYNOPSIS\fP 
.nf
 void destroy_colormap( \fBASColormap\fP *cmap, Bool reusable );

.fi
.SS\fB INPUTS\fP 
.nf
 cmap               \- pointer to valid \fBASColormap\fP structure\.
 reusable         \- if True, then the memory pointed to by cmap will
                    not be deallocated, as if it was allocated on stack

.fi
.SS\fB DESCRIPTION\fP 
.nf
 Destroys \fBASColormap\fP object created using colormap_asimage\.

.fi

.PP
