#!/usr/bin/perl 
# aswmtheme.pl
# convert window maker styles into afterstep looks
# it should work fine.
# however, it has a few issues with t*gradients in window maker, since
# afterstep is at the moment unable to handle these
# i have set it to do a mode 130, but some styles will not
# look correct _at all_
# it also doesnt have the background defined in the look, like 
# window maker styles, so the user will have to select that manually
# dont run this -w, its fine.

$version = "0.1";
@wmtags = (
	["left","right","center"],#TitleJustify
	["normal","singletexture","flat"], #MenuStyle
	["normal","singletexture","flat"], #MenuStyle
);
@astags = (
	["1","2","3"],	#TitleTextAlign
	["3","2","0"], #DrawMenuBorders
	["1","0","0"], #TextureMenuItemsIndividually
);
@wmfont = (
	"DisplayFont",
	"WindowTitleFont",
	"MenuTitleFont",
	"MenuTextFont",
	"ClipTitleFont",
	"IconTitleFont",
);
@asfont = (
	"MyStyle \"default_font\"",
	"MyStyle \"window_font\"",
	"MyStyle \"menu_title_font\"",
	"MyStyle \"menu_text_font\"",
	"MyStyle \"pager_font\"",
	"IconFont"
);
@wmcolor = (
	"HighlightTextColor",
	"FTitleColor",
	"PTitleColor",
	"UTitleColor",
	"MenuTitleColor",
	"MenuTextColor",
);
@ascolor = (
	"MyStyle \"menu_hilite_fore\"",
	"MyStyle \"window_focus_fore\"",
	"MyStyle \"window_shade_fore\"",
	"MyStyle \"window_ufocus_fore\"",
	"MyStyle \"menu_title_fore\"",
	"MyStyle \"menu_text_fore\"",
);
@wmback = (
	"FTitleBack",
	"PTitleBack",
	"UTitleBack",
	"MenuTitleBack",
	"MenuTextBack",
#	"WorkspaceBack",
);

@asback = (
	"MyStyle \"window_focus_back\"",
	"MyStyle \"window_shade_back\"",
	"MyStyle \"window_ufocus_back\"",
	"MyStyle \"menu_title_back\"",
	"MyStyle \"menu_text_back\"",
);

@wmbackstyles = (
	"mhgradient", 	# multi horiz
	"mvgradient", 	# multi vert
	"mdgradient", 	# mutli diag
	"solid",	# solid
	"dgradient",	# normal diag grad
	"vgradient",	# normal vert grad
	"hgradient",	# normal horiz grad
	"spixmap",	# scale
	"cpixmap",	# center
	"tpixmap",	# tile
	"thgradient",	# mode 130 shit "textured gradient"
	"tvgradient",	# doesnt work quite right yet
	"tdgradient",	
);
@asbackstyles = (
	"BackMutliGradient 8",
	"BackMultiGradient 9",
	"BackMultiGradient 6",
	"BackColor",
	"BackGradient 1",
	"BackGradient 2",
	"BackGradient 4",
	"BackPixmap 128",
	"BackPixmap 128",
	"BackPixmap 128",
	"BackPixmap 130",
	"BackPixmap 130",
	"BackPixmap 130",
);
$stylename = "$ENV{HOME}/wmtheme";
$lookname = "$ENV{HOME}/GNUstep/Library/AfterStep/looks/astheme.look";

if (scalar(@ARGV == 1) && "$ARGV[0]" eq "--help") {
	&print_usage();
}

if (scalar(@ARGV > 2 || @ARGV == 1)) {
	print "Invalid argument(s).\n";
	&print_usage();
}

if (scalar(@ARGV == 2)) {
	$stylename = "$ARGV[0]";
	$lookname = "$ARGV[1]";
	$stylename =~ s@^~/@$ENV{HOME}/@;
	$lookname =~ s@^~/@$ENV{HOME}/@;
}

print "Using $stylename -> $lookname\n";
open(STYLE, $stylename);
@lines = <STYLE>;
$line = join '', @lines;
$line =~ s/\n//;
$line =~ s/\}//;
$line =~ s/\{//;
@lines = ();
@lines = split(/;/, $line);
open(LOOK, ">$lookname");
print LOOK "# $lookname \n# generate by aswmtheme.pl $version from \n# $stylename \n# copyright 2000 charlie schmidt ishamael\@themes.org\n\n\n";

foreach $line (@lines) {
	chomp($line);
	($option, $flag) = split(/=/, $line, 2);
	$option =~ s/\s//g;
	$flag =~ s/\s//g;
	$option =~ s/\;//;
	$flag =~ s/\;//;
	if ($option eq "HighlightColor") {
		$flag =~ s/\"//g;
		$result = "MyStyle \"menu_hilite_back\"\nBackColor $flag\n~MyStyle\n";
	} elsif ($option =~ /.*Font.*/) {
		($result) = &transfont($option,$flag);
	} elsif ($option =~ /.*Color.*/ && $option ne "HighlightColor") {
		($result) = &transcolor($option,$flag);
	} elsif ($option =~ /.*Back.*/) {
		($result) = &transback($option,$flag);
	} else {
		($result) = &transtags($option,$flag);
	}
	print LOOK "$result\n";	
}

print LOOK "
MyStyle \"default\"
 Inherit default_font
 ForeColor black
 BackColor black
~MyStyle

MyStyle \"focus_style\"
 Inherit window_focus_fore
 Inherit window_font
 Inherit window_focus_back
~MyStyle

MyStyle \"unfocus_style\"
 Inherit window_ufocus_fore
 Inherit window_font
 Inherit window_ufocus_back
~MyStyle
 
MyStyle \"shade_style\"
 Inherit window_shade_fore
 Inherit window_font
 Inherit window_shade_back
~MyStyle

MyStyle \"menu_title_style\"
 Inherit menu_title_font
 Inherit menu_title_fore
 Inherit menu_title_back
~MyStyle

MyStyle \"menu_item_style\"
 Inherit menu_text_font
 Inherit menu_text_fore
 Inherit menu_text_back
~MyStyle

MyStyle \"menu_hilite_style\"
 Inherit menu_text_font
 Inherit menu_hilite_fore
 Inherit menu_hilite_back
~MyStyle

DefaultStyle \"default\"
FWindowStyle \"focus_style\"
UWindowStyle \"unfocus_style\"
SWindowStyle \"shade_style\"
MenuItemStyle \"menu_item_style\"
MenuTitleStyle \"menu_title_style\"
MenuHiliteStyle \"menu_hilite_style\"
MenuStippleStyle \"menu_item_style\"

MyStyle \"*PagerBallon\"
 Inherit pager_font
~MyStyle

MyStyle \"DeskStyle\"
~MyStyle

MyStyle \"*PagerInActiveDesk\"
~MyStyle

MyStyle \"*PagerActiveDesk\"
~MyStyle

MyStyle \"*PagerFWindowStyle\"
 Inherit focus_style
~MyStyle

MyStyle \"*PagerUWindowStyle\"
 Inherit unfocus_style
~MyStyle

MyStyle \"*PagerSWindowStyle\"
 Inherit shade_style
~MyStyle

MyStyle \"*WharfTile\"
 BackPixmap 129
~MyStyle

MyStyle \"*WinList\"
 Inherit window_font
 BackPixmap 129
~MyStyle

DecorateFrames 0
TexturedHandle
MenuMiniPixmaps 0
RubberBand 2
TitlebarNoPush
TitleButtonStyle 1
TitleButton 1 wm-square.xpm wm-square.xpm
TItleButton 2 wm-x.xpm wm-x.xpm
";
exit();

sub transtags {
	($left,$right) = @_;
	$return = "# Unsupported tag: $left";
	if ($left eq "TitleJustify") {
		for ($first = 0; $first <= "$#{$wmtags[0]}"; $first++) {
			if ($right eq "$wmtags[0][$first]") {
				$return = "TitleTextAlign $astags[0][$first]";
			}
		}
	}
	if ($left eq "MenuStyle") {
		for ($first = 0; $first <= "$#{$wmtags[0]}"; $first++) {
			if ($right eq "$wmtags[1][$first]") {
				$return = "TextureMenuItemsIndividually $astags[2][$first]\nDrawMenuBorders $astags[1][$first]";
			}
		}
	}
	return($return);
}

sub transfont {
	($left,$right) = @_;
	$return = "# Unsupported tag: $left";
	$right =~ s/\"//g;
	for ($first = 0; $first <= $#wmfont; $first++) {
		if ($left eq "$wmfont[$first]") {
			if ("$asfont[$first]" =~ /.*MyStyle.*/) {
				$return = "$asfont[$first]\nFont $right\nTextStyle 0\n~MyStyle\n";
			} else {
				$return = "$asfont[$first] $right\n";
			}
		}
	}
				return($return);
}

sub transcolor {
	($left,$right) = @_;
	$return = "# Unsupported tag: $left";
	$right =~ s/\"//g;
	for ($first = 0; $first <= $#wmcolor; $first++) {
		if ($left eq "$wmcolor[$first]") {
			$return = "$ascolor[$first]\nForeColor $right\n~MyStyle\n";
		}
	}
	return($return);
}

sub transback {
	($left,$right) = @_;
	$return = "# Unsupported tag: $left";
	$right =~ s/\)//;
	$right =~ s/\(//;
	$right =~ s/\"//g;	
	@rightthings = split(/,/, $right);
	$style = $rightthings[0];
	shift @rightthings;
	for ($first = 0; $first <= $#wmback; $first++) {
		if ($left eq "$wmback[$first]") {
			for ($second = 0; $second <= $#wmbackstyles; $second++) {
				if ($style eq "$wmbackstyles[$second]") {
					if ($style =~ /m.gradient/) {
						$return = "$asbackstyles[$second] ";
						@rightthings = reverse @rightthings;
						for ($temp = 0; $temp <= $#rightthings; $temp++) {
							$offsets[$temp] = ($temp+1)/($#rightthings+1);
						}
						for ($third = 0; $third <= $#offsets; $third++) {
							$return = $return." $rightthings[$third] $offsets[$third] ";
						}
					} elsif ($style =~ /.pixmap/ || $style =~ /t.gradient/) {
						$return = "$asbackstyles[$second] $rightthings[0]";
					} elsif ($style =~ /.gradient/) {
						$return = "$asbackstyles[$second] $rightthings[0] $rightthings[1]";
					} elsif ($style == "solid") {
						$return = "$asbackstyles[$second] $rightthings[0]";
					} elsif ($style =~ /#\w+/) {
						$return = "$asbackstyles[$second] $style";
					}
		
				}
			}
			$return = "$asback[$first]\n"."$return"."\n~MyStyle\n";
		}
	}
	return($return);
}

sub print_usage {
	print "aswmtheme version $version\nCharlie Schmidt <ishamael\@themes.org>\n\naswmtheme.pl [wmstyle] [aslook]\n\n";
	exit();
}

