/*****************************************************************************/
/*	astuner - AfterStep Tuner for RadioTrack and RadioReveal cards.      */
/*	cmdtuner - Command line interface.                                   */
/*	Release 2.1						             */
/*	By David Muench.						     */		
/*	cc@spork.neonexus.com						     */
/*	http://www.neonexus.com/cc/					     */
/*  Modified by Keith Dart <kdart@techie.com>                            */
/*									     */
/*	This is an 'AfterStep Look & Feel' Wharf style applet that can be    */
/*	used to control one of the before mentioned radio tuner cards.       */
/*									     */
/*   Based on ascd by Rob Malda and radiotrack-1.1 by Gideon J. le Grange.   */
/*****************************************************************************/

/* $Id: cmdtuner.c,v 1.2 1998/05/08 08:02:56 kdart Exp kdart $ */

#include "cmdtuner.h"

/* Functions *****************************************************************/
void Help(void);
void ParseCmdLine(int argc, char *argv[]);
void ipctouch(char *name);
void ipcstatus(void);
void abort(void);

/* Globals *******************************************************************/

uid_t	uid = 65535;
int		fd;
int		verbose = 0;

/*****************************************************************************/
int main(int argc,char *argv[])
{
	int ret = 0;
	struct passwd *pw;

	uid = getuid();
	pw = getpwuid(uid); 

	if((fd = open(FIFOFILE, O_RDWR )) == -1) {
		fprintf(stderr, "Could not open fifo.\n");
		exit(-1);
	}
	signal (SIGINT, (void *) abort);
	signal (SIGQUIT, (void *) abort);

	ParseCmdLine(argc, argv); 
	
	close(fd);
	return 0;
}

void abort()
{
	close(fd);
	exit(-1);
}

/*****************************************************************************/
void Help()
{       
	fprintf(stderr,"cmdtuner - Version 2.1\n");
	fprintf(stderr,"Written by David Muench <cc@spork.neonexus.com>\n");
	fprintf(stderr,"http://www.neonexus.com/cc/\n");
	fprintf(stderr,"Modified by Keith Dart <kdart@techie.com>\n");
	fprintf(stderr,"usage:  cmdtuner [options ...] \n");
	fprintf(stderr,"options:\n");
	fprintf(stderr,"\n");       
	fprintf(stderr,"Command           What it does\n");
	fprintf(stderr,"--------------------------------------------------\n");
	fprintf(stderr,"h                 Help (this message).\n");
	fprintf(stderr,"on                Turns the radio on.\n");
	fprintf(stderr,"off               Turns the radio off.\n");
	fprintf(stderr,"volup             Turns the volume up a notch.\n");
	fprintf(stderr,"voldown           Turns the volume down a notch.\n");
	fprintf(stderr,"tuneup            Increment tuner up by 200kHz.\n");
	fprintf(stderr,"tunedown          Increment tuner down by 200kHz.\n");
	fprintf(stderr,"tuneto <station>  Tunes to <station>, in MHz (e.g. 90.5), or\n");
	fprintf(stderr,"                  tune to a preset if a digit 0 to N is given.\n");
	fprintf(stderr,"status            Print astuner status information.\n");
	fprintf(stderr,"\n");
	abort();
}

#define TUNEBUFSIZE 32

/****************************************************************************/
void ParseCmdLine(int argc, char *argv[])
{

	char *Argument;
	int i;
	static char tune[TUNEBUFSIZE];
	
	if(argc == 1)
	{
		Help();
		return;
	}
	
	bzero (tune, TUNEBUFSIZE);
	for(i = 1; i < argc; i++) 
	{
		Argument = argv[i];
		
		if (Argument[0] == '-') 
		{
			switch(Argument[1]) 
			{
			case 'h':  /* Help */
				if(++i >= argc) Help();
				continue;
			case 'v': /*verbose*/
				verbose = 1;
				continue;
			default:
				Help();
			}
		}
		else if(strcasecmp(Argument, "on") == 0)
		{
			ipctouch(Argument);
			break;
		}
		else if(strcasecmp(Argument, "off") == 0)
		{
			ipctouch(Argument);
			break;
		}
		else if(strcasecmp(Argument, "volup") == 0)
		{
			ipctouch(Argument);
			break;
		}
		else if(strcasecmp(Argument, "voldown") == 0)
		{
			ipctouch(Argument);
			break;
		}
		else if(strcasecmp(Argument, "tuneup") == 0)
		{
			ipctouch(Argument);
			break;
		}
		else if(strcasecmp(Argument, "tunedown") == 0)
		{
			ipctouch(Argument);
			break;
		}
		else if(strcasecmp(Argument, "status") == 0)
		{
			ipcstatus();
			break;
		}
		else if(strcasecmp(Argument, "tuneto") == 0)
		{
			if ((i+1) <  argc) {
				Argument = argv[i + 1];
				sprintf(tune, "tuneto %s", Argument);
				ipctouch(tune);
			}
			else {
				Help();
			}
			break;
		}
		else
			Help();
	}

}

/****************************************************************************/
void ipctouch(char *name)
{
	if(verbose) printf("writing \"%s\" to fifo.\n", name);
	write(fd, name, strlen(name));
}

void ipcstatus(void)
{
	char buf[256];
	int  nread;
	int ofifofd = -1; 

	if((mkfifo(OFIFOFILE, 0777)) == -1) {
		perror("cmdtuner");
		return;
	}

	if(verbose) printf("writing \"status\" to fifo.\n");
	write(fd, "status", 7);
	/* sent message. Now open and block until server (astuner) responds. */
	if((ofifofd = open(OFIFOFILE, O_RDONLY)) == -1) {
		perror("cmdtuner");
		return;
	}
	
	while ((nread = read(ofifofd, buf, 256)) != 0) {
		write (1, buf, nread);
	}
	close(ofifofd);
	unlink(OFIFOFILE);
}
