/*
 *	astuner - AfterStep FM radio control.
 *	Version 3.1
 *	By David Muench.
 *	cc@spork.neonexus.com
 *	<http://www.neonexus.com/cc/>
 *	Modified by Keith Dart <kdart@techie.com>
 *
 *  Based on ascd by Rob Malda and radiotrack-1.1 by Gideon J. le Grange.
 */
 
/* $Id: astuner.h,v 1.1 1998/05/08 08:27:10 kdart Exp kdart $ */

/*	This is an 'AfterStep Look & Feel' Wharf style applet that can be used
 *	to control an FM radio tuner card.  Note that this program uses the
 *	new radio device driver from Matthew Kirkwood, which is currently only
 *	in Linux kernel 2.1.65 and up. Sorry, you'll have to run the
 *	development kernel, or wait until Linux 2.2 comes out, to use this
 *	tuner.
 */

#ifndef _ASTUNER_H
#define _ASTUNER_H

/********/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include <errno.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <limits.h>
#include <dirent.h>
#include <sys/time.h>
#include <signal.h>
#include <math.h>

#include <linux/radio.h>

#include "config.h"

/* structs *********** ******************************************************/
typedef struct _XpmIcon {
	Pixmap pixmap;
	Pixmap mask;
	XpmAttributes attributes;
} XpmIcon;

typedef struct stations_t {
	int freq;
	char name[5];
} stations_t;

/* Global stuff **************************************************************/
#define TRUE 1
#define FALSE 0

#define NUMSTATIONS 20

/* The rc file is optional. Use it to list your favorite stations. */
#define RCFILE "~/GNUstep/Library/AfterStep/astuner"

/* this is the FIFO for IPC to cmdtuner. */
#define FIFOFILE "/tmp/FIFO..astuner"
#define OFIFOFILE "/tmp/FIFO..astuner-out"

/* the /dev/radio device is now a port of the standard kernel. How cool. */
#define RADIODEVICE "/dev/radio"

/* need these externals for the config parser module. */
char	*myname; /* program name */
stations_t stations[NUMSTATIONS];
extern int used;
extern char	*rcfile;
extern int currstation;
extern struct radio_ctl radiocontrol;
extern struct radio_cap radiofeatures;
extern struct radio_band radioFMband;

extern void cleanup(int);
extern int freqtoint(char *);

#endif
