.TH astime 1 "25 July 2000" "Version 2.7"
.UC
.SH NAME
\fBastime\fP \- the AfterStep analogue clock
.SH SYNOPSIS
.B astime
[-h] [-H] [-V]
        [-iconic] [-withdrawn] [-standout] [-noborder]
        [-geometry \fI[WxH][+|-]x[+|-]y\fP]
        [-rc \fIfile name\fP]
        [-u \fIupdate rate\fP]
        [-exe \fIprogram name\fP]
        [-shift \fIhours\fP]
        [-ns] [-nd] [-nap]
        [-display \fIdisplay\fP]
        [-title \fIname\fP]
        [-bg \fIcolor\fP]
        [-fg \fIcolor\fP]
        [-sec \fIcolor\fP]
        [-min \fIcolor\fP]
        [-hour \fIcolor\fP]
        [-day \fIcolor\fP]
        [-date \fIcolor\fP]
        [-ampm \fIcolor\fP]
        [-nt] [-at] [-fs]
        [-ts] [-fh] [-nh]
        [-ht \fInumber\fP]
        [-ot \fInumber\fP]
        [-nf]
        [-label \fItext\fP]
        [-fn \fIfont name\fP]
        [-lcol \fIlabel color\fP]
        [-ltop]
.SH DESCRIPTION
The \fBastime\fP is a X11 application that acts as
an analogue clock that we all are familiar with.
It shows the current time on the dial. The day of
the week is in the upper left corner and the current
date is at the bottom. The AM/PM indicator is in
the top right corner.

.SH CONFIGURATION OPTIONS
.IP "-h or -H"
.RS
Prints a short description and usage message.
.RE
.IP "-V"
.RS
Version control. Prints out the version of the program.
.RE
.IP "-rc <file name>"
.RS
Read the configuration from the given resource file.
The default resource file read if none are given on
the command line is ~/.astimerc. The settings on the
command line overwrite any settings read from the
resource file.  A single '#' character can be used to
"comment out" any line in the .astimerc file, which is
useful for making temporary changes.
.RE
.IP "-geometry [WxH][+|-]x[+|-]y"
.RS
Displays the window at the specified location
on the screen and resizes the window to the specified
size WxH. This works as standard X Windows
geometry option. (See XParseGeometry (3x)).
.RE
.IP "-iconic"
.RS
Starts the \fBastime\fP application in the iconized mode.
The icon has the same appearance with the main
window.
When this option is given, the -position refers to
the position of the icon window as well as the main window.
.RE
.IP "-withdrawn"
.RS
Starts the \fBastime\fP application in the withdrawn mode.
This option is necessary to be able to dock the
\fBastime\fP in the WindowMaker dock.
When this option is given, the -position refers to
the position of the icon window as well as the main window.
\fBastime\fP ignores the -iconic option when started
in withdrawn mode.
.RE
.IP "-standout"
.RS
This changes the appearance of the \fBastime\fP display from
"pushed-in" to "popped-out". The first is the default look.
The "popped-out" applets look much better in WindowMaker's dock
according to some opinions. Give it a try in any case.
.RE
.IP "-noborder"
.RS
The clock looses its border effectively becoming a 2D 
clock instead of having a raised or lowered faceplate.
This option is reportedly recommended for FVWM use.
When this option is used "-standout" is ignored.
.RE
.IP "-u <update rate>"
.RS
Changes the polling rate for updating the clock.
The update rate is specified in seconds. The value
of 1 is the minimum. Default value is 1 second.
Updating at a different value is hardly a good
idea when you have the seconds hand on. Switch
it off with the "-nosec" option.
.RE
.IP "-exe <program name>"
.RS
Specifies which program should be executed when you click on
the clock's face. If this switch is not specified, \fBastime\fP
does not intercept the mouse clicks at all. So, by default,
nothing is run. This option uses system(3) call to execute
the specified program. The maximum length of the command is
restricted to 255 characters (for no particular reason).

The icon does not usually respond to mouse clicks (you would
want to be able to de-iconify the window, right?) unless you
are running in the "withdrawn" mode (-withdrawn option).
Then the icon responds the same way the clock face does.
.RE
.IP "-shift <hours>"
.RS
Shifts the clock by the specified number of hours. This is
a simple way of putting a clock in a different timezone. 
Useful when you want several clocks showing the current
time in different places. The value can be both positive
and negative. The values above 23 and below -23 are silently
ignored.

Note that the date and day of the week are not adjusted.
.RE
.IP "-ns"
.RS
Do not draw the seconds hand of the clock. Only the
minutes and hours hands are drawn.
.RE
.IP "-nd"
.RS
Do not show the current date.
.RE
.IP "-nap"
.RS
Do not show the AM/PM indicator.
.RE
.IP "-display <name>"
.RS
The name of the display to start the window in.
It works just as X Windows display option.
.RE
.IP "-title <name>"
.RS
Set the window title and the icon title to the specified
name.
.RE
.IP "-bg <color>"
.RS
Changes the color of the background of the dial.
Default colour is #385971.
.RE
.IP "-fg <color>"
.RS
Changes the color of the foreground of the dial.
Default colour is #ffffff.
.RE
.IP "-sec <color>"
.RS
Changes the color of the second hand of the clock.
Default colour is #efc669.
.RE
.IP "-min <color>"
.RS
Changes the color of the minute hand of the clock.
Default colour is #ff3030.
.RE
.IP "-hour <color>"
.RS
Changes the color of the hour hand of the clock.
Default colour is #ef3838.
.RE
.IP "-day <color>"
.RS
Changes the color of the day-of-the-week display.
Default colour is #a0a0a0.
.RE
.IP "-date <color>"
.RS
Changes the color of the date display.
Default colour is #a0a0a0.
.RE
.IP "-ampm <color>"
.RS
Changes the color of the AM/PM display.
Default colour is #a0a0a0.
.RE
.IP "-nt"
.RS
Don't draw the second ticks on the clock face.
.RE
.IP "-at"
.RS
Draw all ticks, not only every 5 seconds.
.RE
.IP "-fs"
.RS
"Floating" second indicator in the style of xclock.
.RE
.IP "-ts"
.RS
Use a thin second hand - default in the regular mode.
Use it to change the appearance of the second hand
while in the -fh mode. It looks very good with the
normal hands of large thickness too.
.RE
.IP "-fh"
.RS
Fancy hands mode. Renders fancy xclock-style hands.
.RE
.IP "-nh"
.RS
"Neon" hands. Try this with the fancy hands mode.
.RE
.IP "-ht <number>"
.RS
Hand thickness. Can be a number from 0 to 200.
.RE
.IP "-ot <number>"
.RS
Hand outline thickness. Can be a number from 0 to 200.
.RE
.IP "-nf"
.RS
No foreground. Equal to "-nd -nap -nt".
.RE
.IP "-label <text>"
.RS
Asks the \fBastime\fP to label the clock's face with the specified
text. Useful when you want to distinguish between different
instances of \fBastime\fP running on your desktop.
.RE
.IP "-fn <font name>"
.RS
Use the specified font for the label. The default font is
"-*-helvetica-medium-r-*-*-9-240-*-*-*-*-*-*". Don't ask me why,
I do not know, I just found it fits my desktop well. If you have
a better idea - send me a mail. The font is loaded only if you
specify a label and has otherwise no effect.
.RE
.IP "-lcol <label color>"
.RS
Draw the label using the specified color. The default color
is #a0a0a0. Has no effect if you did not specify a label.
.RE
.IP "-ltop"
.RS
Draw the label on the top of the clock's face instead of
drawing it at the bottom by default. Does not do anything
if a label was not specified.
.RE
.SH RESOURCE FILE SYNTAX
\fBastime\fP can read and parse a configuration file.
This configuration file describes the desired look of the
applet (there are equialents to all command-line options)
and specifies actions to be taken on particular events.
The configuration file is usually ~/.astimerc but \fBastime\fP
can be forced to read any file using the -rc option. 
Any options read from the configuration file may be overridden
with the command-line options (if a corresponding command-line
option exists, naturally).

The configuration file may contain only one option per line.
Empty lines and lines starting with # are ignored.

.IP "geometry <geometry specification>"
.RS
Your standard X Windows geometry specification.
.RE
.IP "background <color>"
.RS
Specifies the background color.
.RE
.IP "foreground <color>"
.RS
Specifies the foreground color.
.RE
.IP "secondColor <color>"
.RS
Specifies the color for the second hand of the clock.
.RE
.IP "minuteColor <color>"
.RS
Specifies the color for the minute hand of the clock.
.RE
.IP "hourColor <color>"
.RS
Specifies the color for the hour hand of the clock.
.RE
.IP "secondOutColor <color>"
.RS
Specifies the color for the second hand outline in fancy 
and outline modes.
.RE
.IP "minuteOutColor <color>"
.RS
Specifies the color for the minute hand outline in fancy
and outline modes.
.RE
.IP "hourOutColor <color>"
.RS
Specifies the color for the hour hand outline in fancy
and outline modes.
.RE
.IP "secondFillColor <color>"
.RS
Specifies the fill color for the second hand in fancy mode.
.RE
.IP "minuteFillColor <color>"
.RS
Specifies the fill color for the minute hand in fancy mode.
.RE
.IP "hourFillColor <color>"
.RS
Specifies the fill color for the hour hand in fancy mode.
.RE
.IP "dayColor <color>"
.RS
Specifies the color for the day of the week indicator.
.RE
.IP "AMPMColor <color>"
.RS
Specifies the color for the AM/PM indicator.
.RE
.IP "dateColor <color>"
.RS
Specifies the color for the current date indicator.
.RE
.IP "drawSecondHand <0 | 1>"
.RS
A boolean variable (0 | 1) specifying if the second hand should
be drawn.
.RE
.IP "drawDayDate <0 | 1>"
.RS
A boolean variable specifying if the day/date indicator
should be drawn.
.RE
.IP "drawAMPM <0 | 1>"
.RS
A boolean variable specifying if the AM/PM indicator
should be drawn.
.RE
.IP "drawTicks <0 | 1>"
.RS
A boolean variable specifying if the second ticks should be
drawn at all.
.RE
.IP "drawAllTicks <0 | 1>"
.RS
A boolean variable specifying if all ticks should be
drawn and not only every 5 sec.
.RE
.IP "drawForeground <0 | 1>"
.RS
A boolean variable specifying if the foreground elements
should be drawn. When zero is specified only the clock hands appear.
.RE
.IP "floatSeconds <0 | 1>"
.RS
A boolean variable specifying if the second indicator
should be a floating pointer (a bit like in xclock) rather
than a hand.
.RE
.IP "thinSeconds <0 | 1>"
.RS
A boolean variable specifying if the second hand
should be thin.
.RE
.IP "handThickness <thickness>"
.RS
Specifies the thickness of the hands. Can be a value 
between 0 and 200.
.RE
.IP "outThickness <thickness>"
.RS
Specifies the thickness of the outline of the hands. 
Can be a value between 0 and 200.
.RE
.IP "fancyHands <0 | 1>"
.RS
A boolean variable (0 | 1). Render polygonal, xclock-like hands.
.RE
.IP "outlinedHands <0 | 1>"
.RS
A boolean variable (0 | 1). Render polygonal, xclock-like hands without fill.
.RE
.IP "neonHands <0 | 1>"
.RS
A boolean variable (0 | 1). Darken the hand fill colors 
with respect to their outlines, useful with fancy hands.
.RE
.IP "execProg <command line>"
.RS
Specifies a command to be executed when the clock face is clicked.
The command line must be enclosed in double quotes.
.RE
.IP "withdrawn <0 | 1>"
.RS
A boolean variable (0 | 1). This option is necessary when
running with WindowMaker. Produces a withdrawn window that
can be docked.
.RE
.IP "iconic <0 | 1>"
.RS
A boolean variable (0 | 1). Specifies if the applet should
start as an icon rather than a full window.
.RE
.IP "standout <0 | 1>"
.RS
A boolean variable (0 | 1). Changes the appearance of the 
display from "pushed-in" to the "standing out".
.RE
.IP "noborder <0 | 1>"
.RS
A boolean variable (0 | 1). Changes the appearance of the 
display from 3D to plain 2D by removing the shaded border
around the faceplate.
.RE
.IP "shift <+-hours>"
.RS
Specifies that the clock should show the local time shifted
by the given number of hours. Useful to see the time in
different timezones.
.RE
.IP "title <name>"
.RS
Specifies which title should be given to this clock.
.RE
.IP "at hh:mm:ss <command line>"
.RS
Specifies program to be run at a particular time.
The command line must be enclosed in double quotes.
.RE
.IP "Label <text>"
.RS
Asks the \fBastime\fP to label the clock's face with the specified
text. Useful when you want to distinguish between different
instances of \fBastime\fP running on your desktop.
Equivalent to the command-line '-label' option.
.RE
.IP "Font <font name>"
.RS
Use the specified font for the label. The default font is
"-*-helvetica-medium-r-*-*-9-240-*-*-*-*-*-*". Don't ask me why,
I do not know, I just found it fits my desktop well. If you have
a better idea - send me a mail. The font is loaded only if you
specify a label and has otherwise no effect.
Equivalent to the command-line '-fn' option.
.RE
.IP "LabelColor <color>"
.RS
Draw the label using the specified color. The default color
is #a0a0a0. Has no effect if you did not specify a label.
Equivalent to the command-line '-lcolor' option.
.RE
.IP "LabelTop <0 | 1>"
.RS
If the value is 1 draws the label on the top of the clock's face;
if the value is 0 - at the bottom (default). Does not do anything
if a label was not specified.
.RE
.SH INVOCATION
\fBastime\fP can be called in different ways.  The most 
common invocation is the command line:
.nf

	user@host[1]% astime -bg blue -fg white &

.fi
Another way to call \fBastime\fP is from the window manager:
.nf

	*Wharf "astime" nil Swallow "astime" astime -nosec &

.fi
This line, when placed in the \fIwharf\fP file in the user's Afterstep
configuration directory will cause \fBastime\fP to be a
button on the \fBWharf (1)\fP button bar under the \fBafterstep (1)\fP
window manager.

If you run WindowMaker then you should use the "-withdrawn"
option:
.nf

	user@host[1]% astime -withdrawn -standout &

.fi
and then drag the icon to the dock.

If you run fvwm2 I think you will like to try this one:
.nf

	astime -geometry 120x120+890+0 -bg black 
	-fg \\#0000ff -sec \\#efc669 -min \\#20b2aa 
	-hour \\#8141d7 -day \\#7766aa -ampm \\#7766aa 
	-date \\#7766aa -at -fs -fh -nh

.fi
Of course, it looks less scary if you put all those settings in the
~/.astimerc file. The example .astimerc file (sample.astimerc) included
in the distribution provides the aforementioned settings.
.SH BUGS
My programs do not have bugs, they just develop random
features ;-)
.PP
Well, there are limitations. All the strings for the
color names, display name, and the geometry have the
length limit of 64 characters (terminating zero included). 
The string copying routine cuts the names that are longer.
.SH "SEE ALSO"
.BR date (1), X (1x)
.SH COPYRIGHTS
Copyright (c) 1998-2000  Albert Dorofeev <albert@tigr.net>

Copyright (c) 1999 William Kostis <kostis@ee.cornell.edu>

Distributed under GNU General Public License v2 ; 
see LICENSE file for more informations.
.SH AUTHORS
Albert "Tigr" Dorofeev <albert@tigr.net>

William Kostis <kostis@ee.cornell.edu>

See the README file for details and credits.
.sp
