/*
 * astime is an analogue clock utility for X Windows.
 *
 * Copyright (c) 1998-99  Albert Dorofeev <Albert@mail.dma.be>
 * Copyright (c) 1999 William Kostis <kostis@ee.cornell.edu>
 *
 * For the updates see http://bewoner.dma.be/Albert/afterstep/
 *
 * This software is distributed under GPL. For details see LICENSE file.
 */

#ifndef _state_h_
#define _state_h_

/* coordinates structure */
struct coordinates {
  int x, y;
};

typedef struct _pinfo {
  int time[3];
  int done;
  char name[255];
} *PInfo;

#define PSEC   0
#define PMIN   1
#define PHOUR  2

#define HCLINE 0
#define HOLINE 1
#define HFILL  2
#define HTHICK 3

#define MAX_OPT_LEN 64

struct astime_state {
  long int update_interval;         /* interval (sec) to update the dial */

  unsigned short int draw_seconds;  /* render second hand                */
  unsigned short int draw_date;     /* render date                       */
  unsigned short int draw_ampm;     /* render AM/PM                      */
  unsigned short int tprop;         /* tick properties                   */
  unsigned short int float_seconds; /* render floating second indicator  */
  unsigned short int thin_seconds;  /* render thin second hand/indicator */

  unsigned short int hthick;        /* hand thickness                    */
  unsigned short int othick;        /* outline thickness                 */
  unsigned short int neon;          /* neon hands (hand darkening)       */
  unsigned short int hprop[3][3];   /* hand properties                   */

  struct coordinates total_size;
  short int shift;
  unsigned short int run_program;
  unsigned short int cron_program;

  /* main colors */
  char bgcolor[MAX_OPT_LEN];
  char fgcolor[MAX_OPT_LEN];
  /* standard hand colors */
  char seccolor[MAX_OPT_LEN];
  char mincolor[MAX_OPT_LEN];
  char hourcolor[MAX_OPT_LEN];
  /* outside polygon colors */
  char secocolor[MAX_OPT_LEN];
  char minocolor[MAX_OPT_LEN];
  char hourocolor[MAX_OPT_LEN];
  /* inside polygon colors */
  char secfillcolor[MAX_OPT_LEN];
  char minfillcolor[MAX_OPT_LEN];
  char hourfillcolor[MAX_OPT_LEN];
  /* other foreground colors */
  char daycolor[MAX_OPT_LEN];
  char ampmcolor[MAX_OPT_LEN];
  char datecolor[MAX_OPT_LEN];

  unsigned int show_label;	/* Show a user-specified label */
  unsigned int label_top;	/* If the label is on top or at the bottom */
  char label[256];		/* The label text */
  char font_name[256];		/* Font name for the labels */
  char label_color[MAX_OPT_LEN];/* Label color */

  /* executable */
  char program_name[255];

  int nprogs;
  /* program parameters */
  PInfo *PI;
};

#endif
