.TH astime 1 "12 November 1998" "Version 1.1"
.UC
.SH NAME
\fBastime\fP \- the AfterStep analogue clock
.SH SYNOPSIS
.B astime
[-h] [-H] [-V]
        [-iconic] [-withdrawn] [-standout]
        [-geometry \fI[WxH][+|-]x[+|-]y\fP]
        [-u \fIupdate rate\fP]
        [-nosec] [-noday] [-nodate]
        [-display \fIdisplay\fP]
        [-bg \fIcolor\fP]
        [-fg \fIcolor\fP]
        [-sec \fIcolor\fP]
        [-min \fIcolor\fP]
        [-hour \fIcolor\fP]
        [-day \fIcolor\fP]
        [-date \fIcolor\fP]
.SH DESCRIPTION
The \fBastime\fP is a X11 application that acts as
an analogue clock that we all are familiar with.
It shows the current time on the dial. The day of
the week is in the upper left corner and the current
date is at the bottom.

.SH CONFIGURATION OPTIONS
.IP "-h or -H"
.RS
Prints a short description and usage message.
.RE
.IP "-V"
.RS
Version control. Prints out the version of the program.
.RE
.IP "-geometry [WxH][+|-]x[+|-]y"
.RS
Displays the window at the specified location
on the screen and resizes the window to the specified
size WxH. This works as standard X Windows
geometry option. (See XParseGeometry (3x)).
.RE
.IP "-iconic"
.RS
Starts the \fBastime\fP application in the iconized mode.
The icon has the same appearance with the main
window.
When this option is given, the -position refers to
the position of the icon window as well as the main window.
.RE
.IP "-withdrawn"
.RS
Starts the \fBastime\fP application in the withdrawn mode.
This option is necessary to be able to dock the
\fBastime\fP in the WindowMaker dock.
When this option is given, the -position refers to
the position of the icon window as well as the main window.
\fBastime\fP ignores the -iconic option when started
in withdrawn mode.
.RE
.IP "-standout"
.RS
This changes the appearance of the \fBastime\fP display from
"pushed-in" to "popped-out". The first is the default look.
The "popped-out" applets look much better in WindowMaker's dock
according to some opinions. Give it a try in any case.
.RE
.IP "-u <update rate>"
.RS
Changes the polling rate for updating the clock.
The update rate is specified in seconds. The value
of 1 is the minimum. Default value is 1 second.
Updating at a different value is hardly a good
idea when you have the seconds hand on. Switch
it off with the "-nosec" option.
.RE
.IP "-nosec"
.RS
Do not draw the seconds hand of the clock. Only the
minutes and hours hands are drawn.
.RE
.IP "-noday"
.RS
Do not show the day of the week.
.RE
.IP "-nodate"
.RS
Do not show the current date.
.RE
.IP "-display <name>"
.RS
The name of the display to start the window in.
It works just as X Windows display option.
.RE
.IP "-bg <color>"
.RS
Changes the color of the background of the dial.
Default colour is #385971.
.RE
.IP "-fg <color>"
.RS
Changes the color of the foreground of the dial.
Default colour is #efc669.
.RE
.IP "-sec <color>"
.RS
Changes the color of the second hand of the clock.
Default colour is #efc669.
.RE
.IP "-min <color>"
.RS
Changes the color of the minute hand of the clock.
Default colour is #ff3030.
.RE
.IP "-hour <color>"
.RS
Changes the color of the hour hand of the clock.
Default colour is #ef3838.
.RE
.IP "-day <color>"
.RS
Changes the color of the day-of-the-week display.
Default colour is #a0a0a0.
.RE
.IP "-date <color>"
.RS
Changes the color of the date display.
Default colour is #a0a0a0.
.RE
.SH INVOCATION
\fBastime\fP can be called in different ways.  The most 
common invocation is the command line:
.nf

	user@host[1]% astime -bg blue -fg white &

.fi
Another way to call \fBastime\fP is from the window manager:
.nf

	*Wharf "astime" nil Swallow "astime" astime -nosec &

.fi
This line, when placed in the \fIwharf\fP file in the user's Afterstep
configuration directory will cause \fBastime\fP to be a
button on the \fBWharf (1)\fP button bar under the \fBafterstep (1)\fP
window manager.

If you run WindowMaker then you should use the "-withdrawn"
option:
.nf

	user@host[1]% astime -withdrawn -standout &

.fi
and then drag the icon to the dock.
.SH BUGS
My programs do not have bugs, they just develop random
features ;-)
.PP
Well, there are limitations. All the strings for the
color names, display name, and the geometry have the
length limit of 50 characters (terminating zero included). 
The string copying routine cuts the names that are longer.
.SH "SEE ALSO"
.BR date (1)
.SH COPYRIGHTS
Copyright (c) 1998  Albert Dorofeev <Albert@mail.dma.be>

Distributed under GNU General Public License v2 ; 
see LICENSE file for more informations.
.SH AUTHORS
Albert "Tigr" Dorofeev <Albert@mail.dma.be>

See the README file for credits.
.sp
