#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/Xatom.h>

#include "x_color.h"
#include "state.h"
struct astime_state state;

#include "background.xpm"
#include "dof.xpm"
#include "months.xpm"
#include "digits.xpm"

/* nice idea from ascd */
typedef struct _XpmIcon {
    Pixmap pixmap;
    Pixmap mask;
    XpmAttributes attributes;
} XpmIcon;

XpmIcon backgroundXpm;
XpmIcon dofXpm;
XpmIcon monthsXpm;
XpmIcon digitsXpm;

/* X windows related global variables */
Display * mainDisplay = 0;      /* The display we are working on */
Window Root;                    /* The root window of X11 */
Window mainWindow;              /* Application window */
Window iconWindow;              /* Icon window */
XGCValues mainGCV;              /* graphics context values */
GC mainGC;                      /* Graphics context */
Atom wm_delete_window;
Atom wm_protocols;

/* background, digits, months etc pixmap colors */
char bgpixmap_color[4][50];
char dof_pixmap_color[2][50];
char digits_pixmap_color[2][50];
char months_pixmap_color[2][50];

/* calculated values in pixels */
int pixelLength[3];
struct line_struct {
	int x1, y1;
	int x2, y2;
} lines[7];

/* pixels we need */
Pixel pix[3];

/* last time we updated */
time_t last_time = 0;
time_t curTime;

/* current time in nice format */
struct tm * loc_time;

/* requests for update */
int update_request = 0;

float pi=3.14159265359;

void draw_window(Window win)
{
	int i;

        XCopyArea(
                mainDisplay,
                backgroundXpm.pixmap,
                win,
                mainGC,
                0,
                0,
                backgroundXpm.attributes.width,
                backgroundXpm.attributes.height,
                0,
                0
                );
	if ( state.draw_day ) {
		XCopyArea(
			mainDisplay,
			dofXpm.pixmap,
			win,
			mainGC,
			0,
			loc_time->tm_wday * 6,
			13,
			7,
			1,
			1
			);
	}
	if ( state.draw_date ) {
		XCopyArea(
			mainDisplay,
			digitsXpm.pixmap,
			win,
			mainGC,
			0,
			(loc_time->tm_mday /10) * 7,
			7,
			8,
			1,
			45
			);
		XCopyArea(
			mainDisplay,
			digitsXpm.pixmap,
			win,
			mainGC,
			0,
			(loc_time->tm_mday %10) * 7,
			7,
			8,
			8,
			45
			);
		XCopyArea(
			mainDisplay,
			monthsXpm.pixmap,
			win,
			mainGC,
			0,
			loc_time->tm_mon * 6,
			19,
			7,
			18,
			46
			);
		XCopyArea(
			mainDisplay,
			digitsXpm.pixmap,
			win,
			mainGC,
			0,
			(loc_time->tm_year %100 /10) * 7,
			7,
			8,
			38,
			45
			);
		XCopyArea(
			mainDisplay,
			digitsXpm.pixmap,
			win,
			mainGC,
			0,
			(loc_time->tm_year %10) * 7,
			7,
			8,
			45,
			45
			);
	}
#ifdef DEBUG
	mainGCV.foreground = pix[2];
        XChangeGC(
                mainDisplay,
                mainGC,
                GCForeground,
                &mainGCV
                );
	XDrawLine(
		mainDisplay,
		win,
		mainGC,
		10,
		3,
		50,
		3
		);
	XDrawLine(
		mainDisplay,
		win,
		mainGC,
		50,
		3,
		50,
		43
		);
	XDrawLine(
		mainDisplay,
		win,
		mainGC,
		50,
		43,
		10,
		43
		);
	XDrawLine(
		mainDisplay,
		win,
		mainGC,
		10,
		43,
		10,
		3
		);
#endif
	/* the pointers */
	for (i=2; i>=0; --i) {
		if ( ( i == 0 ) && ( state.draw_seconds == 0 ) ) break;
		mainGCV.foreground = pix[i];
		mainGCV.line_width = i;
		XChangeGC(
			mainDisplay,
			mainGC,
			GCForeground|GCLineWidth,
			&mainGCV
			);
		XDrawLine(
			mainDisplay,
			win,
			mainGC,
			lines[i].x1,
			lines[i].y1,
			lines[i].x2,
			lines[i].y2
			);
	}
}

/* convert the position on 0-60 scale into xy coordinates */
inline float convert2x(int tim)
{
	return cos(pi * ( ((float)(tim - 15)) * 6 ) / 180 );
}
inline float convert2y(int tim)
{
	return sin(pi * ( ((float)(tim - 15)) * 6 ) / 180 );
}

/* calculate the lines to be drawn */
void draw()
{
	float xrate, yrate;
	loc_time = localtime(&curTime);
	/* seconds */
	xrate = convert2x(loc_time->tm_sec);
	yrate = convert2y(loc_time->tm_sec);
	lines[0].x1 = 30 - rint(5 * xrate);
	lines[0].y1 = 23 - rint(5 * yrate);
	lines[0].x2 = rint(20 * xrate) + 30;
	lines[0].y2 = rint(20 * yrate) + 23;
#ifdef DEBUG
	printf("%ld sec = %d %d -> %d %d\n", 
		loc_time->tm_sec, lines[0].x1, lines[0].y1,
		lines[0].x2, lines[0].y2);
#endif
	/* minutes */
	xrate = convert2x(loc_time->tm_min);
	yrate = convert2y(loc_time->tm_min);
	lines[1].x1 = 30 - rint(2 * xrate);
	lines[1].y1 = 23 - rint(2 * yrate);
	lines[1].x2 = rint(19 * xrate) + 30;
	lines[1].y2 = rint(19 * yrate) + 23;
	/* hours */
	xrate = convert2x((loc_time->tm_hour % 12) * 5 + loc_time->tm_min/12);
	yrate = convert2y((loc_time->tm_hour % 12) * 5 + loc_time->tm_min/12);
	lines[2].x1 = 30 - rint(2 * xrate);
	lines[2].y1 = 23 - rint(2 * yrate);
	lines[2].x2 = rint(14 * xrate) + 30;
	lines[2].y2 = rint(14 * yrate) + 23;
}

/*
 * Calculate and redraw the lines corresponding to the
 * time.
 */
void refresh()
{
	draw();
	++update_request;
}

/*
 * This function clears up all X related
 * stuff and exits. It is called in case
 * of emergencies too.
 */             
void x_cleanup()
{
        if ( mainDisplay )
        {
                XCloseDisplay(mainDisplay);
        }
        exit(0);
}

/* 
 * This checks for X11 events. We distinguish the following:
 * - request to repaint the window
 * - request to quit (Close button)
 */
void CheckX11Events()
{
        XEvent Event;
        while (XPending(mainDisplay)) { 
                XNextEvent(mainDisplay, &Event);
                switch(Event.type)
                {
                case Expose:
                        if(Event.xexpose.count == 0) {
				++update_request;
			}
                        break;
                case ClientMessage:
                        if ((Event.xclient.message_type == wm_protocols)
                          && (Event.xclient.data.l[0] == wm_delete_window))
			{
#ifdef DEBUG
				printf("caught wm_delete_window, closing\n");
#endif
                                x_cleanup();
			}
                        break;
                }
        }
}

void redraw()
{
	draw_window(mainWindow);
	draw_window(iconWindow);
	update_request = 0;
}

void update()
{
	curTime = time(0);
	if ( (curTime - last_time) >= state.update_interval ) {
		last_time = curTime;
		refresh();
	}
	CheckX11Events();
	if ( update_request ) {
		redraw();
	}
}

void initialize(
			int argc, char** argv,
			char * display_name,
			char * mainGeometry,
                        int withdrawn,
                        int iconic,
                        int pushed_in)
{
	int screen;
	Status status;
	XWindowAttributes winAttr;
	Pixel back_pix, fore_pix;
	XSizeHints SizeHints;
	XTextProperty title;
	char * app_name = "astime";
	XClassHint classHint;
	int gravity;
	XWMHints WmHints;
	XEvent Event;
	int color_depth;
	int tmp;

	mainDisplay = XOpenDisplay(display_name);
	if ( ! mainDisplay ) {
		printf("astime : grrrr... can't open display %s. Sorry ...\n",
			XDisplayName(display_name));
		exit(1);
	}
	screen = DefaultScreen(mainDisplay);
	Root = RootWindow(mainDisplay, screen);
	back_pix = GetColor("white", mainDisplay, Root);
	fore_pix = GetColor("black", mainDisplay, Root);
	color_depth = DefaultDepth(mainDisplay, screen);
#ifdef DEBUG    
        printf("astime : detected color depth %d bpp, using %d bpp\n",
                color_depth, color_depth);
#endif          
	/* adjust the background pixmap */
	if (pushed_in) {
		sprintf(bgpixmap_color[0],
			". c %s",
			DarkenCharColor(state.bgcolor, 1.6, mainDisplay, Root));
		sprintf(bgpixmap_color[2],
			"q c %s",
			LightenCharColor(state.bgcolor, 2.0, mainDisplay, Root));
	} else {
		sprintf(bgpixmap_color[2],
			"q c %s",
			DarkenCharColor(state.bgcolor, 1.2, mainDisplay, Root));
		sprintf(bgpixmap_color[0],
			". c %s",
			LightenCharColor(state.bgcolor, 2.0, mainDisplay, Root));
	}
	sprintf(bgpixmap_color[1], "c c %s", state.bgcolor);
	sprintf(bgpixmap_color[3], "w c %s", state.fgcolor);
	for (tmp = 0; tmp <= 3; ++tmp)
		background[tmp+1] = bgpixmap_color[tmp];

	backgroundXpm.attributes.valuemask |=
                (XpmReturnPixels | XpmReturnExtensions);
        status = XpmCreatePixmapFromData(
                mainDisplay,                    /* display */
                Root,                           /* window */
                background,                     /* xpm */ 
                &backgroundXpm.pixmap,          /* resulting pixmap */
                &backgroundXpm.mask,
                &backgroundXpm.attributes
                );
        if(status != XpmSuccess) {
                printf("astime : (%d) not enough free color cells for background.\n", status);   
		x_cleanup();
        }       
#ifdef DEBUG
	printf("bg pixmap %d x %d\n", 
		backgroundXpm.attributes.width,
		backgroundXpm.attributes.height);
#endif
	/* The day-of-week pixmap */
	sprintf(dof_pixmap_color[0], "c c %s", state.bgcolor);
	sprintf(dof_pixmap_color[1], "l c %s", state.daycolor);
	dof[1] = dof_pixmap_color[0];
	dof[2] = dof_pixmap_color[1];
	dofXpm.attributes.valuemask |=
                (XpmReturnPixels | XpmReturnExtensions);
        status = XpmCreatePixmapFromData(
                mainDisplay,                    /* display */
                Root,                           /* window */
                dof,                     /* xpm */ 
                &dofXpm.pixmap,          /* resulting pixmap */
                &dofXpm.mask,
                &dofXpm.attributes
                );
        if(status != XpmSuccess) {
                printf("astime : (%d) not enough free color cells for day_of_week.\n", status);   
		x_cleanup();
        }       
	/* The digits pixmap */
	sprintf(digits_pixmap_color[0], "c c %s", state.bgcolor);
	sprintf(digits_pixmap_color[1], ". c %s", state.datecolor);
	digits[1] = digits_pixmap_color[0];
	digits[2] = digits_pixmap_color[1];
	digitsXpm.attributes.valuemask |=
                (XpmReturnPixels | XpmReturnExtensions);
        status = XpmCreatePixmapFromData(
                mainDisplay,                    /* display */
                Root,                           /* window */
                digits,                     /* xpm */ 
                &digitsXpm.pixmap,          /* resulting pixmap */
                &digitsXpm.mask,
                &digitsXpm.attributes
                );
        if(status != XpmSuccess) {
                printf("astime : (%d) not enough free color cells for digits.\n", status);   
		x_cleanup();
        }       
	/* The months pixmap */
	sprintf(months_pixmap_color[0], ". c %s", state.bgcolor);
	sprintf(months_pixmap_color[1], "o c %s", state.datecolor);
	months[1] = months_pixmap_color[0];
	months[2] = months_pixmap_color[1];
	monthsXpm.attributes.valuemask |=
                (XpmReturnPixels | XpmReturnExtensions);
        status = XpmCreatePixmapFromData(
                mainDisplay,                    /* display */
                Root,                           /* window */
                months,                     /* xpm */ 
                &monthsXpm.pixmap,          /* resulting pixmap */
                &monthsXpm.mask,
                &monthsXpm.attributes
                );
        if(status != XpmSuccess) {
                printf("astime : (%d) not enough free color cells for months.\n", status);   
		x_cleanup();
        }       

        SizeHints.flags= USSize|USPosition|PMinSize|PMaxSize;
        SizeHints.x = 0; 
        SizeHints.y = 0; 
        XWMGeometry(
                mainDisplay,
                screen,
                mainGeometry,
                NULL,
                1,
                & SizeHints,
                &SizeHints.x,
                &SizeHints.y,
                &SizeHints.width,
                &SizeHints.height,
                &gravity
                );
        SizeHints.min_width =
        SizeHints.max_width =
        SizeHints.width = backgroundXpm.attributes.width;
        SizeHints.min_height =
        SizeHints.max_height =
        SizeHints.height= backgroundXpm.attributes.height;

        mainWindow = XCreateSimpleWindow(
                mainDisplay,            /* display */
                Root,                   /* parent */
                SizeHints.x,            /* x */
                SizeHints.y,            /* y */
                SizeHints.width,        /* width */
                SizeHints.height,       /* height */
                0,                      /* border_width */
                fore_pix,               /* border */
                back_pix                /* background */
                );
                
        iconWindow = XCreateSimpleWindow(
                mainDisplay,            /* display */
                Root,                   /* parent */
                SizeHints.x,            /* x */
                SizeHints.y,            /* y */
                SizeHints.width,        /* width */
                SizeHints.height,       /* height */
                0,                      /* border_width */
                fore_pix,               /* border */
                back_pix                /* background */
                );
                
        XSetWMNormalHints(mainDisplay, mainWindow, &SizeHints);
        status = XClearWindow(mainDisplay, mainWindow);
        
        status = XGetWindowAttributes(
                mainDisplay,    /* display */
                mainWindow,     /* window */
                & winAttr       /* window_attributes_return */
                );
        status = XSetWindowBackgroundPixmap(
                mainDisplay,            /* display */
                mainWindow,             /* window */
                backgroundXpm.pixmap    /* background_pixmap */
                );
        status = XSetWindowBackgroundPixmap(
                mainDisplay,            /* display */
                iconWindow,             /* window */
                backgroundXpm.pixmap    /* background_pixmap */
                );
                
        status = XStringListToTextProperty(&app_name, 1, &title);
        XSetWMName(mainDisplay, mainWindow, &title);
        XSetWMName(mainDisplay, iconWindow, &title);
        
        classHint.res_name = "astime" ;
        classHint.res_class = "ASTIME";
        XSetClassHint(mainDisplay, mainWindow, &classHint);
        XStoreName(mainDisplay, mainWindow, "astime");
        XSetIconName(mainDisplay, mainWindow, "astime");

        status = XSelectInput(
                mainDisplay,    /* display */
                mainWindow,     /* window */
                ExposureMask    /* event_mask */
                );
                
        status = XSelectInput(
                mainDisplay,    /* display */
                iconWindow,     /* window */
                ExposureMask    /* event_mask */
                );
                
        /* Creating Graphics context */
        mainGCV.foreground = fore_pix;
        mainGCV.background = back_pix;
        mainGCV.graphics_exposures = False;
        mainGCV.line_style = LineSolid;
        mainGCV.fill_style = FillSolid;
        mainGCV.line_width = 1;
        mainGC = XCreateGC(
                mainDisplay,
                mainWindow, 
                GCForeground|GCBackground|GCLineWidth|
                        GCLineStyle|GCFillStyle,
                &mainGCV
                );
                
        status = XSetCommand(mainDisplay, mainWindow, argv, argc);
        
        /* Set up the event for quitting the window */
        wm_delete_window = XInternAtom(
                mainDisplay, 
                "WM_DELETE_WINDOW",     /* atom_name */
                False                   /* only_if_exists */
                );
        wm_protocols = XInternAtom(
                mainDisplay,
                "WM_PROTOCOLS",         /* atom_name */
                False                   /* only_if_exists */
                );
        status = XSetWMProtocols(
                mainDisplay, 
                mainWindow,
                &wm_delete_window,
                1
                );
        status = XSetWMProtocols(
                mainDisplay, 
                iconWindow,
                &wm_delete_window,
                1
                );
                
        WmHints.flags = StateHint | IconWindowHint;
        WmHints.initial_state = 
                withdrawn ? WithdrawnState :
                        iconic ? IconicState : NormalState;
        WmHints.icon_window = iconWindow;
        if ( withdrawn ) {
                WmHints.window_group = mainWindow;
                WmHints.flags |= WindowGroupHint;
        }       
        if ( iconic || withdrawn ) {
                WmHints.icon_x = SizeHints.x;
                WmHints.icon_y = SizeHints.y;
                WmHints.flags |= IconPositionHint;
        }       
        XSetWMHints(
                mainDisplay,
                mainWindow, 
                &WmHints);
                
        /* Finally show the window */
        status = XMapWindow(
                mainDisplay,
                mainWindow
                );
                
	/* Get colors while waiting for Expose */
	pix[0] = GetColor(state.seccolor, mainDisplay, Root);
	pix[1] = GetColor(state.mincolor, mainDisplay, Root);
	pix[2] = GetColor(state.hourcolor, mainDisplay, Root);
	/*pix[1] = DarkenColor(state.fgcolor, 1.2, mainDisplay, Root);
	pix[2] = DarkenColor(state.fgcolor, 1.4, mainDisplay, Root);*/

	/* try to read the time */
	curTime = time(0);
	last_time = curTime;
	refresh();

        /* wait for the Expose event now */
        XNextEvent(mainDisplay, &Event); 
        /* We 've got Expose -> draw the parts of the window. */
        redraw(); 
        XFlush(mainDisplay);
}

