/*
 * astime is an analogue clock utility for X Windows.
 * Copyright (c) 1998  Albert Dorofeev <Albert@mail.dma.be>
 * For the updates see http://bewoner.dma.be/Albert/linux/
 *
 * This software is distributed under GPL. For details see LICENSE file.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "safecopy.h"

#include "astime_x.h"
#include "state.h"

extern struct astime_state state;

/*
 * default check and update intervals in microseconds
 *      x11 events - every 1/100 th of a second (in mks)
 *      update dial - every second (in sec)
 */
#define X11_INTERVAL    10000L
#define CHK_INTERVAL    1

int     withdrawn = 0;
int     iconic = 0;
int     pushed_in = 1;
char    display_name[50];
char    mainGeometry[50];

void defaults()
{
	state.update_interval = CHK_INTERVAL;
	state.draw_seconds = 1;
	state.draw_day = 1;
	state.draw_date = 1;
	withdrawn = 0;
	iconic = 0; 
	pushed_in = 1;
	safecopy(display_name, "", 50);
	safecopy(mainGeometry, "", 50);
	safecopy(state.bgcolor, "#385971", 50);
	safecopy(state.fgcolor, "#efc669", 50);
	safecopy(state.seccolor, "#efc669", 50);
	safecopy(state.mincolor, "#ff3030", 50);
	safecopy(state.hourcolor, "#ef3838", 50);
	safecopy(state.daycolor, "#a0a0a0", 50);
	safecopy(state.datecolor, "#a0a0a0", 50);
}

/* print the usage for the tool */
void usage() 
{
        printf("Usage : astime [options ...]\n\n");
        printf("-V              print version and exit\n");
        printf("-h -H -help     print this message\n");
        printf("-u <secs>       the update interval in seconds\n");
        printf("-nosec		don't draw the second pointer\n");
        printf("-noday		don't show the day of the week\n");
        printf("-nodate		don't show the date\n");
        printf("-display <name> the name of the display to use\n");
        printf("-position <xy>  position on the screen (geometry)\n");
        printf("-withdrawn      start in withdrawn shape (for WindowMaker)\n");
        printf("-iconic         start iconized\n");
        printf("-standout       standing out rather than being pushed in\n");
	printf("-bg <color>	background color\n");
	printf("-fg <color>	dial foreground color\n");
	printf("-sec <color>	second pointer color\n");
	printf("-min <color>	minute pointer color\n");
	printf("-hour <color>	hour pointer color\n");
	printf("-day <color>	day of the week display color\n");
	printf("-date <color>	date display color\n");
        printf("\n");
        exit(0);
}       

/* print the version of the tool */
void version()
{
        printf("astime : AfterStep analogue clock version 1.0\n");
}               

void    parsecmdline(int argc, char *argv[])
{
        char    *argument;
        int     i;

	/* parse the command line */
        for (i=1; i<argc; i++) {
                argument=argv[i];
                if (argument[0]=='-') {
                        if (!strncmp(argument,"-withdrawn",10)) {
                                withdrawn=1;
                        } else if (!strncmp(argument,"-iconic",7)) {
                                iconic=1;
                        } else if (!strncmp(argument,"-standout",9)) {
                                pushed_in=0;
                        } else if (!strncmp(argument,"-u",2)) {
                                if (++i >= argc)
                                        usage();
                                state.update_interval = atoi(argv[i]);
                                if ( state.update_interval < 1 )  
                                        state.update_interval = CHK_INTERVAL;
                        } else if (!strncmp(argument,"-nosec",6)) {
                                state.draw_seconds=0;
                        } else if (!strncmp(argument,"-noday",6)) {
                                state.draw_day=0;
                        } else if (!strncmp(argument,"-nodate",7)) {
                                state.draw_date=0;
                        } else if (!strncmp(argument,"-position",9)) {
                                if (++i >= argc)
                                        usage();
                                safecopy(mainGeometry, argv[i], 50);
                        } else if (!strncmp(argument,"-display",8)) {
                                if (++i >= argc)
                                        usage();
                                safecopy(display_name, argv[i], 50);
			} else if (!strncmp(argument,"-bg",3)) {
				if (++i >= argc)
					usage();
				safecopy(state.bgcolor, argv[i], 50);
			} else if (!strncmp(argument,"-fg",3)) {
				if (++i >= argc)
					usage();
				safecopy(state.fgcolor, argv[i], 50);
			} else if (!strncmp(argument,"-sec",4)) {
				if (++i >= argc)
					usage();
				safecopy(state.seccolor, argv[i], 50);
			} else if (!strncmp(argument,"-min",4)) {
				if (++i >= argc)
					usage();
				safecopy(state.mincolor, argv[i], 50);
			} else if (!strncmp(argument,"-hour",5)) {
				if (++i >= argc)
					usage();
				safecopy(state.hourcolor, argv[i], 50);
			} else if (!strncmp(argument,"-day",4)) {
				if (++i >= argc)
					usage();
				safecopy(state.daycolor, argv[i], 50);
			} else if (!strncmp(argument,"-date",5)) {
				if (++i >= argc)
					usage();
				safecopy(state.datecolor, argv[i], 50);
                        } else if (!strncmp(argument,"-V",2)) { 
                                version();
                                exit(0);
                        } else if (!strncmp(argument,"-H",2)) {
                                version();
                                usage();
                        } else if (!strncmp(argument,"-h",2)) {
                                version();
                                usage();
                        } else {
                                version();
                                usage();
                        }       
                } else {
                        version();
                        usage();
                }       
        }       
 
}

void main(int argc, char** argv)
{
	defaults();
	parsecmdline(argc, argv);
	initialize(argc, argv, 
			display_name, 
			mainGeometry, 
			withdrawn, 
			iconic, 
			pushed_in);
	while (1) {
		update();
		usleep(X11_INTERVAL);
	}
}

