/* asppp version 0.1.1 ALPHA*/

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/extensions/shape.h>
#include <X11/xpm.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include "asppp.h"

XpmIcon *current, *Dial, *HUP, *Exit;

/* global flags */
char *progname;
char szHangupCmd [2048];
char szDailCmd [2048];
int wharfShape = 0, ppp, chppp = 5;
Display *dpy;
GC aspppGC;
XGCValues gcv;
Window aspppWindow;
Widget mainWindow;
unsigned long gcm;
XtAppContext asppp;


void evaluateArg (int argc, char **argv);
void showUsage (int bExecute, char const * const pszMsg);


/* main */
int main (int argc, char **argv)
{
	progname = argv[0];
	strcpy (szDailCmd,  "/usr/sbin/pppd");
	strcpy (szHangupCmd, "killall pppd");

	evaluateArg (argc, argv);

	ppp = pppcheck();
	if (ppp < 0)
	{
		fprintf(stderr, "%s: /proc filesystem must be enabled in 
			the kernel for %s to work.\n", progname, progname);
		exit(-1);
	}

	mainWindow = XtAppInitialize (&asppp, "asppp", NULL, 0, &argc, argv, 
		NULL , NULL, 0);
	dpy = XtDisplay(mainWindow);
	aspppWindow = RootWindow(dpy, DefaultScreen(dpy));	

	XtAddEventHandler(mainWindow, ExposureMask, FALSE, 
		(XtEventHandler)ExposureHandler, NULL);
	XtAddEventHandler(mainWindow, ButtonPressMask, FALSE, 
		(XtEventHandler)ButtonHandler, NULL);

	XPMInit();
	XtVaSetValues(mainWindow, XtNwidth, 48, XtNheight, 48, NULL);
	XtRealizeWidget (mainWindow);

	gcm = GCForeground|GCBackground|GCGraphicsExposures;
	gcv.foreground = GetColor("white");
	gcv.background = GetColor("black");
	gcv.graphics_exposures = 0;
	aspppGC = XCreateGC (dpy, aspppWindow, gcm, &gcv);

	XtMapWidget(mainWindow);
	windowRedraw();

	XtAppAddTimeOut(asppp, chppp * 1000, (XtTimerCallbackProc)UpdatePPP, NULL);

	XtAppMainLoop (asppp);
	return(0);
}



void evaluateArg (int argc, char **argv)
{
    int i;
    for (i=1; i<argc; i++)
    {
        if (0 == strcmp("-wharfShape", argv[i]))
        {
          wharfShape = 1;
        }
        else if (0 == strcmp("-dailCmd", argv[i]))
	{
	    showUsage(i + 1 >= argc , "error: missing dail command string\n");
            strncpy (szDailCmd, argv[i+1], sizeof(szDailCmd));
	    ++i;
	}
        else if (0 == strcmp("-hangupCmd", argv[i]))
	{
	    showUsage(i + 1 >= argc , "error: missing hangup command string\n");
            strncpy (szHangupCmd, argv[i+1], sizeof(szHangupCmd));
	    ++i;
	}
	else 
	{
	    showUsage(TRUE, "");
	}
    }
}


void showUsage (int bExecute, char const * const pszMsg)
{
    if (!bExecute)
    {
	return;
    }
    printf ("    %s\n    usage %s [-wharfShape] [-dailCmd <cmd>] [-hangupCmd <cmd>]\n", pszMsg, progname);
    printf ("    version 0.1.3\n");
    exit (0);
}
