#include <X11/Intrinsic.h> 
#include <X11/xpm.h>
#include <malloc.h>
#include <stdio.h>

#include "asppp.h"
#include "dial.xpm"
#include "hangup.xpm"
#include "exit.xpm"

extern int wharfShape, ppp;
extern Display *dpy;
extern Window aspppWindow;
XpmIcon *current, *Dial, *HUP, *Exit;

void XPMError (int errcode)
{
	switch (errcode)
	{
		case 0:
			break;
		case 1:
		case -4:
			fprintf(stderr, "asppp: not enough free color cells\n");
			break;
		case -1:
		case -2:
			fprintf(stderr, "asppp: could not load xpm\n");
			break;
		case -3:
			fprintf(stderr, "asppp: not enough memory free\n");
			break;                                           
		default:
			fprintf(stderr, "asppp: unknown xpm error\n");
			break;
	}

	if (errcode != 0)
		exit(1);
}

void XPMInit (void)
{
	Dial = (XpmIcon *) malloc(sizeof(XpmIcon));
	HUP = (XpmIcon *) malloc(sizeof(XpmIcon));
	Exit = (XpmIcon *) malloc(sizeof(XpmIcon));
	
	/* Dial Icon */
	XPMError (XpmCreatePixmapFromData(dpy, aspppWindow, dial_xpm, 
		&Dial->pixmap, &Dial->mask, &Dial->attributes));
	Dial->exec_flag = 0;
	Dial->exec_name = szDailCmd;

	/* HUP Icon */
	XPMError (XpmCreatePixmapFromData(dpy, aspppWindow, hangup_xpm, 
		&HUP->pixmap, &HUP->mask, &HUP->attributes));
	HUP->exec_flag = 0;
	HUP->exec_name = szHangupCmd; 

	/* Exit Icon */
	XPMError (XpmCreatePixmapFromData(dpy, aspppWindow, exit_xpm, 
		&Exit->pixmap, &Exit->mask, &Exit->attributes));
	Exit->exec_flag = 1;
	Exit->exec_name = NULL;	

	if (ppp)
	{
		current = HUP;
		if (wharfShape)
		{
			(XpmIcon *) HUP->next_xpm = HUP;
			(XpmIcon *) Dial->next_xpm = Dial;
		} else {
			(XpmIcon *) HUP->next_xpm = Exit;
			(XpmIcon *) Dial->next_xpm = Exit;
			(XpmIcon *) Exit->next_xpm = HUP;
		}
	} else {
		current = Dial;
		if (wharfShape)
		{
			(XpmIcon *) Dial->next_xpm = Dial;
			(XpmIcon *) HUP->next_xpm = HUP;
		} else {
			(XpmIcon *) Dial->next_xpm = Exit;
			(XpmIcon *) HUP->next_xpm = Exit;
			(XpmIcon *) Exit->next_xpm = Dial;
		}
	}
}
