/* asppp version 0.1.1 ALPHA*/

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/extensions/shape.h>
#include <X11/xpm.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include "asppp.h"

XpmIcon *current, *Dial, *HUP, *Exit;

/* global flags */
char *progname;
int wharfShape = 1, ppp, chppp = 5;
Display *dpy;
GC aspppGC;
XGCValues gcv;
Window aspppWindow;
Widget mainWindow;
unsigned long gcm;
XtAppContext asppp;

/* main */
int main (int argc, char **argv)
{
	int i;

	progname = argv[0];

        for (i=1; i<argc; i++)
        {
                if (strcmp("-NoWharfShape", argv[i]) == 0) wharfShape=0;
        }

	ppp = pppcheck();
	if (ppp < 0)
	{
		fprintf(stderr, "%s: /proc filesystem must be enabled in 
			the kernel for %s to work.\n", progname, progname);
		exit(-1);
	}

	mainWindow = XtAppInitialize (&asppp, "asppp", NULL, 0, &argc, argv, 
		NULL , NULL, 0);
	dpy = XtDisplay(mainWindow);
	aspppWindow = RootWindow(dpy, DefaultScreen(dpy));	

	XtAddEventHandler(mainWindow, ExposureMask, FALSE, 
		(XtEventHandler)ExposureHandler, NULL);
	XtAddEventHandler(mainWindow, ButtonPressMask, FALSE, 
		(XtEventHandler)ButtonHandler, NULL);

	XPMInit();
	XtVaSetValues(mainWindow, XtNwidth, 48, XtNheight, 48, NULL);
	XtRealizeWidget (mainWindow);

	gcm = GCForeground|GCBackground|GCGraphicsExposures;
	gcv.foreground = GetColor("white");
	gcv.background = GetColor("black");
	gcv.graphics_exposures = 0;
	aspppGC = XCreateGC (dpy, aspppWindow, gcm, &gcv);

	XtMapWidget(mainWindow);
	windowRedraw();

	XtAppAddTimeOut(asppp, chppp * 1000, (XtTimerCallbackProc)UpdatePPP, NULL);

	XtAppMainLoop (asppp);
	return(0);
}
