/*
 * Copyright (c) 1991 David A. Curry <davy@itstd.sri.com>
 * Copyright (c) 1996 Michael J. Hammel <mjhammel@csn.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * plaid.c - routines for manipulating the plaid widget.
 *
 * You can get David A. Curry's original public domain version on :
 * ftp://ftp.ers.ibm.com/pub/davy/xpostit3.3.2.tar.gz
 * 
 */

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <stdio.h>

#include "xpostit.h"
#include "template.h"

Widget		plaidwidget;

/*
 * CreatePlaidWidget - create the plaid widget.
 */
void
CreatePlaidWidget()
{
	Arg args[4];
	register int nargs;
	Dimension width, height;

	/*
	 * Create the plaid widget.
	 */
	plaidwidget = XtCreateWidget("Plaid", plaidWidgetClass, toplevel,
				     NULL, 0);

	XtAddCallback(plaidwidget, XtNlowerCallback, LowerAllNotes, 0);
	XtAddCallback(plaidwidget, XtNraiseCallback, RaiseAllNotes, 0);
	
	/*
	 * Get the width and height of the widget.
	 */
	XtSetArg(args[0], XtNwidth, &width);
	XtSetArg(args[1], XtNheight, &height);
	XtGetValues(plaidwidget, args, 2);

	XtSetArg(args[0], XtNwidth, width);
	XtSetArg(args[1], XtNheight, height);

	/*
	 * If the user didn't set them, then we
	 * should set them to the defaults.
	 */
	nargs=0;
	if ((args[0].value == 0) || (args[1].value == 0)) {
		if (args[0].value == 0) {
			XtSetArg(args[0], XtNwidth, DefaultPlaidWidth);
			nargs++;
		}

		if (args[1].value == 0) {
			XtSetArg(args[1], XtNheight, DefaultPlaidHeight);
			nargs++;
		}

		XtSetValues(plaidwidget, args, nargs);
	}

	/*
	 * Inform the application shell we're here.
	 */
	XtManageChild(plaidwidget);
}
