/*
 * Copyright (c) 1998 Guylhem Aznar <guylhem@oeil.qc.ca>
 * Copyright (c) 1991 David A. Curry <davy@itstd.sri.com>
 * Copyright (c) 1996 Michael J. Hammel <mjhammel@csn.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * plaid.h - private definitions for the plaid widget.
 *
 */

#ifndef _template_h
#define _template_h

/*
 * Resources:
 *
 * Name		     Class		RepType		Default Value
 * ----		     -----		-------		-------------
 * background	     Background		Pixel		XtDefaultBackground
 * border	     BorderColor	Pixel		XtDefaultForeground
 * borderWidth	     BorderWidth	Dimension	1
 * callback	     Callback		Callback	NULL
 * destroyCallback   Callback		Pointer		NULL
 * foreground	     Foreground		Pixel		XtDefaultForeground
 * height	     Height		Dimension	0
 * lowerCallback     Callback		Pointer		NULL
 * raiseCallback     Callback		Pointer		NULL
 * mappedWhenManaged MappedWhenManaged	Boolean		True
 * sensitive	     Sensitive		Boolean		True
 * width	     Width		Dimension	0
 * x		     Position		Position	0
 * y		     Position		Position	0
 */

/*
 * Declare specific PlaidWidget class and instance datatypes.
 */
typedef struct _PlaidClassRec*		PlaidWidgetClass;
typedef struct _PlaidRec*		PlaidWidget;

/*
 * Declare the class constant.
 */
extern WidgetClass			plaidWidgetClass;

/*
 * Declare a couple of new resources.
 */
#define XtNlowerCallback		"lowerCallback"
#define XtNraiseCallback		"raiseCallback"

#endif /* _template_h */
