/*
 * Copyright (c) 1991 David A. Curry <davy@itstd.sri.com>
 * Copyright (c) 1996 Michael J. Hammel <mjhammel@csn.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * menu.c - routines to handle the menu.
 *
 * You can get David A. Curry's original public domain version on :
 * ftp://ftp.ers.ibm.com/pub/davy/xpostit3.3.2.tar.gz
 *
 *
 */

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Shell.h>
#include <stdio.h>

#include "xpostit.h"

static String menustrings[] = {
#define MenuCreate_1p5x2	0
	"Create 1.5x2 Note",
#define MenuCreate_2x3		1
	"Create 2x3 Note",
#define MenuCreate_3x3		2
	"Create 3x3 Note",
#define MenuCreate_3x4		3
	"Create 3x4 Note",
#define MenuCreate_3x5		4
	"Create 3x5 Note",
#define MenuCreate_4x6		5
	"Create 4x6 Note",
#define EndNoteTypes		6
	" ",
#define MenuRaiseAll		7
	"Raise All Notes",
#define MenuLowerAll		8
	"Lower All Notes",
#define MenuSaveAll		9
	"Save All Notes",
#define MenuShowHidden		10
	"Hidden Notes",
#define MenuUnHideAll		11
	"Unhide All Notes",
#define MenuCascade		12
	"Cascade Notes",
#define MenuFindANote		13
	"Find A Note",
#define EndNoteFunctions	14
	" ",
#define MenuExit		15
	"Exit",
#define MenuLastEntry		16
	0,
};

Widget			menuwidget, hiddennotes;
extern XtAppContext	appcontext;
static void		HandleMenuSelection();

/*
 * CreateMenuWidget - create the widget used for the menu.
 */
void
CreateMenuWidget()
{
	Arg args[8];
	Widget entry;
	register int i, nargs;
	XtCallbackRec callbacks[2];

	/*
	 * Set the callback.
	 */
	bzero(callbacks, sizeof(callbacks));
	SetCallback(HandleMenuSelection, NULL);

	/*
	 * Create the menu widget.
	 */
	nargs = 0;
	SetArg(XtNmenuOnScreen, True);
	SetArg(XtNlabel, PostItNoteClass);

	/*
	 * The menu is done with a popup shell.
	 */
	menuwidget = XtCreatePopupShell("Menu", simpleMenuWidgetClass,
					toplevel, args, nargs);

	for (i=0; menustrings[i] != NULL; i++)
	{
		switch (i)
		{
			case EndNoteTypes:
			case EndNoteFunctions:
				entry = XtCreateManagedWidget(menustrings[i],
						smeLineObjectClass, menuwidget,
						NULL, 0);
				break;

			default:
				entry = XtCreateManagedWidget(menustrings[i],
						smeBSBObjectClass, menuwidget,
						NULL, 0);
				XtAddCallback(entry, XtNcallback, 
					HandleMenuSelection, (XtPointer)i);
				break;
		}
	}
		
}

/*
 * HandleMenuSelection - callback from menu widget to handle a selection.
 */
static void
HandleMenuSelection(w, client_data, call_data)
caddr_t client_data, call_data;
Widget w;
{
	/*
	 * Dispatch the command.
	 */
	switch ((int) client_data) {
	case MenuCreate_1p5x2:
		CreateNewNote(PostItNote_1p5x2);
		break;
	case MenuCreate_2x3:
		CreateNewNote(PostItNote_2x3);
		break;
	case MenuCreate_3x3:
		CreateNewNote(PostItNote_3x3);
		break;
	case MenuCreate_3x4:
		CreateNewNote(PostItNote_3x4);
		break;
	case MenuCreate_3x5:
		CreateNewNote(PostItNote_3x5);
		break;
	case MenuCreate_4x6:
		CreateNewNote(PostItNote_4x6);
		break;
	case MenuRaiseAll:
		RaiseAllNotes();
		break;
	case MenuLowerAll:
		LowerAllNotes();
		break;
	case MenuSaveAll:
		SaveAllNotes(True);
		break;
	case MenuShowHidden:
		PopUpList();
		break;
	case MenuUnHideAll:
		UnHideAllNotes();
		break;
	case MenuCascade:
		CascadeNotes();
		break;
	case MenuFindANote:
		MakeNoteListCB();
		break;
	case MenuExit:
		ByeBye();
		break;
	}
}
