#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <stdarg.h>    

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <gdk/gdkkeysyms.h>
#include "as.h"

#define CON_STARTRC     (NULL)
#define CON_STOPRC      (NULL)
#define WARNISRC        (NULL)
#define WARNINGRC       (NULL)
#define WARNMSGRC       (NULL)     
#define CDELAYRC        (NULL)
#define CSYMBOLRC       (NULL)
#define CPOSITIONRC     (NULL)
#define LOGISRC         (NULL)
#define RULESRC         (NULL)
#define ACTCOSTRC       (NULL)
#define DEFAULT0        (NULL)
#define MONDAY          (NULL)
#define TUESDAY         (NULL)
#define WEDNESDAY       (NULL)
#define THURSDAY        (NULL)
#define FRIDAY          (NULL)
#define SATURDAY        (NULL)
#define SUNDAY          (NULL)
#define HOLYDAY         (NULL) 

  GtkWidget *csymbol;
  GtkWidget *cact;
  GtkWidget *cfile;
  GtkWidget *cposition;
  GtkWidget *cwarn;
  GtkWidget *cwarntime;
  GtkWidget *cwarnmsg;
  GtkWidget *cdelay;
  GtkWidget *clogs;
  GtkWidget *cp_1;
  GtkWidget *cp_2;
  GtkWidget *cw_1;
  GtkWidget *cw_2;
  GtkWidget *cl_1;
  GtkWidget *cl_2;
  GtkWidget *dfh;
  GtkWidget *dfm;
  GtkWidget *dth;
  GtkWidget *dtm;
  GtkWidget *du;
  GtkWidget *da;
  GtkWidget *df;
  GtkWidget *dfa;
  GtkWidget *fm_r;
  GtkWidget *fh_r;
  GtkWidget *tm_r;
  GtkWidget *th_r;
  GtkWidget *u_r;
  GtkWidget *f_r;
  GtkWidget *fa_r;
  GtkWidget *a_r;
  GtkWidget *frmAbout;  
  GtkWidget *frmerror;  
  GtkWidget *mon;
  GtkWidget *sat;
  GtkWidget *fri;
  GtkWidget *thu;
  GtkWidget *wed;
  GtkWidget *tue;
  GtkWidget *sun;
  GtkWidget *h_day;
  GtkWidget *h_mon;
  GtkWidget *h_con;
  GtkWidget *h_dcon;
  GtkWidget *list;
  GtkWidget *listr;
  GtkWidget       *list_item;

const   gchar   *list_item_data_key="list_item_data";  

int 	is_mon=1, is_tue=0, is_wed=0, is_thu=0, is_fri=0, is_sat=0, is_sun=0;
int 	is_ac_1=0, is_ac_2=0, is_ac_3=0;
int 	is_cp=0;
int 	is_cw=1;
int 	is_cl=1;
int 	copy_from = 8;
int 	listr_row = 0;
int 	listh_row = 0;
int 	maxholi = 0, maxmon, maxtue, maxwed, maxthu, maxfri, maxsat, maxsun;

char    *con_startrc = NULL;
char    *con_stoprc = NULL;
char    *warnisrc = NULL;
char    *warningrc = NULL;
char    *warnmsgrc = NULL;
char    *cdelayrc = NULL;
char    *csymbolrc = NULL;
char    *cpositionrc = NULL;
char    *logisrc = NULL;         
char    *rulesrc = NULL;
char    *actcostrc = NULL;

char    *default0 = NULL;
char    *monday = NULL;
char    *tuesday = NULL;
char    *wednesday = NULL;
char    *thursday = NULL;
char    *friday = NULL;
char    *saturday = NULL;         
char    *sunday = NULL;
char    *holyday = NULL;
                           

char    *wdays[9]= {NULL,"sunday","monday","tuesday","wednesday","thursday","friday","saturday","default"};
gchar           buffer[64]; 
gchar           mlabel[64];
 

void on_frmAbout_destroy ();

        /* rc keys */

        rckeys aspbm_keys[] = {
                { "connect_start", &con_startrc },
                { "connect_stop", &con_stoprc },
                { "warn", &warnisrc },
                { "warning", &warningrc },
                { "warnmsg", &warnmsgrc },
                { "delay", &cdelayrc },
                { "log", &logisrc },
                { "rules", &rulesrc },
                { NULL, NULL }
        };                                 

        rckeys rules_keys[] = {
                { "currency_symbol", &csymbolrc },
                { "currency_position", &cpositionrc },
                { "activation_cost", &actcostrc },
                { "default", &default0 },
                { "monday", &monday },
                { "tuesday", &tuesday },
                { "wednesday", &wednesday },
                { "thursday", &thursday },
                { "friday", &friday },
                { "saturday", &saturday },
                { "sunday", &sunday },
                { "holydays", &holyday },
                { NULL, NULL }
        };                             

RULES_STRUCT    phone_rules[33];
HRULES_STRUCT   hrules[20];   
            

void defaults() {

int 	max=0;

        maxsun=rule(sunday,1);
        maxmon=rule(monday,2);
        maxtue=rule(tuesday,3);
        maxwed=rule(wednesday,4);
        maxthu=rule(thursday,5);
        maxfri=rule(friday,6);
        maxsat=rule(saturday,7);
        max=rule(default0,8);
        maxholi=hrule(holyday);            
} 

GtkWidget* create_frmAbout ()
{
  GtkWidget *frmAbout;
  GtkWidget *fixed1;
  GtkWidget *lblLicense;
  GtkWidget *lblEmail;
  GtkWidget *lblURL;
  GtkWidget *lblCopyleft;
  GtkWidget *lblVersion;
  GtkWidget *lblTitle;
  GtkWidget *pixmap2;

  frmAbout = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (frmAbout), "frmAbout", frmAbout);
  gtk_widget_set_usize (frmAbout, 300, 200);
  gtk_signal_connect_object (GTK_OBJECT (frmAbout), "destroy",
                             GTK_SIGNAL_FUNC (on_frmAbout_destroy),
                             GTK_OBJECT (frmAbout));
  gtk_window_set_title (GTK_WINDOW (frmAbout), "About...");
  gtk_window_set_policy (GTK_WINDOW (frmAbout), TRUE, TRUE, FALSE);

  fixed1 = gtk_fixed_new ();
  gtk_object_set_data (GTK_OBJECT (frmAbout), "fixed1", fixed1);
  gtk_widget_show (fixed1);
  gtk_container_add (GTK_CONTAINER (frmAbout), fixed1);

  lblLicense = gtk_label_new ("Released under the GNU Public License");
  gtk_object_set_data (GTK_OBJECT (frmAbout), "lblLicense", lblLicense);
  gtk_widget_show (lblLicense);
  gtk_fixed_put (GTK_FIXED (fixed1), lblLicense, 8, 160);
  gtk_widget_set_usize (lblLicense, 288, 16);

  lblEmail = gtk_label_new ("moleiro@ip.pt");
  gtk_object_set_data (GTK_OBJECT (frmAbout), "lblEmail", lblEmail);
  gtk_widget_show (lblEmail);
  gtk_fixed_put (GTK_FIXED (fixed1), lblEmail, 8, 96);
  gtk_widget_set_usize (lblEmail, 288, 16);

  lblURL = gtk_label_new ("www.ip.pt/~ip241956/aspbm/aspbm.html");
  gtk_object_set_data (GTK_OBJECT (frmAbout), "lblURL", lblURL);
  gtk_widget_show (lblURL);
  gtk_fixed_put (GTK_FIXED (fixed1), lblURL, 8, 80);
  gtk_widget_set_usize (lblURL, 288, 16);

  lblCopyleft = gtk_label_new ("Copyleft (c) 1999");
  gtk_object_set_data (GTK_OBJECT (frmAbout), "lblCopyleft", lblCopyleft);
  gtk_widget_show (lblCopyleft);           
  gtk_fixed_put (GTK_FIXED (fixed1), lblCopyleft, 8, 64);
  gtk_widget_set_usize (lblCopyleft, 288, 16);

  lblVersion = gtk_label_new ("1.1");
  gtk_object_set_data (GTK_OBJECT (frmAbout), "lblVersion", lblVersion);
  gtk_widget_show (lblVersion);
  gtk_fixed_put (GTK_FIXED (fixed1), lblVersion, 8, 40);
  gtk_widget_set_usize (lblVersion, 288, 16);

  lblTitle = gtk_label_new ("About - aspbm configuration");
  gtk_object_set_data (GTK_OBJECT (frmAbout), "lblTitle", lblTitle);
  gtk_widget_show (lblTitle);
  gtk_fixed_put (GTK_FIXED (fixed1), lblTitle, 8, 8);
  gtk_widget_set_usize (lblTitle, 288, 32);

  return frmAbout;
}

void on_frmAbout_destroy (GtkObject *object, gpointer user_data)
{
        gtk_widget_hide (frmAbout);
}  

void on_About_activate (GtkMenuItem *menuitem, gpointer user_data)
{
        frmAbout = create_frmAbout();
        gtk_widget_show (frmAbout);
}  
                           
void on_frmerror_destroy (GtkObject *object, gpointer user_data)
{
        gtk_widget_hide (frmerror);
}  

GtkWidget* create_error_msg (int i)
{
  GtkWidget *frmerror;
  GtkWidget *fixed1;
  GtkWidget *lblTitle;

  frmerror = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (frmerror), "frmerror", frmerror);
  gtk_widget_set_usize (frmerror, 300, 50);
  gtk_signal_connect_object (GTK_OBJECT (frmerror), "destroy",
                             GTK_SIGNAL_FUNC (on_frmerror_destroy),
                             GTK_OBJECT (frmerror));
  gtk_window_set_title (GTK_WINDOW (frmerror), "Error message...");
  gtk_window_set_policy (GTK_WINDOW (frmerror), TRUE, TRUE, FALSE);

  fixed1 = gtk_fixed_new ();
  gtk_object_set_data (GTK_OBJECT (frmerror), "fixed1", fixed1);
  gtk_widget_show (fixed1);
  gtk_container_add (GTK_CONTAINER (frmerror), fixed1);

  lblTitle = gtk_label_new ("Error in configuration ...");
  gtk_object_set_data (GTK_OBJECT (frmerror), "lblTitle", lblTitle);
  gtk_widget_show (lblTitle);
  gtk_fixed_put (GTK_FIXED (fixed1), lblTitle, 8, 8);
  gtk_widget_set_usize (lblTitle, 288, 25);

  lblTitle = gtk_label_new (wdays[i]);
  gtk_object_set_data (GTK_OBJECT (frmerror), "lblTitle", lblTitle);
  gtk_widget_show (lblTitle);
  gtk_fixed_put (GTK_FIXED (fixed1), lblTitle, 8, 30);
  gtk_widget_set_usize (lblTitle, 288, 25);

  return frmerror;
}

GtkWidget *create_arrow_button( GtkArrowType  arrow_type,
                                     GtkShadowType shadow_type )
     {
       GtkWidget *button;
       GtkWidget *arrow;

       button = gtk_button_new();
       arrow = gtk_arrow_new (arrow_type, shadow_type);

       gtk_container_add (GTK_CONTAINER (button), arrow);
       
       gtk_widget_show(button);
       gtk_widget_show(arrow);

       return(button);
}

void check_save(int iand, int i) {

int j=0;

if (phone_rules[iand].from_h >= 0 && phone_rules[iand].from_h < 24) {}
else j=1;
if (phone_rules[iand].from_m >= 0 && phone_rules[iand].from_h < 60) {}
else j=1;
if (phone_rules[iand].to_h >= 0 && phone_rules[iand].to_h < 24) {}
else j=1;
if (phone_rules[iand].to_m >= 0 && phone_rules[iand].to_m < 60) {}
else j=1;

if (j==1) {
	frmerror = create_error_msg(i);
        gtk_widget_show (frmerror);
}

} 
	                          
gboolean
on_Main_destroy_event                  (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_main_quit ();
  return FALSE;

}

void
on_File_activate                       (GtkMenuItem     *menuitem,         
                                        gpointer         user_data)
{

}

void
on_Edit_activate                       (GtkMenuItem     *menuitem,         
                                        gpointer         user_data)
{

}



void
on_Help_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
                                                                            
{

}

void
selection_r_made( GtkWidget *clist, gint row, gint column,
                          GdkEventButton *event, gpointer data)
{

gchar  	*text;
int	i1,i2,i3,i4,i5,i7=0;
float	i6,i8=0;

   gtk_clist_get_text(GTK_CLIST(listr), row, column, &text);

   sscanf(text, "from %d:%d to %d:%d use %d at %f first %d at %f", &i1, &i2, &i3, &i4, &i5, &i6, &i7, &i8);

   text = (void *)malloc(64);
   sprintf(text, "%.2i",i1);
   gtk_entry_set_text( GTK_ENTRY (fh_r), text);
   free(text);

   text = (void *)malloc(64);
   sprintf(text, "%.2i",i2);
   gtk_entry_set_text( GTK_ENTRY (fm_r), text);
   free(text);

   text = (void *)malloc(64);
   sprintf(text, "%.2i",i3);
   gtk_entry_set_text( GTK_ENTRY (th_r), text);
   free(text);

   text = (void *)malloc(64);
   sprintf(text, "%.2i",i4);
   gtk_entry_set_text( GTK_ENTRY (tm_r), text);
   free(text);

   text = (void *)malloc(64);
   sprintf(text, "%.2i",i5);
   gtk_entry_set_text( GTK_ENTRY (u_r), text);
   free(text);

   text = (void *)malloc(64);
   sprintf(text, "%.2f",i6);
   gtk_entry_set_text( GTK_ENTRY (a_r), text);
   free(text);

   text = (void *)malloc(64);
   sprintf(text, "%i",i7);
   gtk_entry_set_text( GTK_ENTRY (f_r), text);
   free(text);

   text = (void *)malloc(64);
   sprintf(text, "%.2f",i8);
   gtk_entry_set_text( GTK_ENTRY (fa_r), text);
   free(text);

   listr_row = row;
}  

void
selection_h_made( GtkWidget *clist, gint row, gint column,
                          GdkEventButton *event, gpointer data)
{

gchar  	*text;
int	i1,i2;

   gtk_clist_get_text(GTK_CLIST(list), row, column, &text);

   sscanf(text, "%d/%d,", &i1, &i2);

   text = (void *)malloc(64);
   sprintf(text, "%.2i",i1);
   gtk_entry_set_text( GTK_ENTRY (h_day), text);
   free(text);

   text = (void *)malloc(64);
   sprintf(text, "%.2i",i2);
   gtk_entry_set_text( GTK_ENTRY (h_mon), text);
   free(text);

   listh_row = row;
}  


gboolean
on_badd_button_press_event            (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
                                                                       
{
gchar           *string, *string1, *string2; 
gchar 		*label1[] = {string}; 

	maxholi= maxholi +1;

  	string1 = gtk_entry_get_text(GTK_ENTRY(h_day));
  	string2 = gtk_entry_get_text(GTK_ENTRY(h_mon));

        sprintf(string, "%.2d/%.2d", atoi(string1), atoi(string2));
	gtk_clist_append((GtkCList*) list, label1 );

}

gboolean
on_baddr_button_press_event (GtkWidget *widget, GdkEventButton  *event, gpointer user_data)

{
gchar           *string, *string1, *string2, *string3, *string4, *string5, *string6, *string7, *string8; 
int 	i, max, irule;
gchar  	*text; 
int 	i1, i2, i3, i4, i5, i7;
float	i6, i8;


if (is_sun) {
	maxsun=maxsun + 1;
	max = maxsun;
	irule = 1;
}
if (is_mon) {
	maxmon=maxmon + 1;
	max = maxmon;
	irule = 2;
}
if (is_tue) {
	maxtue=maxtue + 1;
	max = maxtue;
	irule = 3;
}
if (is_wed) {
	maxwed=maxwed + 1;
	max = maxwed;
	irule = 4;
}
if (is_thu) {
	maxthu=maxthu + 1;
	max = maxthu;
	irule = 5;
}
if (is_fri) {
	maxfri=maxfri + 1;
	max = maxfri;
	irule = 6;
}
if (is_sat) {
	maxsat=maxsat + 1;
	max = maxsat;
	irule = 7;
}

string1 = gtk_entry_get_text(GTK_ENTRY(fh_r));
string2 = gtk_entry_get_text(GTK_ENTRY(fm_r));
string3 = gtk_entry_get_text(GTK_ENTRY(th_r));
string4 = gtk_entry_get_text(GTK_ENTRY(tm_r));
string5 = gtk_entry_get_text(GTK_ENTRY(u_r));
string6 = gtk_entry_get_text(GTK_ENTRY(a_r));
string7 = gtk_entry_get_text(GTK_ENTRY(f_r));
string8 = gtk_entry_get_text(GTK_ENTRY(fa_r));

string = (void *)malloc(64);
sprintf(string, "from %.2d:%.2d to %.2d:%.2d use %.2d at %.2f first %d at %.2f", atoi(string1), atoi(string2),
	atoi(string3), atoi(string4), atoi(string5), atof(string6), atoi(string7), atof(string8));

for (i=1;i<2;i++) {
	gchar 	*label1[] = {string}; 
	gtk_clist_append((GtkCList*) listr, label1 );
}
free(string);

for (i=0;i<max;i++) {
	
	gtk_clist_get_text(GTK_CLIST(listr), i, 0, &text);

   	sscanf(text, "from %d:%d to %d:%d use %d at %f first %d at %f", &i1, &i2, &i3, &i4, &i5, &i6, &i7, &i8);

        phone_rules[irule].from_h = i1;
        phone_rules[irule].from_m = i2;
        phone_rules[irule].to_h = i3;
        phone_rules[irule].to_m = i4;
        phone_rules[irule].use = i5;
        phone_rules[irule].at = i6;     	
        phone_rules[irule].first = i7;
        phone_rules[irule].fat = i8;     	
        if (i < max-1 ) phone_rules[irule].and = 1;
	irule = irule +8;     	
}	

return FALSE;
}

gboolean
on_bdel_button_press_event            (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
                                                                       
{
   maxholi= maxholi -1;
   gtk_clist_remove( (GtkCList *) list, listh_row);  
}

gboolean
on_bdelr_button_press_event            (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
                                                                       
{

gchar           *string, *string1, *string2, *string3, *string4, *string5, *string6; 
int 	i, max, irule;
gchar  	*text; 
int 	i1, i2, i3, i4, i5, i7;
float	i6, i8;

gtk_clist_remove( (GtkCList *) listr, listr_row);  

if (is_sun) {
	maxsun=maxsun - 1;
	max = maxsun;
	irule = 1;
}
if (is_mon) {
	maxmon=maxmon - 1;
	max = maxmon;
	irule = 2;
}
if (is_tue) {
	maxtue=maxtue - 1;
	max = maxtue;
	irule = 3;
}
if (is_wed) {
	maxwed=maxwed - 1;
	max = maxwed;
	irule = 4;
}
if (is_thu) {
	maxthu=maxthu - 1;
	max = maxthu;
	irule = 5;
}
if (is_fri) {
	maxfri=maxfri - 1;
	max = maxfri;
	irule = 6;
}
if (is_sat) {
	maxsat=maxsat - 1;
	max = maxsat;
	irule = 7;
}

for (i=0;i<max;i++) {
	
	gtk_clist_get_text(GTK_CLIST(listr), i, 0, &text);

   	sscanf(text, "from %d:%d to %d:%d use %d at %f first %d at %f", &i1, &i2, &i3, &i4, &i5, &i6, &i7, &i8);

        phone_rules[irule].from_h = i1;
        phone_rules[irule].from_m = i2;
        phone_rules[irule].to_h = i3;
        phone_rules[irule].to_m = i4;
        phone_rules[irule].use = i5;
        phone_rules[irule].at = i6;     	
        phone_rules[irule].first = i7;
        phone_rules[irule].fat = i8;     	
        if (i < max-1 ) phone_rules[irule].and = 1;
	irule = irule +8;     	
}	

}

gboolean
on_bsave_button_press_event            (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
                                                                       
{
gchar 	*string, *text;
char  	*aux;
int	i, iand;
char  	temp[128], temp1[128];
char   	*p;  
FILE	*fp;
int	i1,i2;

p = getenv("HOME");
strcpy(temp, p);
strcat(temp, "/.aspbm/aspbmrc");

fp = fopen(temp, "r");
        if (fp==NULL) {                
        }else{
                fclose(fp);
                system("mv -f ~/.aspbm/aspbmrc ~/.aspbm/aspbmrc.bak");
        }                     

fp = fopen(temp, "a+"); 

  	string = gtk_entry_get_text(GTK_ENTRY(h_con));
	fprintf(fp, "connect_start: %s\n", string);

  	string = gtk_entry_get_text(GTK_ENTRY(h_dcon));
	fprintf(fp, "connect_stop: %s\n", string);

	fprintf(fp, "warn: %i\n", is_cw);

  	string = gtk_entry_get_text(GTK_ENTRY(cwarntime));
	fprintf(fp, "warning: %s\n", string);

  	string = gtk_entry_get_text(GTK_ENTRY(cwarnmsg));
	fprintf(fp, "warnmsg: %s\n", string);

  	string = gtk_entry_get_text(GTK_ENTRY(cdelay));
	fprintf(fp, "delay: %s\n", string);

	fprintf(fp, "log: %i\n", is_cl);

  	string = gtk_entry_get_text(GTK_ENTRY(cfile));
	fprintf(fp, "rules: %s\n", string);

fclose(fp);  

p = getenv("HOME");
strcpy(temp, p);
strcat(temp, "/.aspbm/rules/");
strcat(temp, string);
strcpy(temp1, "");
strcat(temp1, "mv -f "); 
strcat(temp1, temp); 
strcat(temp1, " "); 
strcat(temp1, temp); 
strcat(temp1, ".bak"); 

fp = fopen(temp, "r");
        if (fp==NULL) {                
        }else{
                fclose(fp);
                system(temp1);
        }                     

fp = fopen(temp, "a+");    

	string = gtk_entry_get_text(GTK_ENTRY(csymbol));
	fprintf(fp, "currency_symbol: %s\n", string);

	if (is_cp ==0)  string ="left";
	else  string ="right";
	fprintf(fp, "currency_position: %s\n", string);

  	string = gtk_entry_get_text(GTK_ENTRY(cact));
	fprintf(fp, "activation_cost: %s\n", string);

  	string = gtk_entry_get_text(GTK_ENTRY(dfh));
	phone_rules[8].from_h = atoi (string);
  	string = gtk_entry_get_text(GTK_ENTRY(dfm));
	phone_rules[8].from_m = atoi (string);
  	string = gtk_entry_get_text(GTK_ENTRY(dth));
	phone_rules[8].to_h = atoi (string);
  	string = gtk_entry_get_text(GTK_ENTRY(dtm));
	phone_rules[8].to_m = atoi (string);
  	string = gtk_entry_get_text(GTK_ENTRY(du));
	phone_rules[8].use = atoi (string);
  	string = gtk_entry_get_text(GTK_ENTRY(da));
	phone_rules[8].at = atof (string);
  	string = gtk_entry_get_text(GTK_ENTRY(df));
	phone_rules[8].first = atoi (string);
  	string = gtk_entry_get_text(GTK_ENTRY(dfa));
	phone_rules[8].fat = atof (string);

	check_save(8,8);
	fprintf(fp, "default: from %.2i:%.2i to %.2i:%.2i use %i at %.2f first %i at %.2f", 
		phone_rules[8].from_h, phone_rules[8].from_m, phone_rules[8].to_h,
		phone_rules[8].to_m, phone_rules[8].use, phone_rules[8].at,
		phone_rules[8].first, phone_rules[8].fat);

	for (i =1;i <=7;i++) {

	iand = i;
	check_save(iand,i);

	 string = (void *)malloc(256);

	sprintf(string, "%s: from %.2i:%.2i to %.2i:%.2i use %i at %.2f first %i at %.2f", wdays[i],
		phone_rules[iand].from_h, phone_rules[iand].from_m, phone_rules[iand].to_h,
		phone_rules[iand].to_m, phone_rules[iand].use, phone_rules[iand].at,
		phone_rules[iand].first, phone_rules[iand].fat);

	while (phone_rules[iand].and == 1) {
		iand = iand +8;
		check_save(iand,i);

		aux = (void *)malloc(64);
		sprintf(aux, " and from %.2i:%.2i to %.2i:%.2i use %i at %.2f first %i at %.2f", 
			phone_rules[iand].from_h, phone_rules[iand].from_m, phone_rules[iand].to_h,
			phone_rules[iand].to_m, phone_rules[iand].use, phone_rules[iand].at,
			phone_rules[iand].first, phone_rules[iand].fat);
	
		strcat(string,aux);
			
	}

	fprintf(fp, "\n%s", string); 
	}
   
   	sprintf(string, "holydays: ");

	for (i =0 ; i<=maxholi-2;i++) {
     		gtk_clist_get_text(GTK_CLIST(list), i, 0, &text);

   		sscanf(text, "%d/%d,", &i1, &i2);

   		text = (void *)malloc(64);
   		sprintf(text, "%.2i/%.2i, ", i1, i2);
		strcat(string, text);

	}
     	gtk_clist_get_text(GTK_CLIST(list), maxholi-1, 0, &text);
   	sscanf(text, "%d/%d,", &i1, &i2);

   	text = (void *)malloc(64);
   	sprintf(text, "%.2i/%.2i", i1, i2);
	strcat(string, text);

	fprintf(fp, "\n%s\n", string);

   	free(string);
   	free(text);

	fclose(fp);  

return FALSE;
}

void fill(int irule, int max){
  	
int 	iand, i;
gchar 	*stringa;

iand=irule;
stringa = malloc(10); 

gtk_clist_clear((GtkCList*) listr);

for (i=0;i<=max;i++) {
	GtkWidget       *label;
	gchar   *aux[] = {stringa};    

	free(stringa);   
	stringa = malloc(100);    
	sprintf(stringa, "from %.2d:%.2d to %.2d:%.2d use %d at %.2f first %d at %.2f", phone_rules[iand].from_h, phone_rules[iand].from_m,
		phone_rules[iand].to_h, phone_rules[iand].to_m, phone_rules[iand].use, phone_rules[iand].at, phone_rules[iand].first, phone_rules[iand].fat);

	gtk_clist_append((GtkCList*) listr, aux);
	if (i>=1) iand = iand + 8; 
}
gtk_clist_remove( (GtkCList *) listr, 0);

gtk_entry_set_text( GTK_ENTRY (fh_r), "");
gtk_entry_set_text( GTK_ENTRY (fm_r), "");
gtk_entry_set_text( GTK_ENTRY (th_r), "");
gtk_entry_set_text( GTK_ENTRY (tm_r), "");
gtk_entry_set_text( GTK_ENTRY (u_r), "");
gtk_entry_set_text( GTK_ENTRY (a_r), "");
gtk_entry_set_text( GTK_ENTRY (f_r), "");
gtk_entry_set_text( GTK_ENTRY (fa_r), "");

}

gboolean
on_bquit_button_release_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  gtk_main_quit ();
  return FALSE;
}


void
on_Quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)        
{
  gtk_main_quit ();
}

void
on_Copy_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)        
{
if (is_sun==1) copy_from = 1;
if (is_mon==1) copy_from = 2;
if (is_tue==1) copy_from = 3;
if (is_wed==1) copy_from = 4;
if (is_thu==1) copy_from = 5;
if (is_fri==1) copy_from = 6;
if (is_sat==1) copy_from = 7;
}

void
on_Paste_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)        
{

int max, i, irule, day, oldcopy;

if (copy_from==1) max = maxsun;
if (copy_from==2) max = maxmon; 
if (copy_from==3) max = maxtue; 
if (copy_from==4) max = maxwed; 
if (copy_from==5) max = maxthu; 
if (copy_from==6) max = maxfri; 
if (copy_from==7) max = maxsat; 

if (is_sun==1) {irule=1;maxsun=max;}
if (is_mon==1) {irule=2;maxmon=max;} 
if (is_tue==1) {irule=3;maxtue=max;}
if (is_wed==1) {irule=4;maxwed=max;}
if (is_thu==1) {irule=5;maxthu=max;}
if (is_fri==1) {irule=6;maxfri=max;}
if (is_sat==1) {irule=7;maxsat=max;}

day = irule;
oldcopy=copy_from;

for (i=1;i<=max;i++) {
        phone_rules[irule].from_h = phone_rules[copy_from].from_h;
        phone_rules[irule].from_m = phone_rules[copy_from].from_m;
        phone_rules[irule].to_h = phone_rules[copy_from].to_h;
        phone_rules[irule].to_m = phone_rules[copy_from].to_m;
        phone_rules[irule].use = phone_rules[copy_from].use;
        phone_rules[irule].at = phone_rules[copy_from].at;
        phone_rules[irule].first = phone_rules[copy_from].first;
        phone_rules[irule].fat = phone_rules[copy_from].fat;
        phone_rules[irule].and = phone_rules[copy_from].and;
        irule = irule +8;                                  	
        copy_from = copy_from +8;                                  	
}

copy_from=oldcopy;
 
fill(day,max);

}

void
on_mon_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
if (is_mon == 0) is_mon = 1;
else is_mon = 0; 
if (is_mon) fill(2, maxmon);
}  

void
on_tue_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
if (is_tue == 0) is_tue = 1;
else is_tue = 0; 
if (is_tue) fill(3, maxtue);
}  

void
on_wed_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
if (is_wed == 0) is_wed = 1;
else is_wed = 0; 
if (is_wed) fill(4, maxwed);
}  

void
on_thu_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
if (is_thu == 0) is_thu = 1;
else is_thu = 0; 
if (is_thu) fill(5, maxthu);
}  

void
on_fri_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
if (is_fri == 0) is_fri = 1;
else is_fri = 0; 
if (is_fri) fill(6, maxfri);
}  

void
on_sat_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
if (is_sat == 0) is_sat = 1;
else is_sat = 0; 
if (is_sat) fill(7, maxsat);
}  

void
on_sun_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
if (is_sun == 0) is_sun = 1;
else is_sun = 0; 
if (is_sun) fill(1, maxsun);
}  

void
on_ac_1_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
if (is_ac_1 == 0) is_ac_1 = 1;
else is_ac_1 = 0; 
}  

void
on_ac_2_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
if (is_ac_2 == 0) is_ac_2 = 1;
else is_ac_2 = 0; 
}  

void
on_ac_3_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
if (is_ac_3 == 0) is_ac_3 = 1;
else is_ac_3 = 0; 
}  

void
on_cp_1_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
is_cp=0;
}  

void
on_cp_2_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
is_cp=1;
}  

void
on_cw_1_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
is_cw=1;
}  

void
on_cw_2_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
is_cw=0;
}  

void
on_cl_1_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
is_cl=1;
}  

void
on_cl_2_toggled                         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
is_cl=0;
}  


gboolean
on_up_button_press_event               (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
int 	i, max, irule;
gchar  	*text; 
int 	i1, i2, i3, i4, i5, i7;
float	i6, i8;

gtk_clist_row_move(GTK_CLIST(listr), listr_row, listr_row-1);
gtk_clist_select_row (GTK_CLIST (listr), listr_row-1, 0);  

if (is_sun) {
	max = maxsun;
	irule = 1;
}
if (is_mon) {
	max = maxmon;
	irule = 2;
}
if (is_tue) {
	max = maxtue;
	irule = 3;
}
if (is_wed) {
	max = maxwed;
	irule = 4;
}
if (is_thu) {
	max = maxthu;
	irule = 5;
}
if (is_fri) {
	max = maxfri;
	irule = 6;
}
if (is_sat) {
	max = maxsat;
	irule = 7;
}

for (i=0;i<max;i++) {
	
	gtk_clist_get_text(GTK_CLIST(listr), i, 0, &text);

   	sscanf(text, "from %d:%d to %d:%d use %d at %f first %d at %f", &i1, &i2, &i3, &i4, &i5, &i6, &i7, &i8);

        phone_rules[irule].from_h = i1;
        phone_rules[irule].from_m = i2;
        phone_rules[irule].to_h = i3;
        phone_rules[irule].to_m = i4;
        phone_rules[irule].use = i5;
        phone_rules[irule].at = i6;     	
        phone_rules[irule].first = i7;
        phone_rules[irule].fat = i8;     	
        if (i < max-1 ) phone_rules[irule].and = 1;
	irule = irule +8;     	
}	

return FALSE;
}


gboolean
on_down_button_press_event             (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
int 	i, max, irule;
gchar  	*text; 
int 	i1, i2, i3, i4, i5, i7;
float	i6, i8;

gtk_clist_row_move(GTK_CLIST(listr), listr_row, listr_row+1);
gtk_clist_select_row (GTK_CLIST (listr), listr_row+1, 0);  

if (is_sun) {
	max = maxsun;
	irule = 1;
}
if (is_mon) {
	max = maxmon;
	irule = 2;
}
if (is_tue) {
	max = maxtue;
	irule = 3;
}
if (is_wed) {
	max = maxwed;
	irule = 4;
}
if (is_thu) {
	max = maxthu;
	irule = 5;
}
if (is_fri) {
	max = maxfri;
	irule = 6;
}
if (is_sat) {
	max = maxsat;
	irule = 7;
}

for (i=0;i<max;i++) {
	
	gtk_clist_get_text(GTK_CLIST(listr), i, 0, &text);

   	sscanf(text, "from %d:%d to %d:%d use %d at %f first %d at %f", &i1, &i2, &i3, &i4, &i5, &i6, &i7, &i8);

        phone_rules[irule].from_h = i1;
        phone_rules[irule].from_m = i2;
        phone_rules[irule].to_h = i3;
        phone_rules[irule].to_m = i4;
        phone_rules[irule].use = i5;
        phone_rules[irule].at = i6;     	
        phone_rules[irule].first = i7;
        phone_rules[irule].fat = i8;     	
        if (i < max-1 ) phone_rules[irule].and = 1;
	irule = irule +8;     	
}	

return FALSE;
}
    

/* This is an internally used function to set notebook tab widgets. */
void
set_notebook_tab                       (GtkWidget       *notebook,
                                        gint             page_num,
                                        GtkWidget       *widget)
{

  GtkNotebookPage *page;
  GtkWidget *notebook_page;

  page = (GtkNotebookPage*) g_list_nth (GTK_NOTEBOOK (notebook)->children, page_num)->data;
  notebook_page = page->child;
  gtk_widget_ref (notebook_page);
  gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page_num);
  gtk_notebook_insert_page (GTK_NOTEBOOK (notebook), notebook_page,
                            widget, page_num);
  gtk_widget_unref (notebook_page);
}

/***************************************/

int
main (int argc, char *argv[])
{

  	int i,j;
	char    	temp[128];
        char        	*p, *string;  
      	gchar 		*myaux[] = {"aa"}; 
	FILE	*fp;

  GtkWidget *Main;
  GtkWidget *fixed1;
  GSList *cposition_group = NULL;  
  GSList *cwarn_group = NULL;  
  GSList *clog_group = NULL;  
  GSList *cday_group = NULL;  
  GtkWidget *menubar1;
  GtkWidget *File;
  GtkWidget *File_menu;
  GtkWidget *Quit;
  GtkWidget *Edit;
  GtkWidget *Edit_menu;
  GtkWidget *Copy;
  GtkWidget *Paste;
  GtkWidget *Help;
  GtkWidget *Help_menu;
  GtkWidget *About;
  GtkWidget *notebook1;
  GtkWidget *table1;
  GtkWidget *fixedg;
  GtkWidget *hseparator;
  GtkWidget *label;
  GtkWidget *fixedr;
  GtkWidget *fixedh;
  GtkWidget *frame1;
  GtkWidget *bsave;
  GtkWidget *bquit;
  GtkWidget *badd;
  GtkWidget *bdel;
  GtkWidget *baddr;
  GtkWidget *bdelr;
  GtkWidget *up;
  GtkWidget *down;  

  GtkWidget *scrolledwindow;  
  GtkWidget *scrolledwindowr;  

  GtkTooltips *tooltips;

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  tooltips = gtk_tooltips_new ();

  Main = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (Main), "Main", Main);
  gtk_widget_set_usize (Main, 500, 325);
  gtk_window_set_title (GTK_WINDOW (Main), "aspbm - Configuration");
  gtk_window_set_policy (GTK_WINDOW (Main), FALSE, FALSE, FALSE);
  gtk_window_set_wmclass (GTK_WINDOW (Main), "aspbm_conf", "aspbm_conf");   
  gtk_signal_connect_object (GTK_OBJECT (Main), "destroy",
                             GTK_SIGNAL_FUNC (on_Main_destroy_event),
                             GTK_OBJECT (Main)); 

  fixed1 = gtk_fixed_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "fixed1", fixed1);
  gtk_widget_show (fixed1);
  gtk_container_add (GTK_CONTAINER (Main), fixed1);

  bsave = gtk_button_new_with_label ("Save");
  gtk_object_set_data (GTK_OBJECT (Main), "bsave", bsave);
  gtk_widget_show (bsave);
  gtk_fixed_put (GTK_FIXED (fixed1), bsave, 192, 296);
  gtk_widget_set_uposition (bsave, 192, 296);
  gtk_widget_set_usize (bsave, 72, 24);
  gtk_signal_connect (GTK_OBJECT (bsave), "button_press_event",
                      GTK_SIGNAL_FUNC (on_bsave_button_press_event),
                      NULL);

  bquit = gtk_button_new_with_label ("Quit");
  gtk_object_set_data (GTK_OBJECT (Main), "bquit", bquit);
  gtk_widget_show (bquit);
  gtk_fixed_put (GTK_FIXED (fixed1), bquit, 16, 296);
  gtk_widget_set_uposition (bquit, 16, 296);
  gtk_widget_set_usize (bquit, 72, 24);
  gtk_signal_connect (GTK_OBJECT (bquit), "button_release_event",
                      GTK_SIGNAL_FUNC (on_bquit_button_release_event),
                      NULL);

  menubar1 = gtk_menu_bar_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "menubar1", menubar1);
  gtk_widget_show (menubar1);
  gtk_fixed_put (GTK_FIXED (fixed1), menubar1, 0, 0);
  gtk_widget_set_uposition (menubar1, 0, 0);
  gtk_widget_set_usize (menubar1, 500, 24);

  File = gtk_menu_item_new_with_label ("File");
  gtk_object_set_data (GTK_OBJECT (Main), "File", File);
  gtk_widget_show (File);
  gtk_container_add (GTK_CONTAINER (menubar1), File);
  gtk_signal_connect (GTK_OBJECT (File), "activate",
                      GTK_SIGNAL_FUNC (on_File_activate),
                      NULL);

  File_menu = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "File_menu", File_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (File), File_menu);

  Quit = gtk_menu_item_new_with_label ("Quit");
  gtk_object_set_data (GTK_OBJECT (Main), "Quit", Quit);
  gtk_widget_show (Quit);
  gtk_container_add (GTK_CONTAINER (File_menu), Quit);
  gtk_signal_connect (GTK_OBJECT (Quit), "activate",
                      GTK_SIGNAL_FUNC (on_Quit_activate),
                      NULL);

  Edit = gtk_menu_item_new_with_label ("Edit");
  gtk_object_set_data (GTK_OBJECT (Main), "Edit", Edit);
  gtk_widget_show (Edit);
  gtk_container_add (GTK_CONTAINER (menubar1), Edit);
  gtk_signal_connect (GTK_OBJECT (Edit), "activate",
                      GTK_SIGNAL_FUNC (on_Edit_activate),
                      NULL);

  Edit_menu = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "Edit_menu", Edit_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (Edit), Edit_menu);

  Copy = gtk_menu_item_new_with_label ("Copy Day");
  gtk_object_set_data (GTK_OBJECT (Main), "Copy", Copy);
  gtk_widget_show (Copy);
  gtk_container_add (GTK_CONTAINER (Edit_menu), Copy);
  gtk_signal_connect (GTK_OBJECT (Copy), "activate",
                      GTK_SIGNAL_FUNC (on_Copy_activate),
                      NULL);

  Paste = gtk_menu_item_new_with_label ("Paste Day");
  gtk_object_set_data (GTK_OBJECT (Main), "Paste", Paste);
  gtk_widget_show (Paste);
  gtk_container_add (GTK_CONTAINER (Edit_menu), Paste);
  gtk_signal_connect (GTK_OBJECT (Paste), "activate",
                      GTK_SIGNAL_FUNC (on_Paste_activate),
                      NULL);

  Help = gtk_menu_item_new_with_label ("Help");
  gtk_object_set_data (GTK_OBJECT (Main), "Help", Help);
  gtk_widget_show (Help);
  gtk_container_add (GTK_CONTAINER (menubar1), Help);
  gtk_signal_connect (GTK_OBJECT (Help), "activate",
                      GTK_SIGNAL_FUNC (on_Help_activate),
                      NULL);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (Help));

  Help_menu = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "Help_menu", Help_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (Help), Help_menu);

  About = gtk_menu_item_new_with_label ("About");
  gtk_object_set_data (GTK_OBJECT (Main), "About", About);
  gtk_widget_show (About);
  gtk_container_add (GTK_CONTAINER (Help_menu), About);
  gtk_signal_connect (GTK_OBJECT (About), "activate",
                      GTK_SIGNAL_FUNC (on_About_activate),
                      NULL);

  notebook1 = gtk_notebook_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "notebook1", notebook1);
  gtk_widget_show (notebook1);
  gtk_fixed_put (GTK_FIXED (fixed1), notebook1, 8, 32);
  gtk_widget_set_uposition (notebook1, 8, 32);
  gtk_widget_set_usize (notebook1, 480, 260);

  table1 = gtk_table_new (1, 1, FALSE);
  gtk_object_set_data (GTK_OBJECT (Main), "table1", table1);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (notebook1), table1);

  fixedg = gtk_fixed_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "fixedg", fixedg);
  gtk_widget_show (fixedg);
  gtk_table_attach (GTK_TABLE (table1), fixedg, 0, 1, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_widget_set_usize (fixedg, -2, 210);

  csymbol = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "csymbol", csymbol);
  gtk_widget_show (csymbol);
  gtk_fixed_put (GTK_FIXED (fixedg), csymbol, 140, 10);
  gtk_widget_set_uposition (csymbol, 140, 10);
  gtk_widget_set_usize (csymbol, 48, 22);
  gtk_tooltips_set_tip (tooltips, csymbol, "Symbol for country currency", NULL);


  cp_1 = gtk_radio_button_new_with_label (cposition_group, "Left");
  cposition_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cp_1));
  gtk_object_set_data (GTK_OBJECT (Main), "cp_1", cp_1);
  gtk_widget_show (cp_1);
  gtk_fixed_put (GTK_FIXED (fixedg), cp_1, 360, 10);
  gtk_widget_set_uposition (cp_1, 360, 10);
  gtk_widget_set_usize (cp_1, 48, 22);  
  gtk_signal_connect (GTK_OBJECT (cp_1), "toggled",
                      GTK_SIGNAL_FUNC (on_cp_1_toggled),
                      NULL);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (cp_1), TRUE);

  cp_2 = gtk_radio_button_new_with_label (cposition_group, "Right");
  cposition_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cp_2));
  gtk_object_set_data (GTK_OBJECT (Main), "cp_2", cp_2);
  gtk_widget_show (cp_2);    
  gtk_fixed_put (GTK_FIXED (fixedg), cp_2, 410, 10);
  gtk_widget_set_uposition (cp_2, 410, 10);
  gtk_widget_set_usize (cp_2, 48, 22); 
  gtk_signal_connect (GTK_OBJECT (cp_2), "toggled",
                      GTK_SIGNAL_FUNC (on_cp_2_toggled),
                      NULL);

  cact = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "cact", cact);
  gtk_widget_show (cact);
  gtk_fixed_put (GTK_FIXED (fixedg), cact, 140, 35);
  gtk_widget_set_uposition (cact, 140, 35);
  gtk_widget_set_usize (cact, 48, 22);
  gtk_tooltips_set_tip (tooltips, cact, "Call activation cost", NULL);

  cfile = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "cfile", cfile);
  gtk_widget_show (cfile);
  gtk_fixed_put (GTK_FIXED (fixedg), cfile, 320, 35);
  gtk_widget_set_uposition (cfile, 320, 35);
  gtk_widget_set_usize (cfile, 137, 22);
  gtk_tooltips_set_tip (tooltips, cfile, "Rules file", NULL);


  cw_1 = gtk_radio_button_new_with_label (cwarn_group, "True");
  cwarn_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cw_1));
  gtk_object_set_data (GTK_OBJECT (Main), "cw_1", cw_1);
  gtk_widget_show (cw_1);
  gtk_fixed_put (GTK_FIXED (fixedg), cw_1, 72, 70);
  gtk_widget_set_uposition (cw_1, 72, 70);
  gtk_widget_set_usize (cw_1, 48, 22);  
  gtk_signal_connect (GTK_OBJECT (cw_1), "toggled",
                      GTK_SIGNAL_FUNC (on_cw_1_toggled),
                      NULL);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (cw_1), TRUE);

  cw_2 = gtk_radio_button_new_with_label (cwarn_group, "False");
  cwarn_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cw_2));
  gtk_object_set_data (GTK_OBJECT (Main), "cw_2", cw_2);
  gtk_widget_show (cw_2);    
  gtk_fixed_put (GTK_FIXED (fixedg), cw_2, 120, 70);
  gtk_widget_set_uposition (cw_2, 120, 70);
  gtk_widget_set_usize (cw_2, 48, 22); 
  gtk_signal_connect (GTK_OBJECT (cw_2), "toggled",
                      GTK_SIGNAL_FUNC (on_cw_2_toggled),
                      NULL);

  cwarntime = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "cwarntime", cwarntime);
  gtk_widget_show (cwarntime);
  gtk_fixed_put (GTK_FIXED (fixedg), cwarntime, 344, 70);
  gtk_widget_set_uposition (cwarntime, 344, 70);
  gtk_widget_set_usize (cwarntime, 56, 24);
  gtk_tooltips_set_tip (tooltips, cwarntime, "Time in secs to display warning window before pulse drop", NULL);

  hseparator = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "hseparator", hseparator);
  gtk_widget_show (hseparator);
  gtk_fixed_put (GTK_FIXED (fixedg), hseparator, 8, 55);
  gtk_widget_set_uposition (hseparator, 8, 55);
  gtk_widget_set_usize (hseparator, 450, 16);

  cwarnmsg = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "cwarnmsg", cwarnmsg);
  gtk_widget_show (cwarnmsg);
  gtk_fixed_put (GTK_FIXED (fixedg), cwarnmsg, 144, 102);
  gtk_widget_set_uposition (cwarnmsg, 144, 102);
  gtk_widget_set_usize (cwarnmsg, 314, 22);
  gtk_tooltips_set_tip (tooltips, cwarnmsg, "Message to be displayed in warning window", NULL);

  cdelay = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "cdelay", cdelay);
  gtk_widget_show (cdelay);
  gtk_fixed_put (GTK_FIXED (fixedg), cdelay, 144, 140);
  gtk_widget_set_uposition (cdelay, 144, 140);
  gtk_widget_set_usize (cdelay, 48, 22);
  gtk_tooltips_set_tip (tooltips, cdelay, "Time in secs between phone connect and ppp connect", NULL);

  cl_1 = gtk_radio_button_new_with_label (clog_group, "True");
  clog_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cl_1));
  gtk_object_set_data (GTK_OBJECT (Main), "cl_1", cp_1);
  gtk_widget_show (cl_1);
  gtk_fixed_put (GTK_FIXED (fixedg), cl_1, 300, 140);
  gtk_widget_set_uposition (cl_1, 300, 140);
  gtk_widget_set_usize (cl_1, 48, 22);  
  gtk_signal_connect (GTK_OBJECT (cl_1), "toggled",
                      GTK_SIGNAL_FUNC (on_cl_1_toggled),
                      NULL);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (cl_1), TRUE);

  cl_2 = gtk_radio_button_new_with_label (clog_group, "False");
  clog_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cl_2));
  gtk_object_set_data (GTK_OBJECT (Main), "cl_2", cl_2);
  gtk_widget_show (cl_2);    
  gtk_fixed_put (GTK_FIXED (fixedg), cl_2, 350, 140);
  gtk_widget_set_uposition (cl_2, 350, 140);
  gtk_widget_set_usize (cl_2, 48, 22); 
  gtk_signal_connect (GTK_OBJECT (cl_2), "toggled",
                      GTK_SIGNAL_FUNC (on_cl_2_toggled),
                      NULL);


  label = gtk_label_new ("Currency Position:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 232, 10);
  gtk_widget_set_uposition (label, 232, 10);
  gtk_widget_set_usize (label, 136, 24);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  label = gtk_label_new ("Rules File:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 232, 35);
  gtk_widget_set_uposition (label, 232, 35);
  gtk_widget_set_usize (label, 95, 24);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  label = gtk_label_new ("Activation Cost:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 8, 35);
  gtk_widget_set_uposition (label, 8, 35);
  gtk_widget_set_usize (label, 118, 24);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  label = gtk_label_new ("Warning Time:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 232, 70);
  gtk_widget_set_uposition (label, 232, 70);
  gtk_widget_set_usize (label, 112, 24);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  hseparator = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "hseparator", hseparator);
  gtk_widget_show (hseparator);
  gtk_fixed_put (GTK_FIXED (fixedg), hseparator, 8, 125);
  gtk_widget_set_uposition (hseparator, 8, 125);
  gtk_widget_set_usize (hseparator, 450, 16);

  dfh = gtk_entry_new_with_max_length (2);
  gtk_object_set_data (GTK_OBJECT (Main), "dfh", dfh);
  gtk_widget_show (dfh);
  gtk_fixed_put (GTK_FIXED (fixedg), dfh, 55, 195);
  gtk_widget_set_uposition (dfh, 55, 195);
  gtk_widget_set_usize (dfh, 24, 22);
  gtk_tooltips_set_tip (tooltips, dfh, "From hours - 0 to 23 ", NULL);   	

  dfm = gtk_entry_new_with_max_length (2);
  gtk_object_set_data (GTK_OBJECT (Main), "dfm", dfm);
  gtk_widget_show (dfm);
  gtk_fixed_put (GTK_FIXED (fixedg), dfm, 90, 195);
  gtk_widget_set_uposition (dfm, 90, 195);
  gtk_widget_set_usize (dfm, 24, 22);
  gtk_tooltips_set_tip (tooltips, dfm, "From minutes - 0 to 59 ", NULL);   	

  dth = gtk_entry_new_with_max_length (2);
  gtk_object_set_data (GTK_OBJECT (Main), "dth", dth);
  gtk_widget_show (dth);
  gtk_fixed_put (GTK_FIXED (fixedg), dth, 140, 195);
  gtk_widget_set_uposition (dth, 140, 195);
  gtk_widget_set_usize (dth, 24, 22);
  gtk_tooltips_set_tip (tooltips, dth, "To hours - 0 to 23 ", NULL);   	

  dtm = gtk_entry_new_with_max_length (2);
  gtk_object_set_data (GTK_OBJECT (Main), "dtm", dtm);
  gtk_widget_show (dtm);
  gtk_fixed_put (GTK_FIXED (fixedg), dtm, 175, 195);
  gtk_widget_set_uposition (dtm, 175, 195);
  gtk_widget_set_usize (dtm, 24, 22);
  gtk_tooltips_set_tip (tooltips, dtm, "To minutes - 0 to 59 ", NULL);   	

  du = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "du", du);
  gtk_widget_show (du);
  gtk_fixed_put (GTK_FIXED (fixedg), du, 230, 195);
  gtk_widget_set_uposition (du, 230, 195);
  gtk_widget_set_usize (du, 45, 22);
  gtk_tooltips_set_tip (tooltips, du, "Number of seconds of the pulse", NULL);

  da = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "da", da);
  gtk_widget_show (da);
  gtk_fixed_put (GTK_FIXED (fixedg), da, 292, 195);
  gtk_widget_set_uposition (da, 292, 195);
  gtk_widget_set_usize (da, 48, 22);
  gtk_tooltips_set_tip (tooltips, da, "Cost of one pulse", NULL);

  df = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "df", df);
  gtk_widget_show (df);
  gtk_fixed_put (GTK_FIXED (fixedg), df, 370, 195);
  gtk_widget_set_uposition (df, 370, 195);
  gtk_widget_set_usize (df, 35, 22);
  gtk_tooltips_set_tip (tooltips, df, "Time in secs for the first pulse", NULL);

  dfa = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "dfa", dfa);
  gtk_widget_show (dfa);
  gtk_fixed_put (GTK_FIXED (fixedg), dfa, 424, 195);
  gtk_widget_set_uposition (dfa, 424, 195);
  gtk_widget_set_usize (dfa, 33, 22);
  gtk_tooltips_set_tip (tooltips, dfa, "First pulse cost", NULL);

  label = gtk_label_new ("Warning Message:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 8, 102);
  gtk_widget_set_uposition (label, 8, 102);
  gtk_widget_set_usize (label, 136, 24);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  label = gtk_label_new ("Warn:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 8, 70);
  gtk_widget_set_uposition (label, 8, 70);
  gtk_widget_set_usize (label, 64, 24);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  label = gtk_label_new ("Currency Symbol:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 8, 10);
  gtk_widget_set_uposition (label, 8, 10);
  gtk_widget_set_usize (label, 128, 24);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  label = gtk_label_new ("Default:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 8, 170);
  gtk_widget_set_uposition (label, 8, 170);
  gtk_widget_set_usize (label, 74, 24);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  label = gtk_label_new ("Connection Delay:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 8, 140);
  gtk_widget_set_uposition (label, 8, 140);
  gtk_widget_set_usize (label, 136, 24);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  label = gtk_label_new ("Logging:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 232, 140);
  gtk_widget_set_uposition (label, 232, 140);
  gtk_widget_set_usize (label, 72, 24);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  label = gtk_label_new (":");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 75, 195);
  gtk_widget_set_uposition (label, 75, 195);
  gtk_widget_set_usize (label, 16, 24);

  label = gtk_label_new ("to");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 115, 195);
  gtk_widget_set_uposition (label, 115, 195);
  gtk_widget_set_usize (label, 24, 24);

  label = gtk_label_new (":");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 162, 195);
  gtk_widget_set_uposition (label, 162, 195);
  gtk_widget_set_usize (label, 16, 24);

  label = gtk_label_new ("use");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 198, 195);
  gtk_widget_set_uposition (label, 198, 195);
  gtk_widget_set_usize (label, 32, 24);

  label = gtk_label_new ("at");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 270, 195);
  gtk_widget_set_uposition (label, 270, 195);
  gtk_widget_set_usize (label, 24, 24);

  label = gtk_label_new ("first");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 343, 195);
  gtk_widget_set_uposition (label, 343, 195);
  gtk_widget_set_usize (label, 24, 24);

  label = gtk_label_new ("at");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 402, 195);
  gtk_widget_set_uposition (label, 402, 195);
  gtk_widget_set_usize (label, 24, 24);

  label = gtk_label_new ("from");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedg), label, 8, 195);
  gtk_widget_set_uposition (label, 8, 195);
  gtk_widget_set_usize (label, 55, 24);

  hseparator = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "hseparator", hseparator);
  gtk_widget_show (hseparator);
  gtk_fixed_put (GTK_FIXED (fixedg), hseparator, 8, 160);
  gtk_widget_set_uposition (hseparator, 8, 160);
  gtk_widget_set_usize (hseparator, 450, 18);

  fixedr = gtk_fixed_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "fixedr", fixedr);
  gtk_widget_show (fixedr);
  gtk_container_add (GTK_CONTAINER (notebook1), fixedr);

  baddr = gtk_button_new_with_label ("Add");
  gtk_object_set_data (GTK_OBJECT (Main), "baddr", baddr);
  gtk_widget_show (baddr);
  gtk_fixed_put (GTK_FIXED (fixedr), baddr, 390, 30);
  gtk_widget_set_uposition (baddr, 390, 30);
  gtk_widget_set_usize (baddr, 70, 22);
  gtk_signal_connect (GTK_OBJECT (baddr), "button_press_event",
                      GTK_SIGNAL_FUNC (on_baddr_button_press_event),
                      NULL);

  bdelr = gtk_button_new_with_label ("Remove");
  gtk_object_set_data (GTK_OBJECT (Main), "bdelr", bdelr);
  gtk_widget_show (bdelr);
  gtk_fixed_put (GTK_FIXED (fixedr), bdelr, 390, 60);
  gtk_widget_set_uposition (bdelr, 390, 60);
  gtk_widget_set_usize (bdelr, 70, 22);
  gtk_signal_connect (GTK_OBJECT (bdelr), "button_press_event",
                      GTK_SIGNAL_FUNC (on_bdelr_button_press_event),
                      NULL);

  up = create_arrow_button(GTK_ARROW_UP, GTK_SHADOW_OUT);
  gtk_object_set_data (GTK_OBJECT (Main), "up", up);
  gtk_widget_show (up);
  gtk_fixed_put (GTK_FIXED (fixedr), up, 390, 100);
  gtk_widget_set_uposition (up, 390, 100);
  gtk_widget_set_usize (up, 30, 22);
  gtk_signal_connect (GTK_OBJECT (up), "button_press_event",
                      GTK_SIGNAL_FUNC (on_up_button_press_event),
                      NULL);

  down = create_arrow_button(GTK_ARROW_DOWN, GTK_SHADOW_OUT);
  gtk_object_set_data (GTK_OBJECT (Main), "down", down);
  gtk_widget_show (down);
  gtk_fixed_put (GTK_FIXED (fixedr), down, 430, 100);
  gtk_widget_set_uposition (down, 430, 100);
  gtk_widget_set_usize (down, 30, 22);
  gtk_signal_connect (GTK_OBJECT (down), "button_press_event",
                      GTK_SIGNAL_FUNC (on_down_button_press_event),
                      NULL);       

  scrolledwindowr = gtk_scrolled_window_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (Main), "scrolledwindowr", scrolledwindowr);     
  gtk_widget_show (scrolledwindowr);
  gtk_fixed_put (GTK_FIXED (fixedr), scrolledwindowr, 10, 30);
  gtk_widget_set_uposition (scrolledwindowr, 10, 30);                            
  gtk_widget_set_usize (scrolledwindowr, 370, 100);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindowr),GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);


	listr = gtk_clist_new(1);
    	gtk_container_add (GTK_CONTAINER (scrolledwindowr), listr); 
	gtk_signal_connect(GTK_OBJECT(listr), "select_row",
                            GTK_SIGNAL_FUNC(selection_r_made),
                            NULL);
	gtk_clist_set_column_justification(GTK_CLIST(listr), 0, GTK_JUSTIFY_CENTER);

/*	gtk_clist_set_border(GTK_CLIST(listr), GTK_SHADOW_OUT);
    	gtk_clist_set_policy(GTK_CLIST(listr), GTK_POLICY_AUTOMATIC,
                                                GTK_POLICY_AUTOMATIC);
*/
	gtk_clist_set_shadow_type(GTK_CLIST(listr), GTK_SHADOW_IN);
        gtk_clist_set_column_title(GTK_CLIST (listr),0,"Phone Rules");
	gtk_clist_column_titles_show(GTK_CLIST (listr));

    	gtk_widget_show(listr);


  label = gtk_label_new ("from");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedr), label, 15, 140);
  gtk_widget_set_uposition (label, 15, 140);
  gtk_widget_set_usize (label, 24, 22);

  fh_r = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "fh_r", fh_r);
  gtk_widget_show (fh_r);
  gtk_fixed_put (GTK_FIXED (fixedr), fh_r, 45, 140);
  gtk_widget_set_uposition (fh_r, 45, 140);
  gtk_widget_set_usize (fh_r, 25, 22);
  gtk_tooltips_set_tip (tooltips, fh_r, "From hours - 0 to 23", NULL);

  label = gtk_label_new (":");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedr), label, 72, 140);
  gtk_widget_set_uposition (label, 72, 140);
  gtk_widget_set_usize (label, 5, 22);

  fm_r = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "fm_r", fm_r);
  gtk_widget_show (fm_r);
  gtk_fixed_put (GTK_FIXED (fixedr), fm_r, 80, 140);
  gtk_widget_set_uposition (fm_r, 80, 140);
  gtk_widget_set_usize (fm_r, 25, 22);
  gtk_tooltips_set_tip (tooltips, fm_r, "From minutes  - 0 to 59", NULL);

  label = gtk_label_new ("to");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedr), label, 110, 140);
  gtk_widget_set_uposition (label, 110, 140);
  gtk_widget_set_usize (label, 10, 22);

  th_r = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "th_r", th_r);
  gtk_widget_show (th_r);
  gtk_fixed_put (GTK_FIXED (fixedr), th_r, 125, 140);
  gtk_widget_set_uposition (th_r, 125, 140);
  gtk_widget_set_usize (th_r, 25, 22);
  gtk_tooltips_set_tip (tooltips, th_r, "To hours - 0 to 23", NULL);

  label = gtk_label_new (":");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedr), label, 152, 140);
  gtk_widget_set_uposition (label, 152, 140);
  gtk_widget_set_usize (label, 5, 22);

  tm_r = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "tm_r", tm_r);
  gtk_widget_show (tm_r);
  gtk_fixed_put (GTK_FIXED (fixedr), tm_r, 160, 140);
  gtk_widget_set_uposition (tm_r, 160, 140);
  gtk_widget_set_usize (tm_r, 25, 22);
  gtk_tooltips_set_tip (tooltips, tm_r, "To minutes - 0 to 59", NULL);

  label = gtk_label_new ("use");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedr), label, 190, 140);
  gtk_widget_set_uposition (label, 190, 140);
  gtk_widget_set_usize (label, 20, 22);

  u_r = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "u_r", u_r);
  gtk_widget_show (u_r);
  gtk_fixed_put (GTK_FIXED (fixedr), u_r, 215, 140);
  gtk_widget_set_uposition (u_r, 215, 140);
  gtk_widget_set_usize (u_r, 50, 22);
  gtk_tooltips_set_tip (tooltips, u_r, "Time in secs for the first pulse", NULL);

  f_r = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "f_r", f_r);
  gtk_widget_show (f_r);
  gtk_fixed_put (GTK_FIXED (fixedr), f_r, 365, 140);
  gtk_widget_set_uposition (f_r, 365, 140);
  gtk_widget_set_usize (f_r, 35, 22);
  gtk_tooltips_set_tip (tooltips, f_r, "Number of seconds for the first pulse", NULL);

  fa_r = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "fa_r", fa_r);
  gtk_widget_show (fa_r);
  gtk_fixed_put (GTK_FIXED (fixedr), fa_r, 420, 140);
  gtk_widget_set_uposition (fa_r, 420, 140);
  gtk_widget_set_usize (fa_r, 40, 22);
  gtk_tooltips_set_tip (tooltips, fa_r, "First pulse cost", NULL);

  label = gtk_label_new ("at");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedr), label, 405, 140);
  gtk_widget_set_uposition (label, 405, 140);
  gtk_widget_set_usize (label, 10, 22);

  label = gtk_label_new ("first");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedr), label, 328, 140);
  gtk_widget_set_uposition (label, 328, 140);
  gtk_widget_set_usize (label, 30, 22);

  label = gtk_label_new ("at");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedr), label, 270, 140);
  gtk_widget_set_uposition (label, 270, 140);
  gtk_widget_set_usize (label, 10, 22);

  a_r = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "a_r", a_r);
  gtk_widget_show (a_r);
  gtk_fixed_put (GTK_FIXED (fixedr), a_r, 285, 140);
  gtk_widget_set_uposition (a_r, 285, 140);
  gtk_widget_set_usize (a_r, 40, 22);
  gtk_tooltips_set_tip (tooltips, a_r, "Cost of one pulse", NULL);



  mon = gtk_radio_button_new_with_label (cday_group, "Monday");
  cday_group = gtk_radio_button_group (GTK_RADIO_BUTTON (mon));
  gtk_object_set_data (GTK_OBJECT (Main), "mon", mon);
  gtk_widget_show (mon);
  gtk_fixed_put (GTK_FIXED (fixedr), mon, 16, 180);
  gtk_widget_set_uposition (mon, 16, 180);
  gtk_widget_set_usize (mon, 88, 22);  
  gtk_signal_connect (GTK_OBJECT (mon), "toggled",
                      GTK_SIGNAL_FUNC (on_mon_toggled),
                      NULL);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (mon), TRUE);

  tue = gtk_radio_button_new_with_label (cday_group, "Tuesday");
  cday_group = gtk_radio_button_group (GTK_RADIO_BUTTON (tue));
  gtk_object_set_data (GTK_OBJECT (Main), "tue", tue);
  gtk_widget_show (tue);    
  gtk_fixed_put (GTK_FIXED (fixedr), tue, 130, 180);
  gtk_widget_set_uposition (tue, 130, 180);
  gtk_widget_set_usize (tue, 88, 22); 
  gtk_signal_connect (GTK_OBJECT (tue), "toggled",
                      GTK_SIGNAL_FUNC (on_tue_toggled),
                      NULL);

  wed = gtk_radio_button_new_with_label (cday_group, "Wednesday");
  cday_group = gtk_radio_button_group (GTK_RADIO_BUTTON (wed));
  gtk_object_set_data (GTK_OBJECT (Main), "wed", wed);
  gtk_widget_show (wed);    
  gtk_fixed_put (GTK_FIXED (fixedr), wed, 240, 180);
  gtk_widget_set_uposition (wed, 240, 180);
  gtk_widget_set_usize (wed, 88, 22); 
  gtk_signal_connect (GTK_OBJECT (wed), "toggled",
                      GTK_SIGNAL_FUNC (on_wed_toggled),
                      NULL);

  thu = gtk_radio_button_new_with_label (cday_group, "Thursday");
  cday_group = gtk_radio_button_group (GTK_RADIO_BUTTON (thu));
  gtk_object_set_data (GTK_OBJECT (Main), "thu", thu);
  gtk_widget_show (thu);    
  gtk_fixed_put (GTK_FIXED (fixedr), thu, 365, 180);
  gtk_widget_set_uposition (thu, 365, 180);
  gtk_widget_set_usize (thu, 88, 22); 
  gtk_signal_connect (GTK_OBJECT (thu), "toggled",
                      GTK_SIGNAL_FUNC (on_thu_toggled),
                      NULL);

  fri = gtk_radio_button_new_with_label (cday_group, "Friday");
  cday_group = gtk_radio_button_group (GTK_RADIO_BUTTON (fri));
  gtk_object_set_data (GTK_OBJECT (Main), "fri", fri);
  gtk_widget_show (fri);    
  gtk_fixed_put (GTK_FIXED (fixedr), fri, 60, 202);
  gtk_widget_set_uposition (fri, 60, 202);
  gtk_widget_set_usize (fri, 88, 22); 
  gtk_signal_connect (GTK_OBJECT (fri), "toggled",
                      GTK_SIGNAL_FUNC (on_fri_toggled),
                      NULL);

  sat = gtk_radio_button_new_with_label (cday_group, "Saturday");
  cday_group = gtk_radio_button_group (GTK_RADIO_BUTTON (sat));
  gtk_object_set_data (GTK_OBJECT (Main), "sat", sat);
  gtk_widget_show (sat);    
  gtk_fixed_put (GTK_FIXED (fixedr), sat, 195, 202);
  gtk_widget_set_uposition (sat, 195, 202);
  gtk_widget_set_usize (sat, 88, 22); 
  gtk_signal_connect (GTK_OBJECT (sat), "toggled",
                      GTK_SIGNAL_FUNC (on_sat_toggled),
                      NULL);

  sun = gtk_radio_button_new_with_label (cday_group, "Sunday");
  cday_group = gtk_radio_button_group (GTK_RADIO_BUTTON (sun));
  gtk_object_set_data (GTK_OBJECT (Main), "sun", sun);
  gtk_widget_show (sun);    
  gtk_fixed_put (GTK_FIXED (fixedr), sun, 325, 202);
  gtk_widget_set_uposition (sun, 325, 202);
  gtk_widget_set_usize (sun, 88, 22); 
  gtk_signal_connect (GTK_OBJECT (sun), "toggled",
                      GTK_SIGNAL_FUNC (on_sun_toggled),
                      NULL);

  frame1 = gtk_frame_new (NULL);
  gtk_object_set_data (GTK_OBJECT (Main), "frame1", frame1);
  gtk_widget_show (frame1);
  gtk_fixed_put (GTK_FIXED (fixedr), frame1, 8, 177);
  gtk_widget_set_uposition (frame1, 8, 177);
  gtk_widget_set_usize (frame1, 460, 50);

  fixedh = gtk_fixed_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "fixedh", fixedh);
  gtk_widget_show (fixedh);
  gtk_container_add (GTK_CONTAINER (notebook1), fixedh); 

  label = gtk_label_new ("Day:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedh), label, 140, 40);
  gtk_widget_set_uposition (label, 140, 40);
  gtk_widget_set_usize (label, 30, 22);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  h_day = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "h_day", h_day);
  gtk_widget_show (h_day);
  gtk_fixed_put (GTK_FIXED (fixedh), h_day, 180, 40);
  gtk_widget_set_uposition (h_day, 180, 40);
  gtk_widget_set_usize (h_day, 30, 22);
  gtk_tooltips_set_tip (tooltips, h_day, "Day", NULL);

  label = gtk_label_new ("Month:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedh), label, 140, 80);
  gtk_widget_set_uposition (label, 140, 80);
  gtk_widget_set_usize (label, 40, 22);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  h_mon = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "h_mon", h_mon);
  gtk_widget_show (h_mon);
  gtk_fixed_put (GTK_FIXED (fixedh), h_mon, 180, 80);
  gtk_widget_set_uposition (h_mon, 180, 80);
  gtk_widget_set_usize (h_mon, 30, 22);
  gtk_tooltips_set_tip (tooltips, h_mon, "Month", NULL);

  badd = gtk_button_new_with_label ("Add");
  gtk_object_set_data (GTK_OBJECT (Main), "badd", badd);
  gtk_widget_show (badd);
  gtk_fixed_put (GTK_FIXED (fixedh), badd, 140, 120);
  gtk_widget_set_uposition (badd, 140, 120);
  gtk_widget_set_usize (badd, 70, 22);
  gtk_signal_connect (GTK_OBJECT (badd), "button_press_event",
                      GTK_SIGNAL_FUNC (on_badd_button_press_event),
                      NULL);

  bdel = gtk_button_new_with_label ("Remove");
  gtk_object_set_data (GTK_OBJECT (Main), "bdel", bdel);
  gtk_widget_show (bdel);
  gtk_fixed_put (GTK_FIXED (fixedh), bdel, 140, 150);
  gtk_widget_set_uposition (bdel, 140, 150);
  gtk_widget_set_usize (bdel, 70, 22);
  gtk_signal_connect (GTK_OBJECT (bdel), "button_press_event",
                      GTK_SIGNAL_FUNC (on_bdel_button_press_event),
                      NULL);

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (Main), "scrolledwindow", scrolledwindow);   
  gtk_widget_show (scrolledwindow);
  gtk_fixed_put (GTK_FIXED (fixedh), scrolledwindow, 25, 40);
  gtk_widget_set_uposition (scrolledwindow, 25, 40);                          
  gtk_widget_set_usize (scrolledwindow, 100, 170);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	list = gtk_clist_new(1);
  	gtk_container_add (GTK_CONTAINER (scrolledwindow), list);  
    	gtk_signal_connect(GTK_OBJECT(list), "select_row",
                            GTK_SIGNAL_FUNC(selection_h_made),
                            NULL);
	gtk_clist_set_column_justification(GTK_CLIST(list), 0, GTK_JUSTIFY_CENTER);
/*	gtk_clist_set_border(GTK_CLIST(list), GTK_SHADOW_OUT);
    	gtk_clist_set_policy(GTK_CLIST(list), GTK_POLICY_AUTOMATIC,
                                                GTK_POLICY_AUTOMATIC);
*/
	gtk_clist_set_shadow_type(GTK_CLIST(list), GTK_SHADOW_IN);
        gtk_clist_set_column_title(GTK_CLIST (list),0,"Day/Month");
	gtk_clist_column_titles_show(GTK_CLIST (list));
    	gtk_widget_show(list);


  label = gtk_label_new ("Special Days:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedh), label, 8, 16);
  gtk_widget_set_uposition (label, 8, 16);
  gtk_widget_set_usize (label, 112, 22);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  h_con = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "h_con", h_con);
  gtk_widget_show (h_con);
  gtk_fixed_put (GTK_FIXED (fixedh), h_con, 340, 40);
  gtk_widget_set_uposition (h_con, 340, 40);
  gtk_widget_set_usize (h_con, 120, 22);
  gtk_tooltips_set_tip (tooltips, h_con, "Dial script", NULL);

  h_dcon = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "h_dcon", h_dcon);
  gtk_widget_show (h_dcon);
  gtk_fixed_put (GTK_FIXED (fixedh), h_dcon, 340, 80);
  gtk_widget_set_uposition (h_dcon, 340, 80);
  gtk_widget_set_usize (h_dcon, 120, 22);
  gtk_tooltips_set_tip (tooltips, h_dcon, "Hang script", NULL);

  label = gtk_label_new ("Connection:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedh), label, 235, 16);
  gtk_widget_set_uposition (label, 235, 16);
  gtk_widget_set_usize (label, 84, 22);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  label = gtk_label_new ("Start connection:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedh), label, 235, 40);
  gtk_widget_set_uposition (label, 235, 40);
  gtk_widget_set_usize (label, 110, 22);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  label = gtk_label_new ("Stop connection:");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  gtk_fixed_put (GTK_FIXED (fixedh), label, 235, 80);
  gtk_widget_set_uposition (label, 235, 80);
  gtk_widget_set_usize (label, 110, 22);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

  hseparator = gtk_vseparator_new ();
  gtk_object_set_data (GTK_OBJECT (Main), "hseparator", hseparator);
  gtk_widget_show (hseparator);
  gtk_fixed_put (GTK_FIXED (fixedh), hseparator, 220, 35);
  gtk_widget_set_uposition (hseparator, 220, 35);
  gtk_widget_set_usize (hseparator, 16, 185);

  label = gtk_label_new ("Global");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  set_notebook_tab (notebook1, 0, label);

  label = gtk_label_new ("Phone Rules");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  set_notebook_tab (notebook1, 1, label);

  label = gtk_label_new ("Holidays/Connections");
  gtk_object_set_data (GTK_OBJECT (Main), "label", label);
  gtk_widget_show (label);
  set_notebook_tab (notebook1, 2, label);    
 
  gtk_object_set_data (GTK_OBJECT (Main), "tooltips", tooltips);

  gtk_widget_show (Main);

/*********************************************/


  p = getenv("HOME");  
  strcpy(temp, p);
  strcat(temp, "/.aspbm/aspbmrc");

  fp = fopen(temp, "r");

  if (fp) {   
  parse_rcfile(temp, aspbm_keys);       
  }

  p = getenv("HOME");
  strcpy(temp, p);
  strcat(temp, "/.aspbm/rules/");
  strcat(temp, rulesrc);
  parse_rcfile(temp, rules_keys); 

  fp = fopen(temp, "r");

  if (fp) {
  parse_rcfile(temp, rules_keys);
  }                       
        
  defaults();  

  gtk_entry_set_text( GTK_ENTRY (csymbol),csymbolrc);

  gtk_entry_set_text( GTK_ENTRY (h_con),con_startrc);

  gtk_entry_set_text( GTK_ENTRY (h_dcon),con_stoprc);

  if (cpositionrc=="left")   gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (cp_1), TRUE);
  else   gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (cp_2), TRUE);

  gtk_entry_set_text( GTK_ENTRY (cact),actcostrc);

  gtk_entry_set_text( GTK_ENTRY (cfile),rulesrc);

  if (atoi(warnisrc)== 1)   gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (cw_1), TRUE);
  else   gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (cw_2), TRUE);
             
  gtk_entry_set_text( GTK_ENTRY (cwarntime),warningrc);
  gtk_entry_set_text( GTK_ENTRY (cwarnmsg),warnmsgrc);
  gtk_entry_set_text( GTK_ENTRY (cdelay),cdelayrc);

  if (atoi(logisrc)== 1)   gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (cl_1), TRUE);
  else   gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (cl_2), TRUE);

   string = (void *)malloc(64);
   sprintf(string, "%.2i",phone_rules[8].from_h);
   gtk_entry_set_text( GTK_ENTRY (dfh), string);
   free(string);
   string = (void *)malloc(64);
   sprintf(string, "%.2i",phone_rules[8].from_m);
   gtk_entry_set_text( GTK_ENTRY (dfm), string);
   free(string);
   string = (void *)malloc(64);
   sprintf(string, "%.2i",phone_rules[8].to_h);
   gtk_entry_set_text( GTK_ENTRY (dth), string);
   free(string);
   string = (void *)malloc(64);
   sprintf(string, "%.2i",phone_rules[8].to_m);
   gtk_entry_set_text( GTK_ENTRY (dtm), string);
   free(string);
   string = (void *)malloc(64);
   sprintf(string, "%i",phone_rules[8].use);
   gtk_entry_set_text( GTK_ENTRY (du), string);
   free(string);
   string = (void *)malloc(64);
   sprintf(string, "%.2f",phone_rules[8].at);
   gtk_entry_set_text( GTK_ENTRY (da), string);
   free(string);
   string = (void *)malloc(64);
   sprintf(string, "%i",phone_rules[8].first);
   gtk_entry_set_text( GTK_ENTRY (df), string);
   free(string);
   string = (void *)malloc(64);
   sprintf(string, "%.2f",phone_rules[8].fat);
   gtk_entry_set_text( GTK_ENTRY (dfa), string);
   free(string);

   fill(2, maxmon);

   for (i=1; i<maxholi+2; i++) {       	
	GtkWidget       *label;
      	gchar           *string; 
      	gchar 		*label1[] = {string}; 

	string = g_malloc(5);    
        sprintf(string, "%.2d/%.2d", hrules[i].day, hrules[i].month);


	gtk_clist_append((GtkCList*) list, label1 );

   }
   
   gtk_clist_remove( (GtkCList *) list, 0);
	

/***********************************************/
  gtk_main ();

  return 0;

}

