#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <stdarg.h>

#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>

#include <net/ppp_defs.h>
#include <net/if_ppp.h>      

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#ifndef ASPBM_H_INCLUDED
#define ASPBM_H_INCLUDED

  /***********/
 /* Defines */
/***********/

#define MAX_MOUSE_REGION 	(5)
#define ASPBM_VERSION   	"1.0"

  /***************/
 /* Phone rules */
/***************/

typedef struct {
        int             from_h;
        int             from_m;
        int             to_h;
        int             to_m;
        int             use;
        float     	at;
        int             first;
        float     	fat;
        int             and;
} RULES_STRUCT;                         

  /***************/
 /* Hrules */
/***************/

typedef struct {
        int             day;
        int             month;
} HRULES_STRUCT;                         

  /*****************/
 /* Mouse Regions */
/*****************/

typedef struct {
        int             enable;
        int             top;
        int             bottom;
        int             left;
        int             right;
} MOUSE_REGION;                         

  /***********/
 /* RcKeys  */
/***********/

typedef struct _rckeys rckeys;

struct _rckeys {
        const char      *label;
        char            **var;         
};

  /***********/
 /* Pixmaps */
/***********/

typedef struct {
        Pixmap                  pixmap;
        Pixmap                  mask;
        XpmAttributes   attributes;
} XpmIcon;


  /**********************/
 /* External Functions */
/**********************/

void copyXPMArea(int, int, int, int, int, int);  
void openXwindow(int argc, char *argv[], char **, char *, int, int);  
void GetXPM(XpmIcon *, char **);  
Pixel GetColor(char *);  
void createXBMfromXPM(char *, char **, int, int);
void setMaskXY(int, int);  
void AddMouseRegion(int, int, int, int, int);
int GetMouseRegion(int, int);
void RedrawWindowXY(int x, int y);  
void parse_rcfile(const char *, rckeys *);  

Window MakePopup();
void pop(int, int, float, int, float, float, char *, char *); 
void drawpop(int, int, float, int, float, float, char *, char *);  
void do_popdown();  
void poplog();
void poprules(float); 
void warnpop(); 
void bevels();  
int stillonline(char *); 
void Readlog(const char *); 
int Get_ip(char *);  
int hrule(); 
int rule();  
void configfile();
void configrulesfile();  
int f_exist();   

  /**********************/
 /* External Variables */
/**********************/

extern  char 	**environ;  

  /*****************/
 /* X11 Variables */
/*****************/ 

XSizeHints      mysizehints;
XWMHints        mywmhints;
Pixel           back_pix, fore_pix;
Window          iconwin, win;   
XpmIcon         wmgen; 
GC              NormalGC;  
Pixmap          pixmask; 

  /*******************/
 /* Global variable */
/*******************/

Display         *display;            
Window  	root, popup, warn, poplogs;  

MOUSE_REGION    mouse_region[MAX_MOUSE_REGION];  
RULES_STRUCT    phone_rules[33];
HRULES_STRUCT   hrules[20]; 

int     	pop_w, pop_h;
int     	pulse_time; 
int     	screen;  
int     	screen_width;
int     	screen_height;  

float   	pulse_cost;
 
char    	logfile[128];  
char    	local_ip[20];
char    	server_ip[20];  

XFontStruct     *popupfont, *warnfont, *logfont;
GC              NormalGC, PopupGC, WarnGC, LineGC, LogGC; 
Pixel           bg_pixel, fg_pixel, popbg_pixel, popfg_pixel, warnbg_pixel, warnfg_pixel;
Pixel           linebg_pixel, linefg_pixel;
XGCValues       gcv;
unsigned long   gcm; 

#endif 
