#include "aspbm.h" 


long    logttime = 0, logtpulse = 0;   
float   logtcost = 0;  

  /************/
 /* textlong */
/************/

int textlong(int bytes_in,int bytes_out, float cost, int atime, float acost, float actcost, char *csymbol, char *cposition){

int             pop_w;
int             longest;
static  char    *string, *aux;

        string = (void *)malloc(64);
        sprintf(string, "Remote IP: %s", server_ip);
        longest = strlen(string);

        aux = (void *)malloc(64);
        sprintf(aux, "Use: %is at %.2f%s",  pulse_time,pulse_cost,csymbol);
        if (strlen(aux) > longest) {                                    
                string = aux;
                longest = strlen(string);
        }
        free(aux);

        aux = (void *)malloc(64);
        sprintf(aux, "Use: %is at %.2f%s",  atime,acost,csymbol);
        if (strlen(aux) > longest) {
                string = aux;
                longest = strlen(string);
        }
        free(aux);

        aux = (void *)malloc(64);
        sprintf(aux, "Use: Act. Cost %.2f%s", actcost,csymbol);
        if (strlen(aux) > longest) {
                string = aux;
                longest = strlen(string);
        }
        free(aux);

        aux = (void *)malloc(64);
        sprintf(aux, "Bytes In: %i", bytes_in);
        if (strlen(aux) > longest) {
                string = aux;
                longest = strlen(string);
        }
        free(aux);

        aux = (void *)malloc(64);
        sprintf(aux, "Bytes out: %i", bytes_out);
        if (strlen(aux) > longest) {
                string = aux;
                longest = strlen(string);
        }
        free(aux);

        aux = (void *)malloc(64);
        sprintf(aux, "Total Cost: %.2f%s", logtcost, csymbol);
        if (strlen(aux) > longest) {
                string = aux;                              
                longest = strlen(string);
        }
        free(aux);

        pop_w = XTextWidth(popupfont, string , longest) +60;

	return pop_w;
}

  /**********************************/
 /* Makepopup - Construct a window */
/**********************************/

Window MakePopup(int x, int y, unsigned int w, unsigned int h, Pixel fg_pixel, Pixel bg_pixel, int bw){

unsigned long           valuemask;
Window                  my_win;
XSetWindowAttributes    attributes;

valuemask = CWBackingStore | CWSaveUnder | CWOverrideRedirect | CWBackPixel;      
attributes.save_under = True;
attributes.override_redirect = True;
attributes.background_pixel = bg_pixel;
attributes.backing_store = WhenMapped;

my_win = XCreateWindow(display, root, x, y, w, h, bw, CopyFromParent, CopyFromParent, 
	CopyFromParent, valuemask, &attributes);
XMapWindow(display, my_win);

return my_win;
}

  /******************************/
 /* Do_popdown - Kill a window */
/******************************/

void do_popdown(Window win){

XUngrabPointer(display, CurrentTime);
XDestroyWindow(display, win);
}   

  /*****************************/
 /* Draw_arrow - Draw a arrow */
/*****************************/

void draw_arrow(int x, int y, int dir){

if (dir==1) {
        XDrawLine(display, popup,  PopupGC, x-12, y, x-12, y+8);
        XDrawLine(display, popup,  PopupGC, x-12, y, x-5, y+4);
        XDrawLine(display, popup,  LineGC, x-12, y+8, x-5, y+4);
}
if (dir==0) {
        XDrawLine(display, popup,  PopupGC, x+12, y, x+12, y+8);
        XDrawLine(display, popup,  LineGC, x+12, y, x+5, y+4);
        XDrawLine(display, popup,  PopupGC, x+12, y+8, x+5, y+4);
}

}   


  /******************************/
 /* DrawPop - window with info */
/******************************/

void drawpop(int bytes_in, int bytes_out, float cost,int atime,float acost,float actcost, char *csymbol, char *cposition) {

int             logh = 0, logm = 0, logs = 0;
int             tx, dir;
int             win_x, win_y, win_w, win_h, win_xm, win_ym, win_b, win_d;  
static  char    *string;
Window          dummy;   

        Readlog(logfile);

        XGetGeometry(display, popup, &dummy, &win_x, &win_y, &win_w, &win_h, &win_b, &win_d);
        XTranslateCoordinates(display, popup, root, 0, 0, &win_xm, &win_ym, &dummy);
        if(win_xm >= (screen_width / 2)) dir=0;
        else dir=1;     

        tx = XTextWidth(popupfont, "Info Window", strlen("Info Window"));
        tx = (pop_w / 2) - (tx/2);
        XDrawString(display, popup, NormalGC, tx, 15, "Info Window", strlen("Info Window"));

        XDrawLine(display, popup,  PopupGC, 1, 18, pop_w-1, 18);
        XDrawLine(display, popup,  LineGC, 1, 19, pop_w-1, 19);
        XDrawString(display, popup, NormalGC, 5, 32, "Connection", strlen("Connection"));
                                                                                             
        string = (void *)malloc(64);
        sprintf(string, "Remote IP: %s", server_ip);
        XDrawString(display, popup, NormalGC, 20, 50, string, strlen(string));

        free(string);
        string = (void *)malloc(64);
        sprintf(string, "Local IP: %s", local_ip);
        XDrawString(display, popup, NormalGC, 20, 65, string, strlen(string));

        free(string);
        string = (void *)malloc(64);
        if (strstr(cposition,"right")) sprintf(string, "Use: %is at %.2f%s",  pulse_time,pulse_cost,csymbol);
        else sprintf(string, "Use: %is at %s%.2f",  pulse_time,csymbol, pulse_cost);
        XDrawString(display, popup, NormalGC, 20, 80, string, strlen(string));
        free(string);

        string = (void *)malloc(64);
        if (strstr(cposition,"right")) sprintf(string, "%is at %.2f%s",  atime,acost,csymbol);
        else sprintf(string, "%is at %s%.2f",  atime,csymbol, acost);
        XDrawString(display, popup, NormalGC, 50, 95, string, strlen(string));

        string = (void *)malloc(64);                                      
        if (strstr(cposition,"right")) sprintf(string, "Act. Cost %.2f%s", actcost,csymbol);
        else sprintf(string, "Act. Cost %s%.2f",  csymbol, actcost);
        XDrawString(display, popup, NormalGC, 50, 110, string, strlen(string));
	
	if (dir==1) draw_arrow(pop_w, 72, 1);	
	if (dir==0) draw_arrow(0, 72, 0);	

        XDrawLine(display, popup,  PopupGC, 1, 113, pop_w-1, 113);
        XDrawLine(display, popup,  LineGC, 1, 114, pop_w-1, 114);
        XDrawString(display, popup, NormalGC, 20, 130, "Current", strlen("Current"));

        free(string);
        string = (void *)malloc(64);

        if (strstr(cposition,"right")) sprintf(string, "Cost %.2f%s", cost,csymbol);
        else sprintf(string, "Cost %s%.2f", csymbol, cost);

        XDrawString(display, popup, NormalGC, 40, 145, string, strlen(string));

        free(string);                                                   
        string = (void *)malloc(64);
        sprintf(string, "Bytes In: %i", bytes_in);
        XDrawString(display, popup, NormalGC, 40, 160, string, strlen(string));

        free(string);
        string = (void *)malloc(64);
        sprintf(string, "Bytes Out: %i", bytes_out);
        XDrawString(display, popup, NormalGC, 40, 175, string, strlen(string));

        XDrawLine(display, popup,  PopupGC, 1, 178, pop_w-1, 178);
        XDrawLine(display, popup,  LineGC, 1, 179, pop_w-1, 179);
        XDrawString(display, popup, NormalGC, 20, 195, "Total", strlen("Total"));

	if (dir==1) draw_arrow(pop_w, 187, 1);	
	if (dir==0) draw_arrow(0, 187, 0);	

        free(string);
        string = (void *)malloc(64);

        if (strstr(cposition,"right")) sprintf(string, "Total Cost: %.2f%s", logtcost+cost, csymbol);
        else sprintf(string, "Total Cost: %s%.2f", csymbol, logtcost+cost);             
        XDrawString(display, popup, NormalGC, 40, 210, string, strlen(string));

        free(string);
        string = (void *)malloc(64);

        logs = logttime % 60;
        logm = (logttime / 60) % 60;
        logh = (logttime / 3600 );

        sprintf(string, "Total Time: %i:%.2i:%.2i", logh,logm,logs);
        XDrawString(display, popup, NormalGC, 40, 225, string, strlen(string));
        XDrawLine(display, popup,  PopupGC, 1, pop_h, pop_w-1, pop_h);

        free(string);
        bevels(popup, 0, 0, pop_w, pop_h);
}                                                                           
                                    
  /******************************/
 /* Pop - Pop window with info */
/******************************/

void pop(int bytes_in,int bytes_out, float cost, int atime, float acost, float actcost, char *csymbol, char *cposition){

int             x, y;
int             win_x, win_y, win_w, win_h, win_xm, win_ym, win_b, win_d;
Window          dummy;

pop_h = 230;
pop_w = textlong( bytes_in, bytes_out, cost, atime, acost, actcost, csymbol, cposition);

XGetGeometry(display, win, &dummy, &win_x, &win_y, &win_w, &win_h, &win_b, &win_d);
XTranslateCoordinates(display, win, root, 0, 0, &win_xm, &win_ym, &dummy);

if(win_xm >= (screen_width / 2)) x = win_xm - pop_w - 2;
else x = win_xm + 64;

if(win_ym >= (screen_height / 2)) y = win_ym - pop_h +64;
else y = win_ym;

popup = MakePopup(x, y, pop_w, pop_h, popfg_pixel, popbg_pixel, 1);
XGrabPointer(display, popup, True,  ButtonReleaseMask|PointerMotionMask, GrabModeAsync,GrabModeAsync, None, None, CurrentTime);
drawpop(bytes_in, bytes_out, cost, atime, acost, actcost, csymbol, cposition);
}                                             

  /**********************************/
 /* PopLogs - Pop window with logs */
/**********************************/

void poplog() {

int             x, y, log_w = 260, log_h = 400;
int             win_x, win_y, win_w, win_h, win_xm, win_ym, win_b, win_d;
int             tx;
static  char    *string;
Window          dummy;
int             i = 35, j = 0;

int     i1=0,i2=0,i3=0,i4=0,i5=0,i6=0,i7=0;
int     logs=0,logm=0,logh=0;
float   i8=0;
char    temp[128];
FILE    *fp;


        XGetGeometry(display, popup, &dummy, &win_x, &win_y, &win_w, &win_h, &win_b, &win_d);
        XTranslateCoordinates(display, popup, root, 0, 0, &win_xm, &win_ym, &dummy);
                                                                                                 
        fp = fopen(logfile, "r");
        if (fp) {
                while (fgets(temp, 128, fp)) j += 1;
                fclose(fp);
        }

        log_h = j * 15 +60;

        if(win_xm >= (screen_width / 2)) x = win_xm - log_w -2;
        else x = win_xm + pop_w;

        if(win_ym >= (screen_height / 2)) y = win_ym +pop_h - log_h -1;
        else y = win_ym -1;

        if ((y+log_h) >= screen_height) y = y - ((y+log_h)-screen_height);

        poplogs = MakePopup(x, y, log_w, log_h, popfg_pixel, popbg_pixel, 1);

        tx = XTextWidth(popupfont, "Logs Window", strlen("Logs Window"));
        tx = (log_w / 2) - (tx/2);
        XDrawString(display, poplogs, NormalGC, tx, 15, "Logs Window", strlen("Logs Window"));

        XDrawLine(display, poplogs,  PopupGC, 1, 18, log_w-1, 18);
        XDrawLine(display, poplogs,  LineGC, 1, 19, log_w-1, 19);

        XDrawLine(display, poplogs,  LineGC, 45, 40, 45, log_h-22);
        XDrawLine(display, poplogs,  LineGC, 102, 40, 102, log_h-22);
        XDrawLine(display, poplogs,  LineGC, 160, 40, 160, log_h-22);
        XDrawLine(display, poplogs,  LineGC, 205, 40, 205, log_h-22);

        string = (void *)malloc(64);
        sprintf(string, "Date         Time          Online      Pulses       Cost");
        XDrawString(display, poplogs, LogGC, 10, i, string, strlen(string));          
        free(string);

        fp = fopen(logfile, "r");
        if (fp) {
        while (fgets(temp, 128, fp)) {
                i += 15;
                sscanf(temp, "%d/%d - %d:%d:%d - %d - %d - %f", &i1, &i2, &i3, &i4, &i5, &i6, &i7, &i8);

                logs = i6 % 60;
                logm = (i6 / 60) % 60;
                logh = (i6 / 3600 );

                string = (void *)malloc(64);
                sprintf(string, "%.2i/%.2i     %.2i:%.2i:%.2i     %.2i:%.2i:%.2i        %.3i         %.2f", i1, i2, i3, i4, i5, logh, logm, logs, i7, i8); 

                XDrawString(display, poplogs, LogGC, 10, i, string, strlen(string));
                XDrawLine(display, poplogs,  LineGC, 1, i-12, log_w, i-12);
                free(string);
        }
        fclose(fp);
        }

        XDrawLine(display, poplogs,  LineGC, 1, log_h-22, log_w, log_h-22);

        Readlog(logfile);

        logs = logttime % 60;
        logm = (logttime / 60) % 60;
        logh = (logttime / 3600 );

        string = (void *)malloc(64);
        sprintf(string, "Total                 %i:%.2i:%.2i    %.3li    %.2f", logh,logm,logs,logtpulse,logtcost);
        XDrawString(display, poplogs, NormalGC, 10, log_h - 5, string, strlen(string));
        free(string);                                            

        bevels(poplogs, 0, 0, log_w, log_h);
}

  /************************************/
 /* PopRules - Pop window with rules */
/************************************/

void poprules(float actcost) {

int             x, y, log_w = 300, log_h = 300;
int             win_x, win_y, win_w, win_h, win_xm, win_ym, win_b, win_d;
int             tx, iand = 0, i, j = 1, k =1;
int             x1, x2, myy;
Window          dummy;
static  char    *string;
static  char    *aux[9];                                         
aux[1]="Sunday";
aux[2]="Monday";
aux[3]="Tuesday";
aux[4]="Wednesday";
aux[5]="Thursday";
aux[6]="Friday";
aux[7]="Saturday";
aux[8]="Default";

        XGetGeometry(display, popup, &dummy, &win_x, &win_y, &win_w, &win_h, &win_b, &win_d);
        XTranslateCoordinates(display, popup, root, 0, 0, &win_xm, &win_ym, &dummy);

for (i = 1; i<= 8; i++) {
        iand = i;
        k += 2;
        while (phone_rules[iand].and ==1) {
                iand = iand + 8;
                k += 2;                                          
        }
k +=2;
}

log_h = k*15+20;
tx = XTextWidth(popupfont, "00:00", strlen("00:00"));
log_w = 270+tx;

        if(win_xm >= (screen_width / 2)) x = win_xm - log_w -2;
        else x = win_xm + pop_w;

        if(win_ym >= (screen_height / 2)) y = win_ym +pop_h - log_h -1;
        else y = win_ym -1;

        if ((y+log_h) >= screen_height) y = y - ((y+log_h)-screen_height);


        poplogs = MakePopup(x, y, log_w, log_h, popfg_pixel, popbg_pixel, 1);           
        tx = XTextWidth(popupfont, "Rules Window", strlen("Rules Window"));
        tx = (log_w / 2) - (tx/2);
        XDrawString(display, poplogs, NormalGC, tx, 15, "Rules Window", strlen("Rules Window"));

        XDrawLine(display, poplogs,  PopupGC, 1, 18, log_w-1, 18);
        XDrawLine(display, poplogs,  LineGC, 1, 19, log_w-1, 19);

for (i = 1; i<= 8; i++) {

        iand = i;

        XDrawString(display, poplogs, PopupGC,20, 15*j+25, aux[i], strlen(aux[i]));

        j += 2;

        myy = 15*(j-2)+9;

        x1 = phone_rules[iand].from_h*10+phone_rules[iand].from_m*10/60+15;
        x2 = phone_rules[iand].to_h*10+phone_rules[iand].to_m*10/60;
        x2 = x2 -x1+15;

        string = (void *)malloc(64);
        sprintf(string, "%.2i:%.2i", phone_rules[iand].to_h,  phone_rules[iand].to_m);
        tx = XTextWidth(popupfont, string, strlen(string));
        XFillRectangle(display, poplogs, LineGC, x1,15*j+9, x2+tx,12);
        XDrawString(display, poplogs, PopupGC, x1+x2, 15*j+20, string, strlen(string));
        free(string);
        string = (void *)malloc(64);
        sprintf(string, "%.2i:%.2i", phone_rules[iand].from_h,  phone_rules[iand].from_m);
        XDrawString(display, poplogs, PopupGC, x1, 15*j+20, string, strlen(string));
        free(string);
        string = (void *)malloc(64);                              
        sprintf(string, "%i s at %.2f / first %i s at %.2f / Activation cost %.2f", phone_rules[iand].use,
                phone_rules[iand].at, phone_rules[iand].first,  phone_rules[iand].fat, actcost);
        tx = XTextWidth(logfont, string, strlen(string));
        XDrawString(display, poplogs, LogGC, (log_w/2)-(tx/2), 15*(j+1)+20, string, strlen(string));
        free(string);


        while (phone_rules[iand].and ==1) {

                iand = iand + 8;
                j += 2;

                x1 = phone_rules[iand].from_h*10+phone_rules[iand].from_m*10/60+15;
                x2 = phone_rules[iand].to_h*10+phone_rules[iand].to_m*10/60;
                x2 = x2 -x1+15;

                string = (void *)malloc(64);
                sprintf(string, "%.2i:%.2i", phone_rules[iand].to_h,  phone_rules[iand].to_m);
                tx = XTextWidth(popupfont, string, strlen(string));
                XFillRectangle(display, poplogs, LineGC, x1,15*j+9, x2+tx,12);
                XDrawString(display, poplogs, PopupGC, x1+x2, 15*j+20, string, strlen(string));
                free(string);
                string = (void *)malloc(64);
                sprintf(string, "%.2i:%.2i", phone_rules[iand].from_h,  phone_rules[iand].from_m);
                XDrawString(display, poplogs, PopupGC, x1, 15*j+20, string, strlen(string));
                free(string);
                string = (void *)malloc(64);
                sprintf(string, "%i s at %.2f / first %i s at %.2f / Activation cost %.2f", phone_rules[iand].use,
                        phone_rules[iand].at, phone_rules[iand].first,  phone_rules[iand].fat, actcost);
                tx = XTextWidth(logfont, string, strlen(string));
                XDrawString(display, poplogs, LogGC, (log_w/2)-tx/2, 15*(j+1)+20, string, strlen(string));
                free(string);
                                              
        }
        bevels(poplogs, 10,  myy+2 ,log_w-10, 15*(j+1)+23);

        j +=2;
}
bevels(poplogs, 0, 0, log_w, log_h);

}                               

  /********************************/
 /* WarnPop - pop warning window */
/********************************/                        
void warnpop(char *msg) {

int longest, msg_width;

longest = strlen(msg);
msg_width = XTextWidth(warnfont, msg, longest);

if (msg_width > (screen_width-151)) msg_width = screen_width;

warn = MakePopup((int)(screen_width/2-msg_width/2-75), (int)(screen_height/2-100), 
	msg_width+150, 200, warnfg_pixel, warnbg_pixel, 1);

XDrawString(display, warn, WarnGC, (int)((msg_width+150)/2-msg_width/2), 100, msg, strlen(msg));
}                             

  /****************/
 /* Logfile Read */
/****************/

void Readlog(const char *filename) {

int     i1=0,i2=0,i3=0,i4=0,i5=0,i6=0,i7=0;
float   i8=0;
char    temp[128];
FILE    *fp;

logttime = 0;
logtpulse = 0;
logtcost = 0;

fp = fopen(filename, "r");
if (fp) {
        while (fgets(temp, 128, fp)) {
                i6=0;
                i7=0;
                i8=0;
                sscanf(temp, "%d/%d - %d:%d:%d - %d - %d - %f", &i1, &i2, &i3, &i4, &i5, &i6, &i7, &i8);
                logttime=logttime+i6;
                logtpulse=logtpulse+i7;
                logtcost=logtcost+i8;
        }
        fclose(fp);
/*      fprintf(stderr, "\n%li -- %li -- %f\n", logttime, logtpulse, logtcost);*/
}                                                                                    
}



  /***********/
 /* Get IP  */
/***********/

int Get_ip(char *active_interface) {

FILE *tmp;
char ip_s[20];
char ip_l[20];
int ip1, ip2, ip3, ip4;

if(stillonline(active_interface)) {

        system("/sbin/ifconfig | grep P-t-P | awk '{print $2}' | cut -d: -f2 > /tmp/local.ip");
        system("/sbin/ifconfig | grep P-t-P | awk '{print $3}' | cut -d: -f2 > /tmp/server.ip");

        tmp = fopen("/tmp/local.ip", "r");

        if(tmp != NULL) {
                fscanf(tmp, "%s\n", ip_l);
        }
        fclose(tmp);

        tmp = fopen("/tmp/server.ip", "r");

        if(tmp != NULL) {
                fscanf(tmp, "%s\n", ip_s);
        }
        fclose(tmp);

        if(sscanf(ip_l, "%d.%d.%d.%d", &ip1, &ip2, &ip3, &ip4) != 4) {                   
                sprintf(local_ip, "Unknown\n");
        } else {
                sprintf(local_ip, "%d.%d.%d.%d\n", ip1, ip2, ip3, ip4);
        }

        if(sscanf(ip_s, "%d.%d.%d.%d", &ip1, &ip2, &ip3, &ip4) != 4) {
                sprintf(server_ip, "Unknown\n");
        } else {
             sprintf(server_ip, "%d.%d.%d.%d\n", ip1, ip2, ip3, ip4);
        }

        system("rm -f /tmp/local.ip; rm -f /tmp/server.ip");

}
return 1;
}                                           

  /*****************************/
 /* bavels - window decoration*/
/*****************************/

void bevels(Window w, int x, int y, int xw, int yw) {

XDrawLine(display, w,  LineGC, x, y, xw-1, y);
XDrawLine(display, w,  LineGC, x, y, x, yw-1);
XDrawLine(display, w,  PopupGC, x+1,  yw-1, xw,  yw-1);
XDrawLine(display, w,  PopupGC, xw-1, y,  xw-1, yw-1);
}


