/*Afterstep phone bill monitor.

	Author: Pedro Moleiro (moleiro@ip.pt)

	This program is distributed under the GPL license.

-----------------------------------------------------------
Code based on wmppp - 

	Authors: 	Martijn Pieterse (pieterse@xs4all.nl)
              		Antoine Nulle (warp@xs4all.nl) 

Code based on loadmeter - http://www.zip.com.au/~bb/linux/ 

	Author: 	Ben Buxton (bb@zip.com.au)

-----------------------------------------------------------*/
#include "aspbm.h"
#include "misc.h"

#include "xpm/master.xpm"
#include "xpm/shaped.xpm"

  /***********/
 /* Defines */
/***********/

#define HOSTFONT "-*-helvetica-bold-r-*-*-12-*-*-*-*-*-*-*" 
#define WARNFONT "-*-helvetica-bold-r-*-*-24-*-*-*-*-*-*-*" 
#define LOGFONT "-*-helvetica-bold-r-*-*-10-*-*-*-*-*-*-*" 

#define CON_STARTRC 	(NULL)     
#define CON_STOPRC 	(NULL)     
#define WARNISRC 	(NULL)     
#define WARNINGRC 	(NULL)     
#define WARNMSGRC 	(NULL)     
#define CDELAYRC 	(NULL)     
#define CSYMBOLRC 	(NULL)     
#define CPOSITIONRC 	(NULL)     
#define LOGISRC 	(NULL)     
#define RULESRC 	(NULL)     
#define ACTCOSTRC 	(NULL)     
#define DEFAULT0 	(NULL)     
#define MONDAY 		(NULL)     
#define TUESDAY 	(NULL)     
#define WEDNESDAY 	(NULL)     
#define THURSDAY 	(NULL)     
#define FRIDAY 		(NULL)     
#define SATURDAY 	(NULL)     
#define SUNDAY 		(NULL)     
#define HOLYDAY		(NULL)     

#define LED_RX 		(1)
#define LED_TX       	(2)
#define LED_POWER    	(3)   
#define LED_WAIT    	(4)   

#define ORANGE_LED_TIMEOUT 	(60) 

#define LED_ON_X	(55)
#define LED_ON_Y 	(143)
#define LED_OFF_Y 	(138)
#define LED_OFF_X 	(55)
#define LED_ERR_X 	(60)
#define LED_ERR_Y 	(138)
#define LED_WTE_X 	(60)
#define LED_WTE_Y 	(143)
#define LED_SZE_X 	(4)
#define LED_SZE_Y 	(4) 
     
#define LED_PWR_X 	(53)
#define LED_PWR_Y 	(7)
#define LED_SND_X 	(47)
#define LED_SND_Y 	(7)
#define LED_RCV_X 	(41)
#define LED_RCV_Y 	(7)

#define TIME_X        	(19)
#define PULSE_X	      	(6) 

  /********************/
 /* Global Variables */
/********************/

int	Divisor=60; 
int	shaped=0; 
int	test = 0;
int	log = 0;
int	actv = 0;
int	oldday = 0;
int	isholyday = 0;
int 	mask_width = 64;
int 	mask_height = 64;
int	warning, connect_delay;
int	is_blink=1;
int	is_con=0;
int     atime = 0;
int    	myfile=0;

float   acost = 0;
float   actcost = 0; 

char   	*conf_file=NULL;
char    *csymbol=NULL;
char    *cposition=NULL;  
char	*ProgName;
char 	mask_bits[64*128];
char 	*display_name = NULL;  
char    *active_interface = "ppp0"; 

FILE 	*fp; 

pid_t  	stop_child = 0;
pid_t  	start_child = 0;   
 
  /*****************/
 /* PPP variables */
/*****************/

#define         PPP_STATS_HIS   54

int             updaterate = 5;
int             ppp_h = -1;
int             ppp_history[PPP_STATS_HIS+1][2];
long            ppptime;  
                                       
  /***********************/
 /* Function Prototypes */
/***********************/

void usage(void);
void Version(void);
void aspbm_routine(int, char **);
void DrawTime(int, int, int, int); 
void DrawPulse(int, int);
void DrawSpeed(long, int);
void DrawStats(int *, int, int, int, int); 
void get_ppp_stats(struct ppp_stats *cur);  
int get_statistics(char *, long *, long *, long *, long *); 
int get_number(long);
void SetLED(int, int);
void defaults();
int check_pulse();   

  /********/
 /* Main */
/********/

int main(int argc, char *argv[]) {

	int		i;
	
	/* Parse Command Line */

	ProgName = argv[0];
	if (strlen(ProgName) >= 5)
		ProgName += (strlen(ProgName) - 5);
	
	for (i=1; i<argc; i++) {
		char *arg = argv[i];

		if (*arg=='-') {
			switch (arg[1]) {
			case 'p' :
				break;
			case 's' :
                                shaped = 1;
                                break;  
			case 'f' :
                                myfile = 1;
				if (!strcmp(argv[i], "-f")) {
                        		conf_file = argv[i+1];
                        		i++;
                		}
                                break;  
			case 't' :
                                Divisor = 1;
                                break;  
			case 'u' :
                                i++;
                                if (!argv[i]) {
                                        usage();
                                        exit(1);
                                }
                                updaterate = atoi(argv[i]);
                                if (updaterate < 1 || updaterate > 10) {
                                        usage();
                                        exit(1);
                                }
                                break;  
                  	case 'v' :
				Version();
				exit(0);
                                break;  
			case 'z' :
                                test = 1;
				break;
			default:
				usage();
				exit(0);
				break;
			}
		}
	}
	
	aspbm_routine(argc, argv);
	
	return 0;
}

  /******************/
 /* aspbm_routine */
/******************/

char    *con_startrc = NULL;  
char    *con_stoprc = NULL;  
char    *warnisrc = NULL;  
char    *warningrc = NULL;  
char    *warnmsgrc = NULL;  
char    *cdelayrc = NULL;  
char    *csymbolrc = NULL;  
char    *cpositionrc = NULL;  
char    *logisrc = NULL;  
char    *rulesrc = NULL;  
char    *actcostrc = NULL;  

char    *default0 = NULL;  
char    *monday = NULL;  
char    *tuesday = NULL;  
char    *wednesday = NULL;  
char    *thursday = NULL;  
char    *friday = NULL;  
char    *saturday = NULL;  
char    *sunday = NULL;  
char    *holyday = NULL;  


void aspbm_routine(int argc, char **argv) {

	int			status;
	int			j, i, imouse;
	int			start_time, pulsestart_time;
	int			curr_time, last_time;
	int			stat_cur = 0;
	int			Xmask = 0;
	int			pulse_counter = 0;
	int		 	pulse_on, time_on;
	int		 	iswarnpop = 0, ispopup = 0, ispoplog = 0;
	int			warnind = 0;
	int			logind = 0;

	float			cost = 0;

	long		 	bytes_in = 0;
	long		 	bytes_out = 0;
	long                    ppp_send,ppp_sl = 1;
        long                    ppp_recv,ppp_rl = 1;
        long                    ppp_sbytes,ppp_rbytes;
        long                    ppp_osbytes = 0;
	long			ppp_orbytes = 0;        

	char                    main_file[128], rules_file[128]; 
        char                    *home_env;  
	char 			*stringlog;
        	
	XEvent                  Event;  	
        time_t          	logtime;
        struct tm       	*mytime;
	
	/* rc keys */

	rckeys aspbm_keys[] = {
                { "connect_start", &con_startrc },
                { "connect_stop", &con_stoprc },
                { "warn", &warnisrc },
                { "warning", &warningrc },
                { "warnmsg", &warnmsgrc },
                { "delay", &cdelayrc },
                { "log", &logisrc },
                { "rules", &rulesrc },
                { NULL, NULL }
        };                         

	/* rules keys */

	rckeys rules_keys[] = {
                { "currency_symbol", &csymbolrc },
                { "currency_position", &cpositionrc },
                { "activation_cost", &actcostrc },
                { "default", &default0 },
                { "monday", &monday },
                { "tuesday", &tuesday },
                { "wednesday", &wednesday },
                { "thursday", &thursday },
                { "friday", &friday },
                { "saturday", &saturday },
                { "sunday", &sunday },
                { "holydays", &holyday },
                { NULL, NULL }
        };                         


    	/* Read config file */

        home_env = getenv("HOME");

        strcpy(logfile, home_env);
	strcat(logfile,"/.aspbm/log/aspbm.log");

	if (myfile==0) {
		strcpy(main_file, home_env);
        	strcat(main_file, "/.aspbm/aspbmrc");
		configfile(main_file);
		parse_rcfile(main_file, aspbm_keys);
	} else {
		if (f_exist(conf_file)==0) {
			fprintf(stderr,"\nNo config file '%s'\n",conf_file);
			exit(0);
		}
		parse_rcfile(conf_file, aspbm_keys);
	}

	strcpy(rules_file, home_env);
        strcat(rules_file, "/.aspbm/rules/");
        strcat(rules_file, rulesrc);
	configrulesfile(rules_file);
	parse_rcfile(rules_file, rules_keys);


	logind = atoi(logisrc);
	actcost = atof(actcostrc);
	warnind = atoi(warnisrc);
	warning = atoi(warningrc);
	connect_delay = atoi(cdelayrc);
	csymbol=strdup(csymbolrc);
	cposition=strdup(cpositionrc);

	/* Open the display */
	if (shaped){ 
		createXBMfromXPM(mask_bits, master_xpm, mask_width, 2*mask_height);
		openXwindow(argc, argv, master_xpm, mask_bits, mask_width, 2*mask_height);
	} else {
		createXBMfromXPM(mask_bits, shaped_xpm, mask_width, 2*mask_height);
		openXwindow(argc, argv, shaped_xpm, mask_bits, mask_width, 2*mask_height);
	}

        screen  = DefaultScreen(display);
        screen_width = DisplayWidth(display, screen);
        screen_height = DisplayHeight(display, screen);
	root = RootWindow(display, screen);


	defaults();

	AddMouseRegion(0, 4, 49, 60, 60);
	AddMouseRegion(1, 4, 4, 60, 28);
	AddMouseRegion(2, 4, 32, 60, 48);

        start_time = 0;
	pulsestart_time = 0;
        curr_time = time(0);  

	/* aspbm main loop */
	
	while (1) {

		last_time = curr_time;
                curr_time = time(0);  

 		i = waitpid(0, &status, WNOHANG);
		if (i == stop_child && stop_child != 0) {
                        SetLED(LED_POWER,0);
                        stop_child = 0;
                        start_child = 0;
                }                                                
		if (i == start_child && start_child != 0) {
                        if (WIFEXITED(status)) {
				copyXPMArea(4, 150, 56, 14, 4, 110); 
                                SetLED(LED_POWER,0);
                                start_child = 0;
				is_con=1;
                        }
                }                                                      

		if (last_time != curr_time) {

 			if (!start_time && stillonline(active_interface)) {
				Get_ip(active_interface);
                                pulsestart_time = curr_time;
                                start_time = curr_time;
				pulse_counter = 0;
				log = 1;
				time(&logtime);
				pulse_time = check_pulse();
				cost=actcost + pulse_cost;

				if ((pulse_counter == 0) && (actv == 1)) {
         				pulse_cost = acost;
					pulse_time = atime;
					cost=actcost+pulse_cost;
				}
				
				if (pulse_counter == 0) {
					pulsestart_time = curr_time - connect_delay;
                                	start_time = curr_time - connect_delay; 
                               	}                                                              
               		}                                        
		

			if (start_time && stillonline(active_interface)) {

				SetLED(LED_POWER,1);  

			     	time_on = curr_time - start_time;
                        	pulse_on = curr_time - pulsestart_time;
				
				if (pulse_on > (pulse_time-1)) {
                                	pulsestart_time =  curr_time;
					pulse_counter += 1;
					pulse_time = check_pulse();
					cost += pulse_cost;			
						if ((pulse_counter == 1) && (atime == 0) && (actv == 1)) {
							pulse_counter = 2;
							pulsestart_time = curr_time - connect_delay;
                                			start_time = curr_time - connect_delay; 
                               			}                                                              
				}

				if (!pulse_counter) pulse_counter = 1;

				time_on /= Divisor;
				if (Divisor == 1)
                        		if (time_on > 59 * 60 + 59) time_on /= 60;
 
                        	pulse_on = pulse_time - pulse_on; 
				
				if (pulse_on == warning) {
					if (ispoplog) {
						do_popdown(poplogs);
						ispoplog = 0;
					}
					if (ispopup) {
						do_popdown(popup);
						ispopup = 0;
					}
					if (warnind==1) {
						warnpop(warnmsgrc);
						iswarnpop = 1; 
					}
				} else {
					if (iswarnpop) { 
						do_popdown(warn);   
						iswarnpop = 0;
					}
				}	
				
				time_on = get_number(time_on);
           			pulse_on = get_number(pulse_on); 	
				DrawTime(time_on, curr_time % 2, TIME_X, 129); 
				DrawTime(time_on, curr_time % 2, TIME_X+64, 129); 
				DrawTime(pulse_on, curr_time % 2, PULSE_X, 129);
				DrawTime(pulse_on, curr_time % 2, PULSE_X+64, 129);
				DrawPulse(pulse_counter, TIME_X);  
				DrawPulse(pulse_counter, TIME_X+64);  

				get_statistics(active_interface, &ppp_recv, &ppp_send, &ppp_rbytes, &ppp_sbytes);  

				if (ppp_send != ppp_sl) {
					SetLED(LED_TX,1);
                       		} else { 
					SetLED(LED_TX,0);
				}
	
                        	if (ppp_recv != ppp_rl) {
					SetLED(LED_RX,1);
                        	} else { 
					SetLED(LED_RX,0);     
				}

                        	ppp_sl = ppp_send;
                        	ppp_rl = ppp_recv;                                        
				
				if ((curr_time - ppptime >= 0) || (ppptime == 0)) {

                                	ppptime = curr_time + updaterate;

                                	ppp_history[PPP_STATS_HIS][0] = ppp_rbytes - ppp_orbytes;
                                	ppp_history[PPP_STATS_HIS][1] = ppp_sbytes - ppp_osbytes;

					bytes_in += ppp_rbytes - ppp_orbytes;
					bytes_out += ppp_sbytes - ppp_osbytes;

					ppp_orbytes = ppp_rbytes;
                                	ppp_osbytes = ppp_sbytes; 

					DrawStats(&ppp_history[0][0], PPP_STATS_HIS, 18, 5, 58);
					DrawSpeed( ppp_history[PPP_STATS_HIS][0]/updaterate , 32);

                                	for (j=1; j<PPP_STATS_HIS+1; j++) {
                                        	ppp_history[j-1][0] = ppp_history[j][0];
                                        	ppp_history[j-1][1] = ppp_history[j][1];
                               		}
          	    		}      
			} else {
		
				if (log==1) {
				
				if (ispopup) {
                                	do_popdown(popup);
                                    	ispopup = 0;
                               	}      

        				mytime= localtime(&logtime);
					stringlog = (void *)malloc(1024);         

					sprintf(stringlog, "\n%.2i/%.2i - %.2i:%.2i:%.2i - %.5i - %.3i - %.2f", 
						mytime->tm_mday, mytime->tm_mon+1, mytime->tm_hour, 
						mytime->tm_min, mytime->tm_sec, curr_time - start_time, 
						pulse_counter, cost);    
					if (logind==1) {
						fp = fopen(logfile, "a+");
						if (!fp) fprintf(stderr, "\nCheck log file write permissions.\n\n");
						fprintf(fp, stringlog);
						fclose(fp);
					}
					log = 0;
				}  
				
				if (iswarnpop) {
                                   	do_popdown(warn);
                                     	iswarnpop = 0;
                              	}           
				
				for (j=1; j<PPP_STATS_HIS+1; j++) {
                        		ppp_history[j][0] = 0;
                                    	ppp_history[j][1] = 0; 
				}
				if (is_con==0) SetLED(LED_POWER,0); 
 				SetLED(LED_RX,0);
                                SetLED(LED_TX,0); 
				
				cost = 0;
				bytes_in = 0;
				bytes_out = 0;
				start_time = 0;
				ppp_osbytes = 0;
        			ppp_orbytes = 0;
				sprintf(local_ip, "\n"); 
				sprintf(server_ip, "\n"); 

 				DrawTime(0, is_blink, TIME_X, 129);
 				DrawTime(0, is_blink, TIME_X+64, 129);
                                DrawTime(0, is_blink, PULSE_X, 129);
                                DrawTime(0, is_blink, PULSE_X+64, 129);
                                DrawPulse(0, TIME_X);
                                DrawPulse(0, TIME_X+64);
				DrawStats(&ppp_history[0][0], PPP_STATS_HIS, 18, 5, 58);
				DrawSpeed( ppp_history[PPP_STATS_HIS][0]/updaterate , 32);      
				pulse_time = check_pulse();
				
			}
		} 

		

		RedrawWindowXY(0,Xmask); 

		while (XPending(display)) {
                	XNextEvent(display, &Event);
                	switch (Event.type) {
            			case Expose:
                	        	RedrawWindowXY(0,Xmask);
              	        		break;
     	        		case DestroyNotify:
                			XCloseDisplay(display);
                        		exit(0);
                        		break;
     	        		case MotionNotify: 
					if(Event.xany.window == popup && Event.xmotion.x >=0 
						&& Event.xmotion.x <= pop_w  && Event.xmotion.y >= 180
                                           	&& Event.xmotion.y <= pop_h) {
							if (!ispoplog && ispopup) {
								bevels(popup,2,181,pop_w-2,pop_h-2);
								/*system("asconf &");*/
								poplog();
								ispoplog = 1;
							}
					} else {
						if(Event.xany.window == popup && Event.xmotion.x >=0 
						   	&& Event.xmotion.x <= pop_w  && Event.xmotion.y >= 68
                	               	           	&& Event.xmotion.y <= 115) {
								if (!ispoplog && ispopup) {
								bevels(popup,2,68,pop_w-2,115-2);
									poprules(actcost);
									ispoplog = 1;
								}
						} else {
							if (ispoplog) {
								do_popdown(poplogs);
								ispoplog = 0;
								XClearWindow(display, popup);
								drawpop(bytes_in, bytes_out, cost, atime, acost, actcost, csymbol, cposition);
								XGrabPointer(display, popup, True,  ButtonReleaseMask|PointerMotionMask, GrabModeAsync, GrabModeAsync, None, None, CurrentTime); 
							}					
						}
					}
					break;
				case ButtonPress:
					XSetInputFocus(display, win, RevertToNone, CurrentTime);  
					imouse = GetMouseRegion(Event.xbutton.x, Event.xbutton.y);
                       			if (Event.xbutton.button == Button1) {
			         		switch (imouse) {
						case 0: 
							if (!iswarnpop) {
								if (stat_cur==1) {
									if (start_child==0) {
										start_child = execCommand(con_startrc);
										if (start_child) fprintf(stderr,"No start command '%s'\n",con_startrc);
						 				copyXPMArea(4, 165, 56, 14, 4, 110); 
										is_con=1;
										SetLED(LED_WAIT,1);
									}else{
										if (stop_child==0 && start_child>0) {
											stop_child = execCommand(con_stoprc);
	 										if (stop_child) fprintf(stderr,"No stop command '%s'\n",con_stoprc);
	  					 					copyXPMArea(4, 150, 56, 14, 4, 110); 
											is_con=0;
											SetLED(LED_WAIT,1);
										}
									}
								}
							}
						break;
						}
					}

					XSetInputFocus(display, win, RevertToNone, CurrentTime);  
					imouse = GetMouseRegion(Event.xbutton.x, Event.xbutton.y);
                       			if (Event.xbutton.button == Button1) {
			         		switch (imouse) {
						case 2: 
							if (!iswarnpop) {
								if (stat_cur==0) {
									pop(bytes_in, bytes_out, cost,atime,acost,actcost,csymbol, cposition);
									ispopup = 1;
								}
							}
							if (!iswarnpop) {
								if (stat_cur==1) {
									pop(bytes_in, bytes_out, cost, atime, acost, actcost, csymbol, cposition);
									ispopup = 1;
								}
							}
						case 1: 
							if (imouse == 1) {
								if (stat_cur == 1) {
									Xmask = 0;
                        	                        		setMaskXY(0, 0);
                                	                		RedrawWindowXY(0,Xmask);
                                        	        		stat_cur = 0;
									/*test=0;*/
								} else {
									Xmask = 64;
                    		            	        		setMaskXY(0, -64);
	                		        			RedrawWindowXY(0,Xmask);
									stat_cur = 1;
									/*test=1;*/
                        	               			}				
							}	
						}
						break;
					}
 				case ButtonRelease:
					if (ispopup) {
						do_popdown(popup);
						ispopup = 0;
					}
					if (ispoplog) {
						do_popdown(poplogs);
						ispoplog = 0;
					}
					break;	
				default:
                        		break;
        			}                                    
 		 
		}
	usleep(50000L);
	}
}

  /*************/
 /* DrawStats */
/*************/

void DrawStats(int *his, int num, int size, int x_left, int y_bottom) {

 int             pixels_per_byte;
        int             j,k;
        int             *p;

        pixels_per_byte = 1*size;
        p = his;
        for (j=0; j<num; j++) {
                if (p[0] + p[1] > pixels_per_byte)
                        pixels_per_byte = p[0] + p[1];
                p += 2;
        }

        pixels_per_byte /= size;
        p = his;                                
   	
	for (k=0; k<num; k++) {


                for (j=0; j<size; j++) {

                        if (j < p[0] / pixels_per_byte)
                                copyXPMArea(62, 129+1, 1, 1, k+x_left, y_bottom-j);
                        else if (j < (p[0] + p[1]) / pixels_per_byte)
                                copyXPMArea(62, 129+2, 1, 1, k+x_left, y_bottom-j);
                        else
                                copyXPMArea(62, 129+3, 1, 1, k+x_left, y_bottom-j);
                }
                p += 2;
        }                     
}                        

  /************/
 /* DrawTime */
/************/

void DrawTime(int i, int j, int posy, int cor) {

        int	div = 1000;

        copyXPMArea(6*((i / div)%10)+1, cor, 5, 7, 6+6*0, posy);
        div = div /10;
        copyXPMArea(6*((i / div)%10)+1, cor, 5, 7, 6+6*1, posy);
        div = div /10;

        if (j)
                copyXPMArea(62, cor, 1, 7, 6+6*2+1, posy);
        else
                copyXPMArea(63, cor, 1, 7, 6+6*2+1, posy);

        copyXPMArea(6*((i / div)%10)+1, cor, 5, 7, 6+6*2 + 4, posy);
        div = div /10;
        copyXPMArea(6*((i / div)%10)+1, cor, 5, 7, 6+6*3 + 4, posy);
}                                                  

  /*************/
 /* DrawPulse */
/*************/

void DrawPulse(int i,int posy) {

        int     k = 100;

	copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 41+6*0, posy); 
	k = k /10;
       	copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 41+6*1, posy);
        k = k /10;
       	copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 41+6*2, posy);
}               


  /*************/
 /* DrawSpeed */
/*************/

void DrawSpeed(long i,int posy) {

int 	k = 1000;
int	dig1=0,dig2=0,dig3=0,dig4=0;

	dig1=(i / k)%10;
	k = k /10;
	dig2=(i / k)%10;
	k = k /10;
	dig3=(i / k)%10;
	k = k /10;
	dig4=(i / k)%10;
        	
	copyXPMArea(6*dig1+1, 129, 5, 7, 21, posy);
        copyXPMArea(6*dig2+1, 129, 5, 7, 27, posy);
        copyXPMArea(6*dig3+1, 129, 5, 7, 33, posy);
        copyXPMArea(6*dig4+1, 129, 5, 7, 40, posy);
}               

  /***************/
 /* stillonline */
/***************/

int stillonline(char *ifs) {

        FILE    *fp;
        char    temp[128];
	int 	i = 0;

        fp = fopen("/proc/net/route", "r");
        if (fp) {
                while (fgets(temp, 128, fp)) {
                        if (strstr(temp, ifs)) {
       		                i = 1; /* Line is alive */
                        }
                }
                fclose(fp);
        }
        if(test) i = 1;
        return i;
}                          

  /**************/
 /* get_number */
/**************/

int get_number(long time) {

	int i, minute,hour;
        i = 0;

 	minute = time % 60;
        hour = (time / 60) % 100;
        i = hour * 100 + minute;  

        return i;
}                          

  /******************/
 /* get_statistics */
/******************/

int get_statistics(char *devname, long *ip, long *op, long *is, long *os) {

        struct ppp_stats        ppp_cur;
        static int    	        ppp_opened = 0;


        if (!ppp_opened) {
                /* Open the ppp device. */
                memset(&ppp_cur, 0, sizeof(ppp_cur));
                if ((ppp_h = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
                        return -1;
                ppp_opened = 1;
        }                                                  
        get_ppp_stats(&ppp_cur);

        *op = ppp_cur.p.ppp_opackets;
        *ip = ppp_cur.p.ppp_ipackets;

        *is = ppp_cur.p.ppp_ibytes;
        *os = ppp_cur.p.ppp_obytes;

        return 0;
}                                

  /*****************/
 /* get_ppp_stats */
/*****************/

void get_ppp_stats(struct ppp_stats *cur) {

        struct ifpppstatsreq    req;

        memset(&req, 0, sizeof(req));

        req.stats_ptr = (caddr_t) &req.stats;

        strcpy(req.ifr__name, active_interface);

        if (ioctl(ppp_h, SIOCGPPPSTATS, &req) >= 0)
                *cur = req.stats;
}                                           

  /************/
 /* defaults */
/************/

void defaults() {

char *namefont;

	/* Phone Rules */

	rule(sunday,1);
	rule(monday,2);
	rule(tuesday,3);
	rule(wednesday,4);
	rule(thursday,5);
	rule(friday,6);
	rule(saturday,7);
	rule(default0,8);
	hrule(holyday);

	pulse_time = check_pulse();
        
	/* Create Font for drawing */

	namefont = (void *)malloc(80);
        strcpy(namefont, HOSTFONT);  

        popupfont=XLoadQueryFont(display, namefont);
	
	if(popupfont == NULL)
	{
        	fprintf(stderr, "Can't load font %s!\n", namefont);
        	exit(1);
	}                                

	free(namefont);

	namefont = (void *)malloc(80);
        strcpy(namefont, WARNFONT);  

        warnfont=XLoadQueryFont(display, namefont);

	if(popupfont == NULL)
	{
        	fprintf(stderr, "Can't load font %s!\n", namefont);
        	exit(1);
	}                                

	free(namefont);

	/* Create GC for drawing */

	bg_pixel = GetColor("black");
        fg_pixel = GetColor("LightSeaGreen");  

        gcm =  GCForeground | GCBackground | GCGraphicsExposures;
        gcv.foreground = fg_pixel;
        gcv.background = bg_pixel;
        gcv.graphics_exposures = 0;
        NormalGC = XCreateGC(display, root, gcm, &gcv);   

	XSetFont(display, NormalGC, popupfont->fid);

	popbg_pixel = GetColor("#4f4f4f");
        popfg_pixel = GetColor("#222222");  

        gcm =  GCForeground | GCBackground | GCGraphicsExposures;
        gcv.foreground = popfg_pixel;
        gcv.background = popbg_pixel;
        gcv.graphics_exposures = 0;
        PopupGC = XCreateGC(display, root, gcm, &gcv);   

	XSetFont(display, PopupGC, popupfont->fid); 

	warnbg_pixel = GetColor("yellow");
        warnfg_pixel = GetColor("#222222");  

        gcm =  GCForeground | GCBackground | GCGraphicsExposures;
        gcv.foreground = warnfg_pixel;
        gcv.background = warnbg_pixel;
        gcv.graphics_exposures = 0;
        WarnGC = XCreateGC(display, root, gcm, &gcv);   

	XSetFont(display, WarnGC, warnfont->fid); 

	linebg_pixel = GetColor("black");
        linefg_pixel = GetColor("#AAAAAA");  

        gcm =  GCForeground | GCBackground | GCGraphicsExposures;
        gcv.foreground = linefg_pixel;
        gcv.background = linebg_pixel;
        gcv.graphics_exposures = 0;
        LineGC = XCreateGC(display, root, gcm, &gcv);   

	XSetFont(display, LineGC, warnfont->fid); 

        namefont = (void *)malloc(80);
        strcpy(namefont, LOGFONT);  

        logfont=XLoadQueryFont(display, namefont);

	linebg_pixel = GetColor("white");
        linefg_pixel = GetColor("black");  

        gcm =  GCForeground | GCBackground | GCGraphicsExposures;
        gcv.foreground = linefg_pixel;
        gcv.background = linebg_pixel;
        gcv.graphics_exposures = 0;
        LogGC = XCreateGC(display, root, gcm, &gcv);   

	XSetFont(display, LogGC, logfont->fid); 
	free(namefont);
}


  /***************/
 /* check_pulse */
/***************/

int check_pulse() {

int i = 0, wd, aux = 0, aux1 = 0, aux2 = 0, aux3 = 0, aux4 = 0;
int             index = 1, ind = 0, iand;
time_t          time_tp;
struct tm       *mytime;

time(&time_tp);
mytime= localtime(&time_tp);

wd = mytime->tm_wday+1;
iand = wd;

aux = mytime->tm_hour*100+mytime->tm_min;
aux1 = phone_rules[wd].from_h*100+phone_rules[wd].from_m;
aux2 = phone_rules[wd].to_h*100+phone_rules[wd].to_m;

/*fprintf(stderr, "\n%i\n",phone_rules[wd].and);*/

i = phone_rules[8].use;
pulse_cost=phone_rules[8].at;

if ( (aux > (aux1 - 1)) && (aux <= aux2) ) {
        i = phone_rules[wd].use;
        pulse_cost=phone_rules[wd].at;
        atime=phone_rules[wd].first;
        acost=phone_rules[wd].fat;
}                                                        
while (phone_rules[iand].and==1) {

        iand = iand + 8;

        aux3 = phone_rules[iand].from_h*100+phone_rules[iand].from_m;
        aux4 = phone_rules[iand].to_h*100+phone_rules[iand].to_m;

        if ( (aux > (aux3 - 1)) && (aux <= aux4) ) {
                i = phone_rules[iand].use;
                pulse_cost=phone_rules[iand].at;
                acost=phone_rules[iand].fat;
                atime=phone_rules[iand].first;
        }
}

if (oldday !=  mytime->tm_mday) {
        isholyday = 0;
        while (index == 1) {
                ind = ind +1;
                if ((hrules[ind].day == mytime->tm_mday)  && (hrules[ind].month  == (mytime->tm_mon + 1))) isholyday = 1;
                if (ind == 20) index = 0;
/*              fprintf(stderr, "\n%i--%i-%i\n",ind,hrules[ind].day,hrules[ind].month);*/
        }
        oldday =  mytime->tm_mday;
}

if (isholyday == 1) {
        i = phone_rules[8].use;
        pulse_cost=phone_rules[8].at;
}

if (acost != 0) actv=1;
else actv=0;

return i;                                  
} 


  /*********/
 /* usage */
/*********/

void usage(void) {

	fprintf(stderr, "\nAfterstep phone bill monitor - version %s\n\n",ASPBM_VERSION);
	fprintf(stderr, "Pedro Moleiro (moleiro@ip.pt)\n");
	fprintf(stderr, "http:\\\\www.ip.pt\\~ip241956\n\n");
	fprintf(stderr, "usage: aspbm [-options ...]\n\n");
	fprintf(stderr, "options:\n");
	fprintf(stderr, "-h                           this help screen\n");
	fprintf(stderr, "-f <config_file>             read configuration file config_file instead, full path\n");
	fprintf(stderr, "-position <+x+y>             window position\n");
	fprintf(stderr, "-s                           shaped form\n");
	fprintf(stderr, "-t                           set the on-line timer to MM:SS instead of HH:MM\n");
        fprintf(stderr, "-u <update rate>             (1..10), default 5 seconds\n"); 
	fprintf(stderr, "-v                           print the version number\n");
	fprintf(stderr, "-z                           test mode\n");
	fprintf(stderr, "\nExample: aspbm -s -t -u 5\n\n");
}

  /***********/
 /* Version */
/***********/

void Version(void) {

	fprintf(stderr, "\naspbm - version %s\n\n", ASPBM_VERSION);
}

  /**********/
 /* SetLED */
/**********/

void SetLED(int led, int on) {

        switch (led) {
        case LED_WAIT:
		if (on) {
			copyXPMArea(LED_WTE_X, LED_WTE_Y, LED_SZE_X, LED_SZE_Y,  LED_PWR_X, LED_PWR_Y);
			copyXPMArea(LED_WTE_X, LED_WTE_Y, LED_SZE_X, LED_SZE_Y,  LED_PWR_X, LED_PWR_Y+64);
		} else {
			copyXPMArea(LED_OFF_X, LED_OFF_Y, LED_SZE_X, LED_SZE_Y,  LED_PWR_X, LED_PWR_Y);
			copyXPMArea(LED_OFF_X, LED_OFF_Y, LED_SZE_X, LED_SZE_Y,  LED_PWR_X, LED_PWR_Y+64);
		}
                break;
        case LED_POWER:
		if (on) {
			copyXPMArea(LED_ON_X, LED_ON_Y, LED_SZE_X, LED_SZE_Y,  LED_PWR_X, LED_PWR_Y);
			copyXPMArea(LED_ON_X, LED_ON_Y, LED_SZE_X, LED_SZE_Y,  LED_PWR_X, LED_PWR_Y+64);
		} else {
			copyXPMArea(LED_OFF_X, LED_OFF_Y, LED_SZE_X, LED_SZE_Y,  LED_PWR_X, LED_PWR_Y);
			copyXPMArea(LED_OFF_X, LED_OFF_Y, LED_SZE_X, LED_SZE_Y,  LED_PWR_X, LED_PWR_Y+64);
		}
                break;
        case LED_RX:
                if (on) {
			copyXPMArea(LED_ON_X, LED_ON_Y, LED_SZE_X, LED_SZE_Y,  LED_RCV_X, LED_RCV_Y);
			copyXPMArea(LED_ON_X, LED_ON_Y, LED_SZE_X, LED_SZE_Y,  LED_RCV_X, LED_RCV_Y+64);
		} else {
			copyXPMArea(LED_OFF_X, LED_OFF_Y, LED_SZE_X, LED_SZE_Y,  LED_RCV_X, LED_RCV_Y);
			copyXPMArea(LED_OFF_X, LED_OFF_Y, LED_SZE_X, LED_SZE_Y,  LED_RCV_X, LED_RCV_Y+64);
		}
                break;
        case LED_TX:
                if (on) {
			copyXPMArea(LED_ON_X, LED_ON_Y, LED_SZE_X, LED_SZE_Y,  LED_SND_X, LED_SND_Y);
			copyXPMArea(LED_ON_X, LED_ON_Y, LED_SZE_X, LED_SZE_Y,  LED_SND_X, LED_SND_Y+64);
		} else {
			copyXPMArea(LED_OFF_X, LED_OFF_Y, LED_SZE_X, LED_SZE_Y,  LED_SND_X, LED_SND_Y);
			copyXPMArea(LED_OFF_X, LED_OFF_Y, LED_SZE_X, LED_SZE_Y,  LED_SND_X, LED_SND_Y+64);
		}
                break;
        }                                         
}

