/*Afterstep phone bill monitor.

	Author: Pedro Moleiro (moleiro@ip.pt)

	This program is distributed under the GPL license.

-----------------------------------------------------------
Code based on wmppp - 

	Authors: 	Martijn Pieterse (pieterse@xs4all.nl)
              		Antoine Nulle (warp@xs4all.nl) 

Code based on loadmeter - http://www.zip.com.au/~bb/linux/ 

	Author: 	Ben Buxton (bb@zip.com.au)

-----------------------------------------------------------*/

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <stdarg.h> 

#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>

#include <net/ppp_defs.h>
#include <net/if_ppp.h>

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "aspbm.h"

#include "xpm/master.xpm"
#include "xpm/shaped.xpm"

  /***********/
 /* Defines */
/***********/

#define HOSTFONT "-*-helvetica-bold-r-*-*-12-*-*-*-*-*-*-*" 
#define WARNFONT "-*-helvetica-bold-r-*-*-24-*-*-*-*-*-*-*" 

#define WARNISRC 	(NULL)     
#define WARNINGRC 	(NULL)     
#define WARNMSGRC 	(NULL)     
#define CDELAYRC 	(NULL)     
#define CSYMBOLRC 	(NULL)     
#define CPOSITIONRC 	(NULL)     
#define LOGISRC 	(NULL)     
#define DEFAULT0 	(NULL)     
#define MONDAY 		(NULL)     
#define TUESDAY 	(NULL)     
#define WEDNESDAY 	(NULL)     
#define THURSDAY 	(NULL)     
#define FRIDAY 		(NULL)     
#define SATURDAY 	(NULL)     
#define SUNDAY 		(NULL)     
#define HOLYDAY		(NULL)     

#define LED_RX 		(1)
#define LED_TX       	(2)
#define LED_POWER    	(3)   

#define ORANGE_LED_TIMEOUT 	(60) 

#define LED_ON_X	(55)
#define LED_ON_Y 	(143)
#define LED_OFF_Y 	(138)
#define LED_OFF_X 	(55)
#define LED_ERR_X 	(60)
#define LED_ERR_Y 	(138)
#define LED_WTE_X 	(60)
#define LED_WTE_Y 	(143)
#define LED_SZE_X 	(4)
#define LED_SZE_Y 	(4) 
     
#define LED_PWR_X 	(53)
#define LED_PWR_Y 	(7)
#define LED_SND_X 	(47)
#define LED_SND_Y 	(7)
#define LED_RCV_X 	(41)
#define LED_RCV_Y 	(7)

#define TIME_X        	(19)
#define PULSE_X	      	(6) 

  /**********************/
 /* External Variables */
/**********************/

extern	char **environ;

  /*****************/
 /* X11 Variables */
/*****************/

XSizeHints      mysizehints;
XWMHints        mywmhints;
Pixel           back_pix, fore_pix;
char            *Geometry = "";
Window          iconwin, win;
GC              NormalGC;      
XpmIcon         wmgen;
Pixmap          pixmask;

MOUSE_REGION    mouse_region[MAX_MOUSE_REGION];
RULES_STRUCT    phone_rules[33];
HRULES_STRUCT   hrules[20];
	
  /********************/
 /* Global Variables */
/********************/

int	Divisor=60; 
int	shaped=0; 
int	test = 0;
int	log = 0;
int	pulse_time;
int	oldday = 0;
int	isholyday = 0;
int   	screen;
int     screen_width;
int   	screen_height;
int 	mask_width = 64;
int 	mask_height = 64;
int	warning, connect_delay;

long	logttime = 0, logtpulse = 0;

float	logtcost = 0;  
float	pulse_cost;

char  	logfile[128];  
char	*ProgName;
char    *active_interface = "ppp0";  
char 	mask_bits[64*128];
char 	*display_name = NULL;  
FILE 	*fp; 

Window 	root, popup, warn;

XFontStruct     *popupfont, *warnfont; 
GC   		NormalGC, PopupGC, WarnGC; 
Pixel   	bg_pixel, fg_pixel, popbg_pixel, popfg_pixel, warnbg_pixel, warnfg_pixel; 
XGCValues      	gcv;
unsigned long   gcm;  

  /*****************/
 /* PPP variables */
/*****************/

#define         PPP_STATS_HIS   54

int             updaterate = 5;
int             ppp_h = -1;
int             ppp_history[PPP_STATS_HIS+1][2];
long            ppptime;  
                                       
  /***********************/
 /* Function Prototypes */
/***********************/

static void GetXPM(XpmIcon *, char **);
static Pixel GetColor(char *);
void AddMouseRegion(int, int, int, int, int);
int GetMouseRegion(int, int);            
void openXwindow(int argc, char *argv[], char **, char *, int, int);
void RedrawWindowXY(int x, int y);
void createXBMfromXPM(char *, char **, int, int);
void copyXPMArea(int, int, int, int, int, int);
void setMaskXY(int, int);
void parse_rcfile(const char *, rckeys *); 

void Readlog(const char *); 
void usage(void);
void Version(void);
void aspbm_routine(int, char **);
void DrawTime(int, int, int, int); 
void DrawPulse(int, int);
void DrawBytes(long, int);
void DrawSpeed(long, int);
void DrawStats(int *, int, int, int, int); 
void get_ppp_stats(struct ppp_stats *cur);  
int get_statistics(char *, long *, long *, long *, long *); 
int stillonline(char *); 
int get_number(long);
int check_pulse();
Window MakePopup(); 
void do_popdown();
void pop(int,int,float);
void warnpop();
void SetLED(int, int);
void rule();
void hrule();
void defaults();
void configfile();

  /********/
 /* Main */
/********/

int main(int argc, char *argv[]) {

	int		i;
	
	/* Parse Command Line */

	ProgName = argv[0];
	if (strlen(ProgName) >= 5)
		ProgName += (strlen(ProgName) - 5);
	
	for (i=1; i<argc; i++) {
		char *arg = argv[i];

		if (*arg=='-') {
			switch (arg[1]) {
			case 's' :
                                shaped = 1;
                                break;  
			case 't' :
                                Divisor = 1;
                                break;  
			case 'u' :
                                i++;
                                if (!argv[i]) {
                                        usage();
                                        exit(1);
                                }
                                updaterate = atoi(argv[i]);
                                if (updaterate < 1 || updaterate > 10) {
                                        usage();
                                        exit(1);
                                }
                                break;  
                  	case 'v' :
				Version();
				exit(0);
                                break;  
			case 'z' :
                                test = 1;
				break;
			default:
				usage();
				exit(0);
				break;
			}
		}
	}
	
	aspbm_routine(argc, argv);
	
	return 0;
}

  /******************/
 /* aspbm_routine */
/******************/

char    *warnisrc = NULL;  
char    *warningrc = NULL;  
char    *warnmsgrc = NULL;  
char    *cdelayrc = NULL;  
char    *csymbolrc = NULL;  
char    *cpositionrc = NULL;  
char    *logisrc = NULL;  

char    *default0 = NULL;  
char    *monday = NULL;  
char    *tuesday = NULL;  
char    *wednesday = NULL;  
char    *thursday = NULL;  
char    *friday = NULL;  
char    *saturday = NULL;  
char    *sunday = NULL;  
char    *holyday = NULL;  


void aspbm_routine(int argc, char **argv) {

	int			j, imouse;
	int			start_time, pulsestart_time;
	int			curr_time, last_time;
	int			stat_cur = 0;
	int			Xmask = 0;
	int			pulse_counter = 0;
	int		 	pulse_on, time_on;
	int		 	iswarnpop = 0, ispopup = 0;
	int			warnind = 0;
	int			logind = 0;
	float			cost = 0;

	long		 	bytes_in = 0;
	long		 	bytes_out = 0;
	long                    ppp_send,ppp_sl = 1;
        long                    ppp_recv,ppp_rl = 1;
        long                    ppp_sbytes,ppp_rbytes;
        long                    ppp_osbytes = 0;
	long			ppp_orbytes = 0;        

	char                    temp[128]; 
        char                    *p;  
	char 			*stringlog;
        	
	XEvent                  Event;  	
        time_t          	logtime;
        struct tm       	*mytime;
	
	/* rc keys */

	rckeys aspbm_keys[] = {
                { "warn", &warnisrc },
                { "warning", &warningrc },
                { "warnmsg", &warnmsgrc },
                { "delay", &cdelayrc },
                { "currency_symbol", &csymbolrc },
                { "currency_position", &cpositionrc },
                { "log", &logisrc },
                { "default", &default0 },
                { "monday", &monday },
                { "tuesday", &tuesday },
                { "wednesday", &wednesday },
                { "thursday", &thursday },
                { "friday", &friday },
                { "saturday", &saturday },
                { "sunday", &sunday },
                { "holydays", &holyday },

                { NULL, NULL }
        };                         


    	/* Read config file */

	strcpy(temp, "/etc/aspbmrc");
        parse_rcfile(temp, aspbm_keys);

        p = getenv("HOME");

        strcpy(logfile, p);
	strcat(logfile,"/.aspbmlogs/aspbm.log");

        strcpy(temp, p);
        strcat(temp, "/.aspbmrc");
	/* Check for configuration file */
	configfile(temp);
        parse_rcfile(temp, aspbm_keys);

	logind = atoi(logisrc);
	warnind = atoi(warnisrc);
	warning = atoi(warningrc);
	connect_delay = atoi(cdelayrc);

	/* Open the display */
	if (shaped){ 
		createXBMfromXPM(mask_bits, master_xpm, mask_width, 2*mask_height);
		openXwindow(argc, argv, master_xpm, mask_bits, mask_width, 2*mask_height);
	} else {
		createXBMfromXPM(mask_bits, shaped_xpm, mask_width, 2*mask_height);
		openXwindow(argc, argv, shaped_xpm, mask_bits, mask_width, 2*mask_height);
	}

        screen  = DefaultScreen(display);
        screen_width = DisplayWidth(display, screen);
        screen_height = DisplayHeight(display, screen);
	root = RootWindow(display, screen);


	defaults();

	AddMouseRegion(0, 4, 32, 60, 60);
	AddMouseRegion(1, 4, 4, 60, 28);

        start_time = 0;
	pulsestart_time = 0;
        curr_time = time(0);  

	/* aspbm main loop */
	
	while (1) {

		last_time = curr_time;
                curr_time = time(0);  

 		waitpid(0, NULL, WNOHANG); 
 
		if (last_time != curr_time) {

 			if (!start_time && stillonline(active_interface)) {
                                pulsestart_time = curr_time;
                                start_time = curr_time;
				pulse_counter = 0;
				log = 1;
				time(&logtime);
				pulse_time = check_pulse();
				cost=pulse_cost;
				if (pulse_counter == 0) {
					pulsestart_time = curr_time - connect_delay;
                                	start_time = curr_time - connect_delay; 
                               	}                                                              
               		}                                        
		

			if (start_time && stillonline(active_interface)) {

				SetLED(LED_POWER,1);  

			     	time_on = curr_time - start_time;
                        	pulse_on = curr_time - pulsestart_time;
				
				if (pulse_on > (pulse_time-1)) {
                                	pulsestart_time =  curr_time;
					pulse_counter += 1;
					pulse_time = check_pulse();
					cost += pulse_cost;				
				}

				if (!pulse_counter) pulse_counter = 1;

				time_on /= Divisor;
				if (Divisor == 1)
                        		if (time_on > 59 * 60 + 59) time_on /= 60;
 
                        	pulse_on = pulse_time - pulse_on; 
				
				if (pulse_on == warning) {
					if (ispopup) {
						do_popdown(popup);
						ispopup = 0;
					}
					if (warnind==1) {
						warnpop(warnmsgrc);
						iswarnpop = 1; 
					}
				} else {
					if (iswarnpop) { 
						do_popdown(warn);   
						iswarnpop = 0;
					}
				}	
				
				time_on = get_number(time_on);
           			pulse_on = get_number(pulse_on); 	
				DrawTime(time_on, curr_time % 2, TIME_X, 129); 
				DrawTime(time_on, curr_time % 2, TIME_X+64, 129); 
				DrawTime(pulse_on, curr_time % 2, PULSE_X, 129);
				DrawTime(pulse_on, curr_time % 2, PULSE_X+64, 129);
				DrawPulse(pulse_counter, TIME_X);  
				DrawPulse(pulse_counter, TIME_X+64);  

				get_statistics(active_interface, &ppp_recv, &ppp_send, &ppp_rbytes, &ppp_sbytes);  

				if (ppp_send != ppp_sl) {
					SetLED(LED_TX,1);
                       		} else { 
					SetLED(LED_TX,0);
				}
	
                        	if (ppp_recv != ppp_rl) {
					SetLED(LED_RX,1);
                        	} else { 
					SetLED(LED_RX,0);     
				}

                        	ppp_sl = ppp_send;
                        	ppp_rl = ppp_recv;                                        
				
				if ((curr_time - ppptime >= 0) || (ppptime == 0)) {

                                	ppptime = curr_time + updaterate;

                                	ppp_history[PPP_STATS_HIS][0] = ppp_rbytes - ppp_orbytes;
                                	ppp_history[PPP_STATS_HIS][1] = ppp_sbytes - ppp_osbytes;

					bytes_in += ppp_rbytes - ppp_orbytes;
					bytes_out += ppp_sbytes - ppp_osbytes;

					DrawBytes(bytes_in, 33+64);
					DrawBytes(bytes_out, 49+64);

					ppp_orbytes = ppp_rbytes;
                                	ppp_osbytes = ppp_sbytes; 

					DrawStats(&ppp_history[0][0], PPP_STATS_HIS, 18, 5, 58);
					DrawSpeed( ppp_history[PPP_STATS_HIS][0]/updaterate , 32);

                                	for (j=1; j<PPP_STATS_HIS+1; j++) {
                                        	ppp_history[j-1][0] = ppp_history[j][0];
                                        	ppp_history[j-1][1] = ppp_history[j][1];
                               		}
          	    		}      
			} else {
		
				if (log==1) {
				
				if (ispopup) {
                                	do_popdown(popup);
                                    	ispopup = 0;
                               	}      

        				mytime= localtime(&logtime);
					stringlog = (void *)malloc(64);         

					sprintf(stringlog, "\n%.2i/%.2i - %.2i:%.2i:%.2i - %.5i - %.3i - %.2f", 
						mytime->tm_mday, mytime->tm_mon+1, 
						mytime->tm_hour, mytime->tm_min, mytime->tm_sec - connect_delay, 
						curr_time - start_time, 
						pulse_counter, cost);    
					if (logind==1) {
						fp = fopen(logfile, "a+");
						if (!fp) fprintf(stderr, "\nCheck log file write permissions.\n\n");
						fprintf(fp, stringlog);
						fclose(fp);
					}
					log = 0;
				}  
				
				if (iswarnpop) {
                                   	do_popdown(warn);
                                     	iswarnpop = 0;
                              	}           
				
				for (j=1; j<PPP_STATS_HIS+1; j++) {
                        		ppp_history[j][0] = 0;
                                    	ppp_history[j][1] = 0; 
				}
				
				SetLED(LED_POWER,0); 
 				SetLED(LED_RX,0);
                                SetLED(LED_TX,0); 
				
				cost = 0;
				bytes_in = 0;
				bytes_out = 0;
				start_time = 0;
				ppp_osbytes = 0;
        			ppp_orbytes = 0;

 				DrawTime(0, curr_time % 2, TIME_X, 129);
 				DrawTime(0, curr_time % 2, TIME_X+64, 129);
                                DrawTime(0, curr_time % 2, PULSE_X, 129);
                                DrawTime(0, curr_time % 2, PULSE_X+64, 129);
                                DrawPulse(0, TIME_X);
                                DrawPulse(0, TIME_X+64);
				DrawBytes(bytes_in, 33+64);
                                DrawBytes(bytes_out, 49+64);
				DrawStats(&ppp_history[0][0], PPP_STATS_HIS, 18, 5, 58);
				DrawSpeed( ppp_history[PPP_STATS_HIS][0]/updaterate , 32);      
				pulse_time = check_pulse();
				
			}
		} 

		

		RedrawWindowXY(0,Xmask); 

		while (XPending(display)) {
                	XNextEvent(display, &Event);
                	switch (Event.type) {
            			case Expose:
                	        	RedrawWindowXY(0,Xmask);
              	        		break;
     	        		case DestroyNotify:
                			XCloseDisplay(display);
                        		exit(0);
                        		break;
				case ButtonPress:
					imouse = GetMouseRegion(Event.xbutton.x, Event.xbutton.y);
                                	switch (imouse) {   
					case 0: 
						if (!iswarnpop) {
							pop(bytes_in, bytes_out, cost);
							ispopup = 1;
						}
					case 1: 
						if (imouse == 1) {
							if (stat_cur == 1) {
								Xmask = 0;
                                                		setMaskXY(0, 0);
                                                		RedrawWindowXY(0,Xmask);
                                                		stat_cur = 0;
								/*test=0;*/
							} else {
								Xmask = 64;
                                	        		setMaskXY(0, -64);
	                	        			RedrawWindowXY(0,Xmask);
								stat_cur = 1;
								/*test=1;*/
                        	               		}				
						}	
					}
					break;

 				case ButtonRelease:
					imouse = GetMouseRegion(Event.xbutton.x, Event.xbutton.y);
                                	switch (imouse) {   
					case 0: 
					
					}   
					if (ispopup) {
						do_popdown(popup);
						ispopup = 0;
					}
					break;                     
				default:
                        		break;
        		}                                    
 		 
		}
	usleep(50000L);
	}
}

  /*************/
 /* DrawStats */
/*************/

void DrawStats(int *his, int num, int size, int x_left, int y_bottom) {

 int             pixels_per_byte;
        int             j,k;
        int             *p;

        pixels_per_byte = 1*size;
        p = his;
        for (j=0; j<num; j++) {
                if (p[0] + p[1] > pixels_per_byte)
                        pixels_per_byte = p[0] + p[1];
                p += 2;
        }

        pixels_per_byte /= size;
        p = his;                                
   	
	for (k=0; k<num; k++) {


                for (j=0; j<size; j++) {

                        if (j < p[0] / pixels_per_byte)
                                copyXPMArea(62, 129+1, 1, 1, k+x_left, y_bottom-j);
                        else if (j < (p[0] + p[1]) / pixels_per_byte)
                                copyXPMArea(62, 129+2, 1, 1, k+x_left, y_bottom-j);
                        else
                                copyXPMArea(62, 129+3, 1, 1, k+x_left, y_bottom-j);
                }
                p += 2;
        }                     
}                        

  /************/
 /* DrawTime */
/************/

void DrawTime(int i, int j, int posy, int cor) {

        int	div = 1000;

        copyXPMArea(6*((i / div)%10)+1, cor, 5, 7, 6+6*0, posy);
        div = div /10;
        copyXPMArea(6*((i / div)%10)+1, cor, 5, 7, 6+6*1, posy);
        div = div /10;

        if (j)
                copyXPMArea(62, cor, 1, 7, 6+6*2+1, posy);
        else
                copyXPMArea(63, cor, 1, 7, 6+6*2+1, posy);

        copyXPMArea(6*((i / div)%10)+1, cor, 5, 7, 6+6*2 + 4, posy);
        div = div /10;
        copyXPMArea(6*((i / div)%10)+1, cor, 5, 7, 6+6*3 + 4, posy);
}                                                  

  /*************/
 /* DrawPulse */
/*************/

void DrawPulse(int i,int posy) {

        int     k = 100;

	copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 41+6*0, posy); 
	k = k /10;
       	copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 41+6*1, posy);
        k = k /10;
       	copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 41+6*2, posy);
}               

  /*************/
 /* DrawBytes */
/*************/

void DrawBytes(long i,int posy) {

int 	k = 1000;
int	index = 0;
float	aux=0;

aux = i;

while (i>1024){
	index += 1;
	i = i/1024;
	aux = aux/1024;
}
	
copyXPMArea(30, 170, 33, 8, 25, posy);

if (i<100){
	i = aux*100;
	if ((i / k)%10 != 0) copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 26, posy);
       	k = k /10;
	copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 32, posy);
        k = k /10;
        copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 41, posy);
        k = k /10;
        copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 47, posy);
	copyXPMArea(42, 140, 1, 1, 39, posy+6);		
	i = aux/100;
}

if (i>=100 && i<1000){  	
	i = aux*10;
	copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 26, posy); 
        k = k /10;
	copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 32, posy);
        k = k /10;
        copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 38, posy);
        k = k /10;
        copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 47, posy);
	copyXPMArea(42, 140, 1, 1, 44, posy+6);		
	i = aux/10; 
}

if (i>=1000){  	
	copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 29, posy);
       	k = k /10;
	copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 35, posy);
       	k = k /10;
       	copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 41, posy);
       	k = k /10;
       	copyXPMArea(6*((i / k)%10)+1, 129, 5, 7, 47, posy);
}

if (index==0) copyXPMArea(36, 139, 5, 7, 53, posy);    
if (index==1) copyXPMArea(42, 139, 5, 7, 53, posy);    
if (index==2) copyXPMArea(48, 139, 5, 7, 53, posy);    

}               

  /*************/
 /* DrawSpeed */
/*************/

void DrawSpeed(long i,int posy) {

int 	k = 1000;
int	dig1=0,dig2=0,dig3=0,dig4=0;

	dig1=(i / k)%10;
	k = k /10;
	dig2=(i / k)%10;
	k = k /10;
	dig3=(i / k)%10;
	k = k /10;
	dig4=(i / k)%10;
        	
	copyXPMArea(6*dig1+1, 129, 5, 7, 21, posy);
        copyXPMArea(6*dig2+1, 129, 5, 7, 27, posy);
        copyXPMArea(6*dig3+1, 129, 5, 7, 33, posy);
        copyXPMArea(6*dig4+1, 129, 5, 7, 40, posy);
}               

  /***************/
 /* stillonline */
/***************/

int stillonline(char *ifs) {

        FILE    *fp;
        char    temp[128];
	int 	i = 0;

        fp = fopen("/proc/net/route", "r");
        if (fp) {
                while (fgets(temp, 128, fp)) {
                        if (strstr(temp, ifs)) {
       		                i = 1; /* Line is alive */
                        }
                }
                fclose(fp);
        }
        if(test) i = 1;
        return i;
}                          

  /**************/
 /* get_number */
/**************/

int get_number(long time) {

	int i, minute,hour;
        i = 0;

 	minute = time % 60;
        hour = (time / 60) % 100;
        i = hour * 100 + minute;  

        return i;
}                          

  /******************/
 /* get_statistics */
/******************/

int get_statistics(char *devname, long *ip, long *op, long *is, long *os) {

        struct ppp_stats        ppp_cur;
        static int    	        ppp_opened = 0;


        if (!ppp_opened) {
                /* Open the ppp device. */
                memset(&ppp_cur, 0, sizeof(ppp_cur));
                if ((ppp_h = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
                        return -1;
                ppp_opened = 1;
        }                                                  
        get_ppp_stats(&ppp_cur);

        *op = ppp_cur.p.ppp_opackets;
        *ip = ppp_cur.p.ppp_ipackets;

        *is = ppp_cur.p.ppp_ibytes;
        *os = ppp_cur.p.ppp_obytes;

        return 0;
}                                

  /*****************/
 /* get_ppp_stats */
/*****************/

void get_ppp_stats(struct ppp_stats *cur) {

        struct ifpppstatsreq    req;

        memset(&req, 0, sizeof(req));

        req.stats_ptr = (caddr_t) &req.stats;

        strcpy(req.ifr__name, active_interface);

        if (ioctl(ppp_h, SIOCGPPPSTATS, &req) >= 0)
                *cur = req.stats;
}                                           


  /***************/
 /* Config File */
/***************/

void configfile(char *temp) {

char	*stringconf;
FILE    *log;

  	fp = fopen(temp, "r");
		if (fp==NULL) {
			fprintf(stderr, "\n No configuration File.\n Creating %s ...",temp);  

 			stringconf = (void *)malloc(1024);  
			sprintf(stringconf, "warn: 1\nwarning: 30\nwarnmsg: Warning\ndelay: 8\ncurrency_symbol: Esc\ncurrency_position: right\nlog: 0\ndefault: from 0:00 to 23:59 use 400 at 10\nsunday: from 0:00 to 23:59 use 400 at 10\nmonday: from 9:00 to 17:59 use 180 at 10\ntuesday: from 9:00 to 17:59 use 180 at 10\nwednesday: from 9:00 to 17:59 use 180 at 10\nthursday: from 9:00 to 17:59 use 180 at 10\nfriday: from 9:00 to 17:59 use 180 at 10\nsaturday: from 0:00 to 23:59 use 400 at 10\nholydays: 1/1, 2/4, 4/4, 25/4, 1/5, 3/6, 10/6, 15/8, 5/10, 1/11, 1/12, 8/12, 25/12\n");
                        
			fprintf(stderr, "\n Done.");  
			fp = fopen(temp, "a+");
                        	fprintf(fp, stringconf);
				free(stringconf);
		        fclose(fp); 
			
			log = fopen(logfile, "r+");
			if (log==NULL) fprintf(log," ");
			fclose(log);
   	
			fprintf(stderr, "\n\nEdit the file and run aspbm again.\n\n");  
			exit(0);
		}
        fclose(fp); 


}

  /************/
 /* defaults */
/************/

void defaults() {

char *namefont;

	/* Phone Rules */

	rule(sunday,1);
	rule(monday,2);
	rule(tuesday,3);
	rule(wednesday,4);
	rule(thursday,5);
	rule(friday,6);
	rule(saturday,7);
	rule(default0,8);
	hrule(holyday);

	pulse_time = check_pulse();
        
	/* Create Font for drawing */

	namefont = (void *)malloc(80);
        strcpy(namefont, HOSTFONT);  

        popupfont=XLoadQueryFont(display, namefont);
	
	if(popupfont == NULL)
	{
        	fprintf(stderr, "Can't load font %s!\n", namefont);
        	exit(1);
	}                                

	free(namefont);

	namefont = (void *)malloc(80);
        strcpy(namefont, WARNFONT);  

        warnfont=XLoadQueryFont(display, namefont);

	if(popupfont == NULL)
	{
        	fprintf(stderr, "Can't load font %s!\n", namefont);
        	exit(1);
	}                                

	free(namefont);

	/* Create GC for drawing */

	bg_pixel = GetColor("black");
        fg_pixel = GetColor("LightSeaGreen");  

        gcm =  GCForeground | GCBackground | GCGraphicsExposures;
        gcv.foreground = fg_pixel;
        gcv.background = bg_pixel;
        gcv.graphics_exposures = 0;
        NormalGC = XCreateGC(display, root, gcm, &gcv);   

	XSetFont(display, NormalGC, popupfont->fid);

	popbg_pixel = GetColor("#4f4f4f");
        popfg_pixel = GetColor("#222222");  

        gcm =  GCForeground | GCBackground | GCGraphicsExposures;
        gcv.foreground = popfg_pixel;
        gcv.background = popbg_pixel;
        gcv.graphics_exposures = 0;
        PopupGC = XCreateGC(display, root, gcm, &gcv);   

	XSetFont(display, PopupGC, popupfont->fid); 

	warnbg_pixel = GetColor("yellow");
        warnfg_pixel = GetColor("#222222");  

        gcm =  GCForeground | GCBackground | GCGraphicsExposures;
        gcv.foreground = warnfg_pixel;
        gcv.background = warnbg_pixel;
        gcv.graphics_exposures = 0;
        WarnGC = XCreateGC(display, root, gcm, &gcv);   

	XSetFont(display, WarnGC, warnfont->fid); 
}

  /*********/
 /* usage */
/*********/

void usage(void) {

	fprintf(stderr, "\nAfterstep phone bill monitor - version %s\n\n",ASPBM_VERSION);
	fprintf(stderr, "Pedro Moleiro (moleiro@ip.pt)\n");
	fprintf(stderr, "http:\\\\www.ip.pt\\~ip241956\n\n");
	fprintf(stderr, "usage: aspbm [-options ...]\n\n");
	fprintf(stderr, "options:\n");
	fprintf(stderr, "-h                           this help screen\n");
	fprintf(stderr, "-s                           shaped form\n");
	fprintf(stderr, "-t                           set the on-line timer to MM:SS instead of HH:MM\n");
        fprintf(stderr, "-u <update rate>             (1..10), default 5 seconds\n"); 
	fprintf(stderr, "-v                           print the version number\n");
	fprintf(stderr, "-z                           test mode\n");
	fprintf(stderr, "\nExample: aspbm -s -t -u 5\n\n");
}

  /***********/
 /* Version */
/***********/

void Version(void) {

	fprintf(stderr, "\naspbm - version %s\n\n", ASPBM_VERSION);
}

  /***************/
 /* check_pulse */
/***************/

int check_pulse() {

int i = 0, wd, aux = 0, aux1 = 0, aux2 = 0, aux3 = 0, aux4 = 0;
int		index = 1, ind = 0, iand;
time_t          time_tp; 
struct tm       *mytime;

time(&time_tp);
mytime= localtime(&time_tp);   

wd = mytime->tm_wday+1;
iand = wd;

aux = mytime->tm_hour*100+mytime->tm_min;
aux1 = phone_rules[wd].from_h*100+phone_rules[wd].from_m;
aux2 = phone_rules[wd].to_h*100+phone_rules[wd].to_m;
	
/*fprintf(stderr, "\n%i\n",phone_rules[wd].and);*/

i = phone_rules[8].use;
pulse_cost=phone_rules[8].at;

if ( (aux > (aux1 - 1)) && (aux < aux2) ) {
	i = phone_rules[wd].use;
	pulse_cost=phone_rules[wd].at;
}


while (phone_rules[iand].and==1) {

	iand = iand + 8;

	aux3 = phone_rules[iand].from_h*100+phone_rules[iand].from_m;
    	aux4 = phone_rules[iand].to_h*100+phone_rules[iand].to_m; 
 			
        if ( (aux > (aux3 - 1)) && (aux < aux4) ) {
                i = phone_rules[iand].use;
                pulse_cost=phone_rules[iand].at;
        }
}

if (oldday !=  mytime->tm_mday) {
	isholyday = 0;
	while (index == 1) {
		ind = ind +1;
		if ((hrules[ind].day == mytime->tm_mday)  && (hrules[ind].month  == (mytime->tm_mon + 1))) isholyday = 1;
		if (ind == 20) index = 0;
/*		fprintf(stderr, "\n%i--%i-%i\n",ind,hrules[ind].day,hrules[ind].month);*/
	}
	oldday =  mytime->tm_mday;	
}

if (isholyday == 1) {
	i = phone_rules[8].use;
	pulse_cost=phone_rules[8].at;  
}

return i;
}                          

  /**********************************/
 /* Makepopup - Construct a window */
/**********************************/

Window MakePopup(int x, int y, unsigned int w, unsigned int h, Pixel fg_pixel, Pixel bg_pixel, int bw){

Window mywin;
XSetWindowAttributes    setwinattr; 

        mywin = XCreateSimpleWindow(display, root, x, y, w, h, bw,
		fg_pixel, bg_pixel);

	setwinattr.override_redirect=True; 
        XChangeWindowAttributes(display, mywin,
        	CWOverrideRedirect, &setwinattr);    
	
	XMapWindow(display, mywin);
        return mywin;
}     

  /******************************/
 /* Do_popdown - Kill a window */
/******************************/

void do_popdown(Window win)
{
        XUngrabPointer(display, CurrentTime);
        XDestroyWindow(display, win);
}     

  /******************************/
 /* Pop - Pop window with info */
/******************************/ 
 
void pop(int bytes_in,int bytes_out, float cost){

int	xr, yr, wr, hr, myw = 155;
static char *string;
Window dummy;
unsigned int  mask; 
int	logh = 0, logm = 0, logs = 0;

	XQueryPointer(display, root, &dummy, &dummy, &xr, &yr, &wr, &hr, &mask);
	
	if(xr >= (screen_width / 2)) xr = xr - 120;
    	else xr = xr;

    	if(yr >= (screen_height / 2)) yr = yr - 80;
    	else yr = yr;   

	popup = MakePopup(xr, yr, myw, 123, popfg_pixel, popbg_pixel, 1); 

	Readlog(logfile);

	XDrawString(display, popup, NormalGC, 23, 13, "Info Window", strlen("Info Window")); 

	XDrawLine(display, popup,  PopupGC, 1, 18, myw-1, 18);   
	XDrawString(display, popup, NormalGC, 3, 30, "Connection", strlen("Connection")); 

	string = (void *)malloc(64);

	if (strstr(cpositionrc,"right")) sprintf(string, "%is at %.2f%s",  pulse_time,pulse_cost,csymbolrc);
	else sprintf(string, "%is at %s%.2f",  pulse_time,csymbolrc, pulse_cost);

	XDrawString(display, popup, NormalGC, 23, 45, string, strlen(string)); 
	XDrawLine(display, popup,  PopupGC, 1, 48, myw-1, 48);   

	XDrawString(display, popup, NormalGC, 3, 60, "Current", strlen("Current")); 

	free(string);
	string = (void *)malloc(64);

	if (strstr(cpositionrc,"right")) sprintf(string, "Cost %.2f%s", cost,csymbolrc);
	else sprintf(string, "Cost %s%.2f", csymbolrc, cost);

	XDrawString(display, popup, NormalGC, 23, 75, string, strlen(string)); 
	XDrawLine(display, popup,  PopupGC, 1, 78, myw-1, 78);   

	XDrawString(display, popup, NormalGC, 3, 90, "Total", strlen("Total")); 

	free(string);
	string = (void *)malloc(64);

	if (strstr(cpositionrc,"right")) sprintf(string, "Total Cost: %.2f%s", logtcost, csymbolrc);
	else sprintf(string, "Total Cost: %s%.2f", csymbolrc, logtcost);

	XDrawString(display, popup, NormalGC, 23, 105, string, strlen(string)); 

	free(string);
	string = (void *)malloc(64);

	logs = logttime % 60;	
	logm = (logttime / 60) % 60;
	logh = (logttime / 3600 );
                                         
        sprintf(string, "Total Time: %i:%.2i:%.2i", logh,logm,logs);
	XDrawString(display, popup, NormalGC, 23, 120, string, strlen(string)); 
	XDrawLine(display, popup,  PopupGC, 1, 123, myw-1, 123);   

	free(string);

}

  /********************************/
 /* WarnPop - pop warning window */
/********************************/
  
void warnpop(char *msg)
{
int longest, msg_width;
 
	longest = strlen(msg); 
	msg_width = XTextWidth(warnfont, msg, longest); 

	if (msg_width > (screen_width-151)) msg_width = screen_width;

	warn = MakePopup((int)(screen_width/2-msg_width/2-75), 
		(int)(screen_height/2-100), msg_width+150, 200, warnfg_pixel, 
		warnbg_pixel, 1); 

	XDrawString(display, warn, WarnGC, 
		(int)((msg_width+150)/2-msg_width/2), 100, msg, strlen(msg)); 
}                                                

  /**********/
 /* SetLED */
/**********/

void SetLED(int led, int on) {

        switch (led) {
        case LED_POWER:
		if (on) {
			copyXPMArea(LED_ON_X, LED_ON_Y, LED_SZE_X, LED_SZE_Y,  LED_PWR_X, LED_PWR_Y);
			copyXPMArea(LED_ON_X, LED_ON_Y, LED_SZE_X, LED_SZE_Y,  LED_PWR_X, LED_PWR_Y+64);
		} else {
			copyXPMArea(LED_OFF_X, LED_OFF_Y, LED_SZE_X, LED_SZE_Y,  LED_PWR_X, LED_PWR_Y);
			copyXPMArea(LED_OFF_X, LED_OFF_Y, LED_SZE_X, LED_SZE_Y,  LED_PWR_X, LED_PWR_Y+64);
		}
                break;
        case LED_RX:
                if (on) {
			copyXPMArea(LED_ON_X, LED_ON_Y, LED_SZE_X, LED_SZE_Y,  LED_RCV_X, LED_RCV_Y);
			copyXPMArea(LED_ON_X, LED_ON_Y, LED_SZE_X, LED_SZE_Y,  LED_RCV_X, LED_RCV_Y+64);
		} else {
			copyXPMArea(LED_OFF_X, LED_OFF_Y, LED_SZE_X, LED_SZE_Y,  LED_RCV_X, LED_RCV_Y);
			copyXPMArea(LED_OFF_X, LED_OFF_Y, LED_SZE_X, LED_SZE_Y,  LED_RCV_X, LED_RCV_Y+64);
		}
                break;
        case LED_TX:
                if (on) {
			copyXPMArea(LED_ON_X, LED_ON_Y, LED_SZE_X, LED_SZE_Y,  LED_SND_X, LED_SND_Y);
			copyXPMArea(LED_ON_X, LED_ON_Y, LED_SZE_X, LED_SZE_Y,  LED_SND_X, LED_SND_Y+64);
		} else {
			copyXPMArea(LED_OFF_X, LED_OFF_Y, LED_SZE_X, LED_SZE_Y,  LED_SND_X, LED_SND_Y);
			copyXPMArea(LED_OFF_X, LED_OFF_Y, LED_SZE_X, LED_SZE_Y,  LED_SND_X, LED_SND_Y+64);
		}
                break;
        }                                         
}

  /***************/
 /* Phone Rules */
/***************/

void rule(char *string, int irule) {

int 	i1,i2,i3,i4,i5;
int 	index = 1;
float	i6;

/*	fprintf(stderr, "\n%s\n",string);*/
/*	fprintf(stderr, "\n----from %i:%i to %i:%i use %i at %f\n",i1,i2,i3,i4,i5,i6);*/

	sscanf(string, "from %d:%d to %d:%d use %d at %f", &i1, &i2, &i3, &i4, &i5, &i6);
	phone_rules[irule].from_h = i1;
	phone_rules[irule].from_m = i2;
	phone_rules[irule].to_h = i3;
	phone_rules[irule].to_m = i4;
	phone_rules[irule].use = i5;
	phone_rules[irule].at = i6;
        
	if (strstr(string, "and")) {		
                string = strstr(string, "and");
                string += strlen("and ");
		phone_rules[irule].and = 1;

	}
	else {
		index=0;
		phone_rules[irule].and = 0;
	}

	while (index == 1) {

                irule=irule + 8;

		sscanf(string, "from %d:%d to %d:%d use %d at %f", &i1, &i2, &i3, &i4, &i5, &i6);
		phone_rules[irule].from_h = i1;
		phone_rules[irule].from_m = i2;
		phone_rules[irule].to_h = i3;
		phone_rules[irule].to_m = i4;
		phone_rules[irule].use = i5;
		phone_rules[irule].at = i6;

        	if (strstr(string, "and")) {		
       	        	string = strstr(string, "and");
           		string += strlen("and ");
			phone_rules[irule].and = 1;
               	}
		else {
			index=0;
			phone_rules[irule].and = 0;        	             
		}
	}
}                

  /*************/
 /*  Holidays */
/*************/

void hrule(char *string) {

char    *scut=NULL, *sstr=NULL;
char    *p;
int	index = 1;
int     i1,i2,ind = 0;

scut = (void *)malloc(6);
sstr=strdup(string);

while(index == 1) {	
	ind = ind +1;	      

	if (strstr(sstr, ",")) {	
		p = strstr(sstr, ",");
		strncpy(scut,sstr,(strlen(sstr)-strlen(p)+1));
		sscanf(scut, "%d/%d,", &i1, &i2);   
		hrules[ind].day = i1; 
		hrules[ind].month = i2; 

		free(scut); 
		scut = (void *)malloc(6);

		p += strlen(", ");
		sstr=strdup(p);

	}
	else {
	 	sscanf(sstr, "%d/%d,", &i1, &i2);
                hrules[ind].day = i1;
                hrules[ind].month = i2; 
		index = 0;  
	}	

}
free(scut);
}

  /****************/
 /* Logfile Read */
/****************/

void Readlog(const char *filename) {

int     i1=0,i2=0,i3=0,i4=0,i5=0,i6=0,i7=0;
float   i8=0;    
char    temp[128];
FILE    *fp;

logttime = 0;
logtpulse = 0;
logtcost = 0;

fp = fopen(filename, "r");
if (fp) {
	while (fgets(temp, 128, fp)) {
		sscanf(temp, "%d/%d - %d:%d:%d - %d - %d - %f", &i1, &i2, &i3, &i4, &i5, &i6, &i7, &i8);   
             	logttime=logttime+i6;
		logtpulse=logtpulse+i7;
		logtcost=logtcost+i8;
	}
       	fclose(fp);
/*	fprintf(stderr, "\n%li -- %li -- %f\n", logttime, logtpulse, logtcost);*/
}

}                                             
                                                 

/* General */
/*------------------------------------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------------------------------------*/

  /****************/
 /* parse_rcfile */
/****************/

void parse_rcfile(const char *filename, rckeys *keys) {

        char    *p,*q;
        char    temp[128];
        char    *tokens = " :\t\n";
        FILE    *fp;
        int             i,key;

        fp = fopen(filename, "r");
        if (fp) {
                while (fgets(temp, 128, fp)) {
                        key = 0;
                        q = strdup(temp);
                        q = strtok(q, tokens);
                        while (key >= 0 && keys[key].label) {
                                if ((!strcmp(q, keys[key].label))) {
                                        p = strstr(temp, keys[key].label);
                                        p += strlen(keys[key].label);
                                        p += strspn(p, tokens);
                                        if ((i = strcspn(p, "#\n"))) p[i] = 0;
                                        free(*keys[key].var);
                                        *keys[key].var = strdup(p);
                                        key = -1;
                                } else key++;
                        }
                        free(q);
                }
                fclose(fp);
        }
}                                             

  /************/
 /* GetColor */
/************/

static Pixel GetColor(char *name) {

        XColor                          color;
        XWindowAttributes       attributes;

        
	XGetWindowAttributes(display, root, &attributes);

        color.pixel = 0;
        if (!XParseColor(display, attributes.colormap, name, &color)) {
                fprintf(stderr, "aspbm: can't parse %s.\n", name);
        } else if (!XAllocColor(display, attributes.colormap, &color)) {
                fprintf(stderr, "aspbm: can't allocate %s.\n", name);
        }
        return color.pixel;
}                                                         

  /**********/
 /* GetXPM */
/**********/

static void GetXPM(XpmIcon *wmgen, char *pixmap_bytes[]) {

        XWindowAttributes       attributes;
        int                                     err;

        /* For the colormap */
        XGetWindowAttributes(display, root, &attributes);

        wmgen->attributes.valuemask |= (XpmReturnPixels | XpmReturnExtensions);

        err = XpmCreatePixmapFromData(display, root, pixmap_bytes, &(wmgen->pixmap),
                                        &(wmgen->mask), &(wmgen->attributes));

        if (err != XpmSuccess) {
                fprintf(stderr, "Not enough free colorcells.\n");
                exit(1);
        }
}

  /****************/
 /* flush_expose */
/****************/

static int flush_expose(Window w) {

        XEvent          dummy;
        int                     i=0;

        while (XCheckTypedWindowEvent(display, w, Expose, &dummy))
                i++;

        return i;
}

  /******************/
 /* RedrawWindowXY */
/******************/

void RedrawWindowXY(int x, int y) {

        flush_expose(iconwin);
        XCopyArea(display, wmgen.pixmap, iconwin, NormalGC,
                                x,y, wmgen.attributes.width, wmgen.attributes.height, 0,0);
        flush_expose(win);
        XCopyArea(display, wmgen.pixmap, win, NormalGC,    
                                x,y, wmgen.attributes.width, wmgen.attributes.height, 0,0);
}

  /******************/
 /* AddMouseRegion */
/******************/

void AddMouseRegion(int index, int left, int top, int right, int bottom) {

        if (index < MAX_MOUSE_REGION) {
                mouse_region[index].enable = 1;
                mouse_region[index].top = top;
                mouse_region[index].left = left;
                mouse_region[index].bottom = bottom;
                mouse_region[index].right = right;
        }
}

  /******************/
 /* GetMouseRegion */
/******************/

int GetMouseRegion(int x, int y) {

        int             i;
        int             found;

        found = 0;

        for (i=0; i<MAX_MOUSE_REGION && !found; i++) {
                if (mouse_region[i].enable &&
                        x <= mouse_region[i].right &&
                        x >= mouse_region[i].left &&
                        y <= mouse_region[i].bottom &&
                        y >= mouse_region[i].top)
                        found = 1;
        }
        if (!found) return -1;
        return (i-1);
}

  /********************/     
 /* createXBMfromXPM */
/********************/

void createXBMfromXPM(char *xbm, char **xpm, int sx, int sy) {

        int             i,j;
        int             width, height, numcol;
        char    zero;
        unsigned char   bwrite;
        int             bcount;


        sscanf(*xpm, "%d %d %d", &width, &height, &numcol);

        zero = xpm[1][0];
        for (i=numcol+1; i < numcol+sy+1; i++) {
                bcount = 0;
                bwrite = 0;
                for (j=0; j<sx; j++) {
                        bwrite >>= 1;
                        if (xpm[i][j] != zero) {
                                bwrite += 128;
                        }
                        bcount++;
                        if (bcount == 8) {
                                *xbm = bwrite;
                                xbm++;
                                bcount = 0;
                                bwrite = 0;
                        }
                }
        }
}

  /***************/
 /* copyXPMArea */
/***************/

void copyXPMArea(int x, int y, int sx, int sy, int dx, int dy) {

        XCopyArea(display, wmgen.pixmap, wmgen.pixmap, NormalGC, x, y, sx, sy, dx, dy);

}
                                             

  /*************/
 /* setMaskXY */
/*************/

void setMaskXY(int x, int y) {

         XShapeCombineMask(display, win, ShapeBounding, x, y, pixmask, ShapeSet);
         XShapeCombineMask(display, iconwin, ShapeBounding, x, y, pixmask, ShapeSet);
}

  /***************/
 /* openXwindow */
/***************/

void openXwindow(int argc, char *argv[], char *pixmap_bytes[], char *pixmask_bits, int pixmask_width, int pixmask_height) {

        unsigned int    borderwidth = 1;
        XClassHint    	classHint;
        char          	*display_name = NULL;
        char           	*wname = argv[0];
        XTextProperty   name;

        XGCValues     	gcv;
        unsigned long   gcm;

        char          	*geometry = NULL;

        int           	dummy=0;
        int           	i, wx, wy;

        for (i=1; argv[i]; i++) {
                if (!strcmp(argv[i], "-display")) {
                        display_name = argv[i+1];
                        i++;
                }
                if (!strcmp(argv[i], "-geometry")) {
                        geometry = argv[i+1];
                        i++;                                    
                }
        }

        if (!(display = XOpenDisplay(display_name))) {
                fprintf(stderr, "%s: can't open display %s\n",
                                                wname, XDisplayName(display_name));
                exit(1);
        }

        screen  = DefaultScreen(display);
        root    = RootWindow(display, screen);

        /* Convert XPM to XImage */
        GetXPM(&wmgen, pixmap_bytes);

        /* Create a window to hold the stuff */
        mysizehints.flags = USSize | USPosition;
        mysizehints.x = 0;
        mysizehints.y = 0;

        back_pix = GetColor("white");
        fore_pix = GetColor("black");

        XWMGeometry(display, screen, Geometry, NULL, borderwidth, &mysizehints,
                                &mysizehints.x, &mysizehints.y,&mysizehints.width,&mysizehints.height, &dummy);

        mysizehints.width = 64;
        mysizehints.height = 64;

        win = XCreateSimpleWindow(display, root, mysizehints.x, mysizehints.y,
                                mysizehints.width, mysizehints.height, borderwidth, fore_pix, back_pix);

        iconwin = XCreateSimpleWindow(display, win, mysizehints.x, mysizehints.y,
                                mysizehints.width, mysizehints.height, borderwidth, fore_pix, back_pix);

        /* Activate hints */
        XSetWMNormalHints(display, win, &mysizehints);        
        classHint.res_name = wname;
        classHint.res_class = wname;
        XSetClassHint(display, win, &classHint);

        XSelectInput(display, win, ButtonPressMask | ExposureMask | ButtonReleaseMask | PointerMotionMask | StructureNotifyMask);
        XSelectInput(display, iconwin, ButtonPressMask | ExposureMask | ButtonReleaseMask | PointerMotionMask | StructureNotifyMask);

        if (XStringListToTextProperty(&wname, 1, &name) == 0) {
                fprintf(stderr, "%s: can't allocate window name\n", wname);
                exit(1);
        }

        XSetWMName(display, win, &name);

        /* Create GC for drawing */
        gcm = GCForeground | GCBackground | GCGraphicsExposures;
        gcv.foreground = fore_pix;
        gcv.background = back_pix;
        gcv.graphics_exposures = 0;
        NormalGC = XCreateGC(display, root, gcm, &gcv);

        /* ONLYSHAPE ON */
        pixmask = XCreateBitmapFromData(display, win, pixmask_bits, pixmask_width, pixmask_height);
        XShapeCombineMask(display, win, ShapeBounding, 0, 0, pixmask, ShapeSet);
        XShapeCombineMask(display, iconwin, ShapeBounding, 0, 0, pixmask, ShapeSet);

        /* ONLYSHAPE OFF */
        mywmhints.initial_state = WithdrawnState;
        mywmhints.icon_window = iconwin;
        mywmhints.icon_x = mysizehints.x;
        mywmhints.icon_y = mysizehints.y;
        mywmhints.window_group = win;
        mywmhints.flags = StateHint | IconWindowHint | IconPositionHint | WindowGroupHint;     

        XSetWMHints(display, win, &mywmhints);

        XSetCommand(display, win, argv, argc);
        XMapWindow(display, win);

	/* Geometry command*/
        if (geometry) {
                if (sscanf(geometry, "+%d+%d", &wx, &wy) != 2) {
                        fprintf(stderr, "Bad geometry string.\n");
                        exit(1);
                }
                XMoveWindow(display, win, wx, wy);
        }
}
                                              
                                              

