/*
 * Copyright (c) 1999  Albert Dorofeev <Albert@mail.dma.be>
 * For the updates see http://bewoner.dma.be/Albert/
 *
 * This software is distributed under GPL. For details see LICENSE file.
 */

#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>

#include "state.h"

extern struct asmem_state state;

#define BUFFER_LENGTH 400
int fd;
char buf[BUFFER_LENGTH];

void error_handle( int place, const char * message )
{
	int error_num;
	error_num = errno;
	/* if that was an interrupt - quit quietly */
	if (error_num == EINTR) {
		printf("asmem: Interrupted.\n");
		return;
	}
	switch ( place )
	{
	case 1: /* opening the /proc/meminfo file */
		switch (error_num)
		{
		case ENOENT :
			printf("asmem: The file %s does not exist. "
			"Weird system it is.\n", state.proc_mem_filename);
			break;
		case EACCES :
			printf("asmem: You do not have permissions "
			"to read %s\n", state.proc_mem_filename);
			break;
		default :
			printf("asmem: cannot open %s. Error %d: %s\n",
				state.proc_mem_filename, errno,
				sys_errlist[errno]);
			break;
		}
		break;
	default: /* catchall for the rest */
		printf("asmem: %s: Error %d: %s\n",
			message, errno, sys_errlist[errno]);
	}
}

int read_meminfo()
{
	int result;
	result = lseek(fd, 0, SEEK_SET);
	if ( result < 0 ) {
		error_handle(2, "seek");
		return -1;
	}
	result = read(fd, buf, sizeof buf);
	switch(result)
	{
	case 0 : /* Huh? End of file? Pretend this did not happen... */
		break;
	case -1 :
		error_handle(2, "read");
		return -1;
	default :
	}
	buf[result-1] = 0;
	result = sscanf(buf, "%*[^\n]%*s %ld %ld %ld %ld %ld %ld\n%*s %ld %ld %ld",
		&state.fresh.total,
		&state.fresh.used,
		&state.fresh.free,
		&state.fresh.shared,
		&state.fresh.buffers,
		&state.fresh.cached,
		&state.fresh.swap_total,
		&state.fresh.swap_used,
		&state.fresh.swap_free
		);
	switch(result)
	{
	case 0 :
	case -1 :
		printf("asmem: invalid input character while "
			"reading %s\n", state.proc_mem_filename);
		return -1;
	}
#ifdef DEBUG
	printf("+- Total : %ld, used : %ld, free : %ld \n", 
			state.fresh.total, 
			state.fresh.used,
			state.fresh.free);
	printf("|  Shared : %ld, buffers : %ld, cached : %ld \n",
			state.fresh.shared,
			state.fresh.buffers,
			state.fresh.cached);
	printf("+- Swap total : %ld, used : %ld, free : %ld \n",
			state.fresh.swap_total,
			state.fresh.swap_used,
			state.fresh.swap_free);
#endif
	return 0;
}

int open_meminfo()
{
	int result;
	if ((fd = open(state.proc_mem_filename, O_RDONLY)) == -1) {
		error_handle(1, "");
		return -1;
	}
	return 0;
}

int close_meminfo()
{
	close(fd);
	return 0;
}

