.TH asmem 1 "20 October 1998" "Version 0.1-1"
.UC
.SH NAME
\fBasmem\fP \- the AfterStep memory monitor
.SH SYNOPSIS
.B asmem
[-h] [-v]
        [-i] [-w]
        [-p \fI[+|-]x[+|-]y\fP]
        [-bg \fIcolor\fP]
        [-fg \fIcolor\fP]
        [-a1 \fIcolor\fP]
        [-a2 \fIcolor\fP]
        [-a3 \fIcolor\fP]
        [-e \fIcommand\fP]
        [-noborder]
.SH DESCRIPTION
The \fBasmem\fP is a X11 application that acts as
an a memory monitor for computers running Linux.
The applet provides a distinctive AfterStep window
manager look.
.PP
Three arrows show (in the top-down order) the percentage of memory 
used for programs and system, memory used for cache and 
swap space.

.SH CONFIGURATION OPTIONS
.IP "-h"
.RS
Prints a short description and usage message.
.RE
.IP "-v"
.RS
Version control. Prints the version of the applet.
.RE
.IP "-p [+|-]x[+|-]y"
.RS
Displays the window at the specified location
on the screen. This works as standard X Windows
geometry option.
.RE
.IP "-i"
.RS
Starts the \fBasmem\fP application in the iconized mode.
The icon has the same appearance with the main
window.
.RE
.IP "-w"
.RS
Starts the \fBasmem\fP application in the withdrawn mode.
This option is necessary to be able to dock the
\fBasmem\fP in the WindowMaker dock.
.RE
.IP "-fg <color>"
.RS
The color for the "foreground". This color is used to draw
the bars along which the arrows slide. The default is LightGrey.
.RE
.IP "-bg <color>"
.RS
The color for the background of the meter. The default is black.
.RE
.IP "-a1 <color>"
.RS
Color of the upper (memory) arrow. Default is green.
.RE
.IP "-a2 <color>"
.RS
Color of the middle (cache) arrow. Default is yellow.
.RE
.IP "-a3 <color>"
.RS
Color of the bottom (swap) arrow. Default is red.
.RE
.IP "-e <command>"
.RS
The applet will run /bin/sh -c with the specified command
on a mouseclick in the window.
.RE
.IP "-noborder"
.RS
Asks the asmem applet to draw no border around the application window.
.RE
.SH INVOCATION
\fBasmem\fP was written to be swallowed by the AfterStep wharf
module, but it can be used with everything else too.
A common invocation is the command line:
.nf

	user@host[1]% asmem -fg LightSeaGreen -bg "#434343" &

.fi
Another way to call \fBasmem\fP is from the AfterStep Wharf:
.nf

	*Wharf asmem nil Swallow "asmem" asmem -fg LightSeaGreen &

.fi
This line, when placed in the \fIwharf\fP file in the users Afterstep
configuration directory will cause \fBasmem\fP to be a
button on the \fBWharf (1)\fP button bar under the \fBafterstep (1)\fP
window manager.

If you run WindowMaker then you should use the "-w" (for "withdrawn")
option:
.nf

	user@host[1]% asmem -w &

.fi
and then drag the icon to the dock.
.SH BUGS
None that I am aware of.
.SH FILES
.I /proc/meminfo
.SH "SEE ALSO"
.BR Wharf (1), proc (5)
.SH COPYRIGHTS
Copyright (c) 1998 alinden@netcologne.de

Distributed under GNU General Public License
.SH AUTHORS
The application: alinden@netcologne.de

The man page: Albert Dorofeev <Albert@mail.dma.be>
.sp
