/* This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program;  if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA. */

#define MG_SOCKLIB_H

#include <netinet/in.h>
#include <sys/types.h>

#define SOCKET_DELAY 0
#define SOCKET_NDELAY 1

#define SOCKET_RESET 0
#define SOCKET_SET 1
#define HOST_NAMELEN 64

typedef struct {
   struct sockaddr_in sin;	/* sin and sinlen store address and length	*/
   int sinlen;				/* information of the server socket			*/
   int bindflag;			/* used to ensure bind() is only used once	*/
   int sd;					/* Socket descriptor						*/
} SOCKET;

SOCKET *sopen(void);
int sclose(SOCKET *);
int sserver(SOCKET *, int, int);
int sclient(SOCKET *, char *, int);
size_t sread(int sd, char *string, int n, int timeout);
size_t swrite(int sd, char *string);
#include "socklib.c"
