/*
   Copyright (c) 1999 by MoGul <kaliph@gmx.net>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program;  if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include "socklib.h"

#define ACK_MSG "+OK"
#define ERR_MSG "+ERR"
#define TIMEOUT 120
#define DEFAULTPORT 110

/* Macro... for lazy programmers ;) */
#define WAITOK {										\
    switch (sread(sd, input, 200, TIMEOUT)) {			\
        case -1:	/* Error */							\
        case 0:		/* Timeout */						\
            InDuty = 0;									\
            return -1;									\
    }													\
    sscanf(input, "%5s", strg);							\
    if (strcmp(strg, ACK_MSG) != 0)	{					\
        InDuty = 0;										\
        return -1;										\
    }	      											\
}

int pop(char *string, int *nmail, int *oldmail)
/* String must contain - in this order:
    servername username password [port#] */
{
	SOCKET *sock;
    int sd, i, port;
    char input[200], output[200], strg[5];
    char server[100], user[100], password[100];
    char *pnt;
    static int InDuty = 0;	/* We cannot check twice at the same time */


    if (InDuty)
        return -1;
    InDuty = 1;

    pnt = string;
    if (sscanf(pnt, "%100s", server) != 1) {
        InDuty = 0;
        return -1;
    }
    
    pnt += strlen(server) + 1;
    if (sscanf(pnt, "%100s", user) != 1) {
        InDuty = 0;
        return -1;
    }
    
    pnt += strlen(user) + 1;
    if (sscanf(pnt, "%100s", password) != 1) {
        InDuty = 0;
        return -1;
    }
    
    pnt += strlen(password) + 1;
    if (sscanf(pnt, "%d", &port) != 1)
        port = DEFAULTPORT;

    /* Create socket */
    if (!(sock = sopen())) {
        InDuty = 0;
        return -1;
    }

    /* Connect to server */
    if ((sd = sclient(sock, server, port)) == -1) {
        InDuty = 0;
        return -1;
    }
    
    /* We have connected, now we want to see a "+OK" */
    WAITOK;
    
    /* Server gently said hello. Now pass username and Password */
    sprintf(output, "USER %s\n", user);
    swrite(sd, output);
    WAITOK;
        
    sprintf(output, "PASS %s\n", password);
    swrite(sd, output);
    WAITOK;
    
    swrite(sd, "STAT\n");
    WAITOK;
    pnt = input + strlen(strg) + 1;
    i = sscanf(pnt, "%d", nmail);
    
    /* Not all pop-servers support this command, so we have to trap this */
    swrite(sd, "LAST\n");

    switch (sread(sd, input, 200, TIMEOUT)) {
        case -1:	/* Error */
        case 0:		/* Timeout */
            InDuty = 0;
            return -1;
    }
    sscanf(input, "%5s", strg);
    if (strcmp(strg, ACK_MSG) == 0)	{
    /* LIST works */
        pnt = input + strlen(strg) + 1;
        i = sscanf(pnt, "%d", oldmail);
    } else *oldmail = 0;
    
    /* We have it. Now let's go. */
    swrite(sd, "QUIT\n");
    WAITOK;
    sclose(sock);

    InDuty = 0;
    return *nmail;
}
