/*
    middle mouse button: stops program
*/

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <sensors/sensors.h>
#include <sensors/chips.h>
#include <sensors/error.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "../wmgeneral/wmgeneral.h"
#include "../wmgeneral/misc.h"

#include "alarm.h"
#include "lmse_master.xpm"
#include "lmse_mask.xbm"


#define TRUE 1
#define FALSE 0

#define VERSION "0.5"

struct FTVDISPLAY
{
    short temp1, temp2, temp3, temp4, temp5;
    short fan1, fan2, fan3;
    short vid1, vid2, vid3, vid4;
    short in0, in1, in2, in3;
    short in4, in5, in6, in7;
    short in8;
    short pll;
};

struct CHIPS
{
    short exist;
    sensors_chip_name name;
};

struct CHIPS LM78, LM78J, LM79, LM80,
             W83781D, W83782D, W83783S,
             W83627HF, SIS5595, MLCG, MLAS,
             MLCO, ADM9240, DS1780, LM81, LM75;

int degreeScale = FALSE;
int cur_stat_max;
/*prototypes*/
int initChip(void);
int initDisp(struct FTVDISPLAY *ftvdisp);
void asftavmUsage(void);
void showVid(double result, int where, int whichone,int alarmresult);
void showAny(double result, int where, int whichone, int alarmresult);
void showTemp(double result, int where, int whichone,int alarmresult1, int alarmresult2);
void showFan(double result, int where, int whichone,int alarmresult);

int main(int argc, char **argv)
{
    XEvent Event;

    int c,alarms, paused=0, cur_stat=0;

    double temp1=0, temp2=0, temp3=0, temp4=0, temp5=0;
    double fan1=0, fan2=0, fan3=0;
    double vid1=0, vid2=0, vid3=0, vid4=0;
    double in0=0, in1=0, in2=0, in3=0;
    double in4=0, in5=0, in6=0, in7=0, in8=0;
    double pll=0, alarm=0;

    struct FTVDISPLAY ftvdisp;

    for(c=1;c<argc;c++)
    {
        if(argv[c] == NULL)
        {}
        else if(!strcmp(argv[c], "-v"))
        {
            printf("\nasftavm version %s\n\n", VERSION);
            exit(0);
        }
        else if(!strcmp(argv[c], "--help"))
        {
            asftavmUsage();
            exit(0);
        }
        else if(!strcmp(argv[c], "-help"))
        {
            asftavmUsage();
            exit(0);
        }
       else if(!strcmp(argv[c], "-f"))
        {
            degreeScale=TRUE;
        }
        else
        {
            printf("\nillegal option\n\n");
            asftavmUsage();
            exit(0);
        }
    } /*end of for*/

    if(initChip() == -1)
    {
        printf("\nno supported chipsets found.\n\n");
        exit(0);
    }

    if(!initDisp(&ftvdisp))
    {
        printf("\nError\n");
        exit(0);
    }

    openXwindow(argc, argv, lmse_master_xpm, lmse_mask_bits, lmse_mask_width, lmse_mask_height);

    while(1)
    {
        while(XPending(display))
        {
            XNextEvent(display, &Event);
            switch(Event.type)
            {
            case Expose:
                RedrawWindow();
                break;
            case DestroyNotify:
                XCloseDisplay(display);
                exit(0);
                break;
	    case ButtonPress:
		switch(Event.xbutton.button)
		{
		case 2:
		    paused=!paused;
		    break;
		case 1:
		    if(cur_stat==cur_stat_max)
			cur_stat=0;
		    else
			cur_stat=cur_stat+4;
		    break;
		case 3:
		    if(cur_stat==0)
			cur_stat=cur_stat_max;
		    else
			cur_stat=cur_stat-4;
		    break;
		default:
		    break;
        	}
		break;
	    }
        } /*end of while XPending*/

        if(!paused)
	{
	    if(LM78.exist)
    	    {
        	sensors_get_feature(LM78.name, SENSORS_LM78_FAN3, &fan3);
                sensors_get_feature(LM78.name, SENSORS_LM78_FAN2, &fan2);
	        sensors_get_feature(LM78.name, SENSORS_LM78_FAN1, &fan1);
    	        sensors_get_feature(LM78.name, SENSORS_LM78_TEMP, &temp1);
        	sensors_get_feature(LM78.name, SENSORS_LM78_IN0, &in0);
                sensors_get_feature(LM78.name, SENSORS_LM78_IN1, &in1);
	        sensors_get_feature(LM78.name, SENSORS_LM78_IN2, &in2);
    	        sensors_get_feature(LM78.name, SENSORS_LM78_IN3, &in3);
    		sensors_get_feature(LM78.name, SENSORS_LM78_IN4, &in4);
                sensors_get_feature(LM78.name, SENSORS_LM78_IN5, &in5);
	        sensors_get_feature(LM78.name, SENSORS_LM78_IN6, &in6);
    	        sensors_get_feature(LM78.name, SENSORS_LM78_VID, &vid1);
        	sensors_get_feature(LM78.name, SENSORS_LM78_ALARMS, &alarm);
            }
	    else if(LM78J.exist)
            {
	        sensors_get_feature(LM78J.name, SENSORS_LM78_FAN3, &fan3);
    	        sensors_get_feature(LM78J.name, SENSORS_LM78_FAN2, &fan2);
    		sensors_get_feature(LM78J.name, SENSORS_LM78_FAN1, &fan1);
                sensors_get_feature(LM78J.name, SENSORS_LM78_TEMP, &temp1);
	        sensors_get_feature(LM78J.name, SENSORS_LM78_IN0, &in0);
    	        sensors_get_feature(LM78J.name, SENSORS_LM78_IN1, &in1);
        	sensors_get_feature(LM78J.name, SENSORS_LM78_IN2, &in2);
                sensors_get_feature(LM78J.name, SENSORS_LM78_IN3, &in3);
	        sensors_get_feature(LM78J.name, SENSORS_LM78_IN4, &in4);
    	        sensors_get_feature(LM78J.name, SENSORS_LM78_IN5, &in5);
        	sensors_get_feature(LM78J.name, SENSORS_LM78_IN6, &in6);
                sensors_get_feature(LM78J.name, SENSORS_LM78_VID, &vid1);
	        sensors_get_feature(LM78J.name, SENSORS_LM78_ALARMS, &alarm);
    	    }
	    else if(LM79.exist)
    	    {
        	sensors_get_feature(LM79.name, SENSORS_LM78_FAN3, &fan3);
                sensors_get_feature(LM79.name, SENSORS_LM78_FAN2, &fan2);
	        sensors_get_feature(LM79.name, SENSORS_LM78_FAN1, &fan1);
    	        sensors_get_feature(LM79.name, SENSORS_LM78_TEMP, &temp1);
    		sensors_get_feature(LM79.name, SENSORS_LM78_IN0, &in0);
                sensors_get_feature(LM79.name, SENSORS_LM78_IN1, &in1);
	        sensors_get_feature(LM79.name, SENSORS_LM78_IN2, &in2);
    	        sensors_get_feature(LM79.name, SENSORS_LM78_IN3, &in3);
        	sensors_get_feature(LM79.name, SENSORS_LM78_IN4, &in4);
                sensors_get_feature(LM79.name, SENSORS_LM78_IN5, &in5);
	        sensors_get_feature(LM79.name, SENSORS_LM78_IN6, &in6);
    	        sensors_get_feature(LM79.name, SENSORS_LM78_VID, &vid1);
        	sensors_get_feature(LM79.name, SENSORS_LM78_ALARMS, &alarm);
            }
	    else if(SIS5595.exist)
    	    {
        	sensors_get_feature(SIS5595.name, SENSORS_SIS5595_IN0 , &in0);
                sensors_get_feature(SIS5595.name, SENSORS_SIS5595_IN1 , &in1);
	        sensors_get_feature(SIS5595.name, SENSORS_SIS5595_IN2 , &in2);
    	        sensors_get_feature(SIS5595.name, SENSORS_SIS5595_IN3 , &in3);
        	sensors_get_feature(SIS5595.name, SENSORS_SIS5595_FAN2, &fan2);
                sensors_get_feature(SIS5595.name, SENSORS_SIS5595_FAN1, &fan1);
	        sensors_get_feature(SIS5595.name, SENSORS_SIS5595_TEMP, &temp1);
    	        sensors_get_feature(SIS5595.name, SENSORS_SIS5595_ALARMS, &alarm);
	    }
            else if(LM80.exist)
	    {
    	        sensors_get_feature(LM80.name, SENSORS_LM80_IN0, &in0);
        	sensors_get_feature(LM80.name, SENSORS_LM80_IN1, &in1);
                sensors_get_feature(LM80.name, SENSORS_LM80_IN2, &in2);
	        sensors_get_feature(LM80.name, SENSORS_LM80_IN3, &in3);
    	        sensors_get_feature(LM80.name, SENSORS_LM80_IN4, &in4);
        	sensors_get_feature(LM80.name, SENSORS_LM80_IN5, &in5);
                sensors_get_feature(LM80.name, SENSORS_LM80_IN6, &in6);
    	        sensors_get_feature(LM80.name, SENSORS_LM80_FAN2, &fan2);
	        sensors_get_feature(LM80.name, SENSORS_LM80_FAN1, &fan1);
                sensors_get_feature(LM80.name, SENSORS_LM80_TEMP, &temp1);
	        sensors_get_feature(LM80.name, SENSORS_LM80_ALARMS, &alarm);
    	    }
            else if(LM81.exist)
	    {
	        sensors_get_feature(LM81.name, SENSORS_ADM9240_IN0, &in0);
    		sensors_get_feature(LM81.name, SENSORS_ADM9240_IN1, &in1);
                sensors_get_feature(LM81.name, SENSORS_ADM9240_IN2, &in2);
	        sensors_get_feature(LM81.name, SENSORS_ADM9240_IN3, &in3);
    	        sensors_get_feature(LM81.name, SENSORS_ADM9240_IN4, &in4);
        	sensors_get_feature(LM81.name, SENSORS_ADM9240_IN5, &in5);
                sensors_get_feature(LM81.name, SENSORS_ADM9240_FAN2, &fan2);
	        sensors_get_feature(LM81.name, SENSORS_ADM9240_FAN1, &fan1);
    	        sensors_get_feature(LM81.name, SENSORS_ADM9240_TEMP, &temp1);
                sensors_get_feature(LM81.name, SENSORS_ADM9240_VID, &vid1);
	        sensors_get_feature(LM81.name, SENSORS_ADM9240_ALARMS, &alarm);
    	    }
	    else if(ADM9240.exist)
            {
	        sensors_get_feature(ADM9240.name, SENSORS_ADM9240_IN0, &in0);
    	        sensors_get_feature(ADM9240.name, SENSORS_ADM9240_IN1, &in1);
        	sensors_get_feature(ADM9240.name, SENSORS_ADM9240_IN2, &in2);
                sensors_get_feature(ADM9240.name, SENSORS_ADM9240_IN3, &in3);
	        sensors_get_feature(ADM9240.name, SENSORS_ADM9240_IN4, &in4);
    		sensors_get_feature(ADM9240.name, SENSORS_ADM9240_IN5, &in5);
    	        sensors_get_feature(ADM9240.name, SENSORS_ADM9240_FAN2, &fan2);
                sensors_get_feature(ADM9240.name, SENSORS_ADM9240_FAN1, &fan1);
	        sensors_get_feature(ADM9240.name, SENSORS_ADM9240_TEMP, &temp1);
    	        sensors_get_feature(ADM9240.name, SENSORS_ADM9240_VID, &vid1);
                sensors_get_feature(ADM9240.name, SENSORS_ADM9240_ALARMS, &alarm);
	    }
	    else if(DS1780.exist)
            {
	        sensors_get_feature(DS1780.name, SENSORS_DS1780_IN0, &in0);
    	        sensors_get_feature(DS1780.name, SENSORS_DS1780_IN1, &in1);
        	sensors_get_feature(DS1780.name, SENSORS_DS1780_IN2, &in2);
                sensors_get_feature(DS1780.name, SENSORS_DS1780_IN3, &in3);
	        sensors_get_feature(DS1780.name, SENSORS_DS1780_IN4, &in4);
    	        sensors_get_feature(DS1780.name, SENSORS_DS1780_IN5, &in5);
        	sensors_get_feature(DS1780.name, SENSORS_DS1780_FAN2, &fan2);
                sensors_get_feature(DS1780.name, SENSORS_DS1780_FAN1, &fan1);
	        sensors_get_feature(DS1780.name, SENSORS_DS1780_TEMP, &temp1);
    	        sensors_get_feature(DS1780.name, SENSORS_DS1780_VID, &vid1);
        	sensors_get_feature(DS1780.name, SENSORS_DS1780_ALARMS, &alarm);
    	    }
            else if(W83781D.exist)
	    {
    	        sensors_get_feature(W83781D.name, SENSORS_W83781D_FAN3, &fan3);
        	sensors_get_feature(W83781D.name, SENSORS_W83781D_FAN2, &fan2);
                sensors_get_feature(W83781D.name, SENSORS_W83781D_FAN1, &fan1);
	        sensors_get_feature(W83781D.name, SENSORS_W83781D_TEMP3, &temp3);
    	        sensors_get_feature(W83781D.name, SENSORS_W83781D_TEMP2, &temp2);
        	sensors_get_feature(W83781D.name, SENSORS_W83781D_TEMP1, &temp1);
                sensors_get_feature(W83781D.name, SENSORS_W83781D_IN0, &in0);
	        sensors_get_feature(W83781D.name, SENSORS_W83781D_IN1, &in1);
    	        sensors_get_feature(W83781D.name, SENSORS_W83781D_IN2, &in2);
        	sensors_get_feature(W83781D.name, SENSORS_W83781D_IN3, &in3);
                sensors_get_feature(W83781D.name, SENSORS_W83781D_IN4, &in4);
	        sensors_get_feature(W83781D.name, SENSORS_W83781D_IN5, &in5);
    	        sensors_get_feature(W83781D.name, SENSORS_W83781D_IN6, &in6);
        	sensors_get_feature(W83781D.name, SENSORS_W83781D_VID, &vid1);
                sensors_get_feature(W83781D.name, SENSORS_W83781D_ALARMS, &alarm);
	    }
            else if(W83782D.exist)
	    {
    		sensors_get_feature(W83782D.name, SENSORS_W83782D_FAN3, &fan3);
                sensors_get_feature(W83782D.name, SENSORS_W83782D_FAN2, &fan2);
	        sensors_get_feature(W83782D.name, SENSORS_W83782D_FAN1, &fan1);
    	        sensors_get_feature(W83782D.name, SENSORS_W83782D_TEMP3, &temp3);
        	sensors_get_feature(W83782D.name, SENSORS_W83782D_TEMP2, &temp2);
                sensors_get_feature(W83782D.name, SENSORS_W83782D_TEMP1, &temp1);
	        sensors_get_feature(W83782D.name, SENSORS_W83782D_IN0, &in0);
    	        sensors_get_feature(W83782D.name, SENSORS_W83782D_IN1, &in1);
        	sensors_get_feature(W83782D.name, SENSORS_W83782D_IN2, &in2);
                sensors_get_feature(W83782D.name, SENSORS_W83782D_IN3, &in3);
	        sensors_get_feature(W83782D.name, SENSORS_W83782D_IN4, &in4);
    	        sensors_get_feature(W83782D.name, SENSORS_W83782D_IN5, &in5);
        	sensors_get_feature(W83782D.name, SENSORS_W83782D_IN6, &in6);
                sensors_get_feature(W83782D.name, SENSORS_W83782D_IN7, &in7);
	        sensors_get_feature(W83782D.name, SENSORS_W83782D_IN8, &in8);
    	        sensors_get_feature(W83782D.name, SENSORS_W83782D_VID, &vid1);
        	sensors_get_feature(W83782D.name, SENSORS_W83782D_ALARMS, &alarm);
    	    }
            else if(W83627HF.exist)
	    {
    	        sensors_get_feature(W83627HF.name, SENSORS_W83782D_FAN3, &fan3);
        	sensors_get_feature(W83627HF.name, SENSORS_W83782D_FAN2, &fan2);
                sensors_get_feature(W83627HF.name, SENSORS_W83782D_FAN1, &fan1);
	        sensors_get_feature(W83627HF.name, SENSORS_W83782D_TEMP3, &temp3);
    	        sensors_get_feature(W83627HF.name, SENSORS_W83782D_TEMP2, &temp2);
        	sensors_get_feature(W83627HF.name, SENSORS_W83782D_TEMP1, &temp1);
    	        sensors_get_feature(W83627HF.name, SENSORS_W83782D_IN0, &in0);
        	sensors_get_feature(W83627HF.name, SENSORS_W83782D_IN1, &in1);
                sensors_get_feature(W83627HF.name, SENSORS_W83782D_IN2, &in2);
	        sensors_get_feature(W83627HF.name, SENSORS_W83782D_IN3, &in3);
    	        sensors_get_feature(W83627HF.name, SENSORS_W83782D_IN4, &in4);
    		sensors_get_feature(W83627HF.name, SENSORS_W83782D_IN5, &in5);
        	sensors_get_feature(W83627HF.name, SENSORS_W83782D_IN6, &in6);
        	sensors_get_feature(W83627HF.name, SENSORS_W83782D_IN7, &in7);
        	sensors_get_feature(W83627HF.name, SENSORS_W83782D_IN8, &in8);
        	sensors_get_feature(W83627HF.name, SENSORS_W83782D_VID, &vid1);
        	sensors_get_feature(W83627HF.name, SENSORS_W83782D_ALARMS, &alarm);
    	    }	
    	    else if(W83783S.exist)
    	    {
        	sensors_get_feature(W83783S.name, SENSORS_W83783S_FAN3, &fan3);
        	sensors_get_feature(W83783S.name, SENSORS_W83783S_FAN2, &fan2);
        	sensors_get_feature(W83783S.name, SENSORS_W83783S_FAN1, &fan1);
                sensors_get_feature(W83783S.name, SENSORS_W83783S_TEMP2, &temp2);
	        sensors_get_feature(W83783S.name, SENSORS_W83783S_TEMP1, &temp1);
    	        sensors_get_feature(W83783S.name, SENSORS_W83783S_IN0, &in0);
        	sensors_get_feature(W83783S.name, SENSORS_W83783S_IN1, &in1);
                sensors_get_feature(W83783S.name, SENSORS_W83783S_IN2, &in2);
	        sensors_get_feature(W83783S.name, SENSORS_W83783S_IN3, &in3);
    	        sensors_get_feature(W83783S.name, SENSORS_W83783S_IN4, &in4);
        	sensors_get_feature(W83783S.name, SENSORS_W83783S_IN5, &in5);
                sensors_get_feature(W83783S.name, SENSORS_W83783S_IN6, &in6);
	        sensors_get_feature(W83783S.name, SENSORS_W83783S_VID, &vid1);
    	        sensors_get_feature(W83783S.name, SENSORS_W83783S_ALARMS, &alarm);
            }
	    else if(MLCG.exist)
    	    {
                sensors_get_feature(MLCG.name, SENSORS_MAXI_CG_FAN3, &fan3);
	        sensors_get_feature(MLCG.name, SENSORS_MAXI_CG_FAN2, &fan2);
    	        sensors_get_feature(MLCG.name, SENSORS_MAXI_CG_FAN1, &fan1);
        	sensors_get_feature(MLCG.name, SENSORS_MAXI_CG_TEMP3, &temp3);
                sensors_get_feature(MLCG.name, SENSORS_MAXI_CG_TEMP2, &temp2);
	        sensors_get_feature(MLCG.name, SENSORS_MAXI_CG_TEMP1, &temp1);
    	        sensors_get_feature(MLCG.name, SENSORS_MAXI_CG_TEMP4, &temp4);
        	sensors_get_feature(MLCG.name, SENSORS_MAXI_CG_TEMP5, &temp5);
        	sensors_get_feature(MLCG.name, SENSORS_MAXI_CG_PLL, &pll);
        	sensors_get_feature(MLCG.name, SENSORS_MAXI_CG_VID1, &vid1);
        	sensors_get_feature(MLCG.name, SENSORS_MAXI_CG_VID2, &vid2);
        	sensors_get_feature(MLCG.name, SENSORS_MAXI_CG_VID3, &vid3);
        	sensors_get_feature(MLCG.name, SENSORS_MAXI_CG_VID4, &vid4);
                sensors_get_feature(MLCG.name, SENSORS_MAXI_CG_ALARMS, &alarm);
	    }
	    else if(MLAS.exist)
            {
	        sensors_get_feature(MLAS.name, SENSORS_MAXI_AS_FAN3, &fan3);
    	        sensors_get_feature(MLAS.name, SENSORS_MAXI_AS_FAN2, &fan2);
        	sensors_get_feature(MLAS.name, SENSORS_MAXI_AS_FAN1, &fan1);
                sensors_get_feature(MLAS.name, SENSORS_MAXI_AS_TEMP3, &temp3);
	        sensors_get_feature(MLAS.name, SENSORS_MAXI_AS_TEMP2, &temp2);
    	        sensors_get_feature(MLAS.name, SENSORS_MAXI_AS_TEMP1, &temp1);
        	sensors_get_feature(MLAS.name, SENSORS_MAXI_AS_TEMP4, &temp4);
                sensors_get_feature(MLAS.name, SENSORS_MAXI_AS_TEMP5, &temp5);
	        sensors_get_feature(MLAS.name, SENSORS_MAXI_AS_PLL, &pll);
    	        sensors_get_feature(MLAS.name, SENSORS_MAXI_AS_VID1, &vid1);
        	sensors_get_feature(MLAS.name, SENSORS_MAXI_AS_VID2, &vid2);
                sensors_get_feature(MLAS.name, SENSORS_MAXI_AS_VID3, &vid3);
	        sensors_get_feature(MLAS.name, SENSORS_MAXI_AS_VID4, &vid4);
    	        sensors_get_feature(MLAS.name, SENSORS_MAXI_AS_ALARMS, &alarm);
            }
	    else if(MLCO.exist)
    	    {
                sensors_get_feature(MLCO.name, SENSORS_MAXI_CO_FAN3, &fan3);
	        sensors_get_feature(MLCO.name, SENSORS_MAXI_CO_FAN2, &fan2);
    	        sensors_get_feature(MLCO.name, SENSORS_MAXI_CO_FAN1, &fan1);
        	sensors_get_feature(MLCO.name, SENSORS_MAXI_CO_TEMP3, &temp3);
                sensors_get_feature(MLCO.name, SENSORS_MAXI_CO_TEMP2, &temp2);
	        sensors_get_feature(MLCO.name, SENSORS_MAXI_CO_TEMP1, &temp1);
    	        sensors_get_feature(MLCO.name, SENSORS_MAXI_CO_TEMP4, &temp4);
                sensors_get_feature(MLCO.name, SENSORS_MAXI_CO_TEMP5, &temp5);
	        sensors_get_feature(MLCO.name, SENSORS_MAXI_CO_PLL, &pll);
    	        sensors_get_feature(MLCO.name, SENSORS_MAXI_CO_VID1, &vid1);
                sensors_get_feature(MLCO.name, SENSORS_MAXI_CO_VID2, &vid2);
	        sensors_get_feature(MLCO.name, SENSORS_MAXI_CO_VID3, &vid3);
    	        sensors_get_feature(MLCO.name, SENSORS_MAXI_CO_VID4, &vid4);
                sensors_get_feature(MLCO.name, SENSORS_MAXI_CO_ALARMS, &alarm);
	    }

            alarms=alarm+0.5;
    	    if((LM79.exist || LM78J.exist) || LM78.exist)
	    {
                showTemp(temp1,ftvdisp.temp1-cur_stat,0,alarms&LM78_ALARM_TEMP,0);
        	showVid(vid1,ftvdisp.vid1-cur_stat,0,0);
    	        showAny(in0,ftvdisp.in0-cur_stat,1,alarms&LM78_ALARM_IN0);
	        showAny(in1,ftvdisp.in1-cur_stat,2,alarms&LM78_ALARM_IN1);
                showAny(in2,ftvdisp.in2-cur_stat,3,alarms&LM78_ALARM_IN2);
        	showAny(in3,ftvdisp.in3-cur_stat,4,alarms&LM78_ALARM_IN3);
    	        showAny(in4,ftvdisp.in4-cur_stat,10,alarms&LM78_ALARM_IN4);
	        showAny(in5,ftvdisp.in5-cur_stat,10,alarms&LM78_ALARM_IN5);
                showAny(in6,ftvdisp.in6-cur_stat,10,alarms&LM78_ALARM_IN6);
        	showFan(fan1,ftvdisp.fan1-cur_stat,1,alarms&LM78_ALARM_FAN1);
    	        showFan(fan2,ftvdisp.fan2-cur_stat,2,alarms&LM78_ALARM_FAN2);
	        showFan(fan3,ftvdisp.fan3-cur_stat,3,alarms&LM78_ALARM_FAN3);
            } /*end of if LM79 | LM78 | LM78J*/
	    else if(SIS5595.exist)
            {
    		showTemp(temp1,ftvdisp.temp1-cur_stat,0,alarms&SIS5595_ALARM_TEMP,0);
	        showAny(in0,ftvdisp.in0-cur_stat,1,alarms&SIS5595_ALARM_IN0);
                showAny(in1,ftvdisp.in1-cur_stat,2,alarms&SIS5595_ALARM_IN1);
	        showAny(in2,ftvdisp.in2-cur_stat,3,alarms&SIS5595_ALARM_IN2);
    	        showAny(in3,ftvdisp.in3-cur_stat,4,alarms&SIS5595_ALARM_IN3);
        	showFan(fan1,ftvdisp.fan1-cur_stat,1,alarms&SIS5595_ALARM_FAN1);
                showFan(fan2,ftvdisp.fan2-cur_stat,2,alarms&SIS5595_ALARM_FAN2);
	    }/*end of else if SIS5595*/
            else if(LM80.exist)
    	    {
	        showTemp(temp1,ftvdisp.temp1-cur_stat,0,alarms&LM80_ALARM_TEMP_HOT,alarms&LM80_ALARM_TEMP_OS);
                showAny(in0,ftvdisp.in0-cur_stat,3,alarms&LM80_ALARM_IN0);
        	showAny(in1,ftvdisp.in1-cur_stat,5,alarms&LM80_ALARM_IN1);
    	        showAny(in2,ftvdisp.in2-cur_stat,2,alarms&LM80_ALARM_IN2);
	        showAny(in3,ftvdisp.in3-cur_stat,1,alarms&LM80_ALARM_IN3);
                showAny(in4,ftvdisp.in4-cur_stat,4,alarms&LM80_ALARM_IN4);
    	        showAny(in5,ftvdisp.in5-cur_stat,10,alarms&LM80_ALARM_IN5);
    		showAny(in6,ftvdisp.in6-cur_stat,10,alarms&LM80_ALARM_IN6);
	        showFan(fan1,ftvdisp.fan1-cur_stat,1,alarms&LM80_ALARM_FAN1);
                showFan(fan2,ftvdisp.fan2-cur_stat,2,alarms&LM80_ALARM_FAN2);
    	    }/*end of else if LM80*/
	    else if(LM81.exist || ADM9240.exist)
            {
        	showTemp(temp1,ftvdisp.temp1-cur_stat,0,alarms&ADM9240_ALARM_TEMP,0);
    	        showAny(in0,ftvdisp.in0-cur_stat,1,alarms&ADM9240_ALARM_IN0);
	        showAny(in1,ftvdisp.in1-cur_stat,2,alarms&ADM9240_ALARM_IN1);
                showAny(in2,ftvdisp.in2-cur_stat,3,alarms&ADM9240_ALARM_IN2);
        	showAny(in3,ftvdisp.in3-cur_stat,4,alarms&ADM9240_ALARM_IN3);
    	        showAny(in4,ftvdisp.in4-cur_stat,10,alarms&ADM9240_ALARM_IN4);
	        showAny(in5,ftvdisp.in5-cur_stat,10,alarms&ADM9240_ALARM_IN5);
                showFan(fan1,ftvdisp.fan1-cur_stat,1,alarms&ADM9240_ALARM_FAN1);
        	showFan(fan2,ftvdisp.fan2-cur_stat,2,alarms&ADM9240_ALARM_FAN2);
    	        showVid(vid1,ftvdisp.vid1-cur_stat,1,0);
	    }/*end of else if LM81 || ADM9240*/
            else if(DS1780.exist)
    	    {
        	showTemp(temp1,ftvdisp.temp1-cur_stat,0,alarms&ADM9240_ALARM_TEMP,0);
    	        showAny(in0,ftvdisp.in0-cur_stat,1,alarms&ADM9240_ALARM_IN0);
	        showAny(in1,ftvdisp.in1-cur_stat,2,alarms&ADM9240_ALARM_IN1);
                showAny(in2,ftvdisp.in2-cur_stat,3,alarms&ADM9240_ALARM_IN2);
        	showAny(in3,ftvdisp.in3-cur_stat,4,alarms&ADM9240_ALARM_IN3);
    	        showAny(in4,ftvdisp.in4-cur_stat,10,alarms&ADM9240_ALARM_IN4);
	        showAny(in5,ftvdisp.in5-cur_stat,10,alarms&ADM9240_ALARM_IN5);
                showFan(fan1,ftvdisp.fan1-cur_stat,1,alarms&ADM9240_ALARM_FAN1);
        	showFan(fan2,ftvdisp.fan2-cur_stat,2,alarms&ADM9240_ALARM_FAN2);
    	        showVid(vid1,ftvdisp.vid1-cur_stat,1,0);
	    }/*end of else if DS1780*/
            else if(W83781D.exist)
    	    {
        	showTemp(temp1,ftvdisp.temp1-cur_stat,0,alarms&W83781D_ALARM_TEMP1,0);
    	        showTemp(temp2,ftvdisp.temp2-cur_stat,1,alarms&W83781D_ALARM_TEMP23,0);
	        showTemp(temp3,ftvdisp.temp3-cur_stat,2,alarms&W83781D_ALARM_TEMP23,0);
                showFan(fan1,ftvdisp.fan1-cur_stat,1,alarms&W83781D_ALARM_FAN1);
    	        showFan(fan2,ftvdisp.fan2-cur_stat,2,alarms&W83781D_ALARM_FAN2);
    		showFan(fan3,ftvdisp.fan3-cur_stat,3,alarms&W83781D_ALARM_FAN3);
	        showVid(vid1,ftvdisp.vid1-cur_stat,1,0);
                showAny(in0,ftvdisp.in0-cur_stat,1,alarms&W83781D_ALARM_IN0);
        	showAny(in1,ftvdisp.in1-cur_stat,2,alarms&W83781D_ALARM_IN1);
    	        showAny(in2,ftvdisp.in2-cur_stat,3,alarms&W83781D_ALARM_IN2);
	        showAny(in3,ftvdisp.in3-cur_stat,4,alarms&W83781D_ALARM_IN3);
                showAny(in4,ftvdisp.in4-cur_stat,10,alarms&W83781D_ALARM_IN4);
        	showAny(in5,ftvdisp.in5-cur_stat,10,alarms&W83781D_ALARM_IN5);
    	        showAny(in6,ftvdisp.in6-cur_stat,10,alarms&W83781D_ALARM_IN6);
	    } /*end of else if W83781D*/
            else if(W83782D.exist || W83627HF.exist)
	    {
                showTemp(temp1,ftvdisp.temp1-cur_stat,0,alarms&W83781D_ALARM_TEMP1,0);
        	showTemp(temp2,ftvdisp.temp2-cur_stat,1,alarms&W83781D_ALARM_TEMP2,0);
    	        showTemp(temp3,ftvdisp.temp3-cur_stat,2,alarms&W83781D_ALARM_TEMP3,0);
	        showFan(fan1,ftvdisp.fan1-cur_stat,1,alarms&W83781D_ALARM_FAN1);
                showFan(fan2,ftvdisp.fan2-cur_stat,2,alarms&W83781D_ALARM_FAN2);
        	showFan(fan3,ftvdisp.fan3-cur_stat,3,alarms&W83781D_ALARM_FAN3);
    	        showVid(vid1,ftvdisp.vid1-cur_stat,1,0);
	        showAny(in0,ftvdisp.in0-cur_stat,1,alarms&W83781D_ALARM_IN0);
                showAny(in1,ftvdisp.in1-cur_stat,6,alarms&W83781D_ALARM_IN1);
        	showAny(in2,ftvdisp.in2-cur_stat,5,alarms&W83781D_ALARM_IN2);
    	        showAny(in3,ftvdisp.in3-cur_stat,3,alarms&W83781D_ALARM_IN3);
	        showAny(in4,ftvdisp.in4-cur_stat,4,alarms&W83781D_ALARM_IN4);
                showAny(in5,ftvdisp.in5-cur_stat,10,alarms&W83781D_ALARM_IN5);
        	showAny(in6,ftvdisp.in6-cur_stat,2,alarms&W83781D_ALARM_IN6);
    	        showAny(in7,ftvdisp.in7-cur_stat,10,alarms&W83782D_ALARM_IN7);
	        showAny(in8,ftvdisp.in8-cur_stat,10,alarms&W83782D_ALARM_IN8);
            } /*end of else if W83782D || W83627HF*/
    	    else if(W83783S.exist)
	    {
                showTemp(temp1,ftvdisp.temp1-cur_stat,0,alarms&W83781D_ALARM_TEMP1,0);
        	showTemp(temp2,ftvdisp.temp2-cur_stat,1,alarms&W83781D_ALARM_TEMP2,0);
    	        showAny(in0,ftvdisp.in0-cur_stat,1,alarms&W83781D_ALARM_IN0);
	        showFan(fan1,ftvdisp.fan1-cur_stat,1,alarms&W83781D_ALARM_FAN1);
                showFan(fan2,ftvdisp.fan2-cur_stat,2,alarms&W83781D_ALARM_FAN2);
        	showFan(fan3,ftvdisp.fan3-cur_stat,3,alarms&W83781D_ALARM_FAN3);
    	        showAny(in1,ftvdisp.in1-cur_stat,2,alarms&W83781D_ALARM_IN1);
	        showAny(in2,ftvdisp.in2-cur_stat,3,alarms&W83781D_ALARM_IN2);
        	showAny(in3,ftvdisp.in3-cur_stat,4,alarms&W83781D_ALARM_IN3);
    	        showAny(in4,ftvdisp.in4-cur_stat,10,alarms&W83781D_ALARM_IN4);
	        showAny(in5,ftvdisp.in5-cur_stat,10,alarms&W83781D_ALARM_IN5);
                showAny(in6,ftvdisp.in6-cur_stat,10,alarms&W83781D_ALARM_IN6);
        	showVid(vid1,ftvdisp.vid1-cur_stat,1,0);
    	    } /*end of else if W83783S*/
	    else if(MLAS.exist)
            {
                showTemp(temp1,ftvdisp.temp1-cur_stat,0,0,0);
	        showTemp(temp2,ftvdisp.temp2-cur_stat,1,alarms&MAXI_ALARM_TEMP2,0);
    	        showTemp(temp3,ftvdisp.temp3-cur_stat,2,0,0);
        	showTemp(temp4,ftvdisp.temp4-cur_stat,3,alarms&MAXI_ALARM_TEMP4,0);
                showTemp(temp5,ftvdisp.temp5-cur_stat,4,alarms&MAXI_ALARM_TEMP5,0);
	        showFan(fan1,ftvdisp.fan1-cur_stat,1,alarms&MAXI_ALARM_FAN1);
    	        showFan(fan2,ftvdisp.fan2-cur_stat,2,alarms&MAXI_ALARM_FAN2);
        	showFan(fan3,ftvdisp.fan3-cur_stat,3,alarms&MAXI_ALARM_FAN3);
        	showVid(vid1,ftvdisp.vid1-cur_stat,1,alarms&MAXI_ALARM_VID1);
    	        showVid(vid2,ftvdisp.vid2-cur_stat,2,alarms&MAXI_ALARM_VID2);
	        showVid(vid3,ftvdisp.vid3-cur_stat,3,alarms&MAXI_ALARM_VID3);
                showVid(vid4,ftvdisp.vid4-cur_stat,4,alarms&MAXI_ALARM_VID4);
        	showAny(pll,ftvdisp.pll-cur_stat,5,alarms&MAXI_ALARM_PLL);
    	    } /*end of else if MLAS*/
	    else if(MLCG.exist)
            {
        	showTemp(temp1,ftvdisp.temp1-cur_stat,0,0,0);
    	        showTemp(temp2,ftvdisp.temp2-cur_stat,1,alarms&MAXI_ALARM_TEMP2,0);
	        showTemp(temp3,ftvdisp.temp3-cur_stat,2,0,0);
                showTemp(temp4,ftvdisp.temp4-cur_stat,3,alarms&MAXI_ALARM_TEMP4,0);
        	showTemp(temp5,ftvdisp.temp5-cur_stat,4,alarms&MAXI_ALARM_TEMP5,0);
    	        showFan(fan1,ftvdisp.fan1-cur_stat,1,alarms&MAXI_ALARM_FAN1);
	        showFan(fan2,ftvdisp.fan2-cur_stat,2,alarms&MAXI_ALARM_FAN2);
                showFan(fan3,ftvdisp.fan3-cur_stat,3,alarms&MAXI_ALARM_FAN3);
        	showVid(vid1,ftvdisp.vid1-cur_stat,1,alarms&MAXI_ALARM_VID1);
    	        showVid(vid2,ftvdisp.vid2-cur_stat,2,alarms&MAXI_ALARM_VID2);
	        showVid(vid3,ftvdisp.vid3-cur_stat,3,alarms&MAXI_ALARM_VID3);
                showVid(vid4,ftvdisp.vid4-cur_stat,4,alarms&MAXI_ALARM_VID4);
        	showAny(pll,ftvdisp.pll-cur_stat,5,alarms&MAXI_ALARM_PLL);
    	    } /*end of else if MLCG*/
	    else if(MLCO.exist)
            {
    	        showTemp(temp1,ftvdisp.temp1-cur_stat,0,0,0);
	        showTemp(temp2,ftvdisp.temp2-cur_stat,1,alarms&MAXI_ALARM_TEMP2,0);
                showTemp(temp3,ftvdisp.temp3-cur_stat,2,0,0);
        	showTemp(temp4,ftvdisp.temp4-cur_stat,3,alarms&MAXI_ALARM_TEMP4,0);
    	        showTemp(temp5,ftvdisp.temp5-cur_stat,4,alarms&MAXI_ALARM_TEMP5,0);
	        showFan(fan1,ftvdisp.fan1-cur_stat,1,alarms&MAXI_ALARM_FAN1);
                showFan(fan2,ftvdisp.fan2-cur_stat,2,alarms&MAXI_ALARM_FAN2);
        	showFan(fan3,ftvdisp.fan3-cur_stat,3,alarms&MAXI_ALARM_FAN3);
    	        showVid(vid1,ftvdisp.vid1-cur_stat,1,alarms&MAXI_ALARM_VID1);
	        showVid(vid2,ftvdisp.vid2-cur_stat,2,alarms&MAXI_ALARM_VID2);
                showVid(vid3,ftvdisp.vid3-cur_stat,3,alarms&MAXI_ALARM_VID3);
        	showVid(vid4,ftvdisp.vid4-cur_stat,4,alarms&MAXI_ALARM_VID4);
    	        showAny(pll,ftvdisp.pll-cur_stat,5,alarms&MAXI_ALARM_PLL);
	    } /*end of else if MLCO*/
	}/*end of if paused*/
	RedrawWindow();
	usleep(150000);
    } /*end of while*/
    return(0);
}

void asftavmUsage()
{
    printf("Usage:\n\n");
    printf("[-v]        Show version and exit\n");
    printf("[-f]        Use Fahrenheit temperature scale\n");
    printf("[-help]     Show this help\n");
    printf("\nasftavm ver. %s\n", VERSION);
}

void showTemp(double result, int where, int whichone, int alarmresult1, int alarmresult2)
/*whichone: 0=Temp, 1=Cpu1, 2=Cpu2*/
{
    int a,x,y,looplimit;
    double b,temp;

    if(degreeScale) result=32.0+9/5.0*result;

    if(where>0 && where<5)
    {
        switch(where)
        {
        case 1:
            x=34;
            y=5;
            break;
        case 2:
            x=34;
            y=20;
            break;
        case 3:
            y=33;
            x=34;
            break;
        case 4:
            x=34;
            y=46;
            break;
        }/*end of switch*/

        switch(whichone)
        {
        case 0:
            /*TEMP*/
            copyXPMArea(47,64,5,8,x-28,y);
            copyXPMArea(41,64,5,8,x-22,y);
            copyXPMArea(35,64,5,8,x-16,y);
            copyXPMArea(135,64,5,8,x-10,y);
            break;
        case 1:
            /*CPU1*/
            copyXPMArea(53,64,5,8,x-28,y);
            copyXPMArea(135,64,5,8,x-22,y);
            copyXPMArea(135,6,5,8,x-16,y);
            copyXPMArea(71,64,5,8,x-10,y);
            break;
        case 2:
            /*CPU2*/
            copyXPMArea(53,64,5,8,x-28,y);
            copyXPMArea(135,64,5,8,x-22,y);
            copyXPMArea(135,6,5,8,x-16,y);
            copyXPMArea(77,64,5,8,x-10,y);
            break;
        default:
            /*XXXX*/
            copyXPMArea(135,14,5,8,x-28,y);
            copyXPMArea(135,14,5,8,x-22,y);
            copyXPMArea(135,14,5,8,x-16,y);
            copyXPMArea(135,64,5,8,x-10,y);
            break;
        }/*end of switch*/

        if(alarmresult1) copyXPMArea(3,64,1,5,x+25,y+1);
        else copyXPMArea(2,64,1,5,x+25,y+1);
        if(alarmresult2) copyXPMArea(3,64,1,5,x+25,y+5);
        else copyXPMArea(2,64,1,5,x+25,y+5);
	
	if(degreeScale)
	{
	    looplimit=3;
	    temp=modf((result/100),&b);
	    if(result<100) copyXPMArea(135,54,5,8,x,y);
	    else copyXPMArea(71,64,5,8,x,y);
	}
	else
	{
	    looplimit=2;
	    temp=modf((result/10),&b);
	}

        for(a=0;a<looplimit;a++, x=x+6, temp = modf((temp * 10),&b))
        {
            switch((int) b)
            {
            case 0:
                copyXPMArea(65,64,5,8,x,y);
                break;
            case 1:
                copyXPMArea(71,64,5,8,x,y);
                break;
            case 2:
                copyXPMArea(77,64,5,8,x,y);
                break;
            case 3:
                copyXPMArea(83,64,5,8,x,y);
                break;
            case 4:
                copyXPMArea(89,64,5,8,x,y);
                break;
            case 5:
                copyXPMArea(95,64,5,8,x,y);
                break;
            case 6:
                copyXPMArea(101,64,5,8,x,y);
                break;
            case 7:
                copyXPMArea(107,64,5,8,x,y);
                break;
            case 8:
                copyXPMArea(113,64,5,8,x,y);
                break;
            case 9:
                copyXPMArea(119,64,5,8,x,y);
                break;
            default:
                copyXPMArea(135,14,5,8,x,y);
                break;
            } /*end of switch*/
        } /*end of for*/

	if(degreeScale)
	{
	    /*F*/
	    copyXPMArea(125,64,5,8,x,y);
	}
	else
	{
            /*degree celsius*/
	    copyXPMArea(59,64,5,8,x,y);
    	    copyXPMArea(53,64,5,8,x+6,y);
	}
    }
}/*end of showtemp()*/

void showAny(double result, int where, int whichone, int alarmresult)
/*whichone : 1=CORE, 4=+12, 3= +5, 2=+3.3 5=VIO, 6=VTT*/
{
    int a,x,y;
    double b,temp;

    if (where>0 && where<5)
    {
        switch(where)
        {
        case 1:
            x=34;
            y=5;
            break;
        case 2:
            x=34;
            y=20;
            break;
        case 3:
            y=33;
            x=34;
            break;
        case 4:
            x=34;
            y=46;
            break;
        }/*end of switch*/

        switch(whichone)
        {
        case 1:
            /*CORE*/
            copyXPMArea(53,64,5,8,x-28,y);
            copyXPMArea(65,64,5,8,x-22,y);
            copyXPMArea(29,64,5,8,x-16,y);
            copyXPMArea(41,64,5,8,x-10,y);
            break;
        case 4:
            /* +12*/
            copyXPMArea(135,54,5,8,x-28,y);
            copyXPMArea(17,64,5,8,x-22,y);
            copyXPMArea(71,64,5,8,x-16,y);
            copyXPMArea(77,64,5,8,x-10,y);
            break;
        case 3:
            /*  +5*/
            copyXPMArea(135,54,5,8,x-28,y);
            copyXPMArea(135,54,5,8,x-22,y);
            copyXPMArea(17,64,5,8,x-16,y);
            copyXPMArea(95,64,5,8,x-10,y);
            break;
        case 2:
            /* +3.3*/
            copyXPMArea(135,54,5,8,x-28,y);
            copyXPMArea(17,64,5,8,x-22,y);
            copyXPMArea(83,64,5,8,x-16,y);
            copyXPMArea(83,64,5,8,x-10,y);
            break;
        case 5:
            /* VIO*/
            copyXPMArea(135,54,5,8,x-28,y);
            copyXPMArea(23,64,5,8,x-22,y);
            copyXPMArea(5,64,5,8,x-16,y);
            copyXPMArea(65,64,5,8,x-10,y);
            break;
        case 6:
            /* VTT*/
            copyXPMArea(135,54,5,8,x-28,y);
            copyXPMArea(23,64,5,8,x-22,y);
            copyXPMArea(47,64,5,8,x-16,y);
            copyXPMArea(47,64,5,8,x-10,y);
            break;
        default:
            /*XXXX*/
            copyXPMArea(135,14,5,8,x-28,y);
            copyXPMArea(135,14,5,8,x-22,y);
            copyXPMArea(135,14,5,8,x-16,y);
            copyXPMArea(135,14,5,8,x-10,y);
            break;
        }/*end of switch*/

        if(alarmresult) copyXPMArea(3,64,1,5,x+25,y+1);
        else copyXPMArea(2,64,1,5,x+25,y+1);

        temp=modf((result/10),&b);
	if(temp<0) temp=temp*-1;

        for(a=0;a<4;a++, x=x+6, temp = modf((temp * 10),&b))
        {
            switch((int) b)
            {
            case 0:
                copyXPMArea(65,64,5,8,x,y);
                break;
            case 1:
                copyXPMArea(71,64,5,8,x,y);
                break;
            case 2:
                copyXPMArea(77,64,5,8,x,y);
                break;
            case 3:
                copyXPMArea(83,64,5,8,x,y);
                break;
            case 4:
                copyXPMArea(89,64,5,8,x,y);
                break;
            case 5:
                copyXPMArea(95,64,5,8,x,y);
                break;
            case 6:
                copyXPMArea(101,64,5,8,x,y);
                break;
            case 7:
                copyXPMArea(107,64,5,8,x,y);
                break;
            case 8:
                copyXPMArea(113,64,5,8,x,y);
                break;
            case 9:
                copyXPMArea(119,64,5,8,x,y);
                break;
            default:
                copyXPMArea(135,14,5,8,x,y);
                break;
            } /*end of switch*/
        } /*end of for*/
    } /*end of if*/
}/*end of showany()*/

void showFan(double result, int where, int whichone, int alarmresult)
/*whichone: 1=FAN1, 2=FAN2, 3=FAN3 ...*/
{
    int a,x,y;
    double b,temp;
    if(where>0 && where<5)
    {
        switch(where)
        {
        case 1:
            x=34;
            y=5;
            break;
        case 2:
            x=34;
            y=20;
            break;
        case 3:
            y=33;
            x=34;
            break;
        case 4:
            x=34;
            y=46;
            break;
        }/*end of switch*/

        /*FAN*/
        copyXPMArea(125,64,5,8,x-28,y);
        copyXPMArea(135,44,5,8,x-22,y);
        copyXPMArea(135,24,5,8,x-16,y);
        switch(whichone)
        {
        case 1:
            /*1*/
            copyXPMArea(71,64,5,8,x-10,y);
            break;
        case 2:
            /*2*/
            copyXPMArea(77,64,5,8,x-10,y);
            break;
        case 3:
            /*3*/
            copyXPMArea(83,64,5,8,x-10,y);
            break;
        }/*end of switch*/

        if(alarmresult) copyXPMArea(3,64,1,5,x+25,y+1);
        else copyXPMArea(2,64,1,5,x+25,y+1);

        temp=modf((result/1000),&b);

        for(a=0;a<4;a++, x=x+6, temp = modf((temp*10),&b))
        {
            switch((int) b)
            {
            case 0:
                copyXPMArea(65,64,5,8,x,y);
                break;
            case 1:
                copyXPMArea(71,64,5,8,x,y);
                break;
            case 2:
                copyXPMArea(77,64,5,8,x,y);
                break;
            case 3:
                copyXPMArea(83,64,5,8,x,y);
                break;
            case 4:
                copyXPMArea(89,64,5,8,x,y);
                break;
            case 5:
                copyXPMArea(95,64,5,8,x,y);
                break;
            case 6:
                copyXPMArea(101,64,5,8,x,y);
                break;
            case 7:
                copyXPMArea(107,64,5,8,x,y);
                break;
            case 8:
                copyXPMArea(113,64,5,8,x,y);
                break;
            case 9:
                copyXPMArea(119,64,5,8,x,y);
                break;
            default:
                copyXPMArea(135,14,5,8,x,y);
                break;
            } /*end of switch*/
        } /*end of for*/
    }
}/*end of showfan*/

void showVid(double result, int where, int whichone, int alarmresult)
/*whichone: 1=VID1, 2=VID2, 3=VID3 ...*/
{
    int a,x,y;
    double b,temp;

    if(where>0 && where<5)
    {
        switch(where)
        {
        case 1:
            x=34;
            y=5;
            break;
        case 2:
            x=34;
            y=20;
            break;
        case 3:
            y=33;
            x=34;
            break;
        case 4:
            x=34;
            y=46;
            break;
        }/*end of switch*/

        /*VID*/
        copyXPMArea(23,64,5,8,x-28,y);
        copyXPMArea(5,64,5,8,x-22,y);
        copyXPMArea(135,34,5,8,x-16,y);
        switch(whichone)
        {
        case 1:
            /*1*/
            copyXPMArea(71,64,5,8,x-10,y);
            break;
        case 2:
            /*2*/
            copyXPMArea(77,64,5,8,x-10,y);
            break;
        case 3:
            /*3*/
            copyXPMArea(83,64,5,8,x-10,y);
            break;
        }/*end of switch*/

        if(alarmresult) copyXPMArea(3,64,1,5,x+25,y+1);
        else copyXPMArea(2,64,1,5,x+25,y+1);

        temp=modf((result/10),&b);

        for(a=0;a<4;a++, x=x+6, temp = modf((temp*10),&b))
        {
            switch((int) b)
            {
            case 0:
                copyXPMArea(65,64,5,8,x,y);
                break;
            case 1:
                copyXPMArea(71,64,5,8,x,y);
                break;
            case 2:
                copyXPMArea(77,64,5,8,x,y);
                break;
            case 3:
                copyXPMArea(83,64,5,8,x,y);
                break;
            case 4:
                copyXPMArea(89,64,5,8,x,y);
                break;
            case 5:
                copyXPMArea(95,64,5,8,x,y);
                break;
            case 6:
                copyXPMArea(101,64,5,8,x,y);
                break;
            case 7:
                copyXPMArea(107,64,5,8,x,y);
                break;
            case 8:
                copyXPMArea(113,64,5,8,x,y);
                break;
            case 9:
                copyXPMArea(119,64,5,8,x,y);
                break;
            default:
                copyXPMArea(135,14,5,8,x,y);
                break;
            } /*end of switch*/
        } /*end of for*/
    }
}/*end of showvid*/

int initChip()
{
    const sensors_chip_name *name;
    int configFileFound, chip_nr;
    FILE *theConfigFile;

    theConfigFile = fopen("/etc/sensors.conf", "r");
     /*theConfigFile will return 0 if it can't open sensors.conf*/
    if(theConfigFile != 0)
    {
        configFileFound = sensors_init(theConfigFile);
        fclose(theConfigFile);
        if(configFileFound == 0)
        {
            for(chip_nr=0;(name = sensors_get_detected_chips(&chip_nr));)
	    {
                if(!strcmp(name->prefix, SENSORS_W83781D_PREFIX))
                {
                    W83781D.exist=TRUE;
		    W83781D.name=*name;
		    cur_stat_max=12;
                }
                else if(!strcmp(name->prefix, SENSORS_MAXI_CG_PREFIX))
                {
                    MLCG.exist=TRUE;
		    MLCG.name=*name;
		    cur_stat_max=12;
                }
                else if(!strcmp(name->prefix, SENSORS_MAXI_AS_PREFIX))
                {
                    MLAS.exist=TRUE;
		    MLAS.name=*name;
		    cur_stat_max=12;
                }
                else if(!strcmp(name->prefix, SENSORS_MAXI_CO_PREFIX))
                {
                    MLCO.exist=TRUE;
		    MLCO.name=*name;
		    cur_stat_max=12;
                }
                else if(!strcmp(name->prefix, SENSORS_W83782D_PREFIX))
                {
                    W83782D.exist=TRUE;
		    W83782D.name=*name;
		    cur_stat_max=12;
                }
                else if(!strcmp(name->prefix, SENSORS_W83627HF_PREFIX))
                {
                    W83627HF.exist=TRUE;
		    W83627HF.name=*name;
		    cur_stat_max=12;
                }
                else if(!strcmp(name->prefix, SENSORS_W83783S_PREFIX))
                {
                    W83783S.exist=TRUE;
		    W83783S.name=*name;
		    cur_stat_max=12;
                }
                else if(!strcmp(name->prefix, SENSORS_LM79_PREFIX))
                {
                    LM79.exist=TRUE;
		    LM79.name=*name;
		    cur_stat_max=8;
                }
                else if(!strcmp(name->prefix, SENSORS_LM78_PREFIX))
                {
                    LM78.exist=TRUE;
		    LM78.name=*name;
		    cur_stat_max=8;
                }
                else if(!strcmp(name->prefix, SENSORS_LM78J_PREFIX))
                {
                    LM78J.exist=TRUE;
		    LM78J.name=*name;
		    cur_stat_max=8;
                }
                else if(!strcmp(name->prefix, SENSORS_LM80_PREFIX))
                {
                    LM80.exist=TRUE;
		    LM80.name=*name;
		    cur_stat_max=8;
                }
                else if(!strcmp(name->prefix, SENSORS_LM81_PREFIX))
                {
                    LM81.exist=TRUE;
		    LM81.name=*name;
		    cur_stat_max=8;
                }
                else if(!strcmp(name->prefix, SENSORS_ADM9240_PREFIX))
                {
                    ADM9240.exist=TRUE;
		    ADM9240.name=*name;
		    cur_stat_max=8;
                }
                else if(!strcmp(name->prefix, SENSORS_DS1780_PREFIX))
                {
                    DS1780.exist=TRUE;
		    DS1780.name=*name;
		    cur_stat_max=8;
                }
                else if(!strcmp(name->prefix, SENSORS_SIS5595_PREFIX))
                {
                    SIS5595.exist=TRUE;
		    SIS5595.name=*name;
		    cur_stat_max=4;
                }
            }/*end of for*/
	    return 1;
        } /*end of if configFileFound*/
        else printf("could not initialize '/etc/sensors.conf' properly .. exiting.\n");
    } /*end of if theConfigFile*/
    else printf("could not find '/etc/sensors.conf' .. exiting.\n");
    return -1;
}

int initDisp(struct FTVDISPLAY *ftvdisp)
{
    FILE *theConfigFile;
    char temp[256];
    char line[256];

    ftvdisp->temp1=0;
    ftvdisp->temp2=0;
    ftvdisp->temp3=0;
    ftvdisp->temp4=0;
    ftvdisp->temp5=0;
    ftvdisp->in0=0;
    ftvdisp->in1=0;
    ftvdisp->in2=0;
    ftvdisp->in3=0;
    ftvdisp->in4=0;
    ftvdisp->in5=0;
    ftvdisp->in6=0;
    ftvdisp->in7=0;
    ftvdisp->in8=0;
    ftvdisp->fan1=0;
    ftvdisp->fan2=0;
    ftvdisp->fan3=0;
    ftvdisp->vid1=0;
    ftvdisp->vid2=0;
    ftvdisp->vid3=0;
    ftvdisp->vid4=0;
    ftvdisp->pll=0;

    sprintf(temp,"%s/.asftavm", getenv("HOME"));
    theConfigFile = fopen(temp, "r");
    if(theConfigFile != 0)
    {
        while(fgets(line,256,theConfigFile) != NULL)
        {
            if(strstr(line,"temp1")!=NULL) ftvdisp->temp1=atoi(strstr(line," "));
            else if(strstr(line,"temp2")!=NULL) ftvdisp->temp2=atoi(strstr(line," "));
            else if(strstr(line,"temp3")!=NULL) ftvdisp->temp3=atoi(strstr(line," "));
            else if(strstr(line,"temp4")!=NULL) ftvdisp->temp4=atoi(strstr(line," "));
            else if(strstr(line,"temp5")!=NULL) ftvdisp->temp5=atoi(strstr(line," "));
            else if(strstr(line,"in0")!=NULL) ftvdisp->in0=atoi(strstr(line," "));
            else if(strstr(line,"in1")!=NULL) ftvdisp->in1=atoi(strstr(line," "));
            else if(strstr(line,"in2")!=NULL) ftvdisp->in2=atoi(strstr(line," "));
            else if(strstr(line,"in3")!=NULL) ftvdisp->in3=atoi(strstr(line," "));
            else if(strstr(line,"in4")!=NULL) ftvdisp->in4=atoi(strstr(line," "));
            else if(strstr(line,"in5")!=NULL) ftvdisp->in5=atoi(strstr(line," "));
            else if(strstr(line,"in6")!=NULL) ftvdisp->in6=atoi(strstr(line," "));
            else if(strstr(line,"in7")!=NULL) ftvdisp->in7=atoi(strstr(line," "));
            else if(strstr(line,"in8")!=NULL) ftvdisp->in8=atoi(strstr(line," "));
            else if(strstr(line,"vid1")!=NULL) ftvdisp->vid1=atoi(strstr(line," "));
            else if(strstr(line,"vid2")!=NULL) ftvdisp->vid2=atoi(strstr(line," "));
            else if(strstr(line,"vid3")!=NULL) ftvdisp->vid3=atoi(strstr(line," "));
            else if(strstr(line,"vid4")!=NULL) ftvdisp->vid4=atoi(strstr(line," "));
            else if(strstr(line,"fan1")!=NULL) ftvdisp->fan1=atoi(strstr(line," "));
            else if(strstr(line,"fan2")!=NULL) ftvdisp->fan2=atoi(strstr(line," "));
            else if(strstr(line,"fan3")!=NULL) ftvdisp->fan3=atoi(strstr(line," "));
            else if(strstr(line,"pll")!=NULL) ftvdisp->pll=atoi(strstr(line," "));
            else if(strstr(line,"#")!=NULL);
            else printf("Error: %s",line);
        }
        fclose(theConfigFile);
        return 1;
    }
    else
    {
        printf("could not open '~/.asftavm'\n");
        return 0;
    }
}