/*
 *	 asfatm (AfterStep Fan and Temperature Monitor)
 *	 ver 0.80b 
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sensors/sensors.h>
#include <sensors/chips.h>
#include <sensors/error.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "../wmgeneral/wmgeneral.h"
#include "../wmgeneral/misc.h"
#include "version.h"

#include "lmse_master.xpm"
#include "lmse_mask.xbm"

#define LM78 1
#define LM78J 2
#define LM79 3
#define LM80 4

#define LM75 10 

#define W83781D 5
#define W83782D 6
#define W83783S 7
 
#define TRUE 1
#define FALSE 0
#define NONE 86

#define TEMP 100
#define CPU1 101
#define CPU2 102
#define FAN1 103
#define FAN2 104
#define FAN3 105

int c;

//prototypes
void asfatmUsage(void);

void showTemp(int);
void showCPU1(int);
void showCPU2(int);
void showFan1(int);
void showFan2(int);
void showFan3(int);

void placement(void);

double temp1 = 0;
double temp2 = 0;
double temp3 = 0;

double fan1 = 0;
double fan2 = 0;
double fan3 = 0;

int temptemp1 = 0;
int temptemp2 = 0;

int temp2temp1 = 0;
int temp2temp2 = 0;

int temp3temp1 = 0;
int temp3temp2 = 0;

int fan1temp1;
int fan1temp2;
int fan1temp3;
int fan1temp4;
int fan1temp5;
int fan1temp6;

int fan2temp1;
int fan2temp2;
int fan2temp3;
int fan2temp4;
int fan2temp5;
int fan2temp6;

int fan3temp1;
int fan3temp2;
int fan3temp3;
int fan3temp4;
int fan3temp5;
int fan3temp6;

short pos1 = 0;
short pos2 = 0;
short pos3 = 0;
short pos4 = 0;

int beVerbose = FALSE;

int main(int argc, char **argv)
{

	XEvent Event;

	//int chips_nr = 0;
	int nr = 0;
	int configFileFound;
	FILE *configFile;
	const sensors_chip_name *name;
	const sensors_chip_name *other;

	int chiptype = -1;	
	int chiptype2 = -1;
	int otherChip = -1;

	int haslm75 = FALSE;

	for(c=1;c<argc;c++)
	{
	if(argv[c] == NULL)
	{}
	else if(!strcmp(argv[c], "-v"))
	{
	printf("\nasfatm version %s\n\n", VERSION);
	exit(0);
	}
	else if(!strcmp(argv[c], "--help"))
	{
	asfatmUsage();
	exit(0);
	}
	else if(!strcmp(argv[c], "-help"))
	{
	asfatmUsage();
	exit(0);
	}
	else if(!strcmp(argv[c], "-loud"))
	{
	beVerbose = TRUE;
	}
	else
	{
	printf("\nillegal option\n\n");
	asfatmUsage();
	exit(0);
	}
	} //end of for

	configFile = fopen("/etc/sensors.conf", "r");
	//configFile will return 0 if it can't open sensors.conf
	if(configFile != 0)
	{
	configFileFound = sensors_init(configFile);
	fclose(configFile);
	
	if(configFileFound == 0)
	{

	//looking for wd*
	if(beVerbose == TRUE)
	fprintf(stderr, "before wd* detection nr is: %i\n", nr);

	while(chiptype2 == -1)
	{
	name = sensors_get_detected_chips(&nr);
	if(name == NULL)
	{
	if(beVerbose == TRUE)
	fprintf(stderr, "No wd* chipsets found!\n");
	chiptype2 = 86;
	}
	else if(!strcmp(name->prefix, SENSORS_W83781D_PREFIX))
	{
	chiptype = W83781D;
	if(beVerbose == TRUE)
	fprintf(stderr, "%s found!\n", SENSORS_W83781D_PREFIX);
	otherChip = 86;
	chiptype2 = 86;
	}
	else if(!strcmp(name->prefix, SENSORS_W83782D_PREFIX))
	{
	chiptype = W83782D;
	if(beVerbose == TRUE)
	fprintf(stderr, "%s found!\n", SENSORS_W83782D_PREFIX);
	otherChip = 86;
	chiptype2 = 86;
	}
	else if(!strcmp(name->prefix, SENSORS_W83783S_PREFIX))
	{
	chiptype = W83783S;
	if(beVerbose == TRUE)
	fprintf(stderr, "%s found!\n", SENSORS_W83783S_PREFIX);
	otherChip = 86;
	chiptype2 = 86;
	}
	} //end of while

	if(beVerbose == TRUE && chiptype == -1)
	{
	fprintf(stderr, "before reset nr is: %i\n", nr);
	fprintf(stderr, " ... resetting ... \n");	
	}
	if(chiptype == -1)
	nr = 0;

	if(beVerbose == TRUE && chiptype == -1)
	fprintf(stderr, "before lm75 detection nr is: %i\n", nr);

	while(otherChip == -1)
	{
	other = sensors_get_detected_chips(&nr);

	if(other == NULL)
	{
	if(beVerbose == TRUE)
	fprintf(stderr, "%s not found!\n", SENSORS_LM75_PREFIX);
	otherChip = 86;
	}

	else if(!strcmp(other->prefix, SENSORS_LM75_PREFIX))
	{
	haslm75 = TRUE;
	if(beVerbose == TRUE)
	fprintf(stderr, "%s found!\n", SENSORS_LM75_PREFIX);
	otherChip = LM75;
	}

	} //end of while

	if(beVerbose == TRUE && chiptype == -1)
	fprintf(stderr, "before reset nr is: %i\n .. resetting ..\n", nr);
	if(chiptype == -1)
	nr = 0;
	if(beVerbose == TRUE && chiptype == -1)
	fprintf(stderr, "before lm* detection nr is: %i\n", nr);

	while(chiptype == -1)
	{
	name = sensors_get_detected_chips(&nr);

	if(name == NULL)
	{
	fprintf(stderr, "No chipsets detected..\n");
	exit(0);
	}
	else if(!strcmp(name->prefix, SENSORS_LM79_PREFIX))
	{
	chiptype = LM79;
	if(beVerbose == TRUE)
	fprintf(stderr, "found %s!\n", name->prefix);
	}
	else if(!strcmp(name->prefix, SENSORS_LM78_PREFIX))
	{
	chiptype = LM78;
	if(beVerbose == TRUE)
	fprintf(stderr, "found %s!\n", name->prefix);
	}
	else if(!strcmp(name->prefix, SENSORS_LM78J_PREFIX))
	{
	chiptype = LM78J;
	if(beVerbose == TRUE)
	fprintf(stderr, "found %s!\n", name->prefix);
	}
	else if(!strcmp(name->prefix, SENSORS_LM80_PREFIX))
	{
	chiptype = LM80;
	if(beVerbose == TRUE)
	fprintf(stderr, "found %s!\n", name->prefix);
	}

	} //end of while

	if(beVerbose == TRUE)
	fprintf(stderr, "after lm* detection nr is: %i\n", nr);

	if(beVerbose == TRUE)
	{
	fprintf(stderr, "\nDETECTION SUMMARY ----------\n\n");
	fprintf(stderr, "found Chiptype: %i\n", chiptype);
	fprintf(stderr, "found Chipname: %s\n", name->prefix);
	switch(haslm75)
	{
	case FALSE:
	fprintf(stderr, "\nan lm75 was not detected.\n");
	break;
	case TRUE:
	fprintf(stderr, "\nan lm75 was detected.\n");
	break;
	} //end of switch
	} //end of if beVerbose
	} //end of if configFileFound
	else
	{
	printf("could not initialize '/etc/sensors.conf' properly .. exiting.");
	exit(0);
	}
	} //end of if configFile
	else
	{
	printf("\ncould not find '/etc/sensors.conf' .. exiting.\n\n");
	exit(0);
	}

	placement();
	openXwindow(argc, argv, lmse_master_xpm, lmse_mask_bits, lmse_mask_width, lmse_mask_height);

	if(chiptype == -1)
	{
	printf("\nno supported chipsets found.\n\n");
	exit(0);
	}
	else if(chiptype != -1)
	{
	while(1)
	{
	
		while(XPending(display))
		{
		XNextEvent(display, &Event);
		switch(Event.type)
		{
		case Expose:
			RedrawWindow();
			break;
		case DestroyNotify:
			XCloseDisplay(display);
			exit(0);
			break;
		}
		} //end of while XPending

	if((chiptype == LM78 || chiptype == LM78J) || chiptype == LM79)
	{
	sensors_get_feature(*name, SENSORS_LM78_FAN3, &fan3);
	sensors_get_feature(*name, SENSORS_LM78_FAN2, &fan2);
	sensors_get_feature(*name, SENSORS_LM78_FAN1, &fan1);
	sensors_get_feature(*name, SENSORS_LM78_TEMP, &temp1);
	}
	else if(chiptype == LM80)
	{
	sensors_get_feature(*name, SENSORS_LM80_FAN2, &fan2);
	sensors_get_feature(*name, SENSORS_LM80_FAN1, &fan1);
	sensors_get_feature(*name, SENSORS_LM80_TEMP, &temp1);
	}
	else if(chiptype == W83781D)
	{
	sensors_get_feature(*name, SENSORS_W83781D_FAN3, &fan3);
	sensors_get_feature(*name, SENSORS_W83781D_FAN2, &fan2);
	sensors_get_feature(*name, SENSORS_W83781D_FAN1, &fan1);
	sensors_get_feature(*name, SENSORS_W83781D_TEMP3, &temp3);
	sensors_get_feature(*name, SENSORS_W83781D_TEMP2, &temp2);
	sensors_get_feature(*name, SENSORS_W83781D_TEMP1, &temp1);
	}
	else if(chiptype == W83782D)
	{
	sensors_get_feature(*name, SENSORS_W83782D_FAN3, &fan3);
	sensors_get_feature(*name, SENSORS_W83782D_FAN2, &fan2);
	sensors_get_feature(*name, SENSORS_W83782D_FAN1, &fan1);
	sensors_get_feature(*name, SENSORS_W83782D_TEMP3, &temp3);
	sensors_get_feature(*name, SENSORS_W83782D_TEMP2, &temp2);
	sensors_get_feature(*name, SENSORS_W83782D_TEMP1, &temp1);
	}
	else if(chiptype == W83783S)
	{
	sensors_get_feature(*name, SENSORS_W83783S_FAN3, &fan3);
	sensors_get_feature(*name, SENSORS_W83783S_FAN2, &fan2);
	sensors_get_feature(*name, SENSORS_W83783S_FAN1, &fan1);
	sensors_get_feature(*name, SENSORS_W83783S_TEMP2, &temp2);
	sensors_get_feature(*name, SENSORS_W83783S_TEMP1, &temp1);
	}
	else
	{
	fprintf(stderr, "No chipsets initialized .. exiting.\n");
	exit(0);
	}

	if(haslm75 == TRUE && otherChip == LM75)
	{
	sensors_get_feature(*other, SENSORS_LM75_TEMP, &temp2);
	}

	if((chiptype == LM79 || chiptype == LM78J) || chiptype == LM78)
	{
		switch(pos1)
		{
		case TEMP:
		showTemp(5);
		break;
		case CPU1:
		showCPU1(5);
		break;
		case CPU2:
		showCPU2(5);
		break;
		case FAN1:
		showFan1(5);
		break;
		case FAN2:
		showFan2(5);
		break;
		case FAN3:
		showFan3(5);
		break;
		default:
		break;
		}
		
		switch(pos2)
		{
		case TEMP:
		showTemp(20);
		break;
		case CPU1:
		showCPU1(20);
		break;
		case CPU2:
		showCPU2(20);
		break;
		case FAN1:
		showFan1(20);
		break;
		case FAN2:
		showFan2(20);
		break;
		case FAN3:
		showFan3(20);
		break;
		default:
		break;
		}
		
		switch(pos3)
		{
		case TEMP:
		showTemp(33);
		break;
		case CPU1:
		showCPU1(33);
		break;
		case CPU2:
		showCPU2(33);
		break;
		case FAN1:
		showFan1(33);
		break;
		case FAN2:
		showFan2(33);
		break;
		case FAN3:
		showFan3(33);
		break;
		default:
		break;
		}
		
		
		switch(pos4)
		{
		case TEMP:
		showTemp(46);
		break;
		case CPU1:
		showCPU1(46);
		break;
		case CPU2:
		showCPU2(46);
		break;
		case FAN1:
		showFan1(46);
		break;
		case FAN2:
		showFan2(46);
		break;
		case FAN3:
		showFan3(46);
		break;
		default:
		break;
		}
		
	} //end of if chiptype = LM79 | LM80 | LM78J
	else if(chiptype == LM80)
	{
		switch(pos1)
		{
		case TEMP:
		showTemp(5);
		break;
		case CPU1:
		showCPU1(5);
		break;
		case CPU2:
		showCPU2(5);
		break;
		case FAN1:
		showFan1(5);
		break;
		case FAN2:
		showFan2(5);
		break;
		case FAN3:
		showFan3(5);
		break;
		default:
		break;
		}
		
		switch(pos2)
		{
		case TEMP:
		showTemp(20);
		break;
		case CPU1:
		showCPU1(20);
		break;
		case CPU2:
		showCPU2(20);
		break;
		case FAN1:
		showFan1(20);
		break;
		case FAN2:
		showFan2(20);
		break;
		case FAN3:
		showFan3(20);
		break;
		default:
		break;
		}
		
		switch(pos3)
		{
		case TEMP:
		showTemp(33);
		break;
		case CPU1:
		showCPU1(33);
		break;
		case CPU2:
		showCPU2(33);
		break;
		case FAN1:
		showFan1(33);
		break;
		case FAN2:
		showFan2(33);
		break;
		case FAN3:
		showFan3(33);
		break;
		default:
		break;
		}
		
		switch(pos4)
		{
		case TEMP:
		showTemp(46);
		break;
		case CPU1:
		showCPU1(46);
		break;
		case CPU2:
		showCPU2(46);
		break;
		case FAN1:
		showFan1(46);
		break;
		case FAN2:
		showFan2(46);
		break;
		case FAN3:
		showFan3(46);
		break;
		default:
		break;
		}

	} //end of else if chiptype == LM80
	
	else if(chiptype == W83781D || chiptype == W83782D)
	{
		switch(pos1)
		{
		case TEMP:
		showTemp(5);
		break;
		case CPU1:
		showCPU1(5);
		break;
		case CPU2:
		showCPU2(5);
		break;
		case FAN1:
		showFan1(5);
		break;
		case FAN2:
		showFan2(5);
		break;
		case FAN3:
		showFan3(5);
		break;
		default:
		break;
		}
		
		switch(pos2)
		{
		case TEMP:
		showTemp(20);
		break;
		case CPU1:
		showCPU1(20);
		break;
		case CPU2:
		showCPU2(20);
		break;
		case FAN1:
		showFan1(20);
		break;
		case FAN2:
		showFan2(20);
		break;
		case FAN3:
		showFan3(20);
		break;
		default:
		break;
		}
	
		switch(pos3)
		{
		case TEMP:
		showTemp(33);
		break;
		case CPU1:
		showCPU1(33);
		break;
		case CPU2:
		showCPU2(33);
		break;
		case FAN1:
		showFan1(33);
		break;
		case FAN2:
		showFan2(33);
		break;
		case FAN3:
		showFan3(33);
		break;
		default:
		break;
		}
	
		switch(pos4)
		{
		case TEMP:
		showTemp(46);
		break;
		case CPU1:
		showCPU1(46);
		break;
		case CPU2:
		showCPU2(46);
		break;
		case FAN1:
		showFan1(46);
		break;
		case FAN2:
		showFan2(46);
		break;
		case FAN3:
		showFan3(46);
		break;
		default:
		break;
		}
		
	} //end of else if W83781D || W83782D
	
	else if(chiptype == W83783S)
	{
		switch(pos1)
		{
		case TEMP:
		showTemp(5);
		break;
		case CPU1:
		showCPU1(5);
		break;
		case CPU2:
		showCPU2(5);
		break;
		case FAN1:
		showFan1(5);
		break;
		case FAN2:
		showFan2(5);
		break;
		case FAN3:
		showFan3(5);
		break;
		default:
		break;
		}
		
		switch(pos2)
		{
		case TEMP:
		showTemp(20);
		break;
		case CPU1:
		showCPU1(20);
		break;
		case CPU2:
		showCPU2(20);
		break;
		case FAN1:
		showFan1(20);
		break;
		case FAN2:
		showFan2(20);
		break;
		case FAN3:
		showFan3(20);
		break;
		default:
		break;
		}
		
		switch(pos3)
		{
		case TEMP:
		showTemp(33);
		break;
		case CPU1:
		showCPU1(33);
		break;
		case CPU2:
		showCPU2(33);
		break;
		case FAN1:
		showFan1(33);
		break;
		case FAN2:
		showFan2(33);
		break;
		case FAN3:
		showFan3(33);
		break;
		default:
		break;
		}
		
		switch(pos4)
		{
		case TEMP:
		showTemp(46);
		break;
		case CPU1:
		showCPU1(46);
		break;
		case CPU2:
		showCPU2(46);
		break;
		case FAN1:
		showFan1(46);
		break;
		case FAN2:
		showFan2(46);
		break;
		case FAN3:
		showFan3(46);
		break;
		default:
		break;
		}
		
	} //end of if chiptype == W83783S

	RedrawWindow();
	usleep(150000);
	} //end of while
	} //end of if for chiptype 

return(0);
}

void placement()
{
    char temp[256];
    char options[256];

    FILE *asfatmConfig;
    
    sprintf(temp, "%s/.asfatmrc", getenv("HOME"));
    if ((asfatmConfig = fopen(temp, "r")) == NULL)
    {
    fprintf(stderr, "\nCouldn't open asfatm config file..\n");
    fclose(asfatmConfig);
    exit(0);
    }
    else
    {
    if(beVerbose == TRUE)
    fprintf(stderr, "asfatm config file opened successfully..\n");

    while(feof(asfatmConfig) == 0)
    {  
    fgets(options, 256, asfatmConfig);
    //fprintf(stderr, "%s", options);

    //find where temp goes
    if(strstr(options, "[temp] 1") && !strstr(options, "#"))
	pos1 = TEMP;
    if(strstr(options, "[temp] 2") && !strstr(options, "#"))
	pos2 = TEMP;
    if(strstr(options, "[temp] 3") && !strstr(options, "#"))
	pos3 = TEMP;
    if(strstr(options, "[temp] 4") && !strstr(options, "#"))
	pos4 = TEMP;
    //if(strstr(options, "[temp] 0"))
	//{}
	
    //cpu's
    if(strstr(options, "[cpu1] 1") && !strstr(options, "#"))
	pos1 = CPU1;
    if(strstr(options, "[cpu1] 2") && !strstr(options, "#"))
	pos2 = CPU1;
    if(strstr(options, "[cpu1] 3") && !strstr(options, "#"))
	pos3 = CPU1;
    if(strstr(options, "[cpu1] 4") && !strstr(options, "#"))
	pos4 = CPU1;
    //if(strstr(options, "[cpu1] 0"))
	//{}	
    if(strstr(options, "[cpu2] 1") && !strstr(options, "#"))
	pos1 = CPU2;
    if(strstr(options, "[cpu2] 2") && !strstr(options, "#"))
	pos2 = CPU2;
    if(strstr(options, "[cpu2] 3") && !strstr(options, "#"))
	pos3 = CPU2;
    if(strstr(options, "[cpu2] 4") && !strstr(options, "#"))
	pos4 = CPU2;
    //if(strstr(options, "[cpu2] 0"))
	//{}
	
    //find where fan1 should go
    if(strstr(options, "[fan1] 1") && !strstr(options, "#"))
	pos1 = FAN1;
    if(strstr(options, "[fan1] 2") && !strstr(options, "#"))
	pos2 = FAN1;
    if(strstr(options, "[fan1] 3") && !strstr(options, "#"))
	pos3 = FAN1;
    if(strstr(options, "[fan1] 4") && !strstr(options, "#"))
	pos4 = FAN1;
	
    //find where fan2 should go
    if(strstr(options, "[fan2] 1") && !strstr(options, "#"))
	pos1 = FAN2;
    if(strstr(options, "[fan2] 2") && !strstr(options, "#"))
	pos2 = FAN2;
    if(strstr(options, "[fan2] 3") && !strstr(options, "#"))
	pos3 = FAN2;
    if(strstr(options, "[fan2] 4") && !strstr(options, "#"))
	pos4 = FAN2;
    

    //find where fan3 should go
    if(strstr(options, "[fan3] 1") && !strstr(options, "#"))
	pos1 = FAN3;
    if(strstr(options, "[fan3] 2") && !strstr(options, "#"))
	pos2 = FAN3;
    if(strstr(options, "[fan3] 3") && !strstr(options, "#"))
	pos3 = FAN3;
    if(strstr(options, "[fan3] 4") && !strstr(options, "#"))
	pos4 = FAN3;
   
    }
    }

    fclose(asfatmConfig);
    
} //end of placement()

void asfatmUsage()
{
	printf("Usage:\n\n");
	printf("[-v]        show version and exit\n");
	printf("[-help]     show this help\n");
	printf("[-loud]     spew out extra info\n"); 
	printf("\nasfatm is controlled through a config file in\n");
	printf("your home directory (.asfatmrc) see asfatmrc.example\n");
	printf("in the directory where you have the asfatm source code.\n");
	printf("\nasfatm ver. %s\n", VERSION);
}

/*************************************************
yPos

spot1: 5
spot2: 20
spot3: 33
spot4: 46
*************************************************/

void showTemp(int yPos)
{
if(temp1 < 99 && temp1 > 0)
{
    //copy 'TEMP'
    copyXPMArea(78,15,23,7,6,yPos);
    copyXPMArea(78,43,23,7,34,yPos);

temptemp1 = temp1/10;
	switch(temptemp1)
	{
	case 0:
	copyXPMArea(1,64,5,8,36,yPos);
	break;
	case 1:
	copyXPMArea(7,64,5,8,36,yPos);
	break;
	case 2:
	copyXPMArea(13,64,5,8,36,yPos);
	break;
	case 3:
	copyXPMArea(19,64,5,8,36,yPos);
	break;
	case 4:
	copyXPMArea(25,64,5,8,36,yPos);
	break;
	case 5:
	copyXPMArea(31,64,5,8,36,yPos);
	break;
	case 6:
	copyXPMArea(37,64,5,8,36,yPos);
	break;
	case 7:
	copyXPMArea(43,64,5,8,36,yPos);
	break;
	case 8:
	copyXPMArea(49,64,5,8,36,yPos);
	break;
	case 9:
	copyXPMArea(55,64,5,8,36,yPos);
	break;
	default:
	copyXPMArea(71,15,5,8,36,yPos);
	break;
	} //end of switch

temptemp1 = temptemp1*10;
temptemp2 = temp1-temptemp1;

	switch(temptemp2)
	{
	case 0:
	copyXPMArea(1,64,5,8,42,yPos);
	break;
	case 1:
	copyXPMArea(7,64,5,8,42,yPos);
	break;
	case 2:
	copyXPMArea(13,64,5,8,42,yPos);
	break;
	case 3:
	copyXPMArea(19,64,5,8,42,yPos);
	break;
	case 4:
	copyXPMArea(25,64,5,8,42,yPos);
	break;
	case 5:
	copyXPMArea(31,64,5,8,42,yPos);
	break;
	case 6:
	copyXPMArea(37,64,5,8,42,yPos);
	break;
	case 7:
	copyXPMArea(43,64,5,8,42,yPos);
	break;
	case 8:
	copyXPMArea(49,64,5,8,42,yPos);
	break;
	case 9:
	copyXPMArea(55,64,5,8,42,yPos);
	break;
	default:
	copyXPMArea(71,15,5,8,42,yPos);
	break;
	} //end of switch
} //end of if
}

void showCPU1(int yPos)
{
	//copy 'CPU1'
	copyXPMArea(78,57,23,7,6,yPos);
	copyXPMArea(78,43,23,7,34,yPos);
	
	if(temp2 < 99 && temp2 > 0)
	{
	temp2temp1 = temp2 / 10;
		switch(temp2temp1)
		{
		case 0:
		copyXPMArea(1,64,5,8,36,yPos);
		break;
		case 1:
		copyXPMArea(7,64,5,8,36,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,36,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,36,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,36,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,36,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,36,yPos);
		break;
		case 7:
		copyXPMArea(43,64,5,8,36,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,36,yPos);
		break;
		case 9:
		copyXPMArea(55,64,5,8,36,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,36,yPos);
		break;
		} //end of switch

	temp2temp1 = temp2temp1*10;
	temp2temp2 = temp2-temp2temp1;

		switch(temp2temp2)
		{
		case 0:
		copyXPMArea(1,64,5,8,42,yPos);
		break;
		case 1:
		copyXPMArea(7,64,5,8,42,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,42,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,42,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,42,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,42,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,42,yPos);
		break;
		case 7:
		copyXPMArea(42,64,5,8,42,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,42,yPos);
		break;
		case 9:
		copyXPMArea(55,64,5,8,42,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,42,yPos);
		break;
		} //end of switch
	} //end of if
	else
	{
	copyXPMArea(71,35,5,8,36,yPos);
	copyXPMArea(71,35,5,8,42,yPos);
	}
}

void showCPU2(int yPos)
{
	//copy 'CPU2'
	copyXPMArea(78,64,23,7,6,yPos);
	copyXPMArea(78,43,23,7,34,yPos);

	if(temp3 < 99 && temp3 > 0)
	{
	temp3temp1 = temp3 / 10;
		switch(temp3temp1)
		{
		case 0:
		copyXPMArea(1,64,5,8,36,yPos);
		break;
		case 1:
		copyXPMArea(7,64,5,8,36,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,36,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,36,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,36,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,36,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,36,yPos);
		break;
		case 7:
		copyXPMArea(43,64,5,8,36,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,36,yPos);
		break;
		case 9:
		copyXPMArea(55,64,5,8,36,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,36,yPos);
		break;
		} //end of switch

	temp3temp1 = temp3temp1*10;
	temp3temp2 = temp3-temp3temp1;

		switch(temp3temp2)
		{
		case 0:
		copyXPMArea(1,64,5,8,42,yPos);
		break;
		case 1:
		copyXPMArea(7,64,5,8,42,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,42,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,42,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,42,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,42,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,42,yPos);
		break;
		case 7:
		copyXPMArea(43,64,5,8,42,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,42,yPos);
		break;
		case 9:
		copyXPMArea(55,64,5,8,42,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,42,yPos);
		break;
		} //end of switch
	} //end of if
	else
	{
	copyXPMArea(71,35,5,8,36,yPos);
	copyXPMArea(71,35,5,8,42,yPos);
	}
}

void showFan1(int yPos)
{
	//copy 'FAN1'
	copyXPMArea(78,22,23,7,6,yPos);
	copyXPMArea(78,50,23,7,34,yPos);

	if(fan1 < 9999 && fan1 > 0)
	{
		fan1temp1 = fan1 / 1000;
		switch(fan1temp1)
		{
		case 1:
		copyXPMArea(7,64,5,8,34,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,34,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,34,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,34,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,34,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,34,yPos);
		break;
		case 7:
		copyXPMArea(43,64,5,8,34,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,34,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,34,yPos);
		break;
		} //end of switch

	fan1temp1 = fan1temp1 * 1000;
	fan1temp2 = fan1 - fan1temp1;
	fan1temp3 = fan1temp2 / 100;

		switch(fan1temp3)
		{
		case 0:
		copyXPMArea(1,64,5,8,40,yPos);
		break;
		case 1:
		copyXPMArea(7,64,5,8,40,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,40,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,40,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,40,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,40,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,40,yPos);
		break;
		case 7:
		copyXPMArea(43,64,5,8,40,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,40,yPos);
		break;
		case 9:
		copyXPMArea(55,64,5,8,40,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,40,yPos);
		break;
		} //end of switch

	fan1temp3 = fan1temp3 * 100;
	fan1temp4 = fan1temp2 - fan1temp3;
	fan1temp5 = fan1temp4 / 10;

		switch(fan1temp5)
		{
		case 0:
		copyXPMArea(1,64,5,8,46,yPos);
		break;
		case 1:
		copyXPMArea(7,64,5,8,46,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,46,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,46,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,46,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,46,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,46,yPos);
		break;
		case 7:
		copyXPMArea(43,64,5,8,46,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,46,yPos);
		break;
		case 9:
		copyXPMArea(55,64,5,8,46,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,46,yPos);
		} //end of switch

	fan1temp5 = fan1temp5 * 10;
	fan1temp6 = fan1temp4 - fan1temp5;

		switch(fan1temp6)
		{
		case 0:
		copyXPMArea(1,64,5,8,52,yPos);
		break;
		case 1:
		copyXPMArea(7,64,5,8,52,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,52,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,52,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,52,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,52,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,52,yPos);
		break;
		case 7:
		copyXPMArea(43,64,5,8,52,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,52,yPos);
		break;
		case 9:
		copyXPMArea(55,64,5,8,52,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,52,yPos);
		break;
		} //end of switch

	} //end of if

	else
	{
		copyXPMArea(1,64,5,8,34,yPos);
		copyXPMArea(1,64,5,8,40,yPos);
		copyXPMArea(1,64,5,8,46,yPos);
		copyXPMArea(1,64,5,8,52,yPos);
	}

} //end of showFan1


void showFan2(int yPos)
{
	copyXPMArea(78,29,23,7,6,yPos);
	copyXPMArea(78,50,23,7,34,yPos);

	if(fan2 < 9999 && fan2  > 0)
	{
		fan2temp1 = fan2 / 1000;
		switch(fan2temp1)
		{
		case 1:
		copyXPMArea(7,64,5,8,34,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,34,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,34,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,34,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,34,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,34,yPos);
		break;
		case 7:
		copyXPMArea(43,64,5,8,34,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,34,yPos);
		break;
		case 9:
		copyXPMArea(55,64,5,8,34,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,34,yPos);
		break;
		} //end of switch

	fan2temp1 = fan2temp1 * 1000;
	fan2temp2 = fan2 - fan2temp1;
	fan2temp3 = fan2temp2 / 100;

		switch(fan2temp3)
		{
		case 0:
		copyXPMArea(1,64,5,8,40,yPos);
		break;
		case 1:
		copyXPMArea(7,64,5,8,40,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,40,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,40,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,40,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,40,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,40,yPos);
		break;
		case 7:
		copyXPMArea(43,64,5,8,40,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,40,yPos);
		break;
		case 9:
		copyXPMArea(55,64,5,8,40,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,40,yPos);
		break;
		} //end of switch

	fan2temp3 = fan2temp3 * 100;
	fan2temp4 = fan2temp2 - fan2temp3;
	fan2temp5 = fan2temp4 / 10;

		switch(fan2temp5)
		{
		case 0:
		copyXPMArea(1,64,5,8,46,yPos);
		break;
		case 1:
		copyXPMArea(7,64,5,8,46,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,46,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,46,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,46,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,46,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,46,yPos);
		break;
		case 7:
		copyXPMArea(43,64,5,8,46,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,46,yPos);
		break;
		case 9:
		copyXPMArea(55,64,5,8,46,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,46,yPos);
		break;
		} //end of switch

	fan2temp5 = fan2temp5 * 10;
	fan2temp6 = fan2temp4 - fan2temp5;

		switch(fan2temp6)
		{
		case 0:
		copyXPMArea(1,64,5,8,52,yPos);
		break;
		case 1:
		copyXPMArea(7,64,5,8,52,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,52,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,52,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,52,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,52,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,52,yPos);
		break;
		case 7:
		copyXPMArea(43,64,5,8,52,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,52,yPos);
		break;
		case 9:
		copyXPMArea(55,64,5,8,52,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,52,yPos);
		break;
		} //end of switch

	} //end of if
	else
	{
		copyXPMArea(1,64,5,8,34,yPos);
		copyXPMArea(1,64,5,8,40,yPos);
		copyXPMArea(1,64,5,8,46,yPos);
		copyXPMArea(1,64,5,8,52,yPos);
	}
} //end of showFan2in3

void showFan3(int yPos)
{
	//copy 'FAN3
	copyXPMArea(78,36,23,7,6,yPos);
	copyXPMArea(78,50,23,7,34,yPos);

	if(fan3 < 9999 && fan3 > 0)
	{
		fan3temp1 = fan3 / 1000;
		switch(fan3temp1)
		{
		case 1:
		copyXPMArea(7,64,5,8,34,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,34,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,34,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,34,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,34,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,34,yPos);
		break;
		case 7:
		copyXPMArea(43,64,5,8,34,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,34,yPos);
		break;
		case 9:
		copyXPMArea(55,64,5,8,34,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,34,yPos);
		break;
		} //end of switch

	fan3temp1 = fan3temp1 * 1000;
	fan3temp2 = fan3 - fan3temp1;
	fan3temp3 = fan3temp2 / 100;

		switch(fan3temp3)
		{
		case 0:
		copyXPMArea(1,64,5,8,40,yPos);
		break;
		case 1:
		copyXPMArea(7,64,5,8,40,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,40,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,40,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,40,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,40,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,40,yPos);
		break;
		case 7:
		copyXPMArea(43,64,5,8,40,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,40,yPos);
		break;
		case 9:
		copyXPMArea(55,64,5,8,40,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,40,yPos);
		break;
		} //end of switch

	fan3temp3 = fan3temp3 * 100;
	fan3temp4 = fan3temp2 - fan3temp3;
	fan3temp5 = fan3temp4 / 10;

		switch(fan3temp5)
		{
		case 0:
		copyXPMArea(1,64,5,8,46,yPos);
		break;
		case 1:
		copyXPMArea(7,64,5,8,46,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,46,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,46,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,46,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,46,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,46,yPos);
		break;
		case 7:
		copyXPMArea(43,64,5,8,46,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,46,yPos);
		break;
		case 9:
		copyXPMArea(55,64,5,8,46,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,46,yPos);
		break;
		} //end of switch

	fan3temp5 = fan3temp5 * 10;
	fan3temp6 = fan3temp4 - fan3temp5;

		switch(fan3temp6)
		{
		case 0:
		copyXPMArea(1,64,5,8,52,yPos);
		break;
		case 1:
		copyXPMArea(7,64,5,8,52,yPos);
		break;
		case 2:
		copyXPMArea(13,64,5,8,52,yPos);
		break;
		case 3:
		copyXPMArea(19,64,5,8,52,yPos);
		break;
		case 4:
		copyXPMArea(25,64,5,8,52,yPos);
		break;
		case 5:
		copyXPMArea(31,64,5,8,52,yPos);
		break;
		case 6:
		copyXPMArea(37,64,5,8,52,yPos);
		break;
		case 7:
		copyXPMArea(43,64,5,8,52,yPos);
		break;
		case 8:
		copyXPMArea(49,64,5,8,52,yPos);
		break;
		case 9:
		copyXPMArea(55,64,5,8,52,yPos);
		break;
		default:
		copyXPMArea(71,15,5,8,52,yPos);
		break;
		} //end of switch
	}//end of if
	else
	{
		copyXPMArea(1,64,5,8,34,yPos);
		copyXPMArea(1,64,5,8,40,yPos);
		copyXPMArea(1,64,5,8,46,yPos);
		copyXPMArea(1,64,5,8,52,yPos);
	}
} //end of showFan3
