/*
 *	 asfatm (AfterStep Fan and Temperature Monitor)
 *	 ver 0.75b 
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sensors/sensors.h>
#include <sensors/chips.h>
#include <sensors/error.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "../wmgeneral/wmgeneral.h"
#include "../wmgeneral/misc.h"

#include "lmse_master.xpm"
#include "lmse_mask.xbm"

#define LM78 1
#define LM78J 2
#define LM79 3
#define LM80 4

#define LM75 10 

#define W83781D 5
#define W83782D 6
#define W83783S 7

#define TRUE 1
#define FALSE 0
#define NONE 86

#define VERSION "0.75b"

int c;

//prototypes
void asfatmUsage(void);
void showTemp(void);
void showCPU1in1(void);
void showCPU1in2(void);
void showCPU2in1(void);
void showCPU2in2(void);
//which position
void showFan1in2(void);
void showFan1in3(void);
void showFan1in4(void);
void showFan2in3(void);
void showFan2in4(void);
void showFan3in3(void);
void showFan3in4(void);

double temp1 = 0;
double temp2 = 0;
double temp3 = 0;

double fan1 = 0;
double fan2 = 0;
double fan3 = 0;

int temptemp1 = 0;
int temptemp2 = 0;

int temp2temp1 = 0;
int temp2temp2 = 0;

int temp3temp1 = 0;
int temp3temp2 = 0;

int fan1temp1;
int fan1temp2;
int fan1temp3;
int fan1temp4;
int fan1temp5;
int fan1temp6;

int fan2temp1;
int fan2temp2;
int fan2temp3;
int fan2temp4;
int fan2temp5;
int fan2temp6;

int fan3temp1;
int fan3temp2;
int fan3temp3;
int fan3temp4;
int fan3temp5;
int fan3temp6;

int main(int argc, char **argv)
{

	XEvent Event;

	//int chips_nr = 0;
	int nr = 0;
	int configFileFound;
	FILE *theConfigFile;
	const sensors_chip_name *name;
	const sensors_chip_name *other;

	int chiptype = -1;	
	int chiptype2 = -1;
	int otherChip = -1;

	int haslm75 = FALSE;
	int showCPU1Temp = FALSE;
	int showTwoCPUTemps = FALSE;
	int beVerbose = FALSE;

	int Fan1 = FALSE;
	int Fan2 = FALSE;
	int Fan3 = FALSE;

	for(c=1;c<argc;c++)
	{
	if(argv[c] == NULL)
	{}
	else if(!strcmp(argv[c], "-v"))
	{
	printf("\nasfatm version %s\n\n", VERSION);
	exit(0);
	}
	else if(!strcmp(argv[c], "--help"))
	{
	asfatmUsage();
	exit(0);
	}
	else if(!strcmp(argv[c], "-help"))
	{
	asfatmUsage();
	exit(0);
	}
	else if(!strcmp(argv[c], "-cpu"))
	{
	showCPU1Temp = TRUE;
	//uselm75 = TRUE;
	}
	else if(!strcmp(argv[c], "-bothcpus"))
	{
	showTwoCPUTemps = TRUE;
	}
	else if(!strcmp(argv[c], "-fan1"))
	{
	Fan1 = TRUE;
	}
	else if(!strcmp(argv[c], "-fan2"))
	{
	Fan2 = TRUE;
	}
	else if(!strcmp(argv[c], "-fan3"))
	{
	Fan3 = TRUE;
	}
	else if(!strcmp(argv[c], "-loud"))
	{
	beVerbose = TRUE;
	}
	else
	{
	printf("\nillegal option\n\n");
	asfatmUsage();
	exit(0);
	}
	} //end of for

	theConfigFile = fopen("/etc/sensors.conf", "r");
	//theConfigFile will return 0 if it can't open sensors.conf
	if(theConfigFile != 0)
	{
	configFileFound = sensors_init(theConfigFile);
	fclose(theConfigFile);
	
	if(configFileFound == 0)
	{

	//looking for wd*
	if(beVerbose == TRUE)
	fprintf(stderr, "before wd* detection nr is: %i\n", nr);

	while(chiptype2 == -1)
	{
	name = sensors_get_detected_chips(&nr);
	if(name == NULL)
	{
	if(beVerbose == TRUE)
	fprintf(stderr, "No wd* chipsets found!\n");
	chiptype2 = 86;
	}
	else if(!strcmp(name->prefix, SENSORS_W83781D_PREFIX))
	{
	chiptype = W83781D;
	if(beVerbose == TRUE)
	fprintf(stderr, "%s found!\n", SENSORS_W83781D_PREFIX);
	otherChip = 86;
	chiptype2 = 86;
	}
	else if(!strcmp(name->prefix, SENSORS_W83782D_PREFIX))
	{
	chiptype = W83782D;
	if(beVerbose == TRUE)
	fprintf(stderr, "%s found!\n", SENSORS_W83782D_PREFIX);
	otherChip = 86;
	chiptype2 = 86;
	}
	else if(!strcmp(name->prefix, SENSORS_W83783S_PREFIX))
	{
	chiptype = W83783S;
	if(beVerbose == TRUE)
	fprintf(stderr, "%s found!\n", SENSORS_W83783S_PREFIX);
	otherChip = 86;
	chiptype2 = 86;
	}
	} //end of while

	if(beVerbose == TRUE && chiptype == -1)
	{
	fprintf(stderr, "before reset nr is: %i\n", nr);
	fprintf(stderr, " ... resetting ... \n");
	}
	if(chiptype == -1)
	nr = 0;

	if(beVerbose == TRUE && chiptype == -1)
	fprintf(stderr, "before lm75 detection nr is: %i\n", nr);

	while(otherChip == -1)
	{
	other = sensors_get_detected_chips(&nr);

	if(other == NULL)
	{
	if(beVerbose == TRUE)
	fprintf(stderr, "%s not found!\n", SENSORS_LM75_PREFIX);
	otherChip = 86;
	}

	else if(!strcmp(other->prefix, SENSORS_LM75_PREFIX))
	{
	haslm75 = TRUE;
	if(beVerbose == TRUE)
	fprintf(stderr, "%s found!\n", SENSORS_LM75_PREFIX);
	otherChip = LM75;
	}

	} //end of while

	if(beVerbose == TRUE && chiptype == -1)
	fprintf(stderr, "before reset nr is: %i\n .. resetting ..\n", nr);
	if(chiptype == -1)
	nr = 0;
	if(beVerbose == TRUE && chiptype == -1)
	fprintf(stderr, "before lm* detection nr is: %i\n", nr);

	while(chiptype == -1)
	{
	name = sensors_get_detected_chips(&nr);

	if(name == NULL)
	{
	fprintf(stderr, "No chipsets detected..\n");
	exit(0);
	}

	else if(!strcmp(name->prefix, SENSORS_LM79_PREFIX))
	{
	chiptype = LM79;
	if(beVerbose == TRUE)
	fprintf(stderr, "found %s!\n", name->prefix);
	}
	else if(!strcmp(name->prefix, SENSORS_LM78_PREFIX))
	{
	chiptype = LM78;
	if(beVerbose == TRUE)
	fprintf(stderr, "found %s!\n", name->prefix);
	}
	else if(!strcmp(name->prefix, SENSORS_LM78J_PREFIX))
	{
	chiptype = LM78J;
	if(beVerbose == TRUE)
	fprintf(stderr, "found %s!\n", name->prefix);
	}
	else if(!strcmp(name->prefix, SENSORS_LM80_PREFIX))
	{
	chiptype = LM80;
	if(beVerbose == TRUE)
	fprintf(stderr, "found %s!\n", name->prefix);
	}

	} //end of while

	if(beVerbose == TRUE)
	fprintf(stderr, "after lm* detection nr is: %i\n", nr);

	if(beVerbose == TRUE)
	{
	fprintf(stderr, "\nDETECTION SUMMARY ----------\n\n");
	fprintf(stderr, "found Chiptype: %i\n", chiptype);
	fprintf(stderr, "found Chipname: %s\n", name->prefix);
	switch(haslm75)
	{
	case FALSE:
	fprintf(stderr, "\nan lm75 was not detected.\n");
	break;
	case TRUE:
	fprintf(stderr, "\nan lm75 was detected.\n");
	break;
	} //end of switch
	} //end of if beVerbose
	} //end of if configFileFound
	else
	{
	printf("could not initialize '/etc/sensors.conf' properly .. exiting.");
	exit(0);
	}
	} //end of if theConfigFile
	else
	{
	printf("\ncould not find '/etc/sensors.conf' .. exiting.\n\n");
	exit(0);
	}

	openXwindow(argc, argv, lmse_master_xpm, lmse_mask_bits, lmse_mask_width, lmse_mask_height);

	if(chiptype == -1)
	{
	printf("\nno supported chipsets found.\n\n");
	exit(0);
	}
	else if(chiptype != -1)
	{
	while(1)
	{
		while(XPending(display))
		{
		XNextEvent(display, &Event);
		switch(Event.type)
		{
		case Expose:
			RedrawWindow();
			break;
		case DestroyNotify:
			XCloseDisplay(display);
			exit(0);
			break;
		}
		} //end of while XPending

	if((chiptype == LM78 || chiptype == LM78J) || chiptype == LM79)
	{
	sensors_get_feature(*name, SENSORS_LM78_FAN3, &fan3);
	sensors_get_feature(*name, SENSORS_LM78_FAN2, &fan2);
	sensors_get_feature(*name, SENSORS_LM78_FAN1, &fan1);
	sensors_get_feature(*name, SENSORS_LM78_TEMP, &temp1);
	}
	else if(chiptype == LM80)
	{
	sensors_get_feature(*name, SENSORS_LM80_FAN2, &fan2);
	sensors_get_feature(*name, SENSORS_LM80_FAN1, &fan1);
	sensors_get_feature(*name, SENSORS_LM80_TEMP, &temp1);
	}
	else if(chiptype == W83781D)
	{
	sensors_get_feature(*name, SENSORS_W83781D_FAN3, &fan3);
	sensors_get_feature(*name, SENSORS_W83781D_FAN2, &fan2);
	sensors_get_feature(*name, SENSORS_W83781D_FAN1, &fan1);
	sensors_get_feature(*name, SENSORS_W83781D_TEMP3, &temp3);
	sensors_get_feature(*name, SENSORS_W83781D_TEMP2, &temp2);
	sensors_get_feature(*name, SENSORS_W83781D_TEMP1, &temp1);
	}
	else if(chiptype == W83782D)
	{
	sensors_get_feature(*name, SENSORS_W83782D_FAN3, &fan3);
	sensors_get_feature(*name, SENSORS_W83782D_FAN2, &fan2);
	sensors_get_feature(*name, SENSORS_W83782D_FAN1, &fan1);
	sensors_get_feature(*name, SENSORS_W83782D_TEMP3, &temp3);
	sensors_get_feature(*name, SENSORS_W83782D_TEMP2, &temp2);
	sensors_get_feature(*name, SENSORS_W83782D_TEMP1, &temp1);
	}
	else if(chiptype == W83783S)
	{
	sensors_get_feature(*name, SENSORS_W83783S_FAN3, &fan3);
	sensors_get_feature(*name, SENSORS_W83783S_FAN2, &fan2);
	sensors_get_feature(*name, SENSORS_W83783S_FAN1, &fan1);
	sensors_get_feature(*name, SENSORS_W83783S_TEMP2, &temp2);
	sensors_get_feature(*name, SENSORS_W83783S_TEMP1, &temp1);
	}
	else
	{
	fprintf(stderr, "No chipsets initialized .. exiting.\n");
	exit(0);
	}

	if(haslm75 == TRUE && otherChip == LM75)
	{
	sensors_get_feature(*other, SENSORS_LM75_TEMP, &temp2);
	}

	if((chiptype == LM79 || chiptype == LM78J) || chiptype == LM78)
	{
		if(haslm75 == FALSE && showCPU1Temp == TRUE)
		{
		fprintf(stderr, "error: no lm75 detected\n");
		exit(0);
		}
		else if(showTwoCPUTemps == TRUE)
		{
		fprintf(stderr, "error: not supported with chip: %s\n", name->prefix);
		exit(0);
		}
		else if(haslm75 == TRUE && showCPU1Temp == TRUE)
		{
		if(Fan1 == TRUE && Fan2 == TRUE)
		{
		showTemp();
		showCPU1in2();
		showFan1in3();
		showFan2in4();
		}
		else if(Fan1 == TRUE && Fan3 == TRUE)
		{
		showTemp();
		showCPU1in2();
		showFan1in3();
		showFan3in4();
		}
		else if(Fan2 == TRUE && Fan3 == TRUE)
		{
		showTemp();
		showCPU1in2();
		showFan2in3();
		showFan3in4();
		}
		else //default
		{
		showTemp();
		showCPU1in2();
		showFan1in3();
		showFan2in4();
		}
		} //end of haslm75 && showCPU1Temp == TRUE
		else
		{
		showTemp();
		showFan1in2();
		showFan2in3();
		showFan3in4();
		}
		
	} //end of if chiptype = LM79 | LM80 | LM78J
	else if(chiptype == LM80)
	{
		if(haslm75 == FALSE && showCPU1Temp == TRUE)
		{
		fprintf(stderr, "error: no lm75 detected\n");
		exit(0);
		}
		else if(showTwoCPUTemps == TRUE)
		{
		fprintf(stderr, "error: not supported with chip: %s\n", name->prefix);
		exit(0);
		}
		else if(haslm75 == TRUE && showCPU1Temp == TRUE)
		{
		showTemp();
		showCPU1in2();
		showFan1in3();
		showFan2in3();
		}
		else
		{
		showTemp();
		showFan1in2();
		showFan2in3();
		showFan3in4();
		}

	} //end of else if chiptype == LM80
	else if(chiptype == W83781D || chiptype == W83782D)
	{
		if(showCPU1Temp == TRUE)
		{
		if(Fan1 == TRUE && Fan2 == TRUE)
		{
		showTemp();
		showCPU1in2();
		showFan1in3();
		showFan2in4();
		}
		else if(Fan1 == TRUE && Fan3 == TRUE)
		{
		showTemp();
		showCPU1in2();
		showFan1in3();
		showFan3in3();
		}
		else if(Fan2 == TRUE && Fan3 == TRUE)
		{
		showTemp();
		showCPU1in2();
		showFan2in3();
		showFan3in4();
		}
		} //end of if CPU1Temp == TRUE
		else if(showTwoCPUTemps == TRUE)
		{
		if(Fan1 == TRUE && Fan2 == TRUE)
		{
		showCPU1in1();
		showCPU2in2();
		showFan1in3();
		showFan2in4();
		}
		else if(Fan1 == TRUE && Fan3 == TRUE)
		{
		showCPU1in1();
		showCPU2in2();
		showFan1in3();
		showFan3in4();
		}
		else if(Fan2 == TRUE && Fan3 == TRUE)
		{
		showCPU1in1();
		showCPU2in2();
		showFan2in3();
		showFan3in4();
		}
		} //end of showTwoCPUTemps == TRUE
		else
		{
		showCPU1in1();
		showCPU2in2();
		showFan1in3();
		showFan2in4();
		}
	} //end of else if W83781D || W83782D
	else if(chiptype == W83783S)
	{
		if(showCPU1Temp == TRUE)
		{
		if(Fan1 == TRUE && Fan2 == TRUE)
		{
		showTemp();
		showCPU1in2();
		showFan1in3();
		showFan2in4();
		}
		else if(Fan1 == TRUE && Fan3 == TRUE)
		{
		showTemp();
		showCPU1in2();
		showFan1in3();
		showFan2in4();
		}
		else if(Fan2 == TRUE && Fan3 == TRUE)
		{
		showTemp();
		showCPU1in2();
		showFan2in3();
		showFan3in4();
		}
		else
		{
		showTemp();
		showCPU1in2();
		showFan1in3();
		showFan2in4();
		}
		} //end of if showCPU1Temp == TRUE
		else
		{
		showTemp();
		showFan1in2();
		showFan2in3();
		showFan3in4();
		}
	} //end of if chiptype == W83783S

	RedrawWindow();
	usleep(150000);
	} //end of while
	} //end of if for chiptype 

return(0);
}

void asfatmUsage()
{
	printf("Usage:\n\n");
	printf("[-v]        show version and exit\n");
	printf("[-cpu]      show cpu temp (lm75,wd83781d,w83782d,w83783s)\n");
	printf("[-bothcpus] show both cpu temps (w83781d,w83782d)\n");
	printf("[-fan1]     show fan1\n");
	printf("[-fan2]     show fan2\n");
	printf("[-fan3]     show fan3\n");
	printf("[-help]     show this help\n");
	printf("\n[-loud]    spew out extra info\n"); 
	printf("\nasfatm ver. %s\n", VERSION);
}

void showTemp()
{
if(temp1 < 99 && temp1 > 0)
{
temptemp1 = temp1/10;
	switch(temptemp1)
	{
	case 0:
	copyXPMArea(1,64,5,8,36,5);
	break;
	case 1:
	copyXPMArea(7,64,5,8,36,5);
	break;
	case 2:
	copyXPMArea(13,64,5,8,36,5);
	break;
	case 3:
	copyXPMArea(19,64,5,8,36,5);
	break;
	case 4:
	copyXPMArea(25,64,5,8,36,5);
	break;
	case 5:
	copyXPMArea(31,64,5,8,36,5);
	break;
	case 6:
	copyXPMArea(37,64,5,8,36,5);
	break;
	case 7:
	copyXPMArea(43,64,5,8,36,5);
	break;
	case 8:
	copyXPMArea(49,64,5,8,36,5);
	break;
	case 9:
	copyXPMArea(55,64,5,8,36,5);
	break;
	default:
	copyXPMArea(71,15,5,8,36,5);
	break;
	} //end of switch

temptemp1 = temptemp1*10;
temptemp2 = temp1-temptemp1;

	switch(temptemp2)
	{
	case 0:
	copyXPMArea(1,64,5,8,42,5);
	break;
	case 1:
	copyXPMArea(7,64,5,8,42,5);
	break;
	case 2:
	copyXPMArea(13,64,5,8,42,5);
	break;
	case 3:
	copyXPMArea(19,64,5,8,42,5);
	break;
	case 4:
	copyXPMArea(25,64,5,8,42,5);
	break;
	case 5:
	copyXPMArea(31,64,5,8,42,5);
	break;
	case 6:
	copyXPMArea(37,64,5,8,42,5);
	break;
	case 7:
	copyXPMArea(43,64,5,8,42,5);
	break;
	case 8:
	copyXPMArea(49,64,5,8,42,5);
	break;
	case 9:
	copyXPMArea(55,64,5,8,42,5);
	break;
	default:
	copyXPMArea(71,15,5,8,42,5);
	break;
	} //end of switch
} //end of if
}

void showCPU1in1()
{
	//copy 'CPU1' over 'TEMP'
	copyXPMArea(51,6,5,8,6,6);
	copyXPMArea(71,65,5,8,12,6);
	copyXPMArea(71,5,5,8,18,6);
	copyXPMArea(7,65,5,8,24,6);

	if(temp2 < 99 && temp2 > 0)
	{
	temp2temp1 = temp2 / 10;
		switch(temp2temp1)
		{
		case 0:
		copyXPMArea(1,64,5,8,36,5);
		break;
		case 1:
		copyXPMArea(7,64,5,8,36,5);
		break;
		case 2:
		copyXPMArea(13,64,5,8,36,5);
		break;
		case 3:
		copyXPMArea(19,64,5,8,36,5);
		break;
		case 4:
		copyXPMArea(25,64,5,8,36,5);
		break;
		case 5:
		copyXPMArea(31,64,5,8,36,5);
		break;
		case 6:
		copyXPMArea(37,64,5,8,36,5);
		break;
		case 7:
		copyXPMArea(43,64,5,8,36,5);
		break;
		case 8:
		copyXPMArea(49,64,5,8,36,5);
		break;
		case 9:
		copyXPMArea(55,64,5,8,36,5);
		break;
		default:
		copyXPMArea(71,15,5,8,36,5);
		break;
		} //end of switch

	temp2temp1 = temp2temp1*10;
	temp2temp2 = temp2-temp2temp1;

		switch(temp2temp2)
		{
		case 0:
		copyXPMArea(1,64,5,8,42,5);
		break;
		case 1:
		copyXPMArea(7,64,5,8,42,5);
		break;
		case 2:
		copyXPMArea(13,64,5,8,42,5);
		break;
		case 3:
		copyXPMArea(19,64,5,8,42,5);
		break;
		case 4:
		copyXPMArea(25,64,5,8,42,5);
		break;
		case 5:
		copyXPMArea(31,64,5,8,42,5);
		break;
		case 6:
		copyXPMArea(37,64,5,8,42,5);
		break;
		case 7:
		copyXPMArea(42,64,5,8,42,5);
		break;
		case 8:
		copyXPMArea(49,64,5,8,42,5);
		break;
		case 9:
		copyXPMArea(55,64,5,8,42,5);
		break;
		default:
		copyXPMArea(71,15,5,8,42,5);
		break;
		} //end of switch
	} //end of if
	else
	{
	copyXPMArea(71,35,5,8,36,5);
	copyXPMArea(71,35,5,8,42,5);
	}
}

void showCPU1in2()
{
	//copy 'CPU1' over 'FAN1'
	copyXPMArea(51,6,5,8,6,21);
	copyXPMArea(71,65,5,8,12,21);
	copyXPMArea(71,5,5,8,18,21);
	copyXPMArea(7,65,5,8,24,21);

	//copy celcius display
	copyXPMArea(32,4,27,12,32,19);

	if(temp2 < 99 && temp2 > 0)
	{
	temp2temp1 = temp2 / 10;
		switch(temp2temp1)
		{
		case 0:
		copyXPMArea(1,64,5,8,36,21);
		break;
		case 1:
		copyXPMArea(7,64,5,8,36,21);
		break;
		case 2:
		copyXPMArea(13,64,5,8,36,21);
		break;
		case 3:
		copyXPMArea(19,64,5,8,36,21);
		break;
		case 4:
		copyXPMArea(25,64,5,8,36,21);
		break;
		case 5:
		copyXPMArea(31,64,5,8,36,21);
		break;
		case 6:
		copyXPMArea(37,64,5,8,36,21);
		break;
		case 7:
		copyXPMArea(43,64,5,8,36,21);
		break;
		case 8:
		copyXPMArea(49,64,5,8,36,21);
		break;
		case 9:
		copyXPMArea(55,64,5,8,36,21);
		break;
		default:
		copyXPMArea(71,15,5,8,36,21);
		break;
		} //end of switch

	temp2temp1 = temp2temp1*10;
	temp2temp2 = temp2-temp2temp1;

		switch(temp2temp2)
		{
		case 0:
		copyXPMArea(1,64,5,8,42,21);
		break;
		case 1:
		copyXPMArea(7,64,5,8,42,21);
		break;
		case 2:
		copyXPMArea(13,64,5,8,42,21);
		break;
		case 3:
		copyXPMArea(19,64,5,8,42,21);
		break;
		case 4:
		copyXPMArea(25,64,5,8,42,21);
		break;
		case 5:
		copyXPMArea(31,64,5,8,42,21);
		break;
		case 6:
		copyXPMArea(37,64,5,8,42,21);
		break;
		case 7:
		copyXPMArea(42,64,5,8,42,21);
		break;
		case 8:
		copyXPMArea(49,64,5,8,42,21);
		break;
		case 9:
		copyXPMArea(55,64,5,8,42,21);
		break;
		default:
		copyXPMArea(71,15,5,8,42,21);
		break;
		} //end of switch
	} //end of if
	else
	{
	copyXPMArea(71,35,5,8,36,21);
	copyXPMArea(71,35,5,8,42,21);
	}
}

void showCPU2in1()
{
	//copy 'CPU2' over 'TEMP'
	copyXPMArea(51,6,5,8,6,6);
	copyXPMArea(71,65,5,8,12,6);
	copyXPMArea(71,5,5,8,18,6);
	copyXPMArea(13,65,5,8,24,6);

	//copy celcius display
	copyXPMArea(32,4,27,12,32,19);

	if(temp3 < 99 && temp2 > 0)
	{
	temp3temp1 = temp3 / 10;
		switch(temp3temp1)
		{
		case 0:
		copyXPMArea(1,64,5,8,36,6);
		break;
		case 1:
		copyXPMArea(7,64,5,8,36,6);
		break;
		case 2:
		copyXPMArea(13,64,5,8,36,6);
		break;
		case 3:
		copyXPMArea(19,64,5,8,36,6);
		break;
		case 4:
		copyXPMArea(25,64,5,8,36,6);
		break;
		case 5:
		copyXPMArea(31,64,5,8,36,6);
		break;
		case 6:
		copyXPMArea(37,64,5,8,36,6);
		break;
		case 7:
		copyXPMArea(43,64,5,8,36,6);
		break;
		case 8:
		copyXPMArea(49,64,5,8,36,6);
		break;
		case 9:
		copyXPMArea(55,64,5,8,36,6);
		break;
		default:
		copyXPMArea(71,15,5,8,36,6);
		break;
		} //end of switch

	temp3temp1 = temp3temp1*10;
	temp3temp2 = temp3-temp3temp1;

		switch(temp3temp2)
		{
		case 0:
		copyXPMArea(1,64,5,8,42,6);
		break;
		case 1:
		copyXPMArea(7,64,5,8,42,6);
		break;
		case 2:
		copyXPMArea(13,64,5,8,42,6);
		break;
		case 3:
		copyXPMArea(19,64,5,8,42,6);
		break;
		case 4:
		copyXPMArea(25,64,5,8,42,6);
		break;
		case 5:
		copyXPMArea(31,64,5,8,42,6);
		break;
		case 6:
		copyXPMArea(37,64,5,8,42,6);
		break;
		case 7:
		copyXPMArea(43,64,5,8,42,6);
		break;
		case 8:
		copyXPMArea(49,64,5,8,42,6);
		break;
		case 9:
		copyXPMArea(55,64,5,8,42,6);
		break;
		default:
		copyXPMArea(71,15,5,8,42,6);
		break;
		} //end of switch
	} //end of if
	else
	{
	copyXPMArea(71,35,5,8,36,6);
	copyXPMArea(71,35,5,8,42,6);
	}
}

void showCPU2in2()
{
	//copy 'CPU2' over 'FAN1'
	copyXPMArea(51,6,5,8,6,21);
	copyXPMArea(71,65,5,8,12,21);
	copyXPMArea(71,5,5,8,18,21);
	copyXPMArea(13,65,5,8,24,21);

	//copy celcius display
	copyXPMArea(32,4,27,12,32,19);

	if(temp3 < 99 && temp2 > 0)
	{
	temp3temp1 = temp3 / 10;
		switch(temp3temp1)
		{
		case 0:
		copyXPMArea(1,64,5,8,36,21);
		break;
		case 1:
		copyXPMArea(7,64,5,8,36,21);
		break;
		case 2:
		copyXPMArea(13,64,5,8,36,21);
		break;
		case 3:
		copyXPMArea(19,64,5,8,36,21);
		break;
		case 4:
		copyXPMArea(25,64,5,8,36,21);
		break;
		case 5:
		copyXPMArea(31,64,5,8,36,21);
		break;
		case 6:
		copyXPMArea(37,64,5,8,36,21);
		break;
		case 7:
		copyXPMArea(43,64,5,8,36,21);
		break;
		case 8:
		copyXPMArea(49,64,5,8,36,21);
		break;
		case 9:
		copyXPMArea(55,64,5,8,36,21);
		break;
		default:
		copyXPMArea(71,15,5,8,36,21);
		break;
		} //end of switch

	temp3temp1 = temp3temp1*10;
	temp3temp2 = temp3-temp3temp1;

		switch(temp3temp2)
		{
		case 0:
		copyXPMArea(1,64,5,8,42,21);
		break;
		case 1:
		copyXPMArea(7,64,5,8,42,21);
		break;
		case 2:
		copyXPMArea(13,64,5,8,42,21);
		break;
		case 3:
		copyXPMArea(19,64,5,8,42,21);
		break;
		case 4:
		copyXPMArea(25,64,5,8,42,21);
		break;
		case 5:
		copyXPMArea(31,64,5,8,42,21);
		break;
		case 6:
		copyXPMArea(37,64,5,8,42,21);
		break;
		case 7:
		copyXPMArea(43,64,5,8,42,21);
		break;
		case 8:
		copyXPMArea(49,64,5,8,42,21);
		break;
		case 9:
		copyXPMArea(55,64,5,8,42,21);
		break;
		default:
		copyXPMArea(71,15,5,8,42,21);
		break;
		} //end of switch
	} //end of if
	else
	{
	copyXPMArea(71,35,5,8,36,21);
	copyXPMArea(71,35,5,8,42,21);
	}
}

void showFan1in2()
{
	if(fan1 < 9999 && fan1 > 0)
	{
		fan1temp1 = fan1 / 1000;
		switch(fan1temp1)
		{
		case 1:
		copyXPMArea(7,64,5,8,34,20);
		break;
		case 2:
		copyXPMArea(13,64,5,8,34,20);
		break;
		case 3:
		copyXPMArea(19,64,5,8,34,20);
		break;
		case 4:
		copyXPMArea(25,64,5,8,34,20);
		break;
		case 5:
		copyXPMArea(31,64,5,8,34,20);
		break;
		case 6:
		copyXPMArea(37,64,5,8,34,20);
		break;
		case 7:
		copyXPMArea(43,64,5,8,34,20);
		break;
		case 8:
		copyXPMArea(49,64,5,8,34,20);
		break;
		default:
		copyXPMArea(71,15,5,8,34,20);
		break;
		} //end of switch

	fan1temp1 = fan1temp1 * 1000;
	fan1temp2 = fan1 - fan1temp1;
	fan1temp3 = fan1temp2 / 100;

		switch(fan1temp3)
		{
		case 0:
		copyXPMArea(1,64,5,8,40,20);
		break;
		case 1:
		copyXPMArea(7,64,5,8,40,20);
		break;
		case 2:
		copyXPMArea(13,64,5,8,40,20);
		break;
		case 3:
		copyXPMArea(19,64,5,8,40,20);
		break;
		case 4:
		copyXPMArea(25,64,5,8,40,20);
		break;
		case 5:
		copyXPMArea(31,64,5,8,40,20);
		break;
		case 6:
		copyXPMArea(37,64,5,8,40,20);
		break;
		case 7:
		copyXPMArea(43,64,5,8,40,20);
		break;
		case 8:
		copyXPMArea(49,64,5,8,40,20);
		break;
		case 9:
		copyXPMArea(55,64,5,8,40,20);
		break;
		default:
		copyXPMArea(71,15,5,8,40,20);
		break;
		} //end of switch

	fan1temp3 = fan1temp3 * 100;
	fan1temp4 = fan1temp2 - fan1temp3;
	fan1temp5 = fan1temp4 / 10;

		switch(fan1temp5)
		{
		case 0:
		copyXPMArea(1,64,5,8,46,20);
		break;
		case 1:
		copyXPMArea(7,64,5,8,46,20);
		break;
		case 2:
		copyXPMArea(13,64,5,8,46,20);
		break;
		case 3:
		copyXPMArea(19,64,5,8,46,20);
		break;
		case 4:
		copyXPMArea(25,64,5,8,46,20);
		break;
		case 5:
		copyXPMArea(31,64,5,8,46,20);
		break;
		case 6:
		copyXPMArea(37,64,5,8,46,20);
		break;
		case 7:
		copyXPMArea(43,64,5,8,46,20);
		break;
		case 8:
		copyXPMArea(49,64,5,8,46,20);
		break;
		case 9:
		copyXPMArea(55,64,5,8,46,20);
		break;
		default:
		copyXPMArea(71,15,5,8,46,20);
		} //end of switch

	fan1temp5 = fan1temp5 * 10;
	fan1temp6 = fan1temp4 - fan1temp5;

		switch(fan1temp6)
		{
		case 0:
		copyXPMArea(1,64,5,8,52,20);
		break;
		case 1:
		copyXPMArea(7,64,5,8,52,20);
		break;
		case 2:
		copyXPMArea(13,64,5,8,52,20);
		break;
		case 3:
		copyXPMArea(19,64,5,8,52,20);
		break;
		case 4:
		copyXPMArea(25,64,5,8,52,20);
		break;
		case 5:
		copyXPMArea(31,64,5,8,52,20);
		break;
		case 6:
		copyXPMArea(37,64,5,8,52,20);
		break;
		case 7:
		copyXPMArea(43,64,5,8,52,20);
		break;
		case 8:
		copyXPMArea(49,64,5,8,52,20);
		break;
		case 9:
		copyXPMArea(55,64,5,8,52,20);
		break;
		default:
		copyXPMArea(71,15,5,8,52,20);
		break;
		} //end of switch

	} //end of if

	else
	{
		copyXPMArea(1,64,5,8,34,20);
		copyXPMArea(1,64,5,8,40,20);
		copyXPMArea(1,64,5,8,46,20);
		copyXPMArea(1,64,5,8,52,20);
	}

} //end of showFan1in2

void showFan1in3()
{
	//copy '1'
	copyXPMArea(7,64,5,8,24,33);

	if(fan1 < 9999 && fan1 > 0)
	{
		fan1temp1 = fan1 / 1000;
		switch(fan1temp1)
		{
		case 1:
		copyXPMArea(7,64,5,8,34,34);
		break;
		case 2:
		copyXPMArea(13,64,5,8,34,34);
		break;
		case 3:
		copyXPMArea(19,64,5,8,34,34);
		break;
		case 4:
		copyXPMArea(25,64,5,8,34,34);
		break;
		case 5:
		copyXPMArea(31,64,5,8,34,34);
		break;
		case 6:
		copyXPMArea(37,64,5,8,34,34);
		break;
		case 7:
		copyXPMArea(43,64,5,8,34,34);
		break;
		case 8:
		copyXPMArea(49,64,5,8,34,34);
		break;
		default:
		copyXPMArea(71,15,5,8,34,34);
		break;
		} //end of switch

	fan1temp1 = fan1temp1 * 1000;
	fan1temp2 = fan1 - fan1temp1;
	fan1temp3 = fan1temp2 / 100;

		switch(fan1temp3)
		{
		case 0:
		copyXPMArea(1,64,5,8,40,34);
		break;
		case 1:
		copyXPMArea(7,64,5,8,40,34);
		break;
		case 2:
		copyXPMArea(13,64,5,8,40,34);
		break;
		case 3:
		copyXPMArea(19,64,5,8,40,34);
		break;
		case 4:
		copyXPMArea(25,64,5,8,40,34);
		break;
		case 5:
		copyXPMArea(31,64,5,8,40,34);
		break;
		case 6:
		copyXPMArea(37,64,5,8,40,34);
		break;
		case 7:
		copyXPMArea(43,64,5,8,40,34);
		break;
		case 8:
		copyXPMArea(49,64,5,8,40,34);
		break;
		case 9:
		copyXPMArea(55,64,5,8,40,34);
		break;
		default:
		copyXPMArea(71,15,5,8,40,34);
		break;
		} //end of switch

	fan1temp3 = fan1temp3 * 100;
	fan1temp4 = fan1temp2 - fan1temp3;
	fan1temp5 = fan1temp4 / 10;

		switch(fan1temp5)
		{
		case 0:
		copyXPMArea(1,64,5,8,46,34);
		break;
		case 1:
		copyXPMArea(7,64,5,8,46,34);
		break;
		case 2:
		copyXPMArea(13,64,5,8,46,34);
		break;
		case 3:
		copyXPMArea(19,64,5,8,46,34);
		break;
		case 4:
		copyXPMArea(25,64,5,8,46,34);
		break;
		case 5:
		copyXPMArea(31,64,5,8,46,34);
		break;
		case 6:
		copyXPMArea(37,64,5,8,46,34);
		break;
		case 7:
		copyXPMArea(43,64,5,8,46,34);
		break;
		case 8:
		copyXPMArea(49,64,5,8,46,34);
		break;
		case 9:
		copyXPMArea(55,64,5,8,46,34);
		break;
		default:
		copyXPMArea(71,15,5,8,46,34);
		} //end of switch

	fan1temp5 = fan1temp5 * 10;
	fan1temp6 = fan1temp4 - fan1temp5;

		switch(fan1temp6)
		{
		case 0:
		copyXPMArea(1,64,5,8,52,34);
		break;
		case 1:
		copyXPMArea(7,64,5,8,52,34);
		break;
		case 2:
		copyXPMArea(13,64,5,8,52,34);
		break;
		case 3:
		copyXPMArea(19,64,5,8,52,34);
		break;
		case 4:
		copyXPMArea(25,64,5,8,52,34);
		break;
		case 5:
		copyXPMArea(31,64,5,8,52,34);
		break;
		case 6:
		copyXPMArea(37,64,5,8,52,34);
		break;
		case 7:
		copyXPMArea(43,64,5,8,52,34);
		break;
		case 8:
		copyXPMArea(49,64,5,8,52,34);
		break;
		case 9:
		copyXPMArea(55,64,5,8,52,34);
		break;
		default:
		copyXPMArea(71,15,5,8,52,34);
		break;
		} //end of switch

	} //end of if

	else
	{
		copyXPMArea(1,64,5,8,34,34);
		copyXPMArea(1,64,5,8,40,34);
		copyXPMArea(1,64,5,8,46,34);
		copyXPMArea(1,64,5,8,52,34);
	}
}

void showFan1in4()
{
	//copy '1'
	copyXPMArea(7,64,5,8,24,46);

	if(fan1 < 9999 && fan1 > 0)
	{
		fan1temp1 = fan1 / 1000;
		switch(fan1temp1)
		{
		case 1:
		copyXPMArea(7,64,5,8,34,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,34,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,34,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,34,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,34,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,34,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,34,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,34,46);
		break;
		default:
		copyXPMArea(71,15,5,8,34,46);
		break;
		} //end of switch

	fan1temp1 = fan1temp1 * 1000;
	fan1temp2 = fan1 - fan1temp1;
	fan1temp3 = fan1temp2 / 100;

		switch(fan1temp3)
		{
		case 0:
		copyXPMArea(1,64,5,8,40,46);
		break;
		case 1:
		copyXPMArea(7,64,5,8,40,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,40,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,40,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,40,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,40,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,40,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,40,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,40,46);
		break;
		case 9:
		copyXPMArea(55,64,5,8,40,46);
		break;
		default:
		copyXPMArea(71,15,5,8,40,46);
		break;
		} //end of switch

	fan1temp3 = fan1temp3 * 100;
	fan1temp4 = fan1temp2 - fan1temp3;
	fan1temp5 = fan1temp4 / 10;

		switch(fan1temp5)
		{
		case 0:
		copyXPMArea(1,64,5,8,46,46);
		break;
		case 1:
		copyXPMArea(7,64,5,8,46,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,46,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,46,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,46,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,46,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,46,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,46,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,46,46);
		break;
		case 9:
		copyXPMArea(55,64,5,8,46,46);
		break;
		default:
		copyXPMArea(71,15,5,8,46,46);
		} //end of switch

	fan1temp5 = fan1temp5 * 10;
	fan1temp6 = fan1temp4 - fan1temp5;

		switch(fan1temp6)
		{
		case 0:
		copyXPMArea(1,64,5,8,52,46);
		break;
		case 1:
		copyXPMArea(7,64,5,8,52,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,52,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,52,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,52,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,52,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,52,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,52,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,52,46);
		break;
		case 9:
		copyXPMArea(55,64,5,8,52,46);
		break;
		default:
		copyXPMArea(71,15,5,8,52,46);
		break;
		} //end of switch

	} //end of if

	else
	{
		copyXPMArea(1,64,5,8,34,46);
		copyXPMArea(1,64,5,8,40,46);
		copyXPMArea(1,64,5,8,46,46);
		copyXPMArea(1,64,5,8,52,46);
	}
}

void showFan2in3()
{
	if(fan2 < 9999 && fan2  > 0)
	{
		fan2temp1 = fan2 / 1000;
		switch(fan2temp1)
		{
		case 1:
		copyXPMArea(7,64,5,8,34,33);
		break;
		case 2:
		copyXPMArea(13,64,5,8,34,33);
		break;
		case 3:
		copyXPMArea(19,64,5,8,34,33);
		break;
		case 4:
		copyXPMArea(25,64,5,8,34,33);
		break;
		case 5:
		copyXPMArea(31,64,5,8,34,33);
		break;
		case 6:
		copyXPMArea(37,64,5,8,34,33);
		break;
		case 7:
		copyXPMArea(43,64,5,8,34,33);
		break;
		case 8:
		copyXPMArea(49,64,5,8,34,33);
		break;
		case 9:
		copyXPMArea(55,64,5,8,34,33);
		break;
		default:
		copyXPMArea(71,15,5,8,34,33);
		break;
		} //end of switch

	fan2temp1 = fan2temp1 * 1000;
	fan2temp2 = fan2 - fan2temp1;
	fan2temp3 = fan2temp2 / 100;

		switch(fan2temp3)
		{
		case 0:
		copyXPMArea(1,64,5,8,40,33);
		break;
		case 1:
		copyXPMArea(7,64,5,8,40,33);
		break;
		case 2:
		copyXPMArea(13,64,5,8,40,33);
		break;
		case 3:
		copyXPMArea(19,64,5,8,40,33);
		break;
		case 4:
		copyXPMArea(25,64,5,8,40,33);
		break;
		case 5:
		copyXPMArea(31,64,5,8,40,33);
		break;
		case 6:
		copyXPMArea(37,64,5,8,40,33);
		break;
		case 7:
		copyXPMArea(43,64,5,8,40,33);
		break;
		case 8:
		copyXPMArea(49,64,5,8,40,33);
		break;
		case 9:
		copyXPMArea(55,64,5,8,40,33);
		break;
		default:
		copyXPMArea(71,15,5,8,40,33);
		break;
		} //end of switch

	fan2temp3 = fan2temp3 * 100;
	fan2temp4 = fan2temp2 - fan2temp3;
	fan2temp5 = fan2temp4 / 10;

		switch(fan2temp5)
		{
		case 0:
		copyXPMArea(1,64,5,8,46,33);
		break;
		case 1:
		copyXPMArea(7,64,5,8,46,33);
		break;
		case 2:
		copyXPMArea(13,64,5,8,46,33);
		break;
		case 3:
		copyXPMArea(19,64,5,8,46,33);
		break;
		case 4:
		copyXPMArea(25,64,5,8,46,33);
		break;
		case 5:
		copyXPMArea(31,64,5,8,46,33);
		break;
		case 6:
		copyXPMArea(37,64,5,8,46,33);
		break;
		case 7:
		copyXPMArea(43,64,5,8,46,33);
		break;
		case 8:
		copyXPMArea(49,64,5,8,46,33);
		break;
		case 9:
		copyXPMArea(55,64,5,8,46,33);
		break;
		default:
		copyXPMArea(71,15,5,8,46,33);
		break;
		} //end of switch

	fan2temp5 = fan2temp5 * 10;
	fan2temp6 = fan2temp4 - fan2temp5;

		switch(fan2temp6)
		{
		case 0:
		copyXPMArea(1,64,5,8,52,33);
		break;
		case 1:
		copyXPMArea(7,64,5,8,52,33);
		break;
		case 2:
		copyXPMArea(13,64,5,8,52,33);
		break;
		case 3:
		copyXPMArea(19,64,5,8,52,33);
		break;
		case 4:
		copyXPMArea(25,64,5,8,52,33);
		break;
		case 5:
		copyXPMArea(31,64,5,8,52,33);
		break;
		case 6:
		copyXPMArea(37,64,5,8,52,33);
		break;
		case 7:
		copyXPMArea(43,64,5,8,52,33);
		break;
		case 8:
		copyXPMArea(49,64,5,8,52,33);
		break;
		case 9:
		copyXPMArea(55,64,5,8,52,33);
		break;
		default:
		copyXPMArea(71,15,5,8,52,33);
		break;
		} //end of switch

	} //end of if
	else
	{
		copyXPMArea(1,64,5,8,34,33);
		copyXPMArea(1,64,5,8,40,33);
		copyXPMArea(1,64,5,8,46,33);
		copyXPMArea(1,64,5,8,52,33);
	}
} //end of showFan2in3

void showFan2in4()
{
	//copy '2'
	copyXPMArea(13,64,5,8,24,46);

	if(fan2 < 9999 && fan2  > 0)
	{
	
		fan2temp1 = fan2 / 1000;
		switch(fan2temp1)
		{
		case 1:
		copyXPMArea(7,64,5,8,34,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,34,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,34,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,34,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,34,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,34,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,34,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,34,46);
		break;
		case 9:
		copyXPMArea(55,64,5,8,34,46);
		break;
		default:
		copyXPMArea(71,15,5,8,34,46);
		break;
		} //end of switch

	fan2temp1 = fan2temp1 * 1000;
	fan2temp2 = fan2 - fan2temp1;
	fan2temp3 = fan2temp2 / 100;

		switch(fan2temp3)
		{
		case 0:
		copyXPMArea(1,64,5,8,40,46);
		break;
		case 1:
		copyXPMArea(7,64,5,8,40,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,40,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,40,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,40,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,40,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,40,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,40,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,40,46);
		break;
		case 9:
		copyXPMArea(55,64,5,8,40,46);
		break;
		default:
		copyXPMArea(71,15,5,8,40,46);
		break;
		} //end of switch

	fan2temp3 = fan2temp3 * 100;
	fan2temp4 = fan2temp2 - fan2temp3;
	fan2temp5 = fan2temp4 / 10;

		switch(fan2temp5)
		{
		case 0:
		copyXPMArea(1,64,5,8,46,46);
		break;
		case 1:
		copyXPMArea(7,64,5,8,46,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,46,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,46,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,46,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,46,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,46,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,46,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,46,46);
		break;
		case 9:
		copyXPMArea(55,64,5,8,46,46);
		break;
		default:
		copyXPMArea(71,15,5,8,46,46);
		break;
		} //end of switch

	fan2temp5 = fan2temp5 * 10;
	fan2temp6 = fan2temp4 - fan2temp5;

		switch(fan2temp6)
		{
		case 0:
		copyXPMArea(1,64,5,8,52,46);
		break;
		case 1:
		copyXPMArea(7,64,5,8,52,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,52,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,52,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,52,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,52,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,52,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,52,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,52,46);
		break;
		case 9:
		copyXPMArea(55,64,5,8,52,46);
		break;
		default:
		copyXPMArea(71,15,5,8,52,46);
		break;
		} //end of switch

	} //end of if
	else
	{
		copyXPMArea(1,64,5,8,34,46);
		copyXPMArea(1,64,5,8,40,46);
		copyXPMArea(1,64,5,8,46,46);
		copyXPMArea(1,64,5,8,52,46);
	}

} //end of showFan2in4

void showFan3in3()
{
	//copy '3'
	copyXPMArea(19,64,5,8,24,33);

	if(fan3 < 9999 && fan3 > 0)
	{
		fan3temp1 = fan3 / 1000;
		switch(fan3temp1)
		{
		case 1:
		copyXPMArea(7,64,5,8,34,34);
		break;
		case 2:
		copyXPMArea(13,64,5,8,34,34);
		break;
		case 3:
		copyXPMArea(19,64,5,8,34,34);
		break;
		case 4:
		copyXPMArea(25,64,5,8,34,34);
		break;
		case 5:
		copyXPMArea(31,64,5,8,34,34);
		break;
		case 6:
		copyXPMArea(37,64,5,8,34,34);
		break;
		case 7:
		copyXPMArea(43,64,5,8,34,34);
		break;
		case 8:
		copyXPMArea(49,64,5,8,34,34);
		break;
		case 9:
		copyXPMArea(55,64,5,8,34,34);
		break;
		default:
		copyXPMArea(71,15,5,8,34,34);
		break;
		} //end of switch

	fan3temp1 = fan3temp1 * 1000;
	fan3temp2 = fan3 - fan3temp1;
	fan3temp3 = fan3temp2 / 100;

		switch(fan3temp3)
		{
		case 0:
		copyXPMArea(1,64,5,8,40,34);
		break;
		case 1:
		copyXPMArea(7,64,5,8,40,34);
		break;
		case 2:
		copyXPMArea(13,64,5,8,40,34);
		break;
		case 3:
		copyXPMArea(19,64,5,8,40,34);
		break;
		case 4:
		copyXPMArea(25,64,5,8,40,34);
		break;
		case 5:
		copyXPMArea(31,64,5,8,40,34);
		break;
		case 6:
		copyXPMArea(37,64,5,8,40,34);
		break;
		case 7:
		copyXPMArea(43,64,5,8,40,34);
		break;
		case 8:
		copyXPMArea(49,64,5,8,40,34);
		break;
		case 9:
		copyXPMArea(55,64,5,8,40,34);
		break;
		default:
		copyXPMArea(71,15,5,8,40,34);
		break;
		} //end of switch

	fan3temp3 = fan3temp3 * 100;
	fan3temp4 = fan3temp2 - fan3temp3;
	fan3temp5 = fan3temp4 / 10;

		switch(fan3temp5)
		{
		case 0:
		copyXPMArea(1,64,5,8,46,34);
		break;
		case 1:
		copyXPMArea(7,64,5,8,46,34);
		break;
		case 2:
		copyXPMArea(13,64,5,8,46,34);
		break;
		case 3:
		copyXPMArea(19,64,5,8,46,34);
		break;
		case 4:
		copyXPMArea(25,64,5,8,46,34);
		break;
		case 5:
		copyXPMArea(31,64,5,8,46,34);
		break;
		case 6:
		copyXPMArea(37,64,5,8,46,34);
		break;
		case 7:
		copyXPMArea(43,64,5,8,46,34);
		break;
		case 8:
		copyXPMArea(49,64,5,8,46,34);
		break;
		case 9:
		copyXPMArea(55,64,5,8,46,34);
		break;
		default:
		copyXPMArea(71,15,5,8,46,46);
		break;
		} //end of switch

	fan3temp5 = fan3temp5 * 10;
	fan3temp6 = fan3temp4 - fan3temp5;

		switch(fan3temp6)
		{
		case 0:
		copyXPMArea(1,64,5,8,52,34);
		break;
		case 1:
		copyXPMArea(7,64,5,8,52,34);
		break;
		case 2:
		copyXPMArea(13,64,5,8,52,34);
		break;
		case 3:
		copyXPMArea(19,64,5,8,52,34);
		break;
		case 4:
		copyXPMArea(25,64,5,8,52,34);
		break;
		case 5:
		copyXPMArea(31,64,5,8,52,34);
		break;
		case 6:
		copyXPMArea(37,64,5,8,52,34);
		break;
		case 7:
		copyXPMArea(43,64,5,8,52,34);
		break;
		case 8:
		copyXPMArea(49,64,5,8,52,34);
		break;
		case 9:
		copyXPMArea(55,64,5,8,52,34);
		break;
		default:
		copyXPMArea(71,15,5,8,52,34);
		break;
		} //end of switch
	}//end of if
	else
	{
		copyXPMArea(1,64,5,8,34,34);
		copyXPMArea(1,64,5,8,40,34);
		copyXPMArea(1,64,5,8,46,34);
		copyXPMArea(1,64,5,8,52,34);
	}
} //end of showFan3in3

void showFan3in4()
{
	if(fan3 < 9999 && fan3 > 0)
	{
		fan3temp1 = fan3 / 1000;
		switch(fan3temp1)
		{
		case 1:
		copyXPMArea(7,64,5,8,34,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,34,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,34,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,34,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,34,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,34,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,34,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,34,46);
		break;
		case 9:
		copyXPMArea(55,64,5,8,34,46);
		break;
		default:
		copyXPMArea(71,15,5,8,34,46);
		break;
		} //end of switch

	fan3temp1 = fan3temp1 * 1000;
	fan3temp2 = fan3 - fan3temp1;
	fan3temp3 = fan3temp2 / 100;

		switch(fan3temp3)
		{
		case 0:
		copyXPMArea(1,64,5,8,40,46);
		break;
		case 1:
		copyXPMArea(7,64,5,8,40,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,40,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,40,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,40,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,40,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,40,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,40,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,40,46);
		break;
		case 9:
		copyXPMArea(55,64,5,8,40,46);
		break;
		default:
		copyXPMArea(71,15,5,8,40,46);
		break;
		} //end of switch

	fan3temp3 = fan3temp3 * 100;
	fan3temp4 = fan3temp2 - fan3temp3;
	fan3temp5 = fan3temp4 / 10;

		switch(fan3temp5)
		{
		case 0:
		copyXPMArea(1,64,5,8,46,46);
		break;
		case 1:
		copyXPMArea(7,64,5,8,46,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,46,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,46,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,46,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,46,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,46,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,46,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,46,46);
		break;
		case 9:
		copyXPMArea(55,64,5,8,46,46);
		break;
		default:
		copyXPMArea(71,15,5,8,46,46);
		break;
		} //end of switch

	fan3temp5 = fan3temp5 * 10;
	fan3temp6 = fan3temp4 - fan3temp5;

		switch(fan3temp6)
		{
		case 0:
		copyXPMArea(1,64,5,8,52,46);
		break;
		case 1:
		copyXPMArea(7,64,5,8,52,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,52,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,52,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,52,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,52,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,52,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,52,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,52,46);
		break;
		case 9:
		copyXPMArea(55,64,5,8,52,46);
		break;
		default:
		copyXPMArea(71,15,5,8,52,46);
		break;
		} //end of switch
	}//end of if
	else
	{
		copyXPMArea(1,64,5,8,34,46);
		copyXPMArea(1,64,5,8,40,46);
		copyXPMArea(1,64,5,8,46,46);
		copyXPMArea(1,64,5,8,52,46);
	}
} //end of showFan3in4
