/***************************************************

 asfatm (AfterStep Fan and Temperature Monitor)
	 ver 0.39a 

***************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <sensors/sensors.h>
#include <sensors/chips.h>
#include <sensors/error.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "../wmgeneral/wmgeneral.h"
#include "../wmgeneral/misc.h"

#include "lmse_master.xpm"
#include "lmse_mask.xbm"

#define LM78 1
#define LM78J 2
#define LM79 3
#define LM80 4

/*******************************
NOT WORKING ON THESE RIGHT NOW
//#define W83781D 5
//#define W83782D 6
//#define W83783S 7
********************************/

#define TRUE 1
#define FALSE 0

#define VERSION "0.39a"

int c;

void asfatmUsage(void);

int main(int argc, char **argv)
{

	XEvent Event;

	int chips_nr = 0;
	int nr = 0;
	int configFileFound;
	FILE *theConfigFile;
	const sensors_chip_name *name;
	const sensors_chip_name *secondary;

	double fan1 = 0;
	double fan2 = 0;
	double fan3 = 0;
	double temp1 = 0;
	double temp2 = 0;

	int temptemp1; //temporary temperature variable
	int temptemp2; //another

	int temp2temp1;
	int temp2temp2;

	int fan1temp1;
	int fan1temp2;
	int fan1temp3;
	int fan1temp4;
	int fan1temp5;
	int fan1temp6;

	int fan2temp1;
	int fan2temp2;
	int fan2temp3;
	int fan2temp4;
	int fan2temp5;
	int fan2temp6;

	int fan3temp1;
	int fan3temp2;
	int fan3temp3;
	int fan3temp4;
	int fan3temp5;
	int fan3temp6;

	int chiptype = -1;	
	//char *temp;

	int endOfList = FALSE;
	int haslm75 = FALSE;
	int uselm75 = FALSE;
	int beVerbose = FALSE;

	int detectedChiptype = -1;

	for(c=1;c<argc;c++)
	{
	if(argv[c] == NULL)
	{}
	else if(!strcmp(argv[c], "-v"))
	{
	printf("\nasfatm version %s\n\n", VERSION);
	exit(0);
	}
	else if(!strcmp(argv[c], "--help"))
	{
	asfatmUsage();
	exit(0);
	}
	else if(!strcmp(argv[c], "-help"))
	{
	asfatmUsage();
	exit(0);
	}
	else if(!strcmp(argv[c], "-cpu"))
	{
	uselm75 = TRUE;
	}
	else if(!strcmp(argv[c], "-verbose"))
	{
	beVerbose = TRUE;
	}
	else
	{
	printf("\nillegal option\n\n");
	asfatmUsage();
	exit(0);
	}
	} //end of for

	theConfigFile = fopen("/etc/sensors.conf", "r");
	//theConfigFile will return 0 if it can't open sensors.conf
	if(theConfigFile != 0)
	{
	configFileFound = sensors_init(theConfigFile);
	fclose(theConfigFile);
	
	if(configFileFound == 0)
	{
	while(endOfList == FALSE)
	{
	name = sensors_get_detected_chips(&chips_nr);
	if(!strcmp(name->prefix, SENSORS_LM75_PREFIX))
	{
	haslm75 = TRUE;
	//secondary becomes lm75
	secondary = sensors_get_detected_chips(&chips_nr);
	++nr;
	chips_nr = nr;
	}
	else if(!strcmp(name->prefix, SENSORS_LM80_PREFIX))
	{
	chiptype = LM80;
	detectedChiptype = nr;
	++nr;
	chips_nr = nr;
	}
	else if(!strcmp(name->prefix, SENSORS_LM78J_PREFIX))
	{
	chiptype = LM78J;
	detectedChiptype = nr;
	++nr;
	chips_nr = nr;
	}
	else if(!strcmp(name->prefix, SENSORS_LM78_PREFIX))
	{
	chiptype = LM78;
	detectedChiptype = nr;
	++nr;
	chips_nr = nr;
	}
	else if(!strcmp(name->prefix, SENSORS_LM79_PREFIX))
	{
	chiptype = LM79;
	detectedChiptype = nr;
	++nr;
	chips_nr = nr;
	}
	//sloppy, but gets all chips detected for now I think
	else if(!strcmp(name->prefix, "eeprom"))
	{
	endOfList = TRUE;
	++nr;
	chips_nr = nr;
	} //end of else if eeprom
	if(beVerbose == TRUE)
	fprintf(stderr, "%i: %s\n", nr, name->prefix);
	} //end of while endOfList
	name = sensors_get_detected_chips(&detectedChiptype);
	if(beVerbose == TRUE)
	{
	fprintf(stderr, "Detected Chiptype: %i\n", detectedChiptype);
	fprintf(stderr, "Chiptype: %i\n", chiptype);
	fprintf(stderr, "Chipname: %s\n", name->prefix);
	switch(haslm75)
	{
	case FALSE:
	fprintf(stderr, "an lm75 was not detected.\n");
	break;
	case TRUE:
	fprintf(stderr, "an lm75 was detected.\n");
	break;
	} //end of switch
	} //end of if beVerbose
	} //end of if configFileFound
	else
	{
	printf("could not initialize '/etc/sensors.conf' properly .. exiting.");
	exit(0);
	}
	} //end of if theConfigFile
	else
	{
	printf("\ncould not find '/etc/sensors.conf' .. exiting.\n\n");
	exit(0);
	}

	openXwindow(argc, argv, lmse_master_xpm, lmse_mask_bits, lmse_mask_width, lmse_mask_height);

	if(chiptype == -1)
	{
	printf("\nno supported chipsets found.\n\n");
	exit(0);
	}
	else if(chiptype != -1)
	{
	while(1)
	{
		while(XPending(display))
		{
		XNextEvent(display, &Event);
		switch(Event.type)
		{
		case Expose:
			RedrawWindow();
			break;
		case DestroyNotify:
			XCloseDisplay(display);
			exit(0);
			break;
		}
		} //end of while XPending

	if((chiptype == LM78 || chiptype == LM78J) || chiptype == LM79)
	{
	sensors_get_feature(*name, SENSORS_LM78_FAN3, &fan3);
	sensors_get_feature(*name, SENSORS_LM78_FAN2, &fan2);
	sensors_get_feature(*name, SENSORS_LM78_FAN1, &fan1);
	sensors_get_feature(*name, SENSORS_LM78_TEMP, &temp1);
	}
	else if(chiptype == LM80)
	{
	sensors_get_feature(*name, SENSORS_LM80_FAN2, &fan2);
	sensors_get_feature(*name, SENSORS_LM80_FAN1, &fan1);
	sensors_get_feature(*name, SENSORS_LM80_TEMP, &temp1);
	}
	else
	{
	fprintf(stderr, "No supported chipsets found .. exiting.\n");
	exit(0);
	}

	if(haslm75 == TRUE)
	{
	sensors_get_feature(*secondary, SENSORS_LM75_TEMP, &temp2);
	}
/*******************************************************************
TEMPORARILY DISCONTINUING DEVELOPMENT WITH THESE CHIPSETS

	else if(chiptype == W83781D)
	{
	sensors_get_feature(*name, SENSORS_W83781D_FAN3, &fan3);
	sensors_get_feature(*name, SENSORS_W83781D_FAN2, &fan2);
	sensors_get_feature(*name, SENSORS_W83781D_FAN1, &fan1);
	sensors_get_feature(*name, SENSORS_W83781D_TEMP1, &temp1);
	}
	else if(chiptype == W83782D)
	{
	sensors_get_feature(*name, SENSORS_W83782D_FAN3, &fan3);
	sensors_get_feature(*name, SENSORS_W83782D_FAN2, &fan2);
	sensors_get_feature(*name, SENSORS_W83782D_FAN1, &fan1);
	sensors_get_feature(*name, SENSORS_W83782D_TEMP1, &temp1);
	}
	else if(chiptype == W83783S)
	{
	sensors_get_feature(*name, SENSORS_W83783S_FAN3, &fan3);
	sensors_get_feature(*name, SENSORS_W83783S_FAN2, &fan2);
	sensors_get_feature(*name, SENSORS_W83783S_FAN1, &fan1);
	sensors_get_feature(*name, SENSORS_W83783S_TEMP1, &temp1);
	}
**********************************************************************/

	// display cpu temp instead of system temp

	if(haslm75 == TRUE && uselm75 == TRUE)
	{
	if(temp2 < 99 && temp2 > 0)
	{
	//copy 'CPU1' over 'TEMP'
	copyXPMArea(51,6,5,8,6,6);
	copyXPMArea(71,65,5,8,12,6);
	copyXPMArea(71,5,5,8,18,6);
	copyXPMArea(7,65,5,8,24,6);
	
	temp2temp1 = temp2 / 10;
		switch(temp2temp1)
		{
		case 0:
		copyXPMArea(1,64,5,8,36,5);
		break;
		case 1:
		copyXPMArea(7,64,5,8,36,5);
		break;
		case 2:
		copyXPMArea(13,64,5,8,36,5);
		break;
		case 3:
		copyXPMArea(19,64,5,8,36,5);
		break;
		case 4:
		copyXPMArea(25,64,5,8,36,5);
		break;
		case 5:
		copyXPMArea(31,64,5,8,36,5);
		break;
		case 6:
		copyXPMArea(37,64,5,8,36,5);
		break;
		case 7:
		copyXPMArea(43,64,5,8,36,5);
		break;
		case 8:
		copyXPMArea(49,64,5,8,36,5);
		break;
		case 9:
		copyXPMArea(55,64,5,8,36,5);
		break;
		default:
		copyXPMArea(71,15,5,8,36,5);
		break;
		} //end of switch

	temp2temp1 = temp2temp1*10;
	temp2temp2 = temp2-temp2temp1;

		switch(temp2temp2)
		{
		case 0:
		copyXPMArea(1,64,5,8,42,5);
		break;
		case 1:
		copyXPMArea(7,64,5,8,42,5);
		break;
		case 2:
		copyXPMArea(13,64,5,8,42,5);
		break;
		case 3:
		copyXPMArea(19,64,5,8,42,5);
		break;
		case 4:
		copyXPMArea(25,64,5,8,42,5);
		break;
		case 5:
		copyXPMArea(31,64,5,8,42,5);
		break;
		case 6:
		copyXPMArea(37,64,5,8,42,5);
		break;
		case 7:
		copyXPMArea(43,64,5,8,42,5);
		break;
		case 8:
		copyXPMArea(49,64,5,8,42,5);
		break;
		case 9:
		copyXPMArea(55,64,5,8,42,5);
		break;
		default:
		copyXPMArea(71,15,5,8,42,5);
		break;
		} //end of switch
				
	} //end of and if temp2 < 99 > 0
	else
	{
	copyXPMArea(71,15,5,8,36,5);
	copyXPMArea(71,15,5,8,42,5);
	}
	} //end of if has/uselm75 TRUE

	// temperature start

	else
	{
	if(temp1 < 99 && temp1 > 0)
	{
	temptemp1 = temp1/10;
		switch(temptemp1)
		{
		case 0:
		copyXPMArea(1,64,5,8,36,5);
		break;
		case 1:
		copyXPMArea(7,64,5,8,36,5);
		break;
		case 2:
		copyXPMArea(13,64,5,8,36,5);
		break;
		case 3:
		copyXPMArea(19,64,5,8,36,5);
		break;
		case 4:
		copyXPMArea(25,64,5,8,36,5);
		break;
		case 5:
		copyXPMArea(31,64,5,8,36,5);
		break;
		case 6:
		copyXPMArea(37,64,5,8,36,5);
		break;
		case 7:
		copyXPMArea(43,64,5,8,36,5);
		break;
		case 8:
		copyXPMArea(49,64,5,8,36,5);
		break;
		case 9:
		copyXPMArea(55,64,5,8,36,5);
		break;
		default:
		copyXPMArea(71,15,5,8,36,5);
		break;
		} //end of switch

	temptemp1 = temptemp1*10;
	temptemp2 = temp1-temptemp1;

	switch(temptemp2)
	{
		case 0:
		copyXPMArea(1,64,5,8,42,5);
		break;
		case 1:
		copyXPMArea(7,64,5,8,42,5);
		break;
		case 2:
		copyXPMArea(13,64,5,8,42,5);
		break;
		case 3:
		copyXPMArea(19,64,5,8,42,5);
		break;
		case 4:
		copyXPMArea(25,64,5,8,42,5);
		break;
		case 5:
		copyXPMArea(31,64,5,8,42,5);
		break;
		case 6:
		copyXPMArea(37,64,5,8,42,5);
		break;
		case 7:
		copyXPMArea(43,64,5,8,42,5);
		break;
		case 8:
		copyXPMArea(49,64,5,8,42,5);
		break;
		case 9:
		copyXPMArea(55,64,5,8,42,5);
		break;
		default:
		copyXPMArea(71,15,5,8,42,5);
		break;
	} //end of switch
	} //end of if	
	} //end of else

	// fan1 start

	if(fan1 < 9999 && fan1 > 999)
	{
		fan1temp1 = fan1 / 1000;
		switch(fan1temp1)
		{
		case 1:
		copyXPMArea(7,64,5,8,34,20);
		break;
		case 2:
		copyXPMArea(13,64,5,8,34,20);
		break;
		case 3:
		copyXPMArea(19,64,5,8,34,20);
		break;
		case 4:
		copyXPMArea(25,64,5,8,34,20);
		break;
		case 5:
		copyXPMArea(31,64,5,8,34,20);
		break;
		case 6:
		copyXPMArea(37,64,5,8,34,20);
		break;
		case 7:
		copyXPMArea(43,64,5,8,34,20);
		break;
		case 8:
		copyXPMArea(49,64,5,8,34,20);
		break;
		default:
		copyXPMArea(71,15,5,8,34,20);
		break;
		} //end of switch

	fan1temp1 = fan1temp1*1000;
	fan1temp2 = fan1 - fan1temp1;
	fan1temp3 = fan1temp2/100;

		switch(fan1temp3)
		{
		case 0:
		copyXPMArea(1,64,5,8,40,20);
		break;
		case 1:
		copyXPMArea(7,64,5,8,40,20);
		break;
		case 2:
		copyXPMArea(13,64,5,8,40,20);
		break;
		case 3:
		copyXPMArea(19,64,5,8,40,20);
		break;
		case 4:
		copyXPMArea(25,64,5,8,40,20);
		break;
		case 5:
		copyXPMArea(31,64,5,8,40,20);
		break;
		case 6:
		copyXPMArea(37,64,5,8,40,20);
		break;
		case 7:
		copyXPMArea(43,64,5,8,40,20);
		break;
		case 8:
		copyXPMArea(49,64,5,8,40,20);
		break;
		case 9:
		copyXPMArea(55,64,5,8,40,20);
		break;
		default:
		copyXPMArea(71,15,5,8,40,20);
		break;
		} //end of switch

	fan1temp3 = fan1temp3*100;
	fan1temp4 = fan1temp2 - fan1temp3;
	fan1temp5 = fan1temp4 / 10;

		switch(fan1temp5)
		{
		case 0:
		copyXPMArea(1,64,5,8,46,20);
		break;
		case 1:
		copyXPMArea(7,64,5,8,46,20);
		break;
		case 2:
		copyXPMArea(13,64,5,8,46,20);
		break;
		case 3:
		copyXPMArea(19,64,5,8,46,20);
		break;
		case 4:
		copyXPMArea(25,64,5,8,46,20);
		break;
		case 5:
		copyXPMArea(31,64,5,8,46,20);
		break;
		case 6:
		copyXPMArea(37,64,5,8,46,20);
		break;
		case 7:
		copyXPMArea(43,64,5,8,46,20);
		break;
		case 8:
		copyXPMArea(49,64,5,8,46,20);
		break;
		case 9:
		copyXPMArea(55,64,5,8,46,20);
		break;
		default:
		copyXPMArea(71,15,5,8,46,20);
		} // end of switch

	fan1temp5 = fan1temp5*10;
	fan1temp6 = fan1temp4 - fan1temp5;

		switch(fan1temp6)
		{
		case 0:
		copyXPMArea(1,64,5,8,52,20);
		break;
		case 1:
		copyXPMArea(7,64,5,8,52,20);
		break;
		case 2:
		copyXPMArea(13,64,5,8,52,20);
		break;
		case 3:
		copyXPMArea(19,64,5,8,52,20);
		break;
		case 4:
		copyXPMArea(25,64,5,8,52,20);
		break;
		case 5:
		copyXPMArea(31,64,5,8,52,20);
		break;
		case 6:
		copyXPMArea(37,64,5,8,52,20);
		break;
		case 7:
		copyXPMArea(43,64,5,8,52,20);
		break;
		case 8:
		copyXPMArea(49,64,5,8,52,20);
		break;
		case 9:
		copyXPMArea(55,64,5,8,52,20);
		break;
		default:
		copyXPMArea(71,15,5,8,52,20);
		break;
		} //end of switch

	} //end of if

	//if fan rpm is less than 1000 probably don't have one, display N/A

	else if(fan1 < 1000 || fan1 > 9999)
	{
		copyXPMArea(71,54,5,8,34,20);
		copyXPMArea(71,25,5,8,40,20);
		copyXPMArea(71,35,5,8,46,20);
		copyXPMArea(71,45,5,8,52,20);
	}

	// fan2 start

	if(fan2<9999 && fan2>999)
	{
		fan2temp1 = fan2 / 1000;
		switch(fan2temp1)
		{
		case 1:
		copyXPMArea(7,64,5,8,34,34);
		break;
		case 2:
		copyXPMArea(13,64,5,8,34,34);
		break;
		case 3:
		copyXPMArea(19,64,5,8,34,34);
		break;
		case 4:
		copyXPMArea(25,64,5,8,34,34);
		break;
		case 5:
		copyXPMArea(31,64,5,8,34,34);
		break;
		case 6:
		copyXPMArea(37,64,5,8,34,34);
		break;
		case 7:
		copyXPMArea(43,64,5,8,34,34);
		break;
		case 8:
		copyXPMArea(49,64,5,8,34,34);
		break;
		case 9:
		copyXPMArea(55,64,5,8,34,34);
		break;
		default:
		copyXPMArea(71,15,5,8,34,34);
		break;
		} //end of switch

	fan2temp1 = fan2temp1*1000;
	fan2temp2 = fan2 - fan2temp1;
	fan2temp3 = fan2temp2 / 100;

		switch(fan2temp3)
		{
		case 0:
		copyXPMArea(1,64,5,8,40,34);		
		break;
		case 1:
		copyXPMArea(7,64,5,8,40,34);
		break;
		case 2:
		copyXPMArea(13,64,5,8,40,34);
		break;
		case 3:
		copyXPMArea(19,64,5,8,40,34);
		break;
		case 4:
		copyXPMArea(25,64,5,8,40,34);
		break;
		case 5:
		copyXPMArea(31,64,5,8,40,34);
		break;
		case 6:
		copyXPMArea(37,64,5,8,40,34);
		break;
		case 7:
		copyXPMArea(43,64,5,8,40,34);
		break;
		case 8:
		copyXPMArea(49,64,5,8,40,34);
		break;
		case 9:
		copyXPMArea(55,64,5,8,40,34);
		break;
		default:
		copyXPMArea(71,15,5,8,40,34);
		break;
		} // end of switch

	fan2temp3 = fan2temp3 * 100;
	fan2temp4 = fan2temp2 - fan2temp3;
	fan2temp5 = fan2temp4 / 10;

		switch(fan2temp5)
		{
		case 0:
		copyXPMArea(1,64,5,8,46,34);
		break;
		case 1:
		copyXPMArea(7,64,5,8,46,34);
		break;
		case 2:
		copyXPMArea(13,64,5,8,46,34);
		break;
		case 3:
		copyXPMArea(19,64,5,8,46,34);
		break;
		case 4:
		copyXPMArea(25,64,5,8,46,34);
		break;
		case 5:
		copyXPMArea(31,64,5,8,46,34);
		break;
		case 6:
		copyXPMArea(37,64,5,8,46,34);
		break;
		case 7:
		copyXPMArea(43,64,5,8,46,34);
		break;
		case 8:
		copyXPMArea(49,64,5,8,46,34);
		break;
		case 9:
		copyXPMArea(55,64,5,8,46,34);
		break;
		default:
		copyXPMArea(71,15,5,8,46,34);
		break;
		} //end of switch

	fan2temp5 = fan2temp5 * 10;
	fan2temp6 = fan2temp4 - fan2temp5;

		switch(fan2temp6)
		{
		case 0:
		copyXPMArea(1,64,5,8,52,34);
		break;
		case 1:
		copyXPMArea(7,64,5,8,52,34);
		break;
		case 2:
		copyXPMArea(13,64,5,8,52,34);
		break;
		case 3:
		copyXPMArea(19,64,5,8,52,34);
		break;
		case 4:
		copyXPMArea(25,64,5,8,52,34);
		break;
		case 5:
		copyXPMArea(31,64,5,8,52,34);
		break;
		case 6:
		copyXPMArea(37,64,5,8,52,34);
		break;
		case 7:
		copyXPMArea(43,64,5,8,52,34);
		break;
		case 8:
		copyXPMArea(49,64,5,8,52,34);
		break;
		case 9:
		copyXPMArea(55,64,5,8,52,34);
		break;
		default:
		copyXPMArea(71,15,5,8,52,34);
		break;
		} //end of switch

	} //end of if
	else if(fan2 < 1000 || fan2 > 9999)
	{
		copyXPMArea(71,54,5,8,34,34);
		copyXPMArea(71,25,5,8,40,34);
		copyXPMArea(71,35,5,8,46,34);
		copyXPMArea(71,45,5,8,52,34);
	}

	// fan3 start

	if(fan3<9999 && fan3 > 999)
	{
		fan3temp1 = fan3 / 1000;
		switch(fan3temp1)
		{
		case 1:
		copyXPMArea(7,64,5,8,34,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,34,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,34,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,34,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,34,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,34,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,34,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,34,46);
		break;
		case 9:
		copyXPMArea(55,64,5,8,34,46);
		break;
		default:
		copyXPMArea(71,15,5,8,34,46);
		break;
		} //end of switch

	fan3temp1 = fan3temp1 * 1000;
	fan3temp2 = fan3 - fan3temp1;
	fan3temp3 = fan3temp2 / 100;

		switch(fan3temp3)
		{
		case 0:
		copyXPMArea(1,64,5,8,40,46);
		break;
		case 1:
		copyXPMArea(7,64,5,8,40,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,40,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,40,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,40,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,40,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,40,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,40,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,40,46);
		break;
		case 9:
		copyXPMArea(55,64,5,8,40,46);
		break;
		default:
		copyXPMArea(71,15,5,8,40,46);
		break;
		} //end of switch

	fan3temp3 = fan3temp3 * 100;
	fan3temp4 = fan3temp2 - fan3temp3;
	fan3temp5 = fan3temp4 / 10;

		switch(fan3temp5)
		{
		case 0:
		copyXPMArea(1,64,5,8,46,46);
		break;
		case 1:
		copyXPMArea(7,64,5,8,46,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,46,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,46,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,46,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,46,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,46,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,46,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,46,46);
		break;
		case 9:
		copyXPMArea(55,64,5,8,46,46);
		break;
		default:
		copyXPMArea(71,15,5,8,46,46);
		break;
		} //end of switch

	fan3temp5 = fan3temp5 * 10;
	fan3temp6 = fan3temp4 - fan3temp5;

		switch(fan3temp6)
		{
		case 0:
		copyXPMArea(1,64,5,8,52,46);
		break;
		case 1:
		copyXPMArea(7,64,5,8,52,46);
		break;
		case 2:
		copyXPMArea(13,64,5,8,52,46);
		break;
		case 3:
		copyXPMArea(19,64,5,8,52,46);
		break;
		case 4:
		copyXPMArea(25,64,5,8,52,46);
		break;
		case 5:
		copyXPMArea(31,64,5,8,52,46);
		break;
		case 6:
		copyXPMArea(37,64,5,8,52,46);
		break;
		case 7:
		copyXPMArea(43,64,5,8,52,46);
		break;
		case 8:
		copyXPMArea(49,64,5,8,52,46);
		break;
		case 9:
		copyXPMArea(55,64,5,8,52,46);
		break;
		default:
		copyXPMArea(71,15,5,8,52,46);
		break;
		} //end of switch

	} //end of if

	RedrawWindow();
	usleep(150000);
	} //end of while
	} //end of if for chiptype 

return(0);
}

void asfatmUsage()
{
	printf("Usage:\n\n");
	printf("[-v]    show version and exit\n");
	printf("[-cpu]  show cpu temp instead of system temp\n");
	printf("[-help] show this help\n");
	//printf("[-bth] show reciprocating view of temp AND cpu temp\n");
	printf("\n[-verbose] be verbose\n"); 
	printf("\nasfatm ver. %s\n", VERSION);
}
