#include "xutil.h"

xutil::xutil(int argc, char **argv) {

	mainwidget=XtAppInitialize(&application, "asfaces", NULL, 0, 
					&argc, argv, NULL, NULL, 0);
	XtResizeWidget(mainwidget, 56, 57, 0);
	XtRealizeWidget(mainwidget);

	display=XtDisplay(mainwidget);
	root=RootWindow(display, screennum);
	screennum=DefaultScreen(display);
	mainwin=XtWindow(mainwidget);

	XtMapWidget(mainwidget);

			XGCValues	gcv;
	unsigned	long		gcm;
	
	gcm=GCBackground;
	gcv.background=GetColor("black");
	clearoutgc=XCreateGC(display, root, gcm, &gcv);
	gcm=GCForeground;
	gcv.foreground=GetColor("white");
	lettergc=XCreateGC(display, root, gcm, &gcv);
	gcv.foreground=GetColor("#535353");
	topbordergc=XCreateGC(display, root, gcm, &gcv);
	gcv.foreground=GetColor("#dbdbdb");
	bottombordergc=XCreateGC(display, root, gcm, &gcv);

	font=XLoadQueryFont(display, "-*-helvetica-*-*-*-*-10-240-*-*-*-*-*-*");
	XSetFont(display, lettergc, font->fid);

	char	*nomailfile=new char[strlen(LIBDIR)+12];
	char	*defaultfile=new char[strlen(LIBDIR)+13];
	sprintf(nomailfile,"%s/nomail.xpm",LIBDIR);
	sprintf(defaultfile,"%s/default.xpm",LIBDIR);
	
	CreatePixmap(&nomail, 52, 53);
	CreatePixmap(&def, 52, 53);
	LoadPixmapOntoPixmap(&nomail, nomailfile, 52, 53);
	LoadPixmapOntoPixmap(&def, defaultfile, 52, 53);

	delete[] nomailfile;
	delete[] defaultfile;
}

xutil::~xutil() {

	XFreePixmap(display, nomail);
	XFreePixmap(display, def);
}

void	xutil::AddTimeOut(XtTimerCallbackProc proc, int interval, 
				XtPointer pointer) {

	XtAppAddTimeOut(application, interval, proc, pointer);
}

void	xutil::AddEventHandler(XtEventHandler proc, EventMask mask) {

	XtAddEventHandler(mainwidget, mask, FALSE, proc, NULL);
}

void	xutil::CreatePixmap(Pixmap *pixmap, int height, int width) {

	*pixmap=XCreatePixmap(display, root, height, width, 
				DefaultDepth(display, screennum));

	XFillRectangle(display, *pixmap, clearoutgc, 0, 0, height, width);
}

void	xutil::Border() {
	XDrawLine(display, mainwin, topbordergc, 0, 0, 55, 0);
	XDrawLine(display, mainwin, topbordergc, 1, 1, 54, 1);
	XDrawLine(display, mainwin, topbordergc, 0, 0, 0, 56);
	XDrawLine(display, mainwin, topbordergc, 1, 1, 1, 55);


	XDrawLine(display, mainwin, bottombordergc, 55, 0, 55, 56);
	XDrawLine(display, mainwin, bottombordergc, 54, 1, 54, 55);
	XDrawLine(display, mainwin, bottombordergc, 0, 56, 55, 56);
	XDrawLine(display, mainwin, bottombordergc, 1, 55, 54, 55);

	XFlush(display);
}

Pixel	xutil::GetColor(char *colorname) {

	color.pixel=0;

	XParseColor(display, DefaultColormap(display, screennum), 
			colorname, &color);
	XAllocColor(display, DefaultColormap(display, screennum), &color);

	return color.pixel;
}

void	xutil::LoadPixmapOntoPixmap(Pixmap *pixmap, char *filename, 
					int width, int height) {

	struct	XpmIcon	temppixmap;

	temppixmap.xpmattributes.valuemask=(XpmReturnPixels | 
						XpmReturnExtensions);

	XpmReadFileToPixmap(display, mainwin, filename,
					&temppixmap.pixmap,
					&temppixmap.mask,
					&temppixmap.xpmattributes);

	XFillRectangle(display, *pixmap, clearoutgc, 0, 0, width, height);

	int	x, y;
	x=width/2-temppixmap.xpmattributes.width/2;
	y=height/2-temppixmap.xpmattributes.height/2;
	if (x<0) { x=0; }
	if (y<0) { y=0; }

	XCopyArea(display, temppixmap.pixmap, *pixmap, clearoutgc,
			0, 0, temppixmap.xpmattributes.width, 
			temppixmap.xpmattributes.height, x, y);
}

void	xutil::DrawNumbers(int numbers, Pixmap pixmap) {

	char *numstring=new char[6];
	sprintf(numstring,"%i",numbers);

	XDrawString(display, pixmap, lettergc, 0, 10, 
			numstring, strlen(numstring));

	XFlush(display);

	delete[] numstring;
}

void	xutil::MainLoop() {

	XFlush(display);
	XtAppMainLoop(application);
}
