#include "scrollutil.h"

scrollutil::scrollutil(xutil *xu, mailutil *mailu, Window *main) {

	xutility=xu;
	current=NULL;

	mainwindow=main;

	xutility->CreatePixmap(&canvas, 52, 53);

	drawing=0;

	mailutility=mailu;
}

scrollutil::~scrollutil() {
	XFreePixmap(xutility->display, canvas);
}

void	scrollutil::UpdateFaces() {

	mailutility->CopyNodes();

	current=mailutility->first;
}

void	scrollutil::DrawFaceCB(XtPointer XtP, XtIntervalId *XtI) {

	scrollutil	*thisptr=(scrollutil *)XtP;
	thisptr->DrawFace();
}

void	scrollutil::DrawFace() {

	if (drawing==0) {
		drawing=1;

		if (current!=NULL) {
			XCopyArea(xutility->display, 
					*current->pixmap, 
					canvas, 
					xutility->clearoutgc,
					0, 0, 52, 53, 0, 0);
			xutility->DrawNumbers(current->number,
					canvas);
			if (mailutility->first!=
				mailutility->last) {
				/* scrolling faces */
				for (int i=0; i<=52; i++) {
					XCopyArea(xutility->display, 
						canvas, 
						*mainwindow, 
						xutility->clearoutgc, 
						0, 0, 
						i, 53, 
						52-i+2, 2);
					XFlush(xutility->display);
				}
			} else {
				/* just draw it */
				XCopyArea(xutility->display, 
						canvas, 
						*mainwindow, 
						xutility->clearoutgc, 
						0, 0, 
						52, 53, 
						2, 2);
				XFlush(xutility->display);
			}
			if (current->next!=NULL)  {
				current=current->next;
			} else {
				UpdateFaces();
			}
		} else {
		
			XCopyArea(xutility->display, 
						xutility->nomail, 
						*mainwindow, 
						xutility->clearoutgc,
						0, 0, 52, 53, 2, 2);

			UpdateFaces();
		}

		xutility->AddTimeOut(
				(XtTimerCallbackProc)&scrollutil::DrawFaceCB, 
				1500, (XtPointer)this);

		drawing=0;
	}
}
