#include "mailutil.h"

mailutil::mailutil(xutil *xu, confignode *cfgf) {

	first=NULL;
	last=NULL;
	current=NULL;
	tempfirst=NULL;
	templast=NULL;
	tempcurrent=NULL;

	cfgfirst=cfgf;

	xutility=xu;
	checking=0;
	checked=0;
}

mailutil::~mailutil() {
	DeleteTempNodes();
	DeleteNodes();
}

void	mailutil::CheckMailCB(XtPointer XtP, XtIntervalId *XtI) {
	
	mailutil *thisptr=(mailutil *)XtP;
	thisptr->CheckMail();
}

void	mailutil::CheckMail() {

	while(copying==1);
	if (checking==0) {
		checking=1;

		DeleteTempNodes();
		tempfirst=NULL;
		templast=NULL;
		tempcurrent=NULL;
	
		char	*mailfilename=new	char[1024];

		strcpy(mailfilename, getenv("MAIL"));
	
		FILE	*mailfile;
	
		mailfile=fopen(mailfilename, "r");
		delete[] mailfilename;
	
		char	*mailword=new	char[1024];
		char	*name;
		int	counter=0;
		mailword[0]='!';
		mailword[1]=NULL;
		int	flag=0;
	
		if (mailfile!=NULL) {
			while (!feof(mailfile)) {
				fscanf(mailfile, "%s", mailword);
				if (!strcmp(mailword,"")) {
					fscanf(mailfile, "%s", mailword);
					flag=0;
					while (strcmp(mailword,"")) {
						if (!strcmp(mailword,"From:")
							&& flag==0) {
							fgets(mailword, 1024,
								mailfile);
							name=mailword;
							StripName(&name);
							AddEntry(name);
							flag=1;
						}
						fscanf(mailfile,"%s",mailword);
					}
				}
			}
		}
	
		delete[] mailword;
	
		fclose(mailfile);

		xutility->AddTimeOut(
				(XtTimerCallbackProc)&mailutil::CheckMailCB,
				7000, (XtPointer)this);
	
		checking=0;

		checked=1;
	}
}

void	mailutil::DeleteTempNodes() {


	if (tempfirst!=NULL) {
		tempcurrent=tempfirst;

		while(tempcurrent!=templast) {
			tempcurrent=tempcurrent->next;
			delete tempcurrent->previous;
		}
		delete tempcurrent;
	}

	tempfirst=NULL;
	tempcurrent=NULL;
	templast=NULL;
}

void	mailutil::DeleteNodes() {

	if (first!=NULL) {
		current=first;

		while(current!=last) {
			current=current->next;
			delete current->previous;
		}
		delete current;
	}

	first=NULL;
	current=NULL;
	last=NULL;
}

void	mailutil::StripName(char **name) {
	
	// strip to just name@place
	if (strchr(*name,'<')!=NULL) {
		*name=strchr(*name,'<')+1;
		char	*nullptr=strchr(*name,'>');
		*nullptr=NULL;
	}

	// strip off any pre/post white space
	while(**name==' ' || **name=='	') {
		*name=*name+1;
	}
	int i=0;
	while(*(*name+i)!=' ' && *(*name+i)!=10 && 
		*(*name+i)!='	' && *(*name+i)!=NULL) {
		i++;
	}
	if (i>0) {
		*(*name+i)=NULL;
	}
}

void	mailutil::AddEntry(char *name) {
	
	int	found=0;

	tempcurrent=tempfirst;
	while (tempcurrent!=NULL && found==0) {
		if (!strcmp(tempcurrent->name, name)) {
			tempcurrent->number++;
			found=1;
		}
		tempcurrent=current->next;
	}

	if (found==0) {

		Pixmap	*pix=NULL;

		//Lookup pixmap
		cfgcurrent=cfgfirst;
		while(cfgcurrent!=NULL) {
			if (!strcmp(name, cfgcurrent->name)) {
				pix=cfgcurrent->pixmap;
				break;
			}
			cfgcurrent=cfgcurrent->next;
		}
	
		if (pix==NULL) {
			pix=&xutility->def;
		}

		// Empty list
		if (tempfirst==NULL) {
			tempfirst=new mailnode(name, 1, pix,
						NULL, NULL);
			tempcurrent=tempfirst;
		} else {
			tempcurrent=templast;
			tempcurrent->next=new mailnode(name, 1, 
						pix, templast, NULL);
			tempcurrent=tempcurrent->next;
		}
		templast=tempcurrent;
	}
}

void	mailutil::CopyNodes() {

	while(checking==1);
	if (checked==1) {
		copying=1;

		DeleteNodes();
		tempcurrent=tempfirst;
	
		current=NULL;
		first=NULL;
		last=NULL;
		
		if (tempcurrent!=NULL) {
			current=new mailnode(
						tempcurrent->name, 
						tempcurrent->number, 
						tempcurrent->pixmap, 
						NULL, NULL);
			first=current;
			tempcurrent=tempcurrent->next;
			while (tempcurrent!=NULL) {
				current->next=new mailnode(
						tempcurrent->name, 
						tempcurrent->number, 
						tempcurrent->pixmap,
						current, NULL);
				current=current->next;
				tempcurrent=tempcurrent->next;
			}
			last=current;
		}
		checked=0;
		copying=0;
	}
}
