.\" t
.\" @(#)asexec.1 11/05/98
.TH asexec 1 "05 November 1998" "Version 1.3"
.UC
.SH NAME
\fBasexec\fP \- the AfterStep state machine and arbitrary command launcher.

.SH SYNOPSIS
.B asexec [-h] [--help] [-v] [--version]

.SH DESCRIPTION
\fBasexec\fP is an X11 application that provides a simple state machine 
and the ability to execute a command when changing states. \fBasexec\fP 
provides a distinctive AfterStep window manager look and feel and uses a 
resource file to allow customization.
.PP
The states are described in \fBasexec\fP's resource file. Each state may 
have a distinctive pixmap bound to it, which \fBasexec\fP presents in a 
window just large enough to display the largest pixmap.
.PP
The state transitions can be bound to a number of events. These events 
are: entering or leaving the \fBasexec\fP window, mouse click, and a 
timeout. When a state transition occurs, a command may be executed.

.SH CONFIGURATION OPTIONS
None.

.SH RESOURCE FILE SYNTAX
The following options may be placed in the user's \fIasexecrc\fP 
configuration file. Note that all options are case-insensitive.
.IP "*ASExec \fIpixmappath\fP ""\fIpath\fP"""
.RS
Specifies the directory list that will be searched by \fBasexec\fP for 
the pixmaps specified in this resource file. The \fIpath\fP must be 
quoted and contain a colon-separated list of directories. For example:

.nf
"/usr/local/share/pixmaps:/usr/include/X11/pixmaps:."
.fi
.RE
.IP "*ASExec \fIswallow\fP ""\fIwindow-name\fP"" \fIcommand\fP"
.RS
Specifies a command to be run when \fBasexec\fP starts.  Not to be 
confused with the state option of the same name. \fBasexec\fP will watch 
for new windows with the name \fIwindow-name\fP. When one is found, it 
will be "swallowed". That is, its window will disappear from the desktop 
and optionally reappear within the \fBasexec\fP window. See the state 
\fIswallow\fP option below for more details. \fIwindow-name\fP should be 
specified in quotes, for example:
.nf
*ASExec swallow "asclock" asclock -shape
.fi
.RE
.IP "*ASExec state ""\fIstate-label\fP"" ""\fIpixmap\fP"""
.RS
Specifies the beginning of a state definition. This line defines the 
\fIstate-label\fP and starts the list of the state transition 
descriptions. Each state is bound to a \fIpixmap\fP that represents 
the state. The \fIpixmap\fP must be a valid X11 pixmap that can be 
found in the path specified by \fIpixmappath\fP. Both \fIstate-label\fP 
and \fIpixmap\fP name should be enclosed in double quotes. For example:

.nf
*ASExec state "frame0" "frame0.xpm"
.fi
.RE
.IP "*ASExec swallow ""\fIwindow-name\fP"" [\fIx\fP \fIy\fP]"
.RS
Specifies a swallowed window to associate with this state. Not to be 
confused with the global option of the same name. If a global 
\fIswallow\fP option was specified with the same \fIwindow-name\fP, then 
the swallowed window associated with that option will be shown while in 
this state. \fIx\fP and \fIy\fP are optional, and specifies the location 
within the asexec window that the window will be shown. \fIwindow-name\fP 
should be enclosed in double quotes. For example:

.nf
*ASExec   swallow "asclock" 4 3
.fi
.RE
.IP "*ASExec ""\fIbinding-label\fP"" bind ""\fIto-state-label\fP"" \fIevent\fP"
.RS
Specifies a state transition and its trigger.  This statement is only 
valid within a state definition. The \fIto-state-label\fP specifies the 
target state of the state machine and the \fIevent\fP specifies the the 
event which will trigger the state transition. Both \fIbinding-label\fP 
and \fIto-state-label\fP must be enclosed in double quotes as shown in 
the example:

.nf
*ASExec   "next" bind "frame1" timeout 500
.fi

The valid \fIevents\fP for triggering state transitions are:

timeout \fImilliseconds\fP
.RS
Triggers after \fImilliseconds\fP in this state.
.RE
mouse \fIbutton\fP
.RS
Triggers when \fIbutton\fP is pressed in the \fBasexec\fP window.
.RE
enter
.RS
Triggers when the cursor enters the \fBasexec\fP window.
.RE
leave
.RS
Triggers when the cursor leaves the \fBasexec\fP window.
.RE
.fi
.RE
.IP "*ASExec ""\fIbinding-label\fP"" exec ""\fIcommand\fP"""
.RS
Specifies a \fIcommand\fP to be executed when the state transition bound 
to the label \fIbinding-label\fP occurs. For example, for the state 
transition in the above example we could bind the following action:

.nf
*ASExec   "next" exec echo hello, world!
.fi
.RE
.IP "*ASExec ~state"
.RS
Specifies the end of a state definition of a state and terminates the list
of state transitions and action descriptions.
.RE

.SH INVOCATION
\fBasexec\fP can be called in different ways.  The most common invocation 
is the command line:
.nf

	user@host[1]% asexec &

.fi
Another way to call \fBasexec\fP is from the window manager:
.nf

	*Wharf "asexec" nil Swallow "asexec" asexec &

.fi
This line, when placed in the \fIwharf\fP file in the user's Afterstep
configuration directory will cause \fBasexec\fP to be a button on the 
\fBWharf (1)\fP button bar under the \fBafterstep (1)\fP
window manager.

.SH BUGS
None have been found to date.

.SH FILES
.IP asexecrc
The \fBasexec\fP configuration file. It may be in the following places, 
in searching order:

.nf
~/GNUstep/Library/AfterStep/asexec, ~/.asexecrc, ./asexecrc
.fi

.SH SEE ALSO
.BR Wharf (1), AfterStep (1)

.SH COPYRIGHTS
Copyright (c) 1998 Ethan Fischer <allanon@crystaltokyo.com>

Distributed under GNU General Public License v2 ; see LICENSE file for 
more information.

.SH AUTHORS
.IP "Application:"
Ethan Fischer <allanon@crystaltokyo.com>

.IP "Man page:"
Albert Dorofeev <albert@mail.dma.be>

Ethan Fischer <allanon@crystaltokyo.com>
.sp
