#ifndef ASEXEC_H
#define ASEXEC_H

#include "configure.h"
#include "timer.h"

enum
{
	Type_None,
	Type_Timeout,
	Type_Key,
	Type_Mouse,
	Type_Enter,
	Type_Leave,
	Type_Last
} /* binding_type_t */;

typedef struct
{
	Pixmap pixmap;				/* the pixmap to draw */
	Pixmap mask;				/* a 1-bit mask for pixmap */
	int width;					/* width of the pixmap */
	int height;					/* height of the pixmap */
} icon_t;

typedef struct swallow_t
{
	struct swallow_t* next;		/* next window in list */
	char* name;					/* label of this swallow command */
	char* window_name;			/* name of window to swallow */
	char* exec;					/* command to execute */
	Window window;				/* swallowed window */
	pid_t pid;					/* child process id */
	int width;					/* width of swallowed window */
	int height;					/* height of swallowed window */
} swallow_t;

struct state_t;

typedef struct swallow_rec_t
{
	struct swallow_rec_t* next;	/* next record in list */
	struct state_t* parent;		/* state this swallow is bound to */
	char* swallow_label;		/* name of swallow_t to use */
	int x;						/* place window at (x, y); (-1, -1) means */
	int y;						/* center the window */
} swallow_rec_t;

typedef struct binding_t
{
	struct binding_t* next;		/* next binding in list */
	struct state_t* parent;		/* state that this binding is bound to */
	char* name;					/* binding label */
	char* child;				/* state that this binding changes to */
	char* exec;					/* program to execute */
	int type;					/* type of event that will trigger binding */
	int timeout;				/* if positive, the time in ms after entering 
								 * this state that this binding will activate */
	char key;					/* keypress to activate */
	int modifiers;				/* required modifiers (such as shift) */
	int button;					/* mouse button */
} binding_t;

typedef struct state_t
{
	struct state_t* next;		/* next in the list of states */
	char* name;					/* name of this state */
	icon_t icon;				/* icon for this state */
	binding_t* binding;			/* bindings */
	swallow_rec_t* swallow_rec;	/* pointers to swallowed windows */
} state_t;

extern swallow_t* first_swallow;
extern state_t* first_state;
extern state_t* current_state;
extern const char* MyName;
extern char *PixmapPath;

extern Display* dpy;
extern int screen;
extern Window Root;

int mystrcasecmp (const char *s1, const char *s2);
int mystrncasecmp (const char *s1, const char *s2, int n);

char* mystrdup (const char* str);
char* mystrndup (const char* str, int n);

binding_t* find_binding_by_name(const state_t* state, const char* name);
state_t* find_state_by_name(const char* name);

void asexec_init1(int argc, char** argv);
void asexec_init2(int argc, char** argv);
void asexec_handle_events(void);
int load_icon(const char* name, icon_t* icon);

#endif /* ASEXEC_H */
