
#include <string.h>

int 
mystrcasecmp (const char *s1, const char *s2)
{
  int c1, c2;
  int n1, n2;

  n1 = strlen (s1);
  n2 = strlen (s2);
  if (n1 != n2)
    return n1 - n2;
  
  for (;;)
    {
      c1 = *s1++;
      c2 = *s2++;
      if (!c1 || !c2)
	return (c1 - c2);
      if (isupper (c1))
	c1 = tolower(c1);
      if (isupper (c2))
	c2 = tolower(c2);
      if (c1 != c2)
	return (c1 - c2);
    }
}

int 
mystrncasecmp (const char *s1, const char *s2, int n)
{
  int c1, c2;

  for (;;)
    {
      if (!(n--))
	return 0;
      c1 = *s1++;
      c2 = *s2++;
      if (!c1 || !c2)
	return (c1 - c2);
      if (isupper (c1))
	c1 = tolower(c1);
      if (isupper (c2))
	c2 = tolower(c2);
      if (c1 != c2)
	return (c1 - c2);
    }
}
